/* $Id: OscTable.cpp 1740 2008-04-16 06:19:17Z ensonic $
 *
 * Buzz Machine Loader
 * Copyright (C) 2006 Buzztard team <buzztard-devel@lists.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

extern "C" const short OscTable[6][4096] = 
{
    //Osc 0	Level 0
    {
	0     ,	100   ,	201   ,	301   ,	402   ,	502   ,	603   ,	703   ,	804   ,	904   ,	1005  ,	1105  ,	1206  ,	1306  ,	1406  ,	1507  ,	
	1607  ,	1708  ,	1808  ,	1908  ,	2009  ,	2109  ,	2209  ,	2310  ,	2410  ,	2510  ,	2610  ,	2711  ,	2811  ,	2911  ,	3011  ,	3111  ,	
	3211  ,	3311  ,	3411  ,	3511  ,	3611  ,	3711  ,	3811  ,	3911  ,	4011  ,	4110  ,	4210  ,	4310  ,	4409  ,	4509  ,	4608  ,	4708  ,	
	4807  ,	4907  ,	5006  ,	5106  ,	5205  ,	5304  ,	5403  ,	5502  ,	5601  ,	5700  ,	5799  ,	5898  ,	5997  ,	6096  ,	6195  ,	6293  ,	
	6392  ,	6491  ,	6589  ,	6688  ,	6786  ,	6884  ,	6982  ,	7081  ,	7179  ,	7277  ,	7375  ,	7473  ,	7571  ,	7668  ,	7766  ,	7864  ,	
	7961  ,	8059  ,	8156  ,	8253  ,	8351  ,	8448  ,	8545  ,	8642  ,	8739  ,	8836  ,	8932  ,	9029  ,	9126  ,	9222  ,	9319  ,	9415  ,	
	9511  ,	9607  ,	9703  ,	9799  ,	9895  ,	9991  ,	10087 ,	10182 ,	10278 ,	10373 ,	10469 ,	10564 ,	10659 ,	10754 ,	10849 ,	10944 ,	
	11038 ,	11133 ,	11227 ,	11322 ,	11416 ,	11510 ,	11604 ,	11698 ,	11792 ,	11886 ,	11980 ,	12073 ,	12166 ,	12260 ,	12353 ,	12446 ,	
	12539 ,	12632 ,	12724 ,	12817 ,	12909 ,	13002 ,	13094 ,	13186 ,	13278 ,	13370 ,	13462 ,	13553 ,	13645 ,	13736 ,	13827 ,	13918 ,	
	14009 ,	14100 ,	14191 ,	14281 ,	14372 ,	14462 ,	14552 ,	14642 ,	14732 ,	14822 ,	14911 ,	15001 ,	15090 ,	15179 ,	15268 ,	15357 ,	
	15446 ,	15534 ,	15623 ,	15711 ,	15799 ,	15887 ,	15975 ,	16063 ,	16150 ,	16238 ,	16325 ,	16412 ,	16499 ,	16586 ,	16672 ,	16759 ,	
	16845 ,	16931 ,	17017 ,	17103 ,	17189 ,	17274 ,	17360 ,	17445 ,	17530 ,	17615 ,	17699 ,	17784 ,	17868 ,	17952 ,	18036 ,	18120 ,	
	18204 ,	18287 ,	18371 ,	18454 ,	18537 ,	18620 ,	18702 ,	18785 ,	18867 ,	18949 ,	19031 ,	19113 ,	19194 ,	19276 ,	19357 ,	19438 ,	
	19519 ,	19599 ,	19680 ,	19760 ,	19840 ,	19920 ,	20000 ,	20079 ,	20159 ,	20238 ,	20317 ,	20396 ,	20474 ,	20553 ,	20631 ,	20709 ,	
	20787 ,	20864 ,	20942 ,	21019 ,	21096 ,	21173 ,	21249 ,	21326 ,	21402 ,	21478 ,	21554 ,	21629 ,	21705 ,	21780 ,	21855 ,	21930 ,	
	22004 ,	22079 ,	22153 ,	22227 ,	22301 ,	22374 ,	22448 ,	22521 ,	22594 ,	22666 ,	22739 ,	22811 ,	22883 ,	22955 ,	23027 ,	23098 ,	
	23169 ,	23240 ,	23311 ,	23382 ,	23452 ,	23522 ,	23592 ,	23661 ,	23731 ,	23800 ,	23869 ,	23938 ,	24006 ,	24075 ,	24143 ,	24211 ,	
	24278 ,	24346 ,	24413 ,	24480 ,	24546 ,	24613 ,	24679 ,	24745 ,	24811 ,	24877 ,	24942 ,	25007 ,	25072 ,	25136 ,	25201 ,	25265 ,	
	25329 ,	25392 ,	25456 ,	25519 ,	25582 ,	25645 ,	25707 ,	25769 ,	25831 ,	25893 ,	25954 ,	26016 ,	26077 ,	26137 ,	26198 ,	26258 ,	
	26318 ,	26378 ,	26437 ,	26497 ,	26556 ,	26615 ,	26673 ,	26731 ,	26789 ,	26847 ,	26905 ,	26962 ,	27019 ,	27076 ,	27132 ,	27188 ,	
	27244 ,	27300 ,	27355 ,	27411 ,	27466 ,	27520 ,	27575 ,	27629 ,	27683 ,	27736 ,	27790 ,	27843 ,	27896 ,	27948 ,	28001 ,	28053 ,	
	28105 ,	28156 ,	28208 ,	28259 ,	28309 ,	28360 ,	28410 ,	28460 ,	28510 ,	28559 ,	28608 ,	28657 ,	28706 ,	28754 ,	28802 ,	28850 ,	
	28897 ,	28945 ,	28992 ,	29038 ,	29085 ,	29131 ,	29177 ,	29222 ,	29268 ,	29313 ,	29358 ,	29402 ,	29446 ,	29490 ,	29534 ,	29577 ,	
	29621 ,	29663 ,	29706 ,	29748 ,	29790 ,	29832 ,	29873 ,	29915 ,	29955 ,	29996 ,	30036 ,	30076 ,	30116 ,	30156 ,	30195 ,	30234 ,	
	30272 ,	30311 ,	30349 ,	30386 ,	30424 ,	30461 ,	30498 ,	30535 ,	30571 ,	30607 ,	30643 ,	30678 ,	30713 ,	30748 ,	30783 ,	30817 ,	
	30851 ,	30885 ,	30918 ,	30951 ,	30984 ,	31017 ,	31049 ,	31081 ,	31113 ,	31144 ,	31175 ,	31206 ,	31236 ,	31267 ,	31297 ,	31326 ,	
	31356 ,	31385 ,	31413 ,	31442 ,	31470 ,	31498 ,	31525 ,	31553 ,	31580 ,	31606 ,	31633 ,	31659 ,	31684 ,	31710 ,	31735 ,	31760 ,	
	31785 ,	31809 ,	31833 ,	31856 ,	31880 ,	31903 ,	31926 ,	31948 ,	31970 ,	31992 ,	32014 ,	32035 ,	32056 ,	32077 ,	32097 ,	32117 ,	
	32137 ,	32156 ,	32176 ,	32194 ,	32213 ,	32231 ,	32249 ,	32267 ,	32284 ,	32301 ,	32318 ,	32334 ,	32350 ,	32366 ,	32382 ,	32397 ,	
	32412 ,	32426 ,	32441 ,	32455 ,	32468 ,	32482 ,	32495 ,	32508 ,	32520 ,	32532 ,	32544 ,	32556 ,	32567 ,	32578 ,	32588 ,	32599 ,	
	32609 ,	32618 ,	32628 ,	32637 ,	32646 ,	32654 ,	32662 ,	32670 ,	32678 ,	32685 ,	32692 ,	32699 ,	32705 ,	32711 ,	32717 ,	32722 ,	
	32727 ,	32732 ,	32736 ,	32740 ,	32744 ,	32748 ,	32751 ,	32754 ,	32757 ,	32759 ,	32761 ,	32763 ,	32764 ,	32765 ,	32766 ,	32766 ,	
	32767 ,	32766 ,	32766 ,	32765 ,	32764 ,	32763 ,	32761 ,	32759 ,	32757 ,	32754 ,	32751 ,	32748 ,	32744 ,	32740 ,	32736 ,	32732 ,	
	32727 ,	32722 ,	32717 ,	32711 ,	32705 ,	32699 ,	32692 ,	32685 ,	32678 ,	32670 ,	32662 ,	32654 ,	32646 ,	32637 ,	32628 ,	32618 ,	
	32609 ,	32599 ,	32588 ,	32578 ,	32567 ,	32556 ,	32544 ,	32532 ,	32520 ,	32508 ,	32495 ,	32482 ,	32468 ,	32455 ,	32441 ,	32426 ,	
	32412 ,	32397 ,	32382 ,	32366 ,	32350 ,	32334 ,	32318 ,	32301 ,	32284 ,	32267 ,	32249 ,	32231 ,	32213 ,	32194 ,	32176 ,	32156 ,	
	32137 ,	32117 ,	32097 ,	32077 ,	32056 ,	32035 ,	32014 ,	31992 ,	31970 ,	31948 ,	31926 ,	31903 ,	31880 ,	31856 ,	31833 ,	31809 ,	
	31785 ,	31760 ,	31735 ,	31710 ,	31684 ,	31659 ,	31633 ,	31606 ,	31580 ,	31553 ,	31525 ,	31498 ,	31470 ,	31442 ,	31413 ,	31385 ,	
	31356 ,	31326 ,	31297 ,	31267 ,	31236 ,	31206 ,	31175 ,	31144 ,	31113 ,	31081 ,	31049 ,	31017 ,	30984 ,	30951 ,	30918 ,	30885 ,	
	30851 ,	30817 ,	30783 ,	30748 ,	30713 ,	30678 ,	30643 ,	30607 ,	30571 ,	30535 ,	30498 ,	30461 ,	30424 ,	30386 ,	30349 ,	30311 ,	
	30272 ,	30234 ,	30195 ,	30156 ,	30116 ,	30076 ,	30036 ,	29996 ,	29955 ,	29915 ,	29873 ,	29832 ,	29790 ,	29748 ,	29706 ,	29663 ,	
	29621 ,	29577 ,	29534 ,	29490 ,	29446 ,	29402 ,	29358 ,	29313 ,	29268 ,	29222 ,	29177 ,	29131 ,	29085 ,	29038 ,	28992 ,	28945 ,	
	28897 ,	28850 ,	28802 ,	28754 ,	28706 ,	28657 ,	28608 ,	28559 ,	28510 ,	28460 ,	28410 ,	28360 ,	28309 ,	28259 ,	28208 ,	28156 ,	
	28105 ,	28053 ,	28001 ,	27948 ,	27896 ,	27843 ,	27790 ,	27736 ,	27683 ,	27629 ,	27575 ,	27520 ,	27466 ,	27411 ,	27355 ,	27300 ,	
	27244 ,	27188 ,	27132 ,	27076 ,	27019 ,	26962 ,	26905 ,	26847 ,	26789 ,	26731 ,	26673 ,	26615 ,	26556 ,	26497 ,	26437 ,	26378 ,	
	26318 ,	26258 ,	26198 ,	26137 ,	26077 ,	26016 ,	25954 ,	25893 ,	25831 ,	25769 ,	25707 ,	25645 ,	25582 ,	25519 ,	25456 ,	25392 ,	
	25329 ,	25265 ,	25201 ,	25136 ,	25072 ,	25007 ,	24942 ,	24877 ,	24811 ,	24745 ,	24679 ,	24613 ,	24546 ,	24480 ,	24413 ,	24346 ,	
	24278 ,	24211 ,	24143 ,	24075 ,	24006 ,	23938 ,	23869 ,	23800 ,	23731 ,	23661 ,	23592 ,	23522 ,	23452 ,	23382 ,	23311 ,	23240 ,	
	23169 ,	23098 ,	23027 ,	22955 ,	22883 ,	22811 ,	22739 ,	22666 ,	22594 ,	22521 ,	22448 ,	22374 ,	22301 ,	22227 ,	22153 ,	22079 ,	
	22004 ,	21930 ,	21855 ,	21780 ,	21705 ,	21629 ,	21554 ,	21478 ,	21402 ,	21326 ,	21249 ,	21173 ,	21096 ,	21019 ,	20942 ,	20864 ,	
	20787 ,	20709 ,	20631 ,	20553 ,	20474 ,	20396 ,	20317 ,	20238 ,	20159 ,	20079 ,	20000 ,	19920 ,	19840 ,	19760 ,	19680 ,	19599 ,	
	19519 ,	19438 ,	19357 ,	19276 ,	19194 ,	19113 ,	19031 ,	18949 ,	18867 ,	18785 ,	18702 ,	18620 ,	18537 ,	18454 ,	18371 ,	18287 ,	
	18204 ,	18120 ,	18036 ,	17952 ,	17868 ,	17784 ,	17699 ,	17615 ,	17530 ,	17445 ,	17360 ,	17274 ,	17189 ,	17103 ,	17017 ,	16931 ,	
	16845 ,	16759 ,	16672 ,	16586 ,	16499 ,	16412 ,	16325 ,	16238 ,	16150 ,	16063 ,	15975 ,	15887 ,	15799 ,	15711 ,	15623 ,	15534 ,	
	15446 ,	15357 ,	15268 ,	15179 ,	15090 ,	15001 ,	14911 ,	14822 ,	14732 ,	14642 ,	14552 ,	14462 ,	14372 ,	14281 ,	14191 ,	14100 ,	
	14009 ,	13918 ,	13827 ,	13736 ,	13645 ,	13553 ,	13462 ,	13370 ,	13278 ,	13186 ,	13094 ,	13002 ,	12909 ,	12817 ,	12724 ,	12632 ,	
	12539 ,	12446 ,	12353 ,	12260 ,	12166 ,	12073 ,	11980 ,	11886 ,	11792 ,	11698 ,	11604 ,	11510 ,	11416 ,	11322 ,	11227 ,	11133 ,	
	11038 ,	10944 ,	10849 ,	10754 ,	10659 ,	10564 ,	10469 ,	10373 ,	10278 ,	10182 ,	10087 ,	9991  ,	9895  ,	9799  ,	9703  ,	9607  ,	
	9511  ,	9415  ,	9319  ,	9222  ,	9126  ,	9029  ,	8932  ,	8836  ,	8739  ,	8642  ,	8545  ,	8448  ,	8351  ,	8253  ,	8156  ,	8059  ,	
	7961  ,	7864  ,	7766  ,	7668  ,	7571  ,	7473  ,	7375  ,	7277  ,	7179  ,	7081  ,	6982  ,	6884  ,	6786  ,	6688  ,	6589  ,	6491  ,	
	6392  ,	6293  ,	6195  ,	6096  ,	5997  ,	5898  ,	5799  ,	5700  ,	5601  ,	5502  ,	5403  ,	5304  ,	5205  ,	5106  ,	5006  ,	4907  ,	
	4807  ,	4708  ,	4608  ,	4509  ,	4409  ,	4310  ,	4210  ,	4110  ,	4011  ,	3911  ,	3811  ,	3711  ,	3611  ,	3511  ,	3411  ,	3311  ,	
	3211  ,	3111  ,	3011  ,	2911  ,	2811  ,	2711  ,	2610  ,	2510  ,	2410  ,	2310  ,	2209  ,	2109  ,	2009  ,	1908  ,	1808  ,	1708  ,	
	1607  ,	1507  ,	1406  ,	1306  ,	1206  ,	1105  ,	1005  ,	904   ,	804   ,	703   ,	603   ,	502   ,	402   ,	301   ,	201   ,	100   ,	
	0     ,	-100  ,	-201  ,	-301  ,	-402  ,	-502  ,	-603  ,	-703  ,	-804  ,	-904  ,	-1005 ,	-1105 ,	-1206 ,	-1306 ,	-1406 ,	-1507 ,	
	-1607 ,	-1708 ,	-1808 ,	-1908 ,	-2009 ,	-2109 ,	-2209 ,	-2310 ,	-2410 ,	-2510 ,	-2610 ,	-2711 ,	-2811 ,	-2911 ,	-3011 ,	-3111 ,	
	-3211 ,	-3311 ,	-3411 ,	-3511 ,	-3611 ,	-3711 ,	-3811 ,	-3911 ,	-4011 ,	-4110 ,	-4210 ,	-4310 ,	-4409 ,	-4509 ,	-4608 ,	-4708 ,	
	-4807 ,	-4907 ,	-5006 ,	-5106 ,	-5205 ,	-5304 ,	-5403 ,	-5502 ,	-5601 ,	-5700 ,	-5799 ,	-5898 ,	-5997 ,	-6096 ,	-6195 ,	-6293 ,	
	-6392 ,	-6491 ,	-6589 ,	-6688 ,	-6786 ,	-6884 ,	-6982 ,	-7081 ,	-7179 ,	-7277 ,	-7375 ,	-7473 ,	-7571 ,	-7668 ,	-7766 ,	-7864 ,	
	-7961 ,	-8059 ,	-8156 ,	-8253 ,	-8351 ,	-8448 ,	-8545 ,	-8642 ,	-8739 ,	-8836 ,	-8932 ,	-9029 ,	-9126 ,	-9222 ,	-9319 ,	-9415 ,	
	-9511 ,	-9607 ,	-9703 ,	-9799 ,	-9895 ,	-9991 ,	-10087,	-10182,	-10278,	-10373,	-10469,	-10564,	-10659,	-10754,	-10849,	-10944,	
	-11038,	-11133,	-11227,	-11322,	-11416,	-11510,	-11604,	-11698,	-11792,	-11886,	-11980,	-12073,	-12166,	-12260,	-12353,	-12446,	
	-12539,	-12632,	-12724,	-12817,	-12909,	-13002,	-13094,	-13186,	-13278,	-13370,	-13462,	-13553,	-13645,	-13736,	-13827,	-13918,	
	-14009,	-14100,	-14191,	-14281,	-14372,	-14462,	-14552,	-14642,	-14732,	-14822,	-14911,	-15001,	-15090,	-15179,	-15268,	-15357,	
	-15446,	-15534,	-15623,	-15711,	-15799,	-15887,	-15975,	-16063,	-16150,	-16238,	-16325,	-16412,	-16499,	-16586,	-16672,	-16759,	
	-16845,	-16931,	-17017,	-17103,	-17189,	-17274,	-17360,	-17445,	-17530,	-17615,	-17699,	-17784,	-17868,	-17952,	-18036,	-18120,	
	-18204,	-18287,	-18371,	-18454,	-18537,	-18620,	-18702,	-18785,	-18867,	-18949,	-19031,	-19113,	-19194,	-19276,	-19357,	-19438,	
	-19519,	-19599,	-19680,	-19760,	-19840,	-19920,	-20000,	-20079,	-20159,	-20238,	-20317,	-20396,	-20474,	-20553,	-20631,	-20709,	
	-20787,	-20864,	-20942,	-21019,	-21096,	-21173,	-21249,	-21326,	-21402,	-21478,	-21554,	-21629,	-21705,	-21780,	-21855,	-21930,	
	-22004,	-22079,	-22153,	-22227,	-22301,	-22374,	-22448,	-22521,	-22594,	-22666,	-22739,	-22811,	-22883,	-22955,	-23027,	-23098,	
	-23169,	-23240,	-23311,	-23382,	-23452,	-23522,	-23592,	-23661,	-23731,	-23800,	-23869,	-23938,	-24006,	-24075,	-24143,	-24211,	
	-24278,	-24346,	-24413,	-24480,	-24546,	-24613,	-24679,	-24745,	-24811,	-24877,	-24942,	-25007,	-25072,	-25136,	-25201,	-25265,	
	-25329,	-25392,	-25456,	-25519,	-25582,	-25645,	-25707,	-25769,	-25831,	-25893,	-25954,	-26016,	-26077,	-26137,	-26198,	-26258,	
	-26318,	-26378,	-26437,	-26497,	-26556,	-26615,	-26673,	-26731,	-26789,	-26847,	-26905,	-26962,	-27019,	-27076,	-27132,	-27188,	
	-27244,	-27300,	-27355,	-27411,	-27466,	-27520,	-27575,	-27629,	-27683,	-27736,	-27790,	-27843,	-27896,	-27948,	-28001,	-28053,	
	-28105,	-28156,	-28208,	-28259,	-28309,	-28360,	-28410,	-28460,	-28510,	-28559,	-28608,	-28657,	-28706,	-28754,	-28802,	-28850,	
	-28897,	-28945,	-28992,	-29038,	-29085,	-29131,	-29177,	-29222,	-29268,	-29313,	-29358,	-29402,	-29446,	-29490,	-29534,	-29577,	
	-29621,	-29663,	-29706,	-29748,	-29790,	-29832,	-29873,	-29915,	-29955,	-29996,	-30036,	-30076,	-30116,	-30156,	-30195,	-30234,	
	-30272,	-30311,	-30349,	-30386,	-30424,	-30461,	-30498,	-30535,	-30571,	-30607,	-30643,	-30678,	-30713,	-30748,	-30783,	-30817,	
	-30851,	-30885,	-30918,	-30951,	-30984,	-31017,	-31049,	-31081,	-31113,	-31144,	-31175,	-31206,	-31236,	-31267,	-31297,	-31326,	
	-31356,	-31385,	-31413,	-31442,	-31470,	-31498,	-31525,	-31553,	-31580,	-31606,	-31633,	-31659,	-31684,	-31710,	-31735,	-31760,	
	-31785,	-31809,	-31833,	-31856,	-31880,	-31903,	-31926,	-31948,	-31970,	-31992,	-32014,	-32035,	-32056,	-32077,	-32097,	-32117,	
	-32137,	-32156,	-32176,	-32194,	-32213,	-32231,	-32249,	-32267,	-32284,	-32301,	-32318,	-32334,	-32350,	-32366,	-32382,	-32397,	
	-32412,	-32426,	-32441,	-32455,	-32468,	-32482,	-32495,	-32508,	-32520,	-32532,	-32544,	-32556,	-32567,	-32578,	-32588,	-32599,	
	-32609,	-32618,	-32628,	-32637,	-32646,	-32654,	-32662,	-32670,	-32678,	-32685,	-32692,	-32699,	-32705,	-32711,	-32717,	-32722,	
	-32727,	-32732,	-32736,	-32740,	-32744,	-32748,	-32751,	-32754,	-32757,	-32759,	-32761,	-32763,	-32764,	-32765,	-32766,	-32766,	
	-32767,	-32766,	-32766,	-32765,	-32764,	-32763,	-32761,	-32759,	-32757,	-32754,	-32751,	-32748,	-32744,	-32740,	-32736,	-32732,	
	-32727,	-32722,	-32717,	-32711,	-32705,	-32699,	-32692,	-32685,	-32678,	-32670,	-32662,	-32654,	-32646,	-32637,	-32628,	-32618,	
	-32609,	-32599,	-32588,	-32578,	-32567,	-32556,	-32544,	-32532,	-32520,	-32508,	-32495,	-32482,	-32468,	-32455,	-32441,	-32426,	
	-32412,	-32397,	-32382,	-32366,	-32350,	-32334,	-32318,	-32301,	-32284,	-32267,	-32249,	-32231,	-32213,	-32194,	-32176,	-32156,	
	-32137,	-32117,	-32097,	-32077,	-32056,	-32035,	-32014,	-31992,	-31970,	-31948,	-31926,	-31903,	-31880,	-31856,	-31833,	-31809,	
	-31785,	-31760,	-31735,	-31710,	-31684,	-31659,	-31633,	-31606,	-31580,	-31553,	-31525,	-31498,	-31470,	-31442,	-31413,	-31385,	
	-31356,	-31326,	-31297,	-31267,	-31236,	-31206,	-31175,	-31144,	-31113,	-31081,	-31049,	-31017,	-30984,	-30951,	-30918,	-30885,	
	-30851,	-30817,	-30783,	-30748,	-30713,	-30678,	-30643,	-30607,	-30571,	-30535,	-30498,	-30461,	-30424,	-30386,	-30349,	-30311,	
	-30272,	-30234,	-30195,	-30156,	-30116,	-30076,	-30036,	-29996,	-29955,	-29915,	-29873,	-29832,	-29790,	-29748,	-29706,	-29663,	
	-29621,	-29577,	-29534,	-29490,	-29446,	-29402,	-29358,	-29313,	-29268,	-29222,	-29177,	-29131,	-29085,	-29038,	-28992,	-28945,	
	-28897,	-28850,	-28802,	-28754,	-28706,	-28657,	-28608,	-28559,	-28510,	-28460,	-28410,	-28360,	-28309,	-28259,	-28208,	-28156,	
	-28105,	-28053,	-28001,	-27948,	-27896,	-27843,	-27790,	-27736,	-27683,	-27629,	-27575,	-27520,	-27466,	-27411,	-27355,	-27300,	
	-27244,	-27188,	-27132,	-27076,	-27019,	-26962,	-26905,	-26847,	-26789,	-26731,	-26673,	-26615,	-26556,	-26497,	-26437,	-26378,	
	-26318,	-26258,	-26198,	-26137,	-26077,	-26016,	-25954,	-25893,	-25831,	-25769,	-25707,	-25645,	-25582,	-25519,	-25456,	-25392,	
	-25329,	-25265,	-25201,	-25136,	-25072,	-25007,	-24942,	-24877,	-24811,	-24745,	-24679,	-24613,	-24546,	-24480,	-24413,	-24346,	
	-24278,	-24211,	-24143,	-24075,	-24006,	-23938,	-23869,	-23800,	-23731,	-23661,	-23592,	-23522,	-23452,	-23382,	-23311,	-23240,	
	-23169,	-23098,	-23027,	-22955,	-22883,	-22811,	-22739,	-22666,	-22594,	-22521,	-22448,	-22374,	-22301,	-22227,	-22153,	-22079,	
	-22004,	-21930,	-21855,	-21780,	-21705,	-21629,	-21554,	-21478,	-21402,	-21326,	-21249,	-21173,	-21096,	-21019,	-20942,	-20864,	
	-20787,	-20709,	-20631,	-20553,	-20474,	-20396,	-20317,	-20238,	-20159,	-20079,	-20000,	-19920,	-19840,	-19760,	-19680,	-19599,	
	-19519,	-19438,	-19357,	-19276,	-19194,	-19113,	-19031,	-18949,	-18867,	-18785,	-18702,	-18620,	-18537,	-18454,	-18371,	-18287,	
	-18204,	-18120,	-18036,	-17952,	-17868,	-17784,	-17699,	-17615,	-17530,	-17445,	-17360,	-17274,	-17189,	-17103,	-17017,	-16931,	
	-16845,	-16759,	-16672,	-16586,	-16499,	-16412,	-16325,	-16238,	-16150,	-16063,	-15975,	-15887,	-15799,	-15711,	-15623,	-15534,	
	-15446,	-15357,	-15268,	-15179,	-15090,	-15001,	-14911,	-14822,	-14732,	-14642,	-14552,	-14462,	-14372,	-14281,	-14191,	-14100,	
	-14009,	-13918,	-13827,	-13736,	-13645,	-13553,	-13462,	-13370,	-13278,	-13186,	-13094,	-13002,	-12909,	-12817,	-12724,	-12632,	
	-12539,	-12446,	-12353,	-12260,	-12166,	-12073,	-11980,	-11886,	-11792,	-11698,	-11604,	-11510,	-11416,	-11322,	-11227,	-11133,	
	-11038,	-10944,	-10849,	-10754,	-10659,	-10564,	-10469,	-10373,	-10278,	-10182,	-10087,	-9991 ,	-9895 ,	-9799 ,	-9703 ,	-9607 ,	
	-9511 ,	-9415 ,	-9319 ,	-9222 ,	-9126 ,	-9029 ,	-8932 ,	-8836 ,	-8739 ,	-8642 ,	-8545 ,	-8448 ,	-8351 ,	-8253 ,	-8156 ,	-8059 ,	
	-7961 ,	-7864 ,	-7766 ,	-7668 ,	-7571 ,	-7473 ,	-7375 ,	-7277 ,	-7179 ,	-7081 ,	-6982 ,	-6884 ,	-6786 ,	-6688 ,	-6589 ,	-6491 ,	
	-6392 ,	-6293 ,	-6195 ,	-6096 ,	-5997 ,	-5898 ,	-5799 ,	-5700 ,	-5601 ,	-5502 ,	-5403 ,	-5304 ,	-5205 ,	-5106 ,	-5006 ,	-4907 ,	
	-4807 ,	-4708 ,	-4608 ,	-4509 ,	-4409 ,	-4310 ,	-4210 ,	-4110 ,	-4011 ,	-3911 ,	-3811 ,	-3711 ,	-3611 ,	-3511 ,	-3411 ,	-3311 ,	
	-3211 ,	-3111 ,	-3011 ,	-2911 ,	-2811 ,	-2711 ,	-2610 ,	-2510 ,	-2410 ,	-2310 ,	-2209 ,	-2109 ,	-2009 ,	-1908 ,	-1808 ,	-1708 ,	
	-1607 ,	-1507 ,	-1406 ,	-1306 ,	-1206 ,	-1105 ,	-1005 ,	-904  ,	-804  ,	-703  ,	-603  ,	-502  ,	-402  ,	-301  ,	-201  ,	-100  ,
	//Osc 0	Level 1
	0     ,	201   ,	402   ,	603   ,	804   ,	1005  ,	1206  ,	1406  ,	1607  ,	1808  ,	2009  ,	2209  ,	2410  ,	2610  ,	2811  ,	3011  ,	
	3211  ,	3411  ,	3611  ,	3811  ,	4011  ,	4210  ,	4409  ,	4608  ,	4807  ,	5006  ,	5205  ,	5403  ,	5601  ,	5799  ,	5997  ,	6195  ,	
	6392  ,	6589  ,	6786  ,	6982  ,	7179  ,	7375  ,	7571  ,	7766  ,	7961  ,	8156  ,	8351  ,	8545  ,	8739  ,	8932  ,	9126  ,	9319  ,	
	9511  ,	9703  ,	9895  ,	10087 ,	10278 ,	10469 ,	10659 ,	10849 ,	11038 ,	11227 ,	11416 ,	11604 ,	11792 ,	11980 ,	12166 ,	12353 ,	
	12539 ,	12724 ,	12909 ,	13094 ,	13278 ,	13462 ,	13645 ,	13827 ,	14009 ,	14191 ,	14372 ,	14552 ,	14732 ,	14911 ,	15090 ,	15268 ,	
	15446 ,	15623 ,	15799 ,	15975 ,	16150 ,	16325 ,	16499 ,	16672 ,	16845 ,	17017 ,	17189 ,	17360 ,	17530 ,	17699 ,	17868 ,	18036 ,	
	18204 ,	18371 ,	18537 ,	18702 ,	18867 ,	19031 ,	19194 ,	19357 ,	19519 ,	19680 ,	19840 ,	20000 ,	20159 ,	20317 ,	20474 ,	20631 ,	
	20787 ,	20942 ,	21096 ,	21249 ,	21402 ,	21554 ,	21705 ,	21855 ,	22004 ,	22153 ,	22301 ,	22448 ,	22594 ,	22739 ,	22883 ,	23027 ,	
	23169 ,	23311 ,	23452 ,	23592 ,	23731 ,	23869 ,	24006 ,	24143 ,	24278 ,	24413 ,	24546 ,	24679 ,	24811 ,	24942 ,	25072 ,	25201 ,	
	25329 ,	25456 ,	25582 ,	25707 ,	25831 ,	25954 ,	26077 ,	26198 ,	26318 ,	26437 ,	26556 ,	26673 ,	26789 ,	26905 ,	27019 ,	27132 ,	
	27244 ,	27355 ,	27466 ,	27575 ,	27683 ,	27790 ,	27896 ,	28001 ,	28105 ,	28208 ,	28309 ,	28410 ,	28510 ,	28608 ,	28706 ,	28802 ,	
	28897 ,	28992 ,	29085 ,	29177 ,	29268 ,	29358 ,	29446 ,	29534 ,	29621 ,	29706 ,	29790 ,	29873 ,	29955 ,	30036 ,	30116 ,	30195 ,	
	30272 ,	30349 ,	30424 ,	30498 ,	30571 ,	30643 ,	30713 ,	30783 ,	30851 ,	30918 ,	30984 ,	31049 ,	31113 ,	31175 ,	31236 ,	31297 ,	
	31356 ,	31413 ,	31470 ,	31525 ,	31580 ,	31633 ,	31684 ,	31735 ,	31785 ,	31833 ,	31880 ,	31926 ,	31970 ,	32014 ,	32056 ,	32097 ,	
	32137 ,	32176 ,	32213 ,	32249 ,	32284 ,	32318 ,	32350 ,	32382 ,	32412 ,	32441 ,	32468 ,	32495 ,	32520 ,	32544 ,	32567 ,	32588 ,	
	32609 ,	32628 ,	32646 ,	32662 ,	32678 ,	32692 ,	32705 ,	32717 ,	32727 ,	32736 ,	32744 ,	32751 ,	32757 ,	32761 ,	32764 ,	32766 ,	
	32767 ,	32766 ,	32764 ,	32761 ,	32757 ,	32751 ,	32744 ,	32736 ,	32727 ,	32717 ,	32705 ,	32692 ,	32678 ,	32662 ,	32646 ,	32628 ,	
	32609 ,	32588 ,	32567 ,	32544 ,	32520 ,	32495 ,	32468 ,	32441 ,	32412 ,	32382 ,	32350 ,	32318 ,	32284 ,	32249 ,	32213 ,	32176 ,	
	32137 ,	32097 ,	32056 ,	32014 ,	31970 ,	31926 ,	31880 ,	31833 ,	31785 ,	31735 ,	31684 ,	31633 ,	31580 ,	31525 ,	31470 ,	31413 ,	
	31356 ,	31297 ,	31236 ,	31175 ,	31113 ,	31049 ,	30984 ,	30918 ,	30851 ,	30783 ,	30713 ,	30643 ,	30571 ,	30498 ,	30424 ,	30349 ,	
	30272 ,	30195 ,	30116 ,	30036 ,	29955 ,	29873 ,	29790 ,	29706 ,	29621 ,	29534 ,	29446 ,	29358 ,	29268 ,	29177 ,	29085 ,	28992 ,	
	28897 ,	28802 ,	28706 ,	28608 ,	28510 ,	28410 ,	28309 ,	28208 ,	28105 ,	28001 ,	27896 ,	27790 ,	27683 ,	27575 ,	27466 ,	27355 ,	
	27244 ,	27132 ,	27019 ,	26905 ,	26789 ,	26673 ,	26556 ,	26437 ,	26318 ,	26198 ,	26077 ,	25954 ,	25831 ,	25707 ,	25582 ,	25456 ,	
	25329 ,	25201 ,	25072 ,	24942 ,	24811 ,	24679 ,	24546 ,	24413 ,	24278 ,	24143 ,	24006 ,	23869 ,	23731 ,	23592 ,	23452 ,	23311 ,	
	23169 ,	23027 ,	22883 ,	22739 ,	22594 ,	22448 ,	22301 ,	22153 ,	22004 ,	21855 ,	21705 ,	21554 ,	21402 ,	21249 ,	21096 ,	20942 ,	
	20787 ,	20631 ,	20474 ,	20317 ,	20159 ,	20000 ,	19840 ,	19680 ,	19519 ,	19357 ,	19194 ,	19031 ,	18867 ,	18702 ,	18537 ,	18371 ,	
	18204 ,	18036 ,	17868 ,	17699 ,	17530 ,	17360 ,	17189 ,	17017 ,	16845 ,	16672 ,	16499 ,	16325 ,	16150 ,	15975 ,	15799 ,	15623 ,	
	15446 ,	15268 ,	15090 ,	14911 ,	14732 ,	14552 ,	14372 ,	14191 ,	14009 ,	13827 ,	13645 ,	13462 ,	13278 ,	13094 ,	12909 ,	12724 ,	
	12539 ,	12353 ,	12166 ,	11980 ,	11792 ,	11604 ,	11416 ,	11227 ,	11038 ,	10849 ,	10659 ,	10469 ,	10278 ,	10087 ,	9895  ,	9703  ,	
	9511  ,	9319  ,	9126  ,	8932  ,	8739  ,	8545  ,	8351  ,	8156  ,	7961  ,	7766  ,	7571  ,	7375  ,	7179  ,	6982  ,	6786  ,	6589  ,	
	6392  ,	6195  ,	5997  ,	5799  ,	5601  ,	5403  ,	5205  ,	5006  ,	4807  ,	4608  ,	4409  ,	4210  ,	4011  ,	3811  ,	3611  ,	3411  ,	
	3211  ,	3011  ,	2811  ,	2610  ,	2410  ,	2209  ,	2009  ,	1808  ,	1607  ,	1406  ,	1206  ,	1005  ,	804   ,	603   ,	402   ,	201   ,	
	0     ,	-201  ,	-402  ,	-603  ,	-804  ,	-1005 ,	-1206 ,	-1406 ,	-1607 ,	-1808 ,	-2009 ,	-2209 ,	-2410 ,	-2610 ,	-2811 ,	-3011 ,	
	-3211 ,	-3411 ,	-3611 ,	-3811 ,	-4011 ,	-4210 ,	-4409 ,	-4608 ,	-4807 ,	-5006 ,	-5205 ,	-5403 ,	-5601 ,	-5799 ,	-5997 ,	-6195 ,	
	-6392 ,	-6589 ,	-6786 ,	-6982 ,	-7179 ,	-7375 ,	-7571 ,	-7766 ,	-7961 ,	-8156 ,	-8351 ,	-8545 ,	-8739 ,	-8932 ,	-9126 ,	-9319 ,	
	-9511 ,	-9703 ,	-9895 ,	-10087,	-10278,	-10469,	-10659,	-10849,	-11038,	-11227,	-11416,	-11604,	-11792,	-11980,	-12166,	-12353,	
	-12539,	-12724,	-12909,	-13094,	-13278,	-13462,	-13645,	-13827,	-14009,	-14191,	-14372,	-14552,	-14732,	-14911,	-15090,	-15268,	
	-15446,	-15623,	-15799,	-15975,	-16150,	-16325,	-16499,	-16672,	-16845,	-17017,	-17189,	-17360,	-17530,	-17699,	-17868,	-18036,	
	-18204,	-18371,	-18537,	-18702,	-18867,	-19031,	-19194,	-19357,	-19519,	-19680,	-19840,	-20000,	-20159,	-20317,	-20474,	-20631,	
	-20787,	-20942,	-21096,	-21249,	-21402,	-21554,	-21705,	-21855,	-22004,	-22153,	-22301,	-22448,	-22594,	-22739,	-22883,	-23027,	
	-23169,	-23311,	-23452,	-23592,	-23731,	-23869,	-24006,	-24143,	-24278,	-24413,	-24546,	-24679,	-24811,	-24942,	-25072,	-25201,	
	-25329,	-25456,	-25582,	-25707,	-25831,	-25954,	-26077,	-26198,	-26318,	-26437,	-26556,	-26673,	-26789,	-26905,	-27019,	-27132,	
	-27244,	-27355,	-27466,	-27575,	-27683,	-27790,	-27896,	-28001,	-28105,	-28208,	-28309,	-28410,	-28510,	-28608,	-28706,	-28802,	
	-28897,	-28992,	-29085,	-29177,	-29268,	-29358,	-29446,	-29534,	-29621,	-29706,	-29790,	-29873,	-29955,	-30036,	-30116,	-30195,	
	-30272,	-30349,	-30424,	-30498,	-30571,	-30643,	-30713,	-30783,	-30851,	-30918,	-30984,	-31049,	-31113,	-31175,	-31236,	-31297,	
	-31356,	-31413,	-31470,	-31525,	-31580,	-31633,	-31684,	-31735,	-31785,	-31833,	-31880,	-31926,	-31970,	-32014,	-32056,	-32097,	
	-32137,	-32176,	-32213,	-32249,	-32284,	-32318,	-32350,	-32382,	-32412,	-32441,	-32468,	-32495,	-32520,	-32544,	-32567,	-32588,	
	-32609,	-32628,	-32646,	-32662,	-32678,	-32692,	-32705,	-32717,	-32727,	-32736,	-32744,	-32751,	-32757,	-32761,	-32764,	-32766,	
	-32767,	-32766,	-32764,	-32761,	-32757,	-32751,	-32744,	-32736,	-32727,	-32717,	-32705,	-32692,	-32678,	-32662,	-32646,	-32628,	
	-32609,	-32588,	-32567,	-32544,	-32520,	-32495,	-32468,	-32441,	-32412,	-32382,	-32350,	-32318,	-32284,	-32249,	-32213,	-32176,	
	-32137,	-32097,	-32056,	-32014,	-31970,	-31926,	-31880,	-31833,	-31785,	-31735,	-31684,	-31633,	-31580,	-31525,	-31470,	-31413,	
	-31356,	-31297,	-31236,	-31175,	-31113,	-31049,	-30984,	-30918,	-30851,	-30783,	-30713,	-30643,	-30571,	-30498,	-30424,	-30349,	
	-30272,	-30195,	-30116,	-30036,	-29955,	-29873,	-29790,	-29706,	-29621,	-29534,	-29446,	-29358,	-29268,	-29177,	-29085,	-28992,	
	-28897,	-28802,	-28706,	-28608,	-28510,	-28410,	-28309,	-28208,	-28105,	-28001,	-27896,	-27790,	-27683,	-27575,	-27466,	-27355,	
	-27244,	-27132,	-27019,	-26905,	-26789,	-26673,	-26556,	-26437,	-26318,	-26198,	-26077,	-25954,	-25831,	-25707,	-25582,	-25456,	
	-25329,	-25201,	-25072,	-24942,	-24811,	-24679,	-24546,	-24413,	-24278,	-24143,	-24006,	-23869,	-23731,	-23592,	-23452,	-23311,	
	-23169,	-23027,	-22883,	-22739,	-22594,	-22448,	-22301,	-22153,	-22004,	-21855,	-21705,	-21554,	-21402,	-21249,	-21096,	-20942,	
	-20787,	-20631,	-20474,	-20317,	-20159,	-20000,	-19840,	-19680,	-19519,	-19357,	-19194,	-19031,	-18867,	-18702,	-18537,	-18371,	
	-18204,	-18036,	-17868,	-17699,	-17530,	-17360,	-17189,	-17017,	-16845,	-16672,	-16499,	-16325,	-16150,	-15975,	-15799,	-15623,	
	-15446,	-15268,	-15090,	-14911,	-14732,	-14552,	-14372,	-14191,	-14009,	-13827,	-13645,	-13462,	-13278,	-13094,	-12909,	-12724,	
	-12539,	-12353,	-12166,	-11980,	-11792,	-11604,	-11416,	-11227,	-11038,	-10849,	-10659,	-10469,	-10278,	-10087,	-9895 ,	-9703 ,	
	-9511 ,	-9319 ,	-9126 ,	-8932 ,	-8739 ,	-8545 ,	-8351 ,	-8156 ,	-7961 ,	-7766 ,	-7571 ,	-7375 ,	-7179 ,	-6982 ,	-6786 ,	-6589 ,	
	-6392 ,	-6195 ,	-5997 ,	-5799 ,	-5601 ,	-5403 ,	-5205 ,	-5006 ,	-4807 ,	-4608 ,	-4409 ,	-4210 ,	-4011 ,	-3811 ,	-3611 ,	-3411 ,	
	-3211 ,	-3011 ,	-2811 ,	-2610 ,	-2410 ,	-2209 ,	-2009 ,	-1808 ,	-1607 ,	-1406 ,	-1206 ,	-1005 ,	-804  ,	-603  ,	-402  ,	-201  ,
	//Osc 0	Level 2
	0     ,	402   ,	804   ,	1206  ,	1607  ,	2009  ,	2410  ,	2811  ,	3211  ,	3611  ,	4011  ,	4409  ,	4807  ,	5205  ,	5601  ,	5997  ,	
	6392  ,	6786  ,	7179  ,	7571  ,	7961  ,	8351  ,	8739  ,	9126  ,	9511  ,	9895  ,	10278 ,	10659 ,	11038 ,	11416 ,	11792 ,	12166 ,	
	12539 ,	12909 ,	13278 ,	13645 ,	14009 ,	14372 ,	14732 ,	15090 ,	15446 ,	15799 ,	16150 ,	16499 ,	16845 ,	17189 ,	17530 ,	17868 ,	
	18204 ,	18537 ,	18867 ,	19194 ,	19519 ,	19840 ,	20159 ,	20474 ,	20787 ,	21096 ,	21402 ,	21705 ,	22004 ,	22301 ,	22594 ,	22883 ,	
	23169 ,	23452 ,	23731 ,	24006 ,	24278 ,	24546 ,	24811 ,	25072 ,	25329 ,	25582 ,	25831 ,	26077 ,	26318 ,	26556 ,	26789 ,	27019 ,	
	27244 ,	27466 ,	27683 ,	27896 ,	28105 ,	28309 ,	28510 ,	28706 ,	28897 ,	29085 ,	29268 ,	29446 ,	29621 ,	29790 ,	29955 ,	30116 ,	
	30272 ,	30424 ,	30571 ,	30713 ,	30851 ,	30984 ,	31113 ,	31236 ,	31356 ,	31470 ,	31580 ,	31684 ,	31785 ,	31880 ,	31970 ,	32056 ,	
	32137 ,	32213 ,	32284 ,	32350 ,	32412 ,	32468 ,	32520 ,	32567 ,	32609 ,	32646 ,	32678 ,	32705 ,	32727 ,	32744 ,	32757 ,	32764 ,	
	32767 ,	32764 ,	32757 ,	32744 ,	32727 ,	32705 ,	32678 ,	32646 ,	32609 ,	32567 ,	32520 ,	32468 ,	32412 ,	32350 ,	32284 ,	32213 ,	
	32137 ,	32056 ,	31970 ,	31880 ,	31785 ,	31684 ,	31580 ,	31470 ,	31356 ,	31236 ,	31113 ,	30984 ,	30851 ,	30713 ,	30571 ,	30424 ,	
	30272 ,	30116 ,	29955 ,	29790 ,	29621 ,	29446 ,	29268 ,	29085 ,	28897 ,	28706 ,	28510 ,	28309 ,	28105 ,	27896 ,	27683 ,	27466 ,	
	27244 ,	27019 ,	26789 ,	26556 ,	26318 ,	26077 ,	25831 ,	25582 ,	25329 ,	25072 ,	24811 ,	24546 ,	24278 ,	24006 ,	23731 ,	23452 ,	
	23169 ,	22883 ,	22594 ,	22301 ,	22004 ,	21705 ,	21402 ,	21096 ,	20787 ,	20474 ,	20159 ,	19840 ,	19519 ,	19194 ,	18867 ,	18537 ,	
	18204 ,	17868 ,	17530 ,	17189 ,	16845 ,	16499 ,	16150 ,	15799 ,	15446 ,	15090 ,	14732 ,	14372 ,	14009 ,	13645 ,	13278 ,	12909 ,	
	12539 ,	12166 ,	11792 ,	11416 ,	11038 ,	10659 ,	10278 ,	9895  ,	9511  ,	9126  ,	8739  ,	8351  ,	7961  ,	7571  ,	7179  ,	6786  ,	
	6392  ,	5997  ,	5601  ,	5205  ,	4807  ,	4409  ,	4011  ,	3611  ,	3211  ,	2811  ,	2410  ,	2009  ,	1607  ,	1206  ,	804   ,	402   ,	
	0     ,	-402  ,	-804  ,	-1206 ,	-1607 ,	-2009 ,	-2410 ,	-2811 ,	-3211 ,	-3611 ,	-4011 ,	-4409 ,	-4807 ,	-5205 ,	-5601 ,	-5997 ,	
	-6392 ,	-6786 ,	-7179 ,	-7571 ,	-7961 ,	-8351 ,	-8739 ,	-9126 ,	-9511 ,	-9895 ,	-10278,	-10659,	-11038,	-11416,	-11792,	-12166,	
	-12539,	-12909,	-13278,	-13645,	-14009,	-14372,	-14732,	-15090,	-15446,	-15799,	-16150,	-16499,	-16845,	-17189,	-17530,	-17868,	
	-18204,	-18537,	-18867,	-19194,	-19519,	-19840,	-20159,	-20474,	-20787,	-21096,	-21402,	-21705,	-22004,	-22301,	-22594,	-22883,	
	-23169,	-23452,	-23731,	-24006,	-24278,	-24546,	-24811,	-25072,	-25329,	-25582,	-25831,	-26077,	-26318,	-26556,	-26789,	-27019,	
	-27244,	-27466,	-27683,	-27896,	-28105,	-28309,	-28510,	-28706,	-28897,	-29085,	-29268,	-29446,	-29621,	-29790,	-29955,	-30116,	
	-30272,	-30424,	-30571,	-30713,	-30851,	-30984,	-31113,	-31236,	-31356,	-31470,	-31580,	-31684,	-31785,	-31880,	-31970,	-32056,	
	-32137,	-32213,	-32284,	-32350,	-32412,	-32468,	-32520,	-32567,	-32609,	-32646,	-32678,	-32705,	-32727,	-32744,	-32757,	-32764,	
	-32767,	-32764,	-32757,	-32744,	-32727,	-32705,	-32678,	-32646,	-32609,	-32567,	-32520,	-32468,	-32412,	-32350,	-32284,	-32213,	
	-32137,	-32056,	-31970,	-31880,	-31785,	-31684,	-31580,	-31470,	-31356,	-31236,	-31113,	-30984,	-30851,	-30713,	-30571,	-30424,	
	-30272,	-30116,	-29955,	-29790,	-29621,	-29446,	-29268,	-29085,	-28897,	-28706,	-28510,	-28309,	-28105,	-27896,	-27683,	-27466,	
	-27244,	-27019,	-26789,	-26556,	-26318,	-26077,	-25831,	-25582,	-25329,	-25072,	-24811,	-24546,	-24278,	-24006,	-23731,	-23452,	
	-23169,	-22883,	-22594,	-22301,	-22004,	-21705,	-21402,	-21096,	-20787,	-20474,	-20159,	-19840,	-19519,	-19194,	-18867,	-18537,	
	-18204,	-17868,	-17530,	-17189,	-16845,	-16499,	-16150,	-15799,	-15446,	-15090,	-14732,	-14372,	-14009,	-13645,	-13278,	-12909,	
	-12539,	-12166,	-11792,	-11416,	-11038,	-10659,	-10278,	-9895 ,	-9511 ,	-9126 ,	-8739 ,	-8351 ,	-7961 ,	-7571 ,	-7179 ,	-6786 ,	
	-6392 ,	-5997 ,	-5601 ,	-5205 ,	-4807 ,	-4409 ,	-4011 ,	-3611 ,	-3211 ,	-2811 ,	-2410 ,	-2009 ,	-1607 ,	-1206 ,	-804  ,	-402  ,	
	//Osc 0	Level 3
	0     ,	804   ,	1607  ,	2410  ,	3211  ,	4011  ,	4807  ,	5601  ,	6392  ,	7179  ,	7961  ,	8739  ,	9511  ,	10278 ,	11038 ,	11792 ,	
	12539 ,	13278 ,	14009 ,	14732 ,	15446 ,	16150 ,	16845 ,	17530 ,	18204 ,	18867 ,	19519 ,	20159 ,	20787 ,	21402 ,	22004 ,	22594 ,	
	23169 ,	23731 ,	24278 ,	24811 ,	25329 ,	25831 ,	26318 ,	26789 ,	27244 ,	27683 ,	28105 ,	28510 ,	28897 ,	29268 ,	29621 ,	29955 ,	
	30272 ,	30571 ,	30851 ,	31113 ,	31356 ,	31580 ,	31785 ,	31970 ,	32137 ,	32284 ,	32412 ,	32520 ,	32609 ,	32678 ,	32727 ,	32757 ,	
	32767 ,	32757 ,	32727 ,	32678 ,	32609 ,	32520 ,	32412 ,	32284 ,	32137 ,	31970 ,	31785 ,	31580 ,	31356 ,	31113 ,	30851 ,	30571 ,	
	30272 ,	29955 ,	29621 ,	29268 ,	28897 ,	28510 ,	28105 ,	27683 ,	27244 ,	26789 ,	26318 ,	25831 ,	25329 ,	24811 ,	24278 ,	23731 ,	
	23169 ,	22594 ,	22004 ,	21402 ,	20787 ,	20159 ,	19519 ,	18867 ,	18204 ,	17530 ,	16845 ,	16150 ,	15446 ,	14732 ,	14009 ,	13278 ,	
	12539 ,	11792 ,	11038 ,	10278 ,	9511  ,	8739  ,	7961  ,	7179  ,	6392  ,	5601  ,	4807  ,	4011  ,	3211  ,	2410  ,	1607  ,	804   ,	
	0     ,	-804  ,	-1607 ,	-2410 ,	-3211 ,	-4011 ,	-4807 ,	-5601 ,	-6392 ,	-7179 ,	-7961 ,	-8739 ,	-9511 ,	-10278,	-11038,	-11792,	
	-12539,	-13278,	-14009,	-14732,	-15446,	-16150,	-16845,	-17530,	-18204,	-18867,	-19519,	-20159,	-20787,	-21402,	-22004,	-22594,	
	-23169,	-23731,	-24278,	-24811,	-25329,	-25831,	-26318,	-26789,	-27244,	-27683,	-28105,	-28510,	-28897,	-29268,	-29621,	-29955,	
	-30272,	-30571,	-30851,	-31113,	-31356,	-31580,	-31785,	-31970,	-32137,	-32284,	-32412,	-32520,	-32609,	-32678,	-32727,	-32757,	
	-32767,	-32757,	-32727,	-32678,	-32609,	-32520,	-32412,	-32284,	-32137,	-31970,	-31785,	-31580,	-31356,	-31113,	-30851,	-30571,	
	-30272,	-29955,	-29621,	-29268,	-28897,	-28510,	-28105,	-27683,	-27244,	-26789,	-26318,	-25831,	-25329,	-24811,	-24278,	-23731,	
	-23169,	-22594,	-22004,	-21402,	-20787,	-20159,	-19519,	-18867,	-18204,	-17530,	-16845,	-16150,	-15446,	-14732,	-14009,	-13278,	
	-12539,	-11792,	-11038,	-10278,	-9511 ,	-8739 ,	-7961 ,	-7179 ,	-6392 ,	-5601 ,	-4807 ,	-4011 ,	-3211 ,	-2410 ,	-1607 ,	-804  ,	
	//Osc 0	Level 4
	0     ,	1607  ,	3211  ,	4807  ,	6392  ,	7961  ,	9511  ,	11038 ,	12539 ,	14009 ,	15446 ,	16845 ,	18204 ,	19519 ,	20787 ,	22004 ,	
	23169 ,	24278 ,	25329 ,	26318 ,	27244 ,	28105 ,	28897 ,	29621 ,	30272 ,	30851 ,	31356 ,	31785 ,	32137 ,	32412 ,	32609 ,	32727 ,	
	32767 ,	32727 ,	32609 ,	32412 ,	32137 ,	31785 ,	31356 ,	30851 ,	30272 ,	29621 ,	28897 ,	28105 ,	27244 ,	26318 ,	25329 ,	24278 ,	
	23169 ,	22004 ,	20787 ,	19519 ,	18204 ,	16845 ,	15446 ,	14009 ,	12539 ,	11038 ,	9511  ,	7961  ,	6392  ,	4807  ,	3211  ,	1607  ,	
	0     ,	-1607 ,	-3211 ,	-4807 ,	-6392 ,	-7961 ,	-9511 ,	-11038,	-12539,	-14009,	-15446,	-16845,	-18204,	-19519,	-20787,	-22004,	
	-23169,	-24278,	-25329,	-26318,	-27244,	-28105,	-28897,	-29621,	-30272,	-30851,	-31356,	-31785,	-32137,	-32412,	-32609,	-32727,	
	-32767,	-32727,	-32609,	-32412,	-32137,	-31785,	-31356,	-30851,	-30272,	-29621,	-28897,	-28105,	-27244,	-26318,	-25329,	-24278,	
	-23169,	-22004,	-20787,	-19519,	-18204,	-16845,	-15446,	-14009,	-12539,	-11038,	-9511 ,	-7961 ,	-6392 ,	-4807 ,	-3211 ,	-1607 ,	
	//Osc 0	Level 5
	0     ,	3211  ,	6392  ,	9511  ,	12539 ,	15446 ,	18204 ,	20787 ,	23169 ,	25329 ,	27244 ,	28897 ,	30272 ,	31356 ,	32137 ,	32609 ,	
	32767 ,	32609 ,	32137 ,	31356 ,	30272 ,	28897 ,	27244 ,	25329 ,	23169 ,	20787 ,	18204 ,	15446 ,	12539 ,	9511  ,	6392  ,	3211  ,	
	0     ,	-3211 ,	-6392 ,	-9511 ,	-12539,	-15446,	-18204,	-20787,	-23169,	-25329,	-27244,	-28897,	-30272,	-31356,	-32137,	-32609,	
	-32767,	-32609,	-32137,	-31356,	-30272,	-28897,	-27244,	-25329,	-23169,	-20787,	-18204,	-15446,	-12539,	-9511 ,	-6392 ,	-3211 ,	
	//Osc 0	Level 6
	0     ,	6392  ,	12539 ,	18204 ,	23169 ,	27244 ,	30272 ,	32137 ,	32767 ,	32137 ,	30272 ,	27244 ,	23169 ,	18204 ,	12539 ,	6392  ,	
	0     ,	-6392 ,	-12539,	-18204,	-23169,	-27244,	-30272,	-32137,	-32767,	-32137,	-30272,	-27244,	-23169,	-18204,	-12539,	-6392 ,	
	//Osc 0	Level 7
	0     ,	12539 ,	23169 ,	30272 ,	32767 ,	30272 ,	23169 ,	12539 ,	0     ,	-12539,	-23169,	-30272,	-32767,	-30272,	-23169,	-12539,	
	//Osc 0	Level 8
	0     ,	23169 ,	32767 ,	23169 ,	0     ,	-23169,	-32767,	-23169,	
	//Osc 0	Level 9
	0     ,	32767 ,	0     ,	-32767,	
	//Osc 0	Level 10
	0     ,	0     ,	
	//Osc 0	Level 11
	0     ,	0     ,
    },
    //Osc 1	Level 0
    {
	0     ,	32765 ,	25056 ,	29573 ,	26313 ,	28796 ,	26716 ,	28425 ,	26894 ,	28194 ,	26980 ,	28026 ,	27019 ,	27893 ,	27031 ,	27782 ,	
	27027 ,	27683 ,	27012 ,	27594 ,	26989 ,	27511 ,	26960 ,	27434 ,	26927 ,	27360 ,	26891 ,	27289 ,	26852 ,	27220 ,	26811 ,	27153 ,	
	26768 ,	27088 ,	26724 ,	27024 ,	26679 ,	26961 ,	26633 ,	26899 ,	26586 ,	26837 ,	26539 ,	26776 ,	26491 ,	26716 ,	26442 ,	26657 ,	
	26393 ,	26597 ,	26343 ,	26539 ,	26293 ,	26480 ,	26243 ,	26422 ,	26192 ,	26364 ,	26141 ,	26306 ,	26090 ,	26249 ,	26039 ,	26192 ,	
	25987 ,	26134 ,	25936 ,	26078 ,	25884 ,	26021 ,	25832 ,	25964 ,	25780 ,	25908 ,	25728 ,	25851 ,	25675 ,	25795 ,	25623 ,	25739 ,	
	25571 ,	25683 ,	25518 ,	25627 ,	25465 ,	25571 ,	25412 ,	25515 ,	25360 ,	25459 ,	25307 ,	25403 ,	25254 ,	25348 ,	25201 ,	25292 ,	
	25148 ,	25237 ,	25095 ,	25181 ,	25041 ,	25126 ,	24988 ,	25070 ,	24935 ,	25015 ,	24882 ,	24959 ,	24828 ,	24904 ,	24775 ,	24849 ,	
	24722 ,	24794 ,	24668 ,	24738 ,	24615 ,	24683 ,	24561 ,	24628 ,	24508 ,	24573 ,	24454 ,	24518 ,	24401 ,	24463 ,	24347 ,	24408 ,	
	24293 ,	24353 ,	24240 ,	24298 ,	24186 ,	24243 ,	24132 ,	24188 ,	24079 ,	24133 ,	24025 ,	24078 ,	23971 ,	24023 ,	23917 ,	23968 ,	
	23864 ,	23913 ,	23810 ,	23858 ,	23756 ,	23804 ,	23702 ,	23749 ,	23649 ,	23694 ,	23595 ,	23639 ,	23541 ,	23584 ,	23487 ,	23530 ,	
	23433 ,	23475 ,	23379 ,	23420 ,	23325 ,	23365 ,	23271 ,	23311 ,	23218 ,	23256 ,	23164 ,	23201 ,	23110 ,	23146 ,	23056 ,	23092 ,	
	23002 ,	23037 ,	22948 ,	22982 ,	22894 ,	22928 ,	22840 ,	22873 ,	22786 ,	22818 ,	22732 ,	22764 ,	22678 ,	22709 ,	22624 ,	22654 ,	
	22570 ,	22600 ,	22516 ,	22545 ,	22462 ,	22490 ,	22408 ,	22436 ,	22354 ,	22381 ,	22300 ,	22327 ,	22246 ,	22272 ,	22192 ,	22217 ,	
	22138 ,	22163 ,	22084 ,	22108 ,	22030 ,	22054 ,	21975 ,	21999 ,	21921 ,	21944 ,	21867 ,	21890 ,	21813 ,	21835 ,	21759 ,	21781 ,	
	21705 ,	21726 ,	21651 ,	21672 ,	21597 ,	21617 ,	21543 ,	21562 ,	21489 ,	21508 ,	21435 ,	21453 ,	21380 ,	21399 ,	21326 ,	21344 ,	
	21272 ,	21290 ,	21218 ,	21235 ,	21164 ,	21181 ,	21110 ,	21126 ,	21056 ,	21072 ,	21002 ,	21017 ,	20947 ,	20963 ,	20893 ,	20908 ,	
	20839 ,	20854 ,	20785 ,	20799 ,	20731 ,	20745 ,	20677 ,	20690 ,	20623 ,	20636 ,	20568 ,	20581 ,	20514 ,	20527 ,	20460 ,	20472 ,	
	20406 ,	20418 ,	20352 ,	20363 ,	20298 ,	20309 ,	20243 ,	20254 ,	20189 ,	20200 ,	20135 ,	20145 ,	20081 ,	20091 ,	20027 ,	20036 ,	
	19973 ,	19982 ,	19918 ,	19927 ,	19864 ,	19873 ,	19810 ,	19819 ,	19756 ,	19764 ,	19702 ,	19710 ,	19647 ,	19655 ,	19593 ,	19601 ,	
	19539 ,	19546 ,	19485 ,	19492 ,	19431 ,	19437 ,	19377 ,	19383 ,	19322 ,	19328 ,	19268 ,	19274 ,	19214 ,	19220 ,	19160 ,	19165 ,	
	19106 ,	19111 ,	19051 ,	19056 ,	18997 ,	19002 ,	18943 ,	18947 ,	18889 ,	18893 ,	18834 ,	18838 ,	18780 ,	18784 ,	18726 ,	18730 ,	
	18672 ,	18675 ,	18618 ,	18621 ,	18563 ,	18566 ,	18509 ,	18512 ,	18455 ,	18457 ,	18401 ,	18403 ,	18347 ,	18349 ,	18292 ,	18294 ,	
	18238 ,	18240 ,	18184 ,	18185 ,	18130 ,	18131 ,	18075 ,	18076 ,	18021 ,	18022 ,	17967 ,	17968 ,	17913 ,	17913 ,	17858 ,	17859 ,	
	17804 ,	17804 ,	17750 ,	17750 ,	17696 ,	17696 ,	17642 ,	17641 ,	17587 ,	17587 ,	17533 ,	17532 ,	17479 ,	17478 ,	17425 ,	17423 ,	
	17370 ,	17369 ,	17316 ,	17315 ,	17262 ,	17260 ,	17208 ,	17206 ,	17153 ,	17151 ,	17099 ,	17097 ,	17045 ,	17043 ,	16991 ,	16988 ,	
	16936 ,	16934 ,	16882 ,	16879 ,	16828 ,	16825 ,	16774 ,	16771 ,	16719 ,	16716 ,	16665 ,	16662 ,	16611 ,	16607 ,	16557 ,	16553 ,	
	16502 ,	16499 ,	16448 ,	16444 ,	16394 ,	16390 ,	16340 ,	16335 ,	16285 ,	16281 ,	16231 ,	16227 ,	16177 ,	16172 ,	16123 ,	16118 ,	
	16068 ,	16063 ,	16014 ,	16009 ,	15960 ,	15955 ,	15906 ,	15900 ,	15851 ,	15846 ,	15797 ,	15791 ,	15743 ,	15737 ,	15689 ,	15683 ,	
	15634 ,	15628 ,	15580 ,	15574 ,	15526 ,	15519 ,	15472 ,	15465 ,	15417 ,	15411 ,	15363 ,	15356 ,	15309 ,	15302 ,	15255 ,	15248 ,	
	15200 ,	15193 ,	15146 ,	15139 ,	15092 ,	15084 ,	15038 ,	15030 ,	14983 ,	14976 ,	14929 ,	14921 ,	14875 ,	14867 ,	14820 ,	14812 ,	
	14766 ,	14758 ,	14712 ,	14704 ,	14658 ,	14649 ,	14603 ,	14595 ,	14549 ,	14541 ,	14495 ,	14486 ,	14441 ,	14432 ,	14386 ,	14377 ,	
	14332 ,	14323 ,	14278 ,	14269 ,	14224 ,	14214 ,	14169 ,	14160 ,	14115 ,	14106 ,	14061 ,	14051 ,	14006 ,	13997 ,	13952 ,	13942 ,	
	13898 ,	13888 ,	13844 ,	13834 ,	13789 ,	13779 ,	13735 ,	13725 ,	13681 ,	13670 ,	13627 ,	13616 ,	13572 ,	13562 ,	13518 ,	13507 ,	
	13464 ,	13453 ,	13409 ,	13399 ,	13355 ,	13344 ,	13301 ,	13290 ,	13247 ,	13235 ,	13192 ,	13181 ,	13138 ,	13127 ,	13084 ,	13072 ,	
	13030 ,	13018 ,	12975 ,	12964 ,	12921 ,	12909 ,	12867 ,	12855 ,	12812 ,	12801 ,	12758 ,	12746 ,	12704 ,	12692 ,	12650 ,	12637 ,	
	12595 ,	12583 ,	12541 ,	12529 ,	12487 ,	12474 ,	12432 ,	12420 ,	12378 ,	12366 ,	12324 ,	12311 ,	12270 ,	12257 ,	12215 ,	12202 ,	
	12161 ,	12148 ,	12107 ,	12094 ,	12053 ,	12039 ,	11998 ,	11985 ,	11944 ,	11931 ,	11890 ,	11876 ,	11835 ,	11822 ,	11781 ,	11768 ,	
	11727 ,	11713 ,	11673 ,	11659 ,	11618 ,	11604 ,	11564 ,	11550 ,	11510 ,	11496 ,	11455 ,	11441 ,	11401 ,	11387 ,	11347 ,	11333 ,	
	11293 ,	11278 ,	11238 ,	11224 ,	11184 ,	11169 ,	11130 ,	11115 ,	11075 ,	11061 ,	11021 ,	11006 ,	10967 ,	10952 ,	10913 ,	10898 ,	
	10858 ,	10843 ,	10804 ,	10789 ,	10750 ,	10735 ,	10695 ,	10680 ,	10641 ,	10626 ,	10587 ,	10571 ,	10533 ,	10517 ,	10478 ,	10463 ,	
	10424 ,	10408 ,	10370 ,	10354 ,	10315 ,	10300 ,	10261 ,	10245 ,	10207 ,	10191 ,	10153 ,	10137 ,	10098 ,	10082 ,	10044 ,	10028 ,	
	9990  ,	9973  ,	9935  ,	9919  ,	9881  ,	9865  ,	9827  ,	9810  ,	9773  ,	9756  ,	9718  ,	9702  ,	9664  ,	9647  ,	9610  ,	9593  ,	
	9555  ,	9539  ,	9501  ,	9484  ,	9447  ,	9430  ,	9393  ,	9376  ,	9338  ,	9321  ,	9284  ,	9267  ,	9230  ,	9212  ,	9175  ,	9158  ,	
	9121  ,	9104  ,	9067  ,	9049  ,	9013  ,	8995  ,	8958  ,	8941  ,	8904  ,	8886  ,	8850  ,	8832  ,	8795  ,	8778  ,	8741  ,	8723  ,	
	8687  ,	8669  ,	8632  ,	8614  ,	8578  ,	8560  ,	8524  ,	8506  ,	8470  ,	8451  ,	8415  ,	8397  ,	8361  ,	8343  ,	8307  ,	8288  ,	
	8252  ,	8234  ,	8198  ,	8180  ,	8144  ,	8125  ,	8090  ,	8071  ,	8035  ,	8017  ,	7981  ,	7962  ,	7927  ,	7908  ,	7872  ,	7853  ,	
	7818  ,	7799  ,	7764  ,	7745  ,	7710  ,	7690  ,	7655  ,	7636  ,	7601  ,	7582  ,	7547  ,	7527  ,	7492  ,	7473  ,	7438  ,	7419  ,	
	7384  ,	7364  ,	7329  ,	7310  ,	7275  ,	7256  ,	7221  ,	7201  ,	7167  ,	7147  ,	7112  ,	7092  ,	7058  ,	7038  ,	7004  ,	6984  ,	
	6949  ,	6929  ,	6895  ,	6875  ,	6841  ,	6821  ,	6787  ,	6766  ,	6732  ,	6712  ,	6678  ,	6658  ,	6624  ,	6603  ,	6569  ,	6549  ,	
	6515  ,	6495  ,	6461  ,	6440  ,	6407  ,	6386  ,	6352  ,	6332  ,	6298  ,	6277  ,	6244  ,	6223  ,	6189  ,	6168  ,	6135  ,	6114  ,	
	6081  ,	6060  ,	6026  ,	6005  ,	5972  ,	5951  ,	5918  ,	5897  ,	5864  ,	5842  ,	5809  ,	5788  ,	5755  ,	5734  ,	5701  ,	5679  ,	
	5646  ,	5625  ,	5592  ,	5571  ,	5538  ,	5516  ,	5483  ,	5462  ,	5429  ,	5408  ,	5375  ,	5353  ,	5321  ,	5299  ,	5266  ,	5244  ,	
	5212  ,	5190  ,	5158  ,	5136  ,	5103  ,	5081  ,	5049  ,	5027  ,	4995  ,	4973  ,	4941  ,	4918  ,	4886  ,	4864  ,	4832  ,	4810  ,	
	4778  ,	4755  ,	4723  ,	4701  ,	4669  ,	4647  ,	4615  ,	4592  ,	4560  ,	4538  ,	4506  ,	4483  ,	4452  ,	4429  ,	4398  ,	4375  ,	
	4343  ,	4320  ,	4289  ,	4266  ,	4235  ,	4212  ,	4180  ,	4157  ,	4126  ,	4103  ,	4072  ,	4049  ,	4018  ,	3994  ,	3963  ,	3940  ,	
	3909  ,	3886  ,	3855  ,	3831  ,	3800  ,	3777  ,	3746  ,	3723  ,	3692  ,	3668  ,	3637  ,	3614  ,	3583  ,	3560  ,	3529  ,	3505  ,	
	3475  ,	3451  ,	3420  ,	3396  ,	3366  ,	3342  ,	3312  ,	3288  ,	3257  ,	3233  ,	3203  ,	3179  ,	3149  ,	3125  ,	3094  ,	3070  ,	
	3040  ,	3016  ,	2986  ,	2962  ,	2932  ,	2907  ,	2877  ,	2853  ,	2823  ,	2799  ,	2769  ,	2744  ,	2714  ,	2690  ,	2660  ,	2636  ,	
	2606  ,	2581  ,	2551  ,	2527  ,	2497  ,	2472  ,	2443  ,	2418  ,	2389  ,	2364  ,	2334  ,	2309  ,	2280  ,	2255  ,	2226  ,	2201  ,	
	2171  ,	2146  ,	2117  ,	2092  ,	2063  ,	2038  ,	2009  ,	1983  ,	1954  ,	1929  ,	1900  ,	1875  ,	1846  ,	1820  ,	1791  ,	1766  ,	
	1737  ,	1712  ,	1683  ,	1657  ,	1628  ,	1603  ,	1574  ,	1549  ,	1520  ,	1494  ,	1466  ,	1440  ,	1411  ,	1385  ,	1357  ,	1331  ,	
	1303  ,	1277  ,	1248  ,	1222  ,	1194  ,	1168  ,	1140  ,	1114  ,	1085  ,	1059  ,	1031  ,	1005  ,	977   ,	951   ,	923   ,	896   ,	
	868   ,	842   ,	814   ,	788   ,	760   ,	733   ,	705   ,	679   ,	651   ,	625   ,	597   ,	570   ,	542   ,	516   ,	488   ,	461   ,	
	434   ,	407   ,	380   ,	353   ,	325   ,	298   ,	271   ,	244   ,	217   ,	190   ,	162   ,	135   ,	108   ,	81    ,	54    ,	27    ,	
	0     ,	-27   ,	-54   ,	-81   ,	-108  ,	-135  ,	-162  ,	-190  ,	-217  ,	-244  ,	-271  ,	-298  ,	-325  ,	-353  ,	-380  ,	-407  ,	
	-434  ,	-461  ,	-488  ,	-516  ,	-542  ,	-570  ,	-597  ,	-625  ,	-651  ,	-679  ,	-705  ,	-733  ,	-760  ,	-788  ,	-814  ,	-842  ,	
	-868  ,	-896  ,	-923  ,	-951  ,	-977  ,	-1005 ,	-1031 ,	-1059 ,	-1085 ,	-1114 ,	-1140 ,	-1168 ,	-1194 ,	-1222 ,	-1248 ,	-1277 ,	
	-1303 ,	-1331 ,	-1357 ,	-1385 ,	-1411 ,	-1440 ,	-1466 ,	-1494 ,	-1520 ,	-1549 ,	-1574 ,	-1603 ,	-1628 ,	-1657 ,	-1683 ,	-1712 ,	
	-1737 ,	-1766 ,	-1791 ,	-1820 ,	-1846 ,	-1875 ,	-1900 ,	-1929 ,	-1954 ,	-1983 ,	-2009 ,	-2038 ,	-2063 ,	-2092 ,	-2117 ,	-2146 ,	
	-2171 ,	-2201 ,	-2226 ,	-2255 ,	-2280 ,	-2309 ,	-2334 ,	-2364 ,	-2389 ,	-2418 ,	-2443 ,	-2472 ,	-2497 ,	-2527 ,	-2551 ,	-2581 ,	
	-2606 ,	-2636 ,	-2660 ,	-2690 ,	-2714 ,	-2744 ,	-2769 ,	-2799 ,	-2823 ,	-2853 ,	-2877 ,	-2907 ,	-2932 ,	-2962 ,	-2986 ,	-3016 ,	
	-3040 ,	-3070 ,	-3094 ,	-3125 ,	-3149 ,	-3179 ,	-3203 ,	-3233 ,	-3257 ,	-3288 ,	-3312 ,	-3342 ,	-3366 ,	-3396 ,	-3420 ,	-3451 ,	
	-3475 ,	-3505 ,	-3529 ,	-3560 ,	-3583 ,	-3614 ,	-3637 ,	-3668 ,	-3692 ,	-3723 ,	-3746 ,	-3777 ,	-3800 ,	-3831 ,	-3855 ,	-3886 ,	
	-3909 ,	-3940 ,	-3963 ,	-3994 ,	-4018 ,	-4049 ,	-4072 ,	-4103 ,	-4126 ,	-4157 ,	-4180 ,	-4212 ,	-4235 ,	-4266 ,	-4289 ,	-4320 ,	
	-4343 ,	-4375 ,	-4398 ,	-4429 ,	-4452 ,	-4483 ,	-4506 ,	-4538 ,	-4560 ,	-4592 ,	-4615 ,	-4647 ,	-4669 ,	-4701 ,	-4723 ,	-4755 ,	
	-4778 ,	-4810 ,	-4832 ,	-4864 ,	-4886 ,	-4918 ,	-4941 ,	-4973 ,	-4995 ,	-5027 ,	-5049 ,	-5081 ,	-5103 ,	-5136 ,	-5158 ,	-5190 ,	
	-5212 ,	-5244 ,	-5266 ,	-5299 ,	-5321 ,	-5353 ,	-5375 ,	-5408 ,	-5429 ,	-5462 ,	-5483 ,	-5516 ,	-5538 ,	-5571 ,	-5592 ,	-5625 ,	
	-5646 ,	-5679 ,	-5701 ,	-5734 ,	-5755 ,	-5788 ,	-5809 ,	-5842 ,	-5864 ,	-5897 ,	-5918 ,	-5951 ,	-5972 ,	-6005 ,	-6026 ,	-6060 ,	
	-6081 ,	-6114 ,	-6135 ,	-6168 ,	-6189 ,	-6223 ,	-6244 ,	-6277 ,	-6298 ,	-6332 ,	-6352 ,	-6386 ,	-6407 ,	-6440 ,	-6461 ,	-6495 ,	
	-6515 ,	-6549 ,	-6569 ,	-6603 ,	-6624 ,	-6658 ,	-6678 ,	-6712 ,	-6732 ,	-6766 ,	-6787 ,	-6821 ,	-6841 ,	-6875 ,	-6895 ,	-6929 ,	
	-6949 ,	-6984 ,	-7004 ,	-7038 ,	-7058 ,	-7092 ,	-7112 ,	-7147 ,	-7167 ,	-7201 ,	-7221 ,	-7256 ,	-7275 ,	-7310 ,	-7329 ,	-7364 ,	
	-7384 ,	-7419 ,	-7438 ,	-7473 ,	-7492 ,	-7527 ,	-7547 ,	-7582 ,	-7601 ,	-7636 ,	-7655 ,	-7690 ,	-7710 ,	-7745 ,	-7764 ,	-7799 ,	
	-7818 ,	-7853 ,	-7872 ,	-7908 ,	-7927 ,	-7962 ,	-7981 ,	-8017 ,	-8035 ,	-8071 ,	-8090 ,	-8125 ,	-8144 ,	-8180 ,	-8198 ,	-8234 ,	
	-8252 ,	-8288 ,	-8307 ,	-8343 ,	-8361 ,	-8397 ,	-8415 ,	-8451 ,	-8470 ,	-8506 ,	-8524 ,	-8560 ,	-8578 ,	-8614 ,	-8632 ,	-8669 ,	
	-8687 ,	-8723 ,	-8741 ,	-8778 ,	-8795 ,	-8832 ,	-8850 ,	-8886 ,	-8904 ,	-8941 ,	-8958 ,	-8995 ,	-9013 ,	-9049 ,	-9067 ,	-9104 ,	
	-9121 ,	-9158 ,	-9175 ,	-9212 ,	-9230 ,	-9267 ,	-9284 ,	-9321 ,	-9338 ,	-9376 ,	-9393 ,	-9430 ,	-9447 ,	-9484 ,	-9501 ,	-9539 ,	
	-9555 ,	-9593 ,	-9610 ,	-9647 ,	-9664 ,	-9702 ,	-9718 ,	-9756 ,	-9773 ,	-9810 ,	-9827 ,	-9865 ,	-9881 ,	-9919 ,	-9935 ,	-9973 ,	
	-9990 ,	-10028,	-10044,	-10082,	-10098,	-10137,	-10153,	-10191,	-10207,	-10245,	-10261,	-10300,	-10315,	-10354,	-10370,	-10408,	
	-10424,	-10463,	-10478,	-10517,	-10533,	-10571,	-10587,	-10626,	-10641,	-10680,	-10695,	-10735,	-10750,	-10789,	-10804,	-10843,	
	-10858,	-10898,	-10913,	-10952,	-10967,	-11006,	-11021,	-11061,	-11075,	-11115,	-11130,	-11169,	-11184,	-11224,	-11238,	-11278,	
	-11293,	-11333,	-11347,	-11387,	-11401,	-11441,	-11455,	-11496,	-11510,	-11550,	-11564,	-11604,	-11618,	-11659,	-11673,	-11713,	
	-11727,	-11768,	-11781,	-11822,	-11835,	-11876,	-11890,	-11931,	-11944,	-11985,	-11998,	-12039,	-12053,	-12094,	-12107,	-12148,	
	-12161,	-12202,	-12215,	-12257,	-12270,	-12311,	-12324,	-12366,	-12378,	-12420,	-12432,	-12474,	-12487,	-12529,	-12541,	-12583,	
	-12595,	-12637,	-12650,	-12692,	-12704,	-12746,	-12758,	-12801,	-12812,	-12855,	-12867,	-12909,	-12921,	-12964,	-12975,	-13018,	
	-13030,	-13072,	-13084,	-13127,	-13138,	-13181,	-13192,	-13235,	-13247,	-13290,	-13301,	-13344,	-13355,	-13399,	-13409,	-13453,	
	-13464,	-13507,	-13518,	-13562,	-13572,	-13616,	-13627,	-13670,	-13681,	-13725,	-13735,	-13779,	-13789,	-13834,	-13844,	-13888,	
	-13898,	-13942,	-13952,	-13997,	-14006,	-14051,	-14061,	-14106,	-14115,	-14160,	-14169,	-14214,	-14224,	-14269,	-14278,	-14323,	
	-14332,	-14377,	-14386,	-14432,	-14441,	-14486,	-14495,	-14541,	-14549,	-14595,	-14603,	-14649,	-14658,	-14704,	-14712,	-14758,	
	-14766,	-14812,	-14820,	-14867,	-14875,	-14921,	-14929,	-14976,	-14983,	-15030,	-15038,	-15084,	-15092,	-15139,	-15146,	-15193,	
	-15200,	-15248,	-15255,	-15302,	-15309,	-15356,	-15363,	-15411,	-15417,	-15465,	-15472,	-15519,	-15526,	-15574,	-15580,	-15628,	
	-15634,	-15683,	-15689,	-15737,	-15743,	-15791,	-15797,	-15846,	-15851,	-15900,	-15906,	-15955,	-15960,	-16009,	-16014,	-16063,	
	-16068,	-16118,	-16123,	-16172,	-16177,	-16227,	-16231,	-16281,	-16285,	-16335,	-16340,	-16390,	-16394,	-16444,	-16448,	-16499,	
	-16502,	-16553,	-16557,	-16607,	-16611,	-16662,	-16665,	-16716,	-16719,	-16771,	-16774,	-16825,	-16828,	-16879,	-16882,	-16934,	
	-16936,	-16988,	-16991,	-17043,	-17045,	-17097,	-17099,	-17151,	-17153,	-17206,	-17208,	-17260,	-17262,	-17315,	-17316,	-17369,	
	-17370,	-17423,	-17425,	-17478,	-17479,	-17532,	-17533,	-17587,	-17587,	-17641,	-17642,	-17696,	-17696,	-17750,	-17750,	-17804,	
	-17804,	-17859,	-17858,	-17913,	-17913,	-17968,	-17967,	-18022,	-18021,	-18076,	-18075,	-18131,	-18130,	-18185,	-18184,	-18240,	
	-18238,	-18294,	-18292,	-18349,	-18347,	-18403,	-18401,	-18457,	-18455,	-18512,	-18509,	-18566,	-18563,	-18621,	-18618,	-18675,	
	-18672,	-18730,	-18726,	-18784,	-18780,	-18838,	-18834,	-18893,	-18889,	-18947,	-18943,	-19002,	-18997,	-19056,	-19051,	-19111,	
	-19106,	-19165,	-19160,	-19220,	-19214,	-19274,	-19268,	-19328,	-19322,	-19383,	-19377,	-19437,	-19431,	-19492,	-19485,	-19546,	
	-19539,	-19601,	-19593,	-19655,	-19647,	-19710,	-19702,	-19764,	-19756,	-19819,	-19810,	-19873,	-19864,	-19927,	-19918,	-19982,	
	-19973,	-20036,	-20027,	-20091,	-20081,	-20145,	-20135,	-20200,	-20189,	-20254,	-20243,	-20309,	-20298,	-20363,	-20352,	-20418,	
	-20406,	-20472,	-20460,	-20527,	-20514,	-20581,	-20568,	-20636,	-20623,	-20690,	-20677,	-20745,	-20731,	-20799,	-20785,	-20854,	
	-20839,	-20908,	-20893,	-20963,	-20947,	-21017,	-21002,	-21072,	-21056,	-21126,	-21110,	-21181,	-21164,	-21235,	-21218,	-21290,	
	-21272,	-21344,	-21326,	-21399,	-21380,	-21453,	-21435,	-21508,	-21489,	-21562,	-21543,	-21617,	-21597,	-21672,	-21651,	-21726,	
	-21705,	-21781,	-21759,	-21835,	-21813,	-21890,	-21867,	-21944,	-21921,	-21999,	-21975,	-22054,	-22030,	-22108,	-22084,	-22163,	
	-22138,	-22217,	-22192,	-22272,	-22246,	-22327,	-22300,	-22381,	-22354,	-22436,	-22408,	-22490,	-22462,	-22545,	-22516,	-22600,	
	-22570,	-22654,	-22624,	-22709,	-22678,	-22764,	-22732,	-22818,	-22786,	-22873,	-22840,	-22928,	-22894,	-22982,	-22948,	-23037,	
	-23002,	-23092,	-23056,	-23146,	-23110,	-23201,	-23164,	-23256,	-23218,	-23311,	-23271,	-23365,	-23325,	-23420,	-23379,	-23475,	
	-23433,	-23530,	-23487,	-23584,	-23541,	-23639,	-23595,	-23694,	-23649,	-23749,	-23702,	-23804,	-23756,	-23858,	-23810,	-23913,	
	-23864,	-23968,	-23917,	-24023,	-23971,	-24078,	-24025,	-24133,	-24079,	-24188,	-24132,	-24243,	-24186,	-24298,	-24240,	-24353,	
	-24293,	-24408,	-24347,	-24463,	-24401,	-24518,	-24454,	-24573,	-24508,	-24628,	-24561,	-24683,	-24615,	-24738,	-24668,	-24794,	
	-24722,	-24849,	-24775,	-24904,	-24828,	-24959,	-24882,	-25015,	-24935,	-25070,	-24988,	-25126,	-25041,	-25181,	-25095,	-25237,	
	-25148,	-25292,	-25201,	-25348,	-25254,	-25403,	-25307,	-25459,	-25360,	-25515,	-25412,	-25571,	-25465,	-25627,	-25518,	-25683,	
	-25571,	-25739,	-25623,	-25795,	-25675,	-25851,	-25728,	-25908,	-25780,	-25964,	-25832,	-26021,	-25884,	-26078,	-25936,	-26134,	
	-25987,	-26192,	-26039,	-26249,	-26090,	-26306,	-26141,	-26364,	-26192,	-26422,	-26243,	-26480,	-26293,	-26539,	-26343,	-26597,	
	-26393,	-26657,	-26442,	-26716,	-26491,	-26776,	-26539,	-26837,	-26586,	-26899,	-26633,	-26961,	-26679,	-27024,	-26724,	-27088,	
	-26768,	-27153,	-26811,	-27220,	-26852,	-27289,	-26891,	-27360,	-26927,	-27434,	-26960,	-27511,	-26989,	-27594,	-27012,	-27683,	
	-27027,	-27782,	-27031,	-27893,	-27019,	-28026,	-26980,	-28194,	-26894,	-28425,	-26716,	-28796,	-26313,	-29573,	-25056,	-32765,	
	//Osc 1	Level 1
	0     ,	32737 ,	25002 ,	29491 ,	26204 ,	28660 ,	26553 ,	28235 ,	26677 ,	27949 ,	26708 ,	27727 ,	26693 ,	27540 ,	26651 ,	27374 ,	
	26593 ,	27221 ,	26523 ,	27078 ,	26446 ,	26941 ,	26363 ,	26809 ,	26275 ,	26680 ,	26185 ,	26555 ,	26092 ,	26432 ,	25997 ,	26311 ,	
	25900 ,	26191 ,	25801 ,	26073 ,	25702 ,	25955 ,	25602 ,	25839 ,	25500 ,	25723 ,	25399 ,	25608 ,	25296 ,	25493 ,	25193 ,	25379 ,	
	25089 ,	25266 ,	24986 ,	25153 ,	24881 ,	25040 ,	24777 ,	24927 ,	24672 ,	24815 ,	24567 ,	24703 ,	24461 ,	24591 ,	24356 ,	24479 ,	
	24250 ,	24368 ,	24144 ,	24257 ,	24038 ,	24146 ,	23932 ,	24035 ,	23825 ,	23924 ,	23719 ,	23813 ,	23612 ,	23702 ,	23505 ,	23592 ,	
	23399 ,	23481 ,	23292 ,	23371 ,	23185 ,	23261 ,	23078 ,	23151 ,	22971 ,	23040 ,	22863 ,	22930 ,	22756 ,	22820 ,	22649 ,	22710 ,	
	22541 ,	22601 ,	22434 ,	22491 ,	22327 ,	22381 ,	22219 ,	22271 ,	22112 ,	22161 ,	22004 ,	22052 ,	21896 ,	21942 ,	21789 ,	21832 ,	
	21681 ,	21723 ,	21573 ,	21613 ,	21465 ,	21504 ,	21358 ,	21394 ,	21250 ,	21285 ,	21142 ,	21175 ,	21034 ,	21066 ,	20926 ,	20957 ,	
	20818 ,	20847 ,	20710 ,	20738 ,	20602 ,	20628 ,	20494 ,	20519 ,	20386 ,	20410 ,	20278 ,	20301 ,	20170 ,	20191 ,	20062 ,	20082 ,	
	19954 ,	19973 ,	19846 ,	19864 ,	19738 ,	19754 ,	19630 ,	19645 ,	19522 ,	19536 ,	19414 ,	19427 ,	19306 ,	19318 ,	19198 ,	19209 ,	
	19089 ,	19099 ,	18981 ,	18990 ,	18873 ,	18881 ,	18765 ,	18772 ,	18657 ,	18663 ,	18548 ,	18554 ,	18440 ,	18445 ,	18332 ,	18336 ,	
	18224 ,	18227 ,	18115 ,	18118 ,	18007 ,	18009 ,	17899 ,	17900 ,	17791 ,	17791 ,	17682 ,	17682 ,	17574 ,	17573 ,	17466 ,	17464 ,	
	17357 ,	17355 ,	17249 ,	17246 ,	17141 ,	17137 ,	17032 ,	17028 ,	16924 ,	16919 ,	16816 ,	16810 ,	16707 ,	16701 ,	16599 ,	16592 ,	
	16491 ,	16483 ,	16382 ,	16374 ,	16274 ,	16265 ,	16166 ,	16156 ,	16057 ,	16047 ,	15949 ,	15938 ,	15841 ,	15829 ,	15732 ,	15720 ,	
	15624 ,	15612 ,	15515 ,	15503 ,	15407 ,	15394 ,	15299 ,	15285 ,	15190 ,	15176 ,	15082 ,	15067 ,	14973 ,	14958 ,	14865 ,	14849 ,	
	14757 ,	14740 ,	14648 ,	14631 ,	14540 ,	14523 ,	14431 ,	14414 ,	14323 ,	14305 ,	14215 ,	14196 ,	14106 ,	14087 ,	13998 ,	13978 ,	
	13889 ,	13869 ,	13781 ,	13761 ,	13672 ,	13652 ,	13564 ,	13543 ,	13455 ,	13434 ,	13347 ,	13325 ,	13239 ,	13216 ,	13130 ,	13107 ,	
	13022 ,	12999 ,	12913 ,	12890 ,	12805 ,	12781 ,	12696 ,	12672 ,	12588 ,	12563 ,	12479 ,	12454 ,	12371 ,	12346 ,	12262 ,	12237 ,	
	12154 ,	12128 ,	12046 ,	12019 ,	11937 ,	11910 ,	11829 ,	11801 ,	11720 ,	11693 ,	11612 ,	11584 ,	11503 ,	11475 ,	11395 ,	11366 ,	
	11286 ,	11257 ,	11178 ,	11149 ,	11069 ,	11040 ,	10961 ,	10931 ,	10852 ,	10822 ,	10744 ,	10713 ,	10635 ,	10605 ,	10527 ,	10496 ,	
	10418 ,	10387 ,	10310 ,	10278 ,	10201 ,	10169 ,	10093 ,	10061 ,	9984  ,	9952  ,	9876  ,	9843  ,	9767  ,	9734  ,	9659  ,	9625  ,	
	9550  ,	9517  ,	9442  ,	9408  ,	9333  ,	9299  ,	9225  ,	9190  ,	9116  ,	9081  ,	9008  ,	8973  ,	8899  ,	8864  ,	8791  ,	8755  ,	
	8682  ,	8646  ,	8574  ,	8537  ,	8465  ,	8429  ,	8357  ,	8320  ,	8248  ,	8211  ,	8140  ,	8102  ,	8031  ,	7994  ,	7923  ,	7885  ,	
	7814  ,	7776  ,	7706  ,	7667  ,	7597  ,	7558  ,	7488  ,	7450  ,	7380  ,	7341  ,	7271  ,	7232  ,	7163  ,	7123  ,	7054  ,	7015  ,	
	6946  ,	6906  ,	6837  ,	6797  ,	6729  ,	6688  ,	6620  ,	6579  ,	6512  ,	6471  ,	6403  ,	6362  ,	6295  ,	6253  ,	6186  ,	6144  ,	
	6078  ,	6036  ,	5969  ,	5927  ,	5861  ,	5818  ,	5752  ,	5709  ,	5644  ,	5601  ,	5535  ,	5492  ,	5426  ,	5383  ,	5318  ,	5274  ,	
	5209  ,	5166  ,	5101  ,	5057  ,	4992  ,	4948  ,	4884  ,	4839  ,	4775  ,	4730  ,	4667  ,	4622  ,	4558  ,	4513  ,	4450  ,	4404  ,	
	4341  ,	4295  ,	4233  ,	4187  ,	4124  ,	4078  ,	4016  ,	3969  ,	3907  ,	3860  ,	3798  ,	3752  ,	3690  ,	3643  ,	3581  ,	3534  ,	
	3473  ,	3425  ,	3364  ,	3317  ,	3256  ,	3208  ,	3147  ,	3099  ,	3039  ,	2990  ,	2930  ,	2882  ,	2822  ,	2773  ,	2713  ,	2664  ,	
	2605  ,	2555  ,	2496  ,	2447  ,	2387  ,	2338  ,	2279  ,	2229  ,	2170  ,	2120  ,	2062  ,	2011  ,	1953  ,	1903  ,	1845  ,	1794  ,	
	1736  ,	1685  ,	1628  ,	1576  ,	1519  ,	1468  ,	1411  ,	1359  ,	1302  ,	1250  ,	1193  ,	1141  ,	1085  ,	1033  ,	976   ,	924   ,	
	868   ,	815   ,	759   ,	706   ,	651   ,	598   ,	542   ,	489   ,	434   ,	380   ,	325   ,	271   ,	217   ,	163   ,	108   ,	54    ,	
	0     ,	-54   ,	-108  ,	-163  ,	-217  ,	-271  ,	-325  ,	-380  ,	-434  ,	-489  ,	-542  ,	-598  ,	-651  ,	-706  ,	-759  ,	-815  ,	
	-868  ,	-924  ,	-976  ,	-1033 ,	-1085 ,	-1141 ,	-1193 ,	-1250 ,	-1302 ,	-1359 ,	-1411 ,	-1468 ,	-1519 ,	-1576 ,	-1628 ,	-1685 ,	
	-1736 ,	-1794 ,	-1845 ,	-1903 ,	-1953 ,	-2011 ,	-2062 ,	-2120 ,	-2170 ,	-2229 ,	-2279 ,	-2338 ,	-2387 ,	-2447 ,	-2496 ,	-2555 ,	
	-2605 ,	-2664 ,	-2713 ,	-2773 ,	-2822 ,	-2882 ,	-2930 ,	-2990 ,	-3039 ,	-3099 ,	-3147 ,	-3208 ,	-3256 ,	-3317 ,	-3364 ,	-3425 ,	
	-3473 ,	-3534 ,	-3581 ,	-3643 ,	-3690 ,	-3752 ,	-3798 ,	-3860 ,	-3907 ,	-3969 ,	-4016 ,	-4078 ,	-4124 ,	-4187 ,	-4233 ,	-4295 ,	
	-4341 ,	-4404 ,	-4450 ,	-4513 ,	-4558 ,	-4622 ,	-4667 ,	-4730 ,	-4775 ,	-4839 ,	-4884 ,	-4948 ,	-4992 ,	-5057 ,	-5101 ,	-5166 ,	
	-5209 ,	-5274 ,	-5318 ,	-5383 ,	-5426 ,	-5492 ,	-5535 ,	-5601 ,	-5644 ,	-5709 ,	-5752 ,	-5818 ,	-5861 ,	-5927 ,	-5969 ,	-6036 ,	
	-6078 ,	-6144 ,	-6186 ,	-6253 ,	-6295 ,	-6362 ,	-6403 ,	-6471 ,	-6512 ,	-6579 ,	-6620 ,	-6688 ,	-6729 ,	-6797 ,	-6837 ,	-6906 ,	
	-6946 ,	-7015 ,	-7054 ,	-7123 ,	-7163 ,	-7232 ,	-7271 ,	-7341 ,	-7380 ,	-7450 ,	-7488 ,	-7558 ,	-7597 ,	-7667 ,	-7706 ,	-7776 ,	
	-7814 ,	-7885 ,	-7923 ,	-7994 ,	-8031 ,	-8102 ,	-8140 ,	-8211 ,	-8248 ,	-8320 ,	-8357 ,	-8429 ,	-8465 ,	-8537 ,	-8574 ,	-8646 ,	
	-8682 ,	-8755 ,	-8791 ,	-8864 ,	-8899 ,	-8973 ,	-9008 ,	-9081 ,	-9116 ,	-9190 ,	-9225 ,	-9299 ,	-9333 ,	-9408 ,	-9442 ,	-9517 ,	
	-9550 ,	-9625 ,	-9659 ,	-9734 ,	-9767 ,	-9843 ,	-9876 ,	-9952 ,	-9984 ,	-10061,	-10093,	-10169,	-10201,	-10278,	-10310,	-10387,	
	-10418,	-10496,	-10527,	-10605,	-10635,	-10713,	-10744,	-10822,	-10852,	-10931,	-10961,	-11040,	-11069,	-11149,	-11178,	-11257,	
	-11286,	-11366,	-11395,	-11475,	-11503,	-11584,	-11612,	-11693,	-11720,	-11801,	-11829,	-11910,	-11937,	-12019,	-12046,	-12128,	
	-12154,	-12237,	-12262,	-12346,	-12371,	-12454,	-12479,	-12563,	-12588,	-12672,	-12696,	-12781,	-12805,	-12890,	-12913,	-12999,	
	-13022,	-13107,	-13130,	-13216,	-13239,	-13325,	-13347,	-13434,	-13455,	-13543,	-13564,	-13652,	-13672,	-13761,	-13781,	-13869,	
	-13889,	-13978,	-13998,	-14087,	-14106,	-14196,	-14215,	-14305,	-14323,	-14414,	-14431,	-14523,	-14540,	-14631,	-14648,	-14740,	
	-14757,	-14849,	-14865,	-14958,	-14973,	-15067,	-15082,	-15176,	-15190,	-15285,	-15299,	-15394,	-15407,	-15503,	-15515,	-15612,	
	-15624,	-15720,	-15732,	-15829,	-15841,	-15938,	-15949,	-16047,	-16057,	-16156,	-16166,	-16265,	-16274,	-16374,	-16382,	-16483,	
	-16491,	-16592,	-16599,	-16701,	-16707,	-16810,	-16816,	-16919,	-16924,	-17028,	-17032,	-17137,	-17141,	-17246,	-17249,	-17355,	
	-17357,	-17464,	-17466,	-17573,	-17574,	-17682,	-17682,	-17791,	-17791,	-17900,	-17899,	-18009,	-18007,	-18118,	-18115,	-18227,	
	-18224,	-18336,	-18332,	-18445,	-18440,	-18554,	-18548,	-18663,	-18657,	-18772,	-18765,	-18881,	-18873,	-18990,	-18981,	-19099,	
	-19089,	-19209,	-19198,	-19318,	-19306,	-19427,	-19414,	-19536,	-19522,	-19645,	-19630,	-19754,	-19738,	-19864,	-19846,	-19973,	
	-19954,	-20082,	-20062,	-20191,	-20170,	-20301,	-20278,	-20410,	-20386,	-20519,	-20494,	-20628,	-20602,	-20738,	-20710,	-20847,	
	-20818,	-20957,	-20926,	-21066,	-21034,	-21175,	-21142,	-21285,	-21250,	-21394,	-21358,	-21504,	-21465,	-21613,	-21573,	-21723,	
	-21681,	-21832,	-21789,	-21942,	-21896,	-22052,	-22004,	-22161,	-22112,	-22271,	-22219,	-22381,	-22327,	-22491,	-22434,	-22601,	
	-22541,	-22710,	-22649,	-22820,	-22756,	-22930,	-22863,	-23040,	-22971,	-23151,	-23078,	-23261,	-23185,	-23371,	-23292,	-23481,	
	-23399,	-23592,	-23505,	-23702,	-23612,	-23813,	-23719,	-23924,	-23825,	-24035,	-23932,	-24146,	-24038,	-24257,	-24144,	-24368,	
	-24250,	-24479,	-24356,	-24591,	-24461,	-24703,	-24567,	-24815,	-24672,	-24927,	-24777,	-25040,	-24881,	-25153,	-24986,	-25266,	
	-25089,	-25379,	-25193,	-25493,	-25296,	-25608,	-25399,	-25723,	-25500,	-25839,	-25602,	-25955,	-25702,	-26073,	-25801,	-26191,	
	-25900,	-26311,	-25997,	-26432,	-26092,	-26555,	-26185,	-26680,	-26275,	-26809,	-26363,	-26941,	-26446,	-27078,	-26523,	-27221,	
	-26593,	-27374,	-26651,	-27540,	-26693,	-27727,	-26708,	-27949,	-26677,	-28235,	-26553,	-28660,	-26204,	-29491,	-25002,	-32737,	
	//Osc 1	Level 2
	0     ,	32683 ,	24894 ,	29328 ,	25987 ,	28389 ,	26228 ,	27854 ,	26243 ,	27460 ,	26165 ,	27129 ,	26042 ,	26833 ,	25891 ,	26558 ,	
	25724 ,	26297 ,	25546 ,	26044 ,	25360 ,	25799 ,	25169 ,	25558 ,	24973 ,	25321 ,	24774 ,	25087 ,	24572 ,	24855 ,	24368 ,	24625 ,	
	24163 ,	24397 ,	23956 ,	24169 ,	23748 ,	23943 ,	23539 ,	23718 ,	23330 ,	23494 ,	23119 ,	23270 ,	22908 ,	23046 ,	22697 ,	22824 ,	
	22484 ,	22601 ,	22272 ,	22379 ,	22059 ,	22158 ,	21846 ,	21936 ,	21633 ,	21715 ,	21419 ,	21495 ,	21205 ,	21274 ,	20991 ,	21054 ,	
	20777 ,	20833 ,	20562 ,	20613 ,	20347 ,	20394 ,	20133 ,	20174 ,	19918 ,	19954 ,	19703 ,	19735 ,	19488 ,	19515 ,	19272 ,	19296 ,	
	19057 ,	19077 ,	18842 ,	18858 ,	18626 ,	18639 ,	18410 ,	18420 ,	18195 ,	18201 ,	17979 ,	17982 ,	17763 ,	17763 ,	17547 ,	17544 ,	
	17332 ,	17326 ,	17116 ,	17107 ,	16900 ,	16889 ,	16684 ,	16670 ,	16467 ,	16452 ,	16251 ,	16233 ,	16035 ,	16015 ,	15819 ,	15796 ,	
	15603 ,	15578 ,	15387 ,	15360 ,	15170 ,	15141 ,	14954 ,	14923 ,	14738 ,	14705 ,	14521 ,	14487 ,	14305 ,	14268 ,	14088 ,	14050 ,	
	13872 ,	13832 ,	13656 ,	13614 ,	13439 ,	13396 ,	13223 ,	13178 ,	13006 ,	12960 ,	12789 ,	12742 ,	12573 ,	12524 ,	12356 ,	12306 ,	
	12140 ,	12088 ,	11923 ,	11870 ,	11707 ,	11652 ,	11490 ,	11434 ,	11273 ,	11216 ,	11057 ,	10998 ,	10840 ,	10780 ,	10623 ,	10562 ,	
	10407 ,	10344 ,	10190 ,	10126 ,	9973  ,	9908  ,	9757  ,	9690  ,	9540  ,	9472  ,	9323  ,	9255  ,	9106  ,	9037  ,	8890  ,	8819  ,	
	8673  ,	8601  ,	8456  ,	8383  ,	8239  ,	8165  ,	8023  ,	7947  ,	7806  ,	7730  ,	7589  ,	7512  ,	7372  ,	7294  ,	7155  ,	7076  ,	
	6939  ,	6858  ,	6722  ,	6641  ,	6505  ,	6423  ,	6288  ,	6205  ,	6071  ,	5987  ,	5855  ,	5770  ,	5638  ,	5552  ,	5421  ,	5334  ,	
	5204  ,	5116  ,	4987  ,	4898  ,	4770  ,	4681  ,	4554  ,	4463  ,	4337  ,	4245  ,	4120  ,	4027  ,	3903  ,	3810  ,	3686  ,	3592  ,	
	3469  ,	3374  ,	3253  ,	3157  ,	3036  ,	2939  ,	2819  ,	2721  ,	2602  ,	2503  ,	2385  ,	2286  ,	2168  ,	2068  ,	1951  ,	1850  ,	
	1734  ,	1632  ,	1518  ,	1415  ,	1301  ,	1197  ,	1084  ,	979   ,	867   ,	762   ,	650   ,	544   ,	433   ,	326   ,	216   ,	108   ,	
	0     ,	-108  ,	-216  ,	-326  ,	-433  ,	-544  ,	-650  ,	-762  ,	-867  ,	-979  ,	-1084 ,	-1197 ,	-1301 ,	-1415 ,	-1518 ,	-1632 ,	
	-1734 ,	-1850 ,	-1951 ,	-2068 ,	-2168 ,	-2286 ,	-2385 ,	-2503 ,	-2602 ,	-2721 ,	-2819 ,	-2939 ,	-3036 ,	-3157 ,	-3253 ,	-3374 ,	
	-3469 ,	-3592 ,	-3686 ,	-3810 ,	-3903 ,	-4027 ,	-4120 ,	-4245 ,	-4337 ,	-4463 ,	-4554 ,	-4681 ,	-4770 ,	-4898 ,	-4987 ,	-5116 ,	
	-5204 ,	-5334 ,	-5421 ,	-5552 ,	-5638 ,	-5770 ,	-5855 ,	-5987 ,	-6071 ,	-6205 ,	-6288 ,	-6423 ,	-6505 ,	-6641 ,	-6722 ,	-6858 ,	
	-6939 ,	-7076 ,	-7155 ,	-7294 ,	-7372 ,	-7512 ,	-7589 ,	-7730 ,	-7806 ,	-7947 ,	-8023 ,	-8165 ,	-8239 ,	-8383 ,	-8456 ,	-8601 ,	
	-8673 ,	-8819 ,	-8890 ,	-9037 ,	-9106 ,	-9255 ,	-9323 ,	-9472 ,	-9540 ,	-9690 ,	-9757 ,	-9908 ,	-9973 ,	-10126,	-10190,	-10344,	
	-10407,	-10562,	-10623,	-10780,	-10840,	-10998,	-11057,	-11216,	-11273,	-11434,	-11490,	-11652,	-11707,	-11870,	-11923,	-12088,	
	-12140,	-12306,	-12356,	-12524,	-12573,	-12742,	-12789,	-12960,	-13006,	-13178,	-13223,	-13396,	-13439,	-13614,	-13656,	-13832,	
	-13872,	-14050,	-14088,	-14268,	-14305,	-14487,	-14521,	-14705,	-14738,	-14923,	-14954,	-15141,	-15170,	-15360,	-15387,	-15578,	
	-15603,	-15796,	-15819,	-16015,	-16035,	-16233,	-16251,	-16452,	-16467,	-16670,	-16684,	-16889,	-16900,	-17107,	-17116,	-17326,	
	-17332,	-17544,	-17547,	-17763,	-17763,	-17982,	-17979,	-18201,	-18195,	-18420,	-18410,	-18639,	-18626,	-18858,	-18842,	-19077,	
	-19057,	-19296,	-19272,	-19515,	-19488,	-19735,	-19703,	-19954,	-19918,	-20174,	-20133,	-20394,	-20347,	-20613,	-20562,	-20833,	
	-20777,	-21054,	-20991,	-21274,	-21205,	-21495,	-21419,	-21715,	-21633,	-21936,	-21846,	-22158,	-22059,	-22379,	-22272,	-22601,	
	-22484,	-22824,	-22697,	-23046,	-22908,	-23270,	-23119,	-23494,	-23330,	-23718,	-23539,	-23943,	-23748,	-24169,	-23956,	-24397,	
	-24163,	-24625,	-24368,	-24855,	-24572,	-25087,	-24774,	-25321,	-24973,	-25558,	-25169,	-25799,	-25360,	-26044,	-25546,	-26297,	
	-25724,	-26558,	-25891,	-26833,	-26042,	-27129,	-26165,	-27460,	-26243,	-27854,	-26228,	-28389,	-25987,	-29328,	-24894,	-32683,	
	//Osc 1	Level 3
	0     ,	32574 ,	24677 ,	29002 ,	25553 ,	27844 ,	25577 ,	27092 ,	25375 ,	26480 ,	25081 ,	25932 ,	24740 ,	25418 ,	24373 ,	24925 ,	
	23989 ,	24446 ,	23594 ,	23976 ,	23192 ,	23513 ,	22783 ,	23054 ,	22371 ,	22599 ,	21955 ,	22148 ,	21536 ,	21698 ,	21115 ,	21250 ,	
	20693 ,	20804 ,	20269 ,	20359 ,	19845 ,	19915 ,	19419 ,	19472 ,	18992 ,	19030 ,	18565 ,	18588 ,	18137 ,	18147 ,	17709 ,	17707 ,	
	17280 ,	17267 ,	16851 ,	16827 ,	16421 ,	16388 ,	15991 ,	15949 ,	15561 ,	15510 ,	15130 ,	15071 ,	14699 ,	14633 ,	14268 ,	14195 ,	
	13837 ,	13757 ,	13406 ,	13319 ,	12975 ,	12881 ,	12543 ,	12444 ,	12111 ,	12006 ,	11680 ,	11569 ,	11248 ,	11132 ,	10816 ,	10695 ,	
	10384 ,	10257 ,	9951  ,	9821  ,	9519  ,	9384  ,	9087  ,	8947  ,	8654  ,	8510  ,	8222  ,	8073  ,	7790  ,	7637  ,	7357  ,	7200  ,	
	6924  ,	6763  ,	6492  ,	6327  ,	6059  ,	5890  ,	5626  ,	5454  ,	5194  ,	5017  ,	4761  ,	4581  ,	4328  ,	4145  ,	3895  ,	3708  ,	
	3463  ,	3272  ,	3030  ,	2835  ,	2597  ,	2399  ,	2164  ,	1963  ,	1731  ,	1527  ,	1298  ,	1090  ,	865   ,	654   ,	432   ,	218   ,	
	0     ,	-218  ,	-432  ,	-654  ,	-865  ,	-1090 ,	-1298 ,	-1527 ,	-1731 ,	-1963 ,	-2164 ,	-2399 ,	-2597 ,	-2835 ,	-3030 ,	-3272 ,	
	-3463 ,	-3708 ,	-3895 ,	-4145 ,	-4328 ,	-4581 ,	-4761 ,	-5017 ,	-5194 ,	-5454 ,	-5626 ,	-5890 ,	-6059 ,	-6327 ,	-6492 ,	-6763 ,	
	-6924 ,	-7200 ,	-7357 ,	-7637 ,	-7790 ,	-8073 ,	-8222 ,	-8510 ,	-8654 ,	-8947 ,	-9087 ,	-9384 ,	-9519 ,	-9821 ,	-9951 ,	-10257,	
	-10384,	-10695,	-10816,	-11132,	-11248,	-11569,	-11680,	-12006,	-12111,	-12444,	-12543,	-12881,	-12975,	-13319,	-13406,	-13757,	
	-13837,	-14195,	-14268,	-14633,	-14699,	-15071,	-15130,	-15510,	-15561,	-15949,	-15991,	-16388,	-16421,	-16827,	-16851,	-17267,	
	-17280,	-17707,	-17709,	-18147,	-18137,	-18588,	-18565,	-19030,	-18992,	-19472,	-19419,	-19915,	-19845,	-20359,	-20269,	-20804,	
	-20693,	-21250,	-21115,	-21698,	-21536,	-22148,	-21955,	-22599,	-22371,	-23054,	-22783,	-23513,	-23192,	-23976,	-23594,	-24446,	
	-23989,	-24925,	-24373,	-25418,	-24740,	-25932,	-25081,	-26480,	-25375,	-27092,	-25577,	-27844,	-25553,	-29002,	-24677,	-32574,	
	//Osc 1	Level 4
	0     ,	32356 ,	24244 ,	28347 ,	24687 ,	26753 ,	24279 ,	25565 ,	23644 ,	24517 ,	22916 ,	23532 ,	22143 ,	22582 ,	21343 ,	21653 ,	
	20526 ,	20737 ,	19699 ,	19831 ,	18863 ,	18931 ,	18022 ,	18036 ,	17176 ,	17145 ,	16328 ,	16257 ,	15476 ,	15371 ,	14623 ,	14486 ,	
	13768 ,	13604 ,	12912 ,	12722 ,	12055 ,	11842 ,	11196 ,	10962 ,	10337 ,	10083 ,	9478  ,	9204  ,	8617  ,	8326  ,	7757  ,	7449  ,	
	6896  ,	6572  ,	6034  ,	5695  ,	5173  ,	4818  ,	4311  ,	3942  ,	3449  ,	3066  ,	2587  ,	2190  ,	1724  ,	1313  ,	862   ,	437   ,	
	0     ,	-437  ,	-862  ,	-1313 ,	-1724 ,	-2190 ,	-2587 ,	-3066 ,	-3449 ,	-3942 ,	-4311 ,	-4818 ,	-5173 ,	-5695 ,	-6034 ,	-6572 ,	
	-6896 ,	-7449 ,	-7757 ,	-8326 ,	-8617 ,	-9204 ,	-9478 ,	-10083,	-10337,	-10962,	-11196,	-11842,	-12055,	-12722,	-12912,	-13604,	
	-13768,	-14486,	-14623,	-15371,	-15476,	-16257,	-16328,	-17145,	-17176,	-18036,	-18022,	-18931,	-18863,	-19831,	-19699,	-20737,	
	-20526,	-21653,	-21343,	-22582,	-22143,	-23532,	-22916,	-24517,	-23644,	-25565,	-24279,	-26753,	-24687,	-28347,	-24244,	-32356,	
	//Osc 1	Level 5
	0     ,	31918 ,	23381 ,	27033 ,	22963 ,	24563 ,	21692 ,	22499 ,	20194 ,	20574 ,	18605 ,	18713 ,	16970 ,	16887 ,	15308 ,	15081 ,	
	13630 ,	13288 ,	11941 ,	11504 ,	10245 ,	9726  ,	8544  ,	7953  ,	6838  ,	6183  ,	5131  ,	4415  ,	3421  ,	2648  ,	1711  ,	882   ,	
	0     ,	-882  ,	-1711 ,	-2648 ,	-3421 ,	-4415 ,	-5131 ,	-6183 ,	-6838 ,	-7953 ,	-8544 ,	-9726 ,	-10245,	-11504,	-11941,	-13288,	
	-13630,	-15081,	-15308,	-16887,	-16970,	-18713,	-18605,	-20574,	-20194,	-22499,	-21692,	-24563,	-22963,	-27033,	-23381,	-31918,	
	//Osc 1	Level 6
	0     ,	31035 ,	21670 ,	24385 ,	19541 ,	20148 ,	16560 ,	16316 ,	13355 ,	12621 ,	10061 ,	8986  ,	6724  ,	5382  ,	3366  ,	1792  ,	
	0     ,	-1792 ,	-3366 ,	-5382 ,	-6724 ,	-8986 ,	-10061,	-12621,	-13355,	-16316,	-16560,	-20148,	-19541,	-24385,	-21670,	-31035,	
	//Osc 1	Level 7
	0     ,	29242 ,	18303 ,	19002 ,	12816 ,	11161 ,	6499  ,	3695  ,	0     ,	-3695 ,	-6499 ,	-11161,	-12816,	-19002,	-18303,	-29242,	
	//Osc 1	Level 8
	0     ,	25547 ,	11804 ,	7840  ,	0     ,	-7840 ,	-11804,	-25547,	
	//Osc 1	Level 9
	0     ,	17707 ,	0     ,	-17706,	
	//Osc 1	Level 10
	0     ,	0     ,	
	//Osc 1	Level 11
	0     ,	0     ,	
    },
    //Osc 2	Level 0
    {
	0     ,	30341 ,	23234 ,	27438 ,	24446 ,	26770 ,	24870 ,	26477 ,	25085 ,	26313 ,	25214 ,	26208 ,	25301 ,	26135 ,	25362 ,	26082 ,	
	25409 ,	26041 ,	25445 ,	26009 ,	25474 ,	25983 ,	25498 ,	25961 ,	25517 ,	25943 ,	25534 ,	25928 ,	25548 ,	25915 ,	25561 ,	25903 ,	
	25571 ,	25893 ,	25581 ,	25884 ,	25590 ,	25876 ,	25597 ,	25869 ,	25604 ,	25862 ,	25610 ,	25856 ,	25616 ,	25851 ,	25621 ,	25846 ,	
	25626 ,	25841 ,	25630 ,	25837 ,	25634 ,	25833 ,	25638 ,	25830 ,	25641 ,	25827 ,	25644 ,	25824 ,	25647 ,	25821 ,	25650 ,	25818 ,	
	25653 ,	25815 ,	25655 ,	25813 ,	25657 ,	25811 ,	25660 ,	25809 ,	25662 ,	25807 ,	25664 ,	25805 ,	25665 ,	25803 ,	25667 ,	25801 ,	
	25669 ,	25800 ,	25670 ,	25798 ,	25672 ,	25797 ,	25673 ,	25795 ,	25675 ,	25794 ,	25676 ,	25793 ,	25677 ,	25791 ,	25678 ,	25790 ,	
	25680 ,	25789 ,	25681 ,	25788 ,	25682 ,	25787 ,	25683 ,	25786 ,	25684 ,	25785 ,	25685 ,	25784 ,	25685 ,	25783 ,	25686 ,	25783 ,	
	25687 ,	25782 ,	25688 ,	25781 ,	25689 ,	25780 ,	25689 ,	25779 ,	25690 ,	25779 ,	25691 ,	25778 ,	25692 ,	25777 ,	25692 ,	25777 ,	
	25693 ,	25776 ,	25693 ,	25776 ,	25694 ,	25775 ,	25695 ,	25774 ,	25695 ,	25774 ,	25696 ,	25773 ,	25696 ,	25773 ,	25697 ,	25772 ,	
	25697 ,	25772 ,	25698 ,	25771 ,	25698 ,	25771 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25700 ,	25769 ,	25700 ,	25769 ,	
	25701 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	25702 ,	25767 ,	25702 ,	25767 ,	25703 ,	25767 ,	25703 ,	25766 ,	25703 ,	25766 ,	
	25704 ,	25766 ,	25704 ,	25765 ,	25704 ,	25765 ,	25704 ,	25765 ,	25705 ,	25764 ,	25705 ,	25764 ,	25705 ,	25764 ,	25706 ,	25764 ,	
	25706 ,	25763 ,	25706 ,	25763 ,	25706 ,	25763 ,	25707 ,	25763 ,	25707 ,	25762 ,	25707 ,	25762 ,	25707 ,	25762 ,	25708 ,	25762 ,	
	25708 ,	25761 ,	25708 ,	25761 ,	25708 ,	25761 ,	25708 ,	25761 ,	25709 ,	25761 ,	25709 ,	25760 ,	25709 ,	25760 ,	25709 ,	25760 ,	
	25709 ,	25760 ,	25710 ,	25760 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25711 ,	25759 ,	
	25711 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	25712 ,	25758 ,	25712 ,	25757 ,	25712 ,	25757 ,	
	25712 ,	25757 ,	25712 ,	25757 ,	25712 ,	25757 ,	25712 ,	25757 ,	25713 ,	25757 ,	25713 ,	25757 ,	25713 ,	25756 ,	25713 ,	25756 ,	
	25713 ,	25756 ,	25713 ,	25756 ,	25713 ,	25756 ,	25713 ,	25756 ,	25714 ,	25756 ,	25714 ,	25756 ,	25714 ,	25755 ,	25714 ,	25755 ,	
	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25715 ,	25755 ,	25715 ,	25755 ,	
	25715 ,	25755 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	
	25715 ,	25754 ,	25715 ,	25754 ,	25716 ,	25754 ,	25716 ,	25754 ,	25716 ,	25754 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	
	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	
	25716 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	
	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	
	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	
	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	
	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	
	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	
	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	
	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	
	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25719 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	
	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25751 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	
	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25718 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	
	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	
	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25752 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	25717 ,	25753 ,	
	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	
	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25753 ,	25716 ,	25754 ,	25716 ,	25754 ,	25716 ,	25754 ,	25716 ,	25754 ,	25715 ,	25754 ,	
	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25754 ,	25715 ,	25755 ,	
	25715 ,	25755 ,	25715 ,	25755 ,	25715 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25755 ,	
	25714 ,	25755 ,	25714 ,	25755 ,	25714 ,	25756 ,	25714 ,	25756 ,	25714 ,	25756 ,	25713 ,	25756 ,	25713 ,	25756 ,	25713 ,	25756 ,	
	25713 ,	25756 ,	25713 ,	25756 ,	25713 ,	25757 ,	25713 ,	25757 ,	25713 ,	25757 ,	25712 ,	25757 ,	25712 ,	25757 ,	25712 ,	25757 ,	
	25712 ,	25757 ,	25712 ,	25757 ,	25712 ,	25758 ,	25712 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	25711 ,	25758 ,	
	25711 ,	25759 ,	25711 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25759 ,	25710 ,	25760 ,	25710 ,	25760 ,	
	25709 ,	25760 ,	25709 ,	25760 ,	25709 ,	25760 ,	25709 ,	25761 ,	25709 ,	25761 ,	25708 ,	25761 ,	25708 ,	25761 ,	25708 ,	25761 ,	
	25708 ,	25762 ,	25708 ,	25762 ,	25707 ,	25762 ,	25707 ,	25762 ,	25707 ,	25763 ,	25707 ,	25763 ,	25706 ,	25763 ,	25706 ,	25763 ,	
	25706 ,	25764 ,	25706 ,	25764 ,	25705 ,	25764 ,	25705 ,	25764 ,	25705 ,	25765 ,	25704 ,	25765 ,	25704 ,	25765 ,	25704 ,	25766 ,	
	25704 ,	25766 ,	25703 ,	25766 ,	25703 ,	25767 ,	25703 ,	25767 ,	25702 ,	25767 ,	25702 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	
	25701 ,	25769 ,	25700 ,	25769 ,	25700 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25771 ,	25698 ,	25771 ,	25698 ,	25772 ,	
	25697 ,	25772 ,	25697 ,	25773 ,	25696 ,	25773 ,	25696 ,	25774 ,	25695 ,	25774 ,	25695 ,	25775 ,	25694 ,	25776 ,	25693 ,	25776 ,	
	25693 ,	25777 ,	25692 ,	25777 ,	25692 ,	25778 ,	25691 ,	25779 ,	25690 ,	25779 ,	25689 ,	25780 ,	25689 ,	25781 ,	25688 ,	25782 ,	
	25687 ,	25783 ,	25686 ,	25783 ,	25685 ,	25784 ,	25685 ,	25785 ,	25684 ,	25786 ,	25683 ,	25787 ,	25682 ,	25788 ,	25681 ,	25789 ,	
	25680 ,	25790 ,	25678 ,	25791 ,	25677 ,	25793 ,	25676 ,	25794 ,	25675 ,	25795 ,	25673 ,	25797 ,	25672 ,	25798 ,	25670 ,	25800 ,	
	25669 ,	25801 ,	25667 ,	25803 ,	25665 ,	25805 ,	25664 ,	25807 ,	25662 ,	25809 ,	25660 ,	25811 ,	25657 ,	25813 ,	25655 ,	25815 ,	
	25653 ,	25818 ,	25650 ,	25821 ,	25647 ,	25824 ,	25644 ,	25827 ,	25641 ,	25830 ,	25638 ,	25833 ,	25634 ,	25837 ,	25630 ,	25841 ,	
	25626 ,	25846 ,	25621 ,	25851 ,	25616 ,	25856 ,	25610 ,	25862 ,	25604 ,	25869 ,	25597 ,	25876 ,	25590 ,	25884 ,	25581 ,	25893 ,	
	25571 ,	25903 ,	25561 ,	25915 ,	25548 ,	25928 ,	25534 ,	25943 ,	25517 ,	25961 ,	25498 ,	25983 ,	25474 ,	26009 ,	25445 ,	26041 ,	
	25409 ,	26082 ,	25362 ,	26135 ,	25301 ,	26208 ,	25214 ,	26313 ,	25085 ,	26477 ,	24870 ,	26770 ,	24446 ,	27438 ,	23234 ,	30341 ,	
	0     ,	-30341,	-23234,	-27438,	-24446,	-26770,	-24870,	-26477,	-25085,	-26313,	-25214,	-26208,	-25301,	-26135,	-25362,	-26082,	
	-25409,	-26041,	-25445,	-26009,	-25474,	-25983,	-25498,	-25961,	-25517,	-25943,	-25534,	-25928,	-25548,	-25915,	-25561,	-25903,	
	-25571,	-25893,	-25581,	-25884,	-25590,	-25876,	-25597,	-25869,	-25604,	-25862,	-25610,	-25856,	-25616,	-25851,	-25621,	-25846,	
	-25626,	-25841,	-25630,	-25837,	-25634,	-25833,	-25638,	-25830,	-25641,	-25827,	-25644,	-25824,	-25647,	-25821,	-25650,	-25818,	
	-25653,	-25815,	-25655,	-25813,	-25657,	-25811,	-25660,	-25809,	-25662,	-25807,	-25664,	-25805,	-25665,	-25803,	-25667,	-25801,	
	-25669,	-25800,	-25670,	-25798,	-25672,	-25797,	-25673,	-25795,	-25675,	-25794,	-25676,	-25793,	-25677,	-25791,	-25678,	-25790,	
	-25680,	-25789,	-25681,	-25788,	-25682,	-25787,	-25683,	-25786,	-25684,	-25785,	-25685,	-25784,	-25685,	-25783,	-25686,	-25783,	
	-25687,	-25782,	-25688,	-25781,	-25689,	-25780,	-25689,	-25779,	-25690,	-25779,	-25691,	-25778,	-25692,	-25777,	-25692,	-25777,	
	-25693,	-25776,	-25693,	-25776,	-25694,	-25775,	-25695,	-25774,	-25695,	-25774,	-25696,	-25773,	-25696,	-25773,	-25697,	-25772,	
	-25697,	-25772,	-25698,	-25771,	-25698,	-25771,	-25699,	-25770,	-25699,	-25770,	-25699,	-25770,	-25700,	-25769,	-25700,	-25769,	
	-25701,	-25768,	-25701,	-25768,	-25701,	-25768,	-25702,	-25767,	-25702,	-25767,	-25703,	-25767,	-25703,	-25766,	-25703,	-25766,	
	-25704,	-25766,	-25704,	-25765,	-25704,	-25765,	-25704,	-25765,	-25705,	-25764,	-25705,	-25764,	-25705,	-25764,	-25706,	-25764,	
	-25706,	-25763,	-25706,	-25763,	-25706,	-25763,	-25707,	-25763,	-25707,	-25762,	-25707,	-25762,	-25707,	-25762,	-25708,	-25762,	
	-25708,	-25761,	-25708,	-25761,	-25708,	-25761,	-25708,	-25761,	-25709,	-25761,	-25709,	-25760,	-25709,	-25760,	-25709,	-25760,	
	-25709,	-25760,	-25710,	-25760,	-25710,	-25759,	-25710,	-25759,	-25710,	-25759,	-25710,	-25759,	-25710,	-25759,	-25711,	-25759,	
	-25711,	-25758,	-25711,	-25758,	-25711,	-25758,	-25711,	-25758,	-25711,	-25758,	-25712,	-25758,	-25712,	-25757,	-25712,	-25757,	
	-25712,	-25757,	-25712,	-25757,	-25712,	-25757,	-25712,	-25757,	-25713,	-25757,	-25713,	-25757,	-25713,	-25756,	-25713,	-25756,	
	-25713,	-25756,	-25713,	-25756,	-25713,	-25756,	-25713,	-25756,	-25714,	-25756,	-25714,	-25756,	-25714,	-25755,	-25714,	-25755,	
	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25715,	-25755,	-25715,	-25755,	
	-25715,	-25755,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	
	-25715,	-25754,	-25715,	-25754,	-25716,	-25754,	-25716,	-25754,	-25716,	-25754,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	
	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	
	-25716,	-25753,	-25717,	-25753,	-25717,	-25753,	-25717,	-25753,	-25717,	-25753,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	
	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	
	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	
	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	
	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	
	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	
	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	
	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	
	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25719,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	
	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25751,	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	
	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	-25718,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	
	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	
	-25717,	-25752,	-25717,	-25752,	-25717,	-25752,	-25717,	-25753,	-25717,	-25753,	-25717,	-25753,	-25717,	-25753,	-25717,	-25753,	
	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	
	-25716,	-25753,	-25716,	-25753,	-25716,	-25753,	-25716,	-25754,	-25716,	-25754,	-25716,	-25754,	-25716,	-25754,	-25715,	-25754,	
	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25754,	-25715,	-25755,	
	-25715,	-25755,	-25715,	-25755,	-25715,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	-25714,	-25755,	
	-25714,	-25755,	-25714,	-25755,	-25714,	-25756,	-25714,	-25756,	-25714,	-25756,	-25713,	-25756,	-25713,	-25756,	-25713,	-25756,	
	-25713,	-25756,	-25713,	-25756,	-25713,	-25757,	-25713,	-25757,	-25713,	-25757,	-25712,	-25757,	-25712,	-25757,	-25712,	-25757,	
	-25712,	-25757,	-25712,	-25757,	-25712,	-25758,	-25712,	-25758,	-25711,	-25758,	-25711,	-25758,	-25711,	-25758,	-25711,	-25758,	
	-25711,	-25759,	-25711,	-25759,	-25710,	-25759,	-25710,	-25759,	-25710,	-25759,	-25710,	-25759,	-25710,	-25760,	-25710,	-25760,	
	-25709,	-25760,	-25709,	-25760,	-25709,	-25760,	-25709,	-25761,	-25709,	-25761,	-25708,	-25761,	-25708,	-25761,	-25708,	-25761,	
	-25708,	-25762,	-25708,	-25762,	-25707,	-25762,	-25707,	-25762,	-25707,	-25763,	-25707,	-25763,	-25706,	-25763,	-25706,	-25763,	
	-25706,	-25764,	-25706,	-25764,	-25705,	-25764,	-25705,	-25764,	-25705,	-25765,	-25704,	-25765,	-25704,	-25765,	-25704,	-25766,	
	-25704,	-25766,	-25703,	-25766,	-25703,	-25767,	-25703,	-25767,	-25702,	-25767,	-25702,	-25768,	-25701,	-25768,	-25701,	-25768,	
	-25701,	-25769,	-25700,	-25769,	-25700,	-25770,	-25699,	-25770,	-25699,	-25770,	-25699,	-25771,	-25698,	-25771,	-25698,	-25772,	
	-25697,	-25772,	-25697,	-25773,	-25696,	-25773,	-25696,	-25774,	-25695,	-25774,	-25695,	-25775,	-25694,	-25776,	-25693,	-25776,	
	-25693,	-25777,	-25692,	-25777,	-25692,	-25778,	-25691,	-25779,	-25690,	-25779,	-25689,	-25780,	-25689,	-25781,	-25688,	-25782,	
	-25687,	-25783,	-25686,	-25783,	-25685,	-25784,	-25685,	-25785,	-25684,	-25786,	-25683,	-25787,	-25682,	-25788,	-25681,	-25789,	
	-25680,	-25790,	-25678,	-25791,	-25677,	-25793,	-25676,	-25794,	-25675,	-25795,	-25673,	-25797,	-25672,	-25798,	-25670,	-25800,	
	-25669,	-25801,	-25667,	-25803,	-25665,	-25805,	-25664,	-25807,	-25662,	-25809,	-25660,	-25811,	-25657,	-25813,	-25655,	-25815,	
	-25653,	-25818,	-25650,	-25821,	-25647,	-25824,	-25644,	-25827,	-25641,	-25830,	-25638,	-25833,	-25634,	-25837,	-25630,	-25841,	
	-25626,	-25846,	-25621,	-25851,	-25616,	-25856,	-25610,	-25862,	-25604,	-25869,	-25597,	-25876,	-25590,	-25884,	-25581,	-25893,	
	-25571,	-25903,	-25561,	-25915,	-25548,	-25928,	-25534,	-25943,	-25517,	-25961,	-25498,	-25983,	-25474,	-26009,	-25445,	-26041,	
	-25409,	-26082,	-25362,	-26135,	-25301,	-26208,	-25214,	-26313,	-25085,	-26477,	-24870,	-26770,	-24446,	-27438,	-23234,	-30341,	
	//Osc 2	Level 1
	0     ,	30341 ,	23234 ,	27438 ,	24446 ,	26770 ,	24870 ,	26477 ,	25085 ,	26313 ,	25214 ,	26208 ,	25300 ,	26136 ,	25362 ,	26082 ,	
	25408 ,	26042 ,	25445 ,	26010 ,	25473 ,	25984 ,	25497 ,	25962 ,	25517 ,	25944 ,	25533 ,	25929 ,	25548 ,	25915 ,	25560 ,	25904 ,	
	25571 ,	25894 ,	25580 ,	25885 ,	25589 ,	25877 ,	25596 ,	25870 ,	25603 ,	25863 ,	25609 ,	25857 ,	25615 ,	25852 ,	25620 ,	25847 ,	
	25624 ,	25843 ,	25629 ,	25839 ,	25633 ,	25835 ,	25636 ,	25831 ,	25640 ,	25828 ,	25643 ,	25825 ,	25646 ,	25822 ,	25648 ,	25820 ,	
	25651 ,	25817 ,	25653 ,	25815 ,	25656 ,	25813 ,	25658 ,	25810 ,	25660 ,	25809 ,	25662 ,	25807 ,	25663 ,	25805 ,	25665 ,	25803 ,	
	25667 ,	25802 ,	25668 ,	25800 ,	25670 ,	25799 ,	25671 ,	25798 ,	25672 ,	25796 ,	25674 ,	25795 ,	25675 ,	25794 ,	25676 ,	25793 ,	
	25677 ,	25792 ,	25678 ,	25791 ,	25679 ,	25790 ,	25680 ,	25789 ,	25681 ,	25788 ,	25682 ,	25787 ,	25683 ,	25786 ,	25683 ,	25785 ,	
	25684 ,	25785 ,	25685 ,	25784 ,	25686 ,	25783 ,	25686 ,	25783 ,	25687 ,	25782 ,	25688 ,	25781 ,	25688 ,	25781 ,	25689 ,	25780 ,	
	25689 ,	25780 ,	25690 ,	25779 ,	25690 ,	25779 ,	25691 ,	25778 ,	25691 ,	25778 ,	25692 ,	25777 ,	25692 ,	25777 ,	25693 ,	25776 ,	
	25693 ,	25776 ,	25694 ,	25775 ,	25694 ,	25775 ,	25694 ,	25775 ,	25695 ,	25774 ,	25695 ,	25774 ,	25696 ,	25774 ,	25696 ,	25773 ,	
	25696 ,	25773 ,	25696 ,	25773 ,	25697 ,	25772 ,	25697 ,	25772 ,	25697 ,	25772 ,	25698 ,	25772 ,	25698 ,	25771 ,	25698 ,	25771 ,	
	25698 ,	25771 ,	25699 ,	25771 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25700 ,	25770 ,	25700 ,	25769 ,	
	25700 ,	25769 ,	25700 ,	25769 ,	25700 ,	25769 ,	25701 ,	25769 ,	25701 ,	25769 ,	25701 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	
	25701 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	25702 ,	25768 ,	25702 ,	25768 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	
	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	
	25702 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	
	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	25703 ,	25767 ,	
	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	
	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25767 ,	25702 ,	25768 ,	25702 ,	25768 ,	25702 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	
	25701 ,	25768 ,	25701 ,	25768 ,	25701 ,	25768 ,	25701 ,	25769 ,	25701 ,	25769 ,	25701 ,	25769 ,	25700 ,	25769 ,	25700 ,	25769 ,	
	25700 ,	25769 ,	25700 ,	25770 ,	25700 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25770 ,	25699 ,	25771 ,	25699 ,	25771 ,	
	25698 ,	25771 ,	25698 ,	25771 ,	25698 ,	25772 ,	25698 ,	25772 ,	25697 ,	25772 ,	25697 ,	25772 ,	25697 ,	25773 ,	25696 ,	25773 ,	
	25696 ,	25773 ,	25696 ,	25774 ,	25696 ,	25774 ,	25695 ,	25774 ,	25695 ,	25775 ,	25694 ,	25775 ,	25694 ,	25775 ,	25694 ,	25776 ,	
	25693 ,	25776 ,	25693 ,	25777 ,	25692 ,	25777 ,	25692 ,	25778 ,	25691 ,	25778 ,	25691 ,	25779 ,	25690 ,	25779 ,	25690 ,	25780 ,	
	25689 ,	25780 ,	25689 ,	25781 ,	25688 ,	25781 ,	25688 ,	25782 ,	25687 ,	25783 ,	25686 ,	25783 ,	25686 ,	25784 ,	25685 ,	25785 ,	
	25684 ,	25785 ,	25683 ,	25786 ,	25683 ,	25787 ,	25682 ,	25788 ,	25681 ,	25789 ,	25680 ,	25790 ,	25679 ,	25791 ,	25678 ,	25792 ,	
	25677 ,	25793 ,	25676 ,	25794 ,	25675 ,	25795 ,	25674 ,	25796 ,	25672 ,	25798 ,	25671 ,	25799 ,	25670 ,	25800 ,	25668 ,	25802 ,	
	25667 ,	25803 ,	25665 ,	25805 ,	25663 ,	25807 ,	25662 ,	25809 ,	25660 ,	25810 ,	25658 ,	25813 ,	25656 ,	25815 ,	25653 ,	25817 ,	
	25651 ,	25820 ,	25648 ,	25822 ,	25646 ,	25825 ,	25643 ,	25828 ,	25640 ,	25831 ,	25636 ,	25835 ,	25633 ,	25839 ,	25629 ,	25843 ,	
	25624 ,	25847 ,	25620 ,	25852 ,	25615 ,	25857 ,	25609 ,	25863 ,	25603 ,	25870 ,	25596 ,	25877 ,	25589 ,	25885 ,	25580 ,	25894 ,	
	25571 ,	25904 ,	25560 ,	25915 ,	25548 ,	25929 ,	25533 ,	25944 ,	25517 ,	25962 ,	25497 ,	25984 ,	25473 ,	26010 ,	25445 ,	26042 ,	
	25408 ,	26082 ,	25362 ,	26136 ,	25300 ,	26208 ,	25214 ,	26313 ,	25085 ,	26477 ,	24870 ,	26770 ,	24446 ,	27438 ,	23234 ,	30341 ,	
	0     ,	-30341,	-23234,	-27438,	-24446,	-26770,	-24870,	-26477,	-25085,	-26313,	-25214,	-26208,	-25300,	-26136,	-25362,	-26082,	
	-25408,	-26042,	-25445,	-26010,	-25473,	-25984,	-25497,	-25962,	-25517,	-25944,	-25533,	-25929,	-25548,	-25915,	-25560,	-25904,	
	-25571,	-25894,	-25580,	-25885,	-25589,	-25877,	-25596,	-25870,	-25603,	-25863,	-25609,	-25857,	-25615,	-25852,	-25620,	-25847,	
	-25624,	-25843,	-25629,	-25839,	-25633,	-25835,	-25636,	-25831,	-25640,	-25828,	-25643,	-25825,	-25646,	-25822,	-25648,	-25820,	
	-25651,	-25817,	-25653,	-25815,	-25656,	-25813,	-25658,	-25810,	-25660,	-25809,	-25662,	-25807,	-25663,	-25805,	-25665,	-25803,	
	-25667,	-25802,	-25668,	-25800,	-25670,	-25799,	-25671,	-25798,	-25672,	-25796,	-25674,	-25795,	-25675,	-25794,	-25676,	-25793,	
	-25677,	-25792,	-25678,	-25791,	-25679,	-25790,	-25680,	-25789,	-25681,	-25788,	-25682,	-25787,	-25683,	-25786,	-25683,	-25785,	
	-25684,	-25785,	-25685,	-25784,	-25686,	-25783,	-25686,	-25783,	-25687,	-25782,	-25688,	-25781,	-25688,	-25781,	-25689,	-25780,	
	-25689,	-25780,	-25690,	-25779,	-25690,	-25779,	-25691,	-25778,	-25691,	-25778,	-25692,	-25777,	-25692,	-25777,	-25693,	-25776,	
	-25693,	-25776,	-25694,	-25775,	-25694,	-25775,	-25694,	-25775,	-25695,	-25774,	-25695,	-25774,	-25696,	-25774,	-25696,	-25773,	
	-25696,	-25773,	-25696,	-25773,	-25697,	-25772,	-25697,	-25772,	-25697,	-25772,	-25698,	-25772,	-25698,	-25771,	-25698,	-25771,	
	-25698,	-25771,	-25699,	-25771,	-25699,	-25770,	-25699,	-25770,	-25699,	-25770,	-25699,	-25770,	-25700,	-25770,	-25700,	-25769,	
	-25700,	-25769,	-25700,	-25769,	-25700,	-25769,	-25701,	-25769,	-25701,	-25769,	-25701,	-25768,	-25701,	-25768,	-25701,	-25768,	
	-25701,	-25768,	-25701,	-25768,	-25701,	-25768,	-25702,	-25768,	-25702,	-25768,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	
	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	
	-25702,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	
	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	-25703,	-25767,	
	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	
	-25702,	-25767,	-25702,	-25767,	-25702,	-25767,	-25702,	-25768,	-25702,	-25768,	-25702,	-25768,	-25701,	-25768,	-25701,	-25768,	
	-25701,	-25768,	-25701,	-25768,	-25701,	-25768,	-25701,	-25769,	-25701,	-25769,	-25701,	-25769,	-25700,	-25769,	-25700,	-25769,	
	-25700,	-25769,	-25700,	-25770,	-25700,	-25770,	-25699,	-25770,	-25699,	-25770,	-25699,	-25770,	-25699,	-25771,	-25699,	-25771,	
	-25698,	-25771,	-25698,	-25771,	-25698,	-25772,	-25698,	-25772,	-25697,	-25772,	-25697,	-25772,	-25697,	-25773,	-25696,	-25773,	
	-25696,	-25773,	-25696,	-25774,	-25696,	-25774,	-25695,	-25774,	-25695,	-25775,	-25694,	-25775,	-25694,	-25775,	-25694,	-25776,	
	-25693,	-25776,	-25693,	-25777,	-25692,	-25777,	-25692,	-25778,	-25691,	-25778,	-25691,	-25779,	-25690,	-25779,	-25690,	-25780,	
	-25689,	-25780,	-25689,	-25781,	-25688,	-25781,	-25688,	-25782,	-25687,	-25783,	-25686,	-25783,	-25686,	-25784,	-25685,	-25785,	
	-25684,	-25785,	-25683,	-25786,	-25683,	-25787,	-25682,	-25788,	-25681,	-25789,	-25680,	-25790,	-25679,	-25791,	-25678,	-25792,	
	-25677,	-25793,	-25676,	-25794,	-25675,	-25795,	-25674,	-25796,	-25672,	-25798,	-25671,	-25799,	-25670,	-25800,	-25668,	-25802,	
	-25667,	-25803,	-25665,	-25805,	-25663,	-25807,	-25662,	-25809,	-25660,	-25810,	-25658,	-25813,	-25656,	-25815,	-25653,	-25817,	
	-25651,	-25820,	-25648,	-25822,	-25646,	-25825,	-25643,	-25828,	-25640,	-25831,	-25636,	-25835,	-25633,	-25839,	-25629,	-25843,	
	-25624,	-25847,	-25620,	-25852,	-25615,	-25857,	-25609,	-25863,	-25603,	-25870,	-25596,	-25877,	-25589,	-25885,	-25580,	-25894,	
	-25571,	-25904,	-25560,	-25915,	-25548,	-25929,	-25533,	-25944,	-25517,	-25962,	-25497,	-25984,	-25473,	-26010,	-25445,	-26042,	
	-25408,	-26082,	-25362,	-26136,	-25300,	-26208,	-25214,	-26313,	-25085,	-26477,	-24870,	-26770,	-24446,	-27438,	-23234,	-30341,	
	//Osc 2	Level 2
	0     ,	30341 ,	23234 ,	27438 ,	24446 ,	26770 ,	24869 ,	26478 ,	25084 ,	26314 ,	25213 ,	26209 ,	25299 ,	26137 ,	25361 ,	26084 ,	
	25407 ,	26043 ,	25443 ,	26011 ,	25471 ,	25986 ,	25495 ,	25964 ,	25514 ,	25946 ,	25531 ,	25931 ,	25545 ,	25918 ,	25557 ,	25907 ,	
	25567 ,	25897 ,	25577 ,	25888 ,	25585 ,	25881 ,	25592 ,	25874 ,	25599 ,	25867 ,	25605 ,	25862 ,	25610 ,	25857 ,	25615 ,	25852 ,	
	25619 ,	25848 ,	25624 ,	25844 ,	25627 ,	25840 ,	25631 ,	25837 ,	25634 ,	25834 ,	25637 ,	25831 ,	25639 ,	25829 ,	25642 ,	25826 ,	
	25644 ,	25824 ,	25646 ,	25822 ,	25648 ,	25820 ,	25650 ,	25818 ,	25652 ,	25817 ,	25653 ,	25815 ,	25655 ,	25814 ,	25656 ,	25812 ,	
	25658 ,	25811 ,	25659 ,	25810 ,	25660 ,	25809 ,	25661 ,	25808 ,	25662 ,	25807 ,	25663 ,	25806 ,	25664 ,	25805 ,	25665 ,	25804 ,	
	25665 ,	25804 ,	25666 ,	25803 ,	25667 ,	25802 ,	25667 ,	25802 ,	25668 ,	25801 ,	25668 ,	25801 ,	25669 ,	25800 ,	25669 ,	25800 ,	
	25669 ,	25800 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25671 ,	25799 ,	25671 ,	25799 ,	
	25671 ,	25799 ,	25671 ,	25799 ,	25671 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25799 ,	25670 ,	25800 ,	
	25669 ,	25800 ,	25669 ,	25800 ,	25669 ,	25801 ,	25668 ,	25801 ,	25668 ,	25802 ,	25667 ,	25802 ,	25667 ,	25803 ,	25666 ,	25804 ,	
	25665 ,	25804 ,	25665 ,	25805 ,	25664 ,	25806 ,	25663 ,	25807 ,	25662 ,	25808 ,	25661 ,	25809 ,	25660 ,	25810 ,	25659 ,	25811 ,	
	25658 ,	25812 ,	25656 ,	25814 ,	25655 ,	25815 ,	25653 ,	25817 ,	25652 ,	25818 ,	25650 ,	25820 ,	25648 ,	25822 ,	25646 ,	25824 ,	
	25644 ,	25826 ,	25642 ,	25829 ,	25639 ,	25831 ,	25637 ,	25834 ,	25634 ,	25837 ,	25631 ,	25840 ,	25627 ,	25844 ,	25624 ,	25848 ,	
	25619 ,	25852 ,	25615 ,	25857 ,	25610 ,	25862 ,	25605 ,	25867 ,	25599 ,	25874 ,	25592 ,	25881 ,	25585 ,	25888 ,	25577 ,	25897 ,	
	25567 ,	25907 ,	25557 ,	25918 ,	25545 ,	25931 ,	25531 ,	25946 ,	25514 ,	25964 ,	25495 ,	25986 ,	25471 ,	26011 ,	25443 ,	26043 ,	
	25407 ,	26084 ,	25361 ,	26137 ,	25299 ,	26209 ,	25213 ,	26314 ,	25084 ,	26478 ,	24869 ,	26770 ,	24446 ,	27438 ,	23234 ,	30341 ,	
	0     ,	-30341,	-23234,	-27438,	-24446,	-26770,	-24869,	-26478,	-25084,	-26314,	-25213,	-26209,	-25299,	-26137,	-25361,	-26084,	
	-25407,	-26043,	-25443,	-26011,	-25471,	-25986,	-25495,	-25964,	-25514,	-25946,	-25531,	-25931,	-25545,	-25918,	-25557,	-25907,	
	-25567,	-25897,	-25577,	-25888,	-25585,	-25881,	-25592,	-25874,	-25599,	-25867,	-25605,	-25862,	-25610,	-25857,	-25615,	-25852,	
	-25619,	-25848,	-25624,	-25844,	-25627,	-25840,	-25631,	-25837,	-25634,	-25834,	-25637,	-25831,	-25639,	-25829,	-25642,	-25826,	
	-25644,	-25824,	-25646,	-25822,	-25648,	-25820,	-25650,	-25818,	-25652,	-25817,	-25653,	-25815,	-25655,	-25814,	-25656,	-25812,	
	-25658,	-25811,	-25659,	-25810,	-25660,	-25809,	-25661,	-25808,	-25662,	-25807,	-25663,	-25806,	-25664,	-25805,	-25665,	-25804,	
	-25665,	-25804,	-25666,	-25803,	-25667,	-25802,	-25667,	-25802,	-25668,	-25801,	-25668,	-25801,	-25669,	-25800,	-25669,	-25800,	
	-25669,	-25800,	-25670,	-25799,	-25670,	-25799,	-25670,	-25799,	-25670,	-25799,	-25670,	-25799,	-25671,	-25799,	-25671,	-25799,	
	-25671,	-25799,	-25671,	-25799,	-25671,	-25799,	-25670,	-25799,	-25670,	-25799,	-25670,	-25799,	-25670,	-25799,	-25670,	-25800,	
	-25669,	-25800,	-25669,	-25800,	-25669,	-25801,	-25668,	-25801,	-25668,	-25802,	-25667,	-25802,	-25667,	-25803,	-25666,	-25804,	
	-25665,	-25804,	-25665,	-25805,	-25664,	-25806,	-25663,	-25807,	-25662,	-25808,	-25661,	-25809,	-25660,	-25810,	-25659,	-25811,	
	-25658,	-25812,	-25656,	-25814,	-25655,	-25815,	-25653,	-25817,	-25652,	-25818,	-25650,	-25820,	-25648,	-25822,	-25646,	-25824,	
	-25644,	-25826,	-25642,	-25829,	-25639,	-25831,	-25637,	-25834,	-25634,	-25837,	-25631,	-25840,	-25627,	-25844,	-25624,	-25848,	
	-25619,	-25852,	-25615,	-25857,	-25610,	-25862,	-25605,	-25867,	-25599,	-25874,	-25592,	-25881,	-25585,	-25888,	-25577,	-25897,	
	-25567,	-25907,	-25557,	-25918,	-25545,	-25931,	-25531,	-25946,	-25514,	-25964,	-25495,	-25986,	-25471,	-26011,	-25443,	-26043,	
	-25407,	-26084,	-25361,	-26137,	-25299,	-26209,	-25213,	-26314,	-25084,	-26478,	-24869,	-26770,	-24446,	-27438,	-23234,	-30341,	
	//Osc 2	Level 3
	0     ,	30341 ,	23233 ,	27440 ,	24444 ,	26772 ,	24867 ,	26480 ,	25081 ,	26317 ,	25209 ,	26214 ,	25294 ,	26142 ,	25355 ,	26090 ,	
	25400 ,	26050 ,	25435 ,	26019 ,	25463 ,	25994 ,	25486 ,	25974 ,	25504 ,	25957 ,	25520 ,	25943 ,	25533 ,	25931 ,	25544 ,	25920 ,	
	25554 ,	25911 ,	25562 ,	25904 ,	25569 ,	25897 ,	25575 ,	25891 ,	25581 ,	25886 ,	25585 ,	25882 ,	25590 ,	25878 ,	25593 ,	25875 ,	
	25596 ,	25872 ,	25599 ,	25869 ,	25601 ,	25867 ,	25603 ,	25866 ,	25604 ,	25865 ,	25605 ,	25864 ,	25606 ,	25863 ,	25606 ,	25863 ,	
	25607 ,	25863 ,	25606 ,	25863 ,	25606 ,	25864 ,	25605 ,	25865 ,	25604 ,	25866 ,	25603 ,	25867 ,	25601 ,	25869 ,	25599 ,	25872 ,	
	25596 ,	25875 ,	25593 ,	25878 ,	25590 ,	25882 ,	25585 ,	25886 ,	25581 ,	25891 ,	25575 ,	25897 ,	25569 ,	25904 ,	25562 ,	25911 ,	
	25554 ,	25920 ,	25544 ,	25931 ,	25533 ,	25943 ,	25520 ,	25957 ,	25504 ,	25974 ,	25486 ,	25994 ,	25463 ,	26019 ,	25435 ,	26050 ,	
	25400 ,	26090 ,	25355 ,	26142 ,	25294 ,	26214 ,	25209 ,	26317 ,	25081 ,	26480 ,	24867 ,	26772 ,	24444 ,	27440 ,	23233 ,	30341 ,	
	0     ,	-30341,	-23233,	-27440,	-24444,	-26772,	-24867,	-26480,	-25081,	-26317,	-25209,	-26214,	-25294,	-26142,	-25355,	-26090,	
	-25400,	-26050,	-25435,	-26019,	-25463,	-25994,	-25486,	-25974,	-25504,	-25957,	-25520,	-25943,	-25533,	-25931,	-25544,	-25920,	
	-25554,	-25911,	-25562,	-25904,	-25569,	-25897,	-25575,	-25891,	-25581,	-25886,	-25585,	-25882,	-25590,	-25878,	-25593,	-25875,	
	-25596,	-25872,	-25599,	-25869,	-25601,	-25867,	-25603,	-25866,	-25604,	-25865,	-25605,	-25864,	-25606,	-25863,	-25606,	-25863,	
	-25607,	-25863,	-25606,	-25863,	-25606,	-25864,	-25605,	-25865,	-25604,	-25866,	-25603,	-25867,	-25601,	-25869,	-25599,	-25872,	
	-25596,	-25875,	-25593,	-25878,	-25590,	-25882,	-25585,	-25886,	-25581,	-25891,	-25575,	-25897,	-25569,	-25904,	-25562,	-25911,	
	-25554,	-25920,	-25544,	-25931,	-25533,	-25943,	-25520,	-25957,	-25504,	-25974,	-25486,	-25994,	-25463,	-26019,	-25435,	-26050,	
	-25400,	-26090,	-25355,	-26142,	-25294,	-26214,	-25209,	-26317,	-25081,	-26480,	-24867,	-26772,	-24444,	-27440,	-23233,	-30341,	
	//Osc 2	Level 4
	0     ,	30343 ,	23230 ,	27444 ,	24438 ,	26780 ,	24858 ,	26491 ,	25068 ,	26332 ,	25193 ,	26232 ,	25274 ,	26164 ,	25332 ,	26116 ,	
	25373 ,	26080 ,	25404 ,	26053 ,	25427 ,	26033 ,	25444 ,	26018 ,	25458 ,	26006 ,	25467 ,	25998 ,	25474 ,	25993 ,	25477 ,	25991 ,	
	25479 ,	25991 ,	25477 ,	25993 ,	25474 ,	25998 ,	25467 ,	26006 ,	25458 ,	26018 ,	25444 ,	26033 ,	25427 ,	26053 ,	25404 ,	26080 ,	
	25373 ,	26116 ,	25332 ,	26164 ,	25274 ,	26232 ,	25193 ,	26332 ,	25068 ,	26491 ,	24858 ,	26780 ,	24438 ,	27444 ,	23230 ,	30343 ,	
	0     ,	-30343,	-23230,	-27444,	-24438,	-26780,	-24858,	-26491,	-25068,	-26332,	-25193,	-26232,	-25274,	-26164,	-25332,	-26116,	
	-25373,	-26080,	-25404,	-26053,	-25427,	-26033,	-25444,	-26018,	-25458,	-26006,	-25467,	-25998,	-25474,	-25993,	-25477,	-25991,	
	-25479,	-25991,	-25477,	-25993,	-25474,	-25998,	-25467,	-26006,	-25458,	-26018,	-25444,	-26033,	-25427,	-26053,	-25404,	-26080,	
	-25373,	-26116,	-25332,	-26164,	-25274,	-26232,	-25193,	-26332,	-25068,	-26491,	-24858,	-26780,	-24438,	-27444,	-23230,	-30343,	
	//Osc 2	Level 5
	0     ,	30349 ,	23217 ,	27463 ,	24412 ,	26813 ,	24818 ,	26539 ,	25013 ,	26395 ,	25120 ,	26314 ,	25181 ,	26269 ,	25213 ,	26249 ,	
	25223 ,	26249 ,	25213 ,	26269 ,	25181 ,	26314 ,	25120 ,	26395 ,	25013 ,	26539 ,	24818 ,	26813 ,	24412 ,	27463 ,	23217 ,	30349 ,	
	0     ,	-30349,	-23217,	-27463,	-24412,	-26813,	-24818,	-26539,	-25013,	-26395,	-25120,	-26314,	-25181,	-26269,	-25213,	-26249,	
	-25223,	-26249,	-25213,	-26269,	-25181,	-26314,	-25120,	-26395,	-25013,	-26539,	-24818,	-26813,	-24412,	-27463,	-23217,	-30349,	
	//Osc 2	Level 6
	0     ,	30374 ,	23166 ,	27542 ,	24302 ,	26957 ,	24632 ,	26774 ,	24715 ,	26774 ,	24632 ,	26957 ,	24302 ,	27542 ,	23166 ,	30374 ,	
	0     ,	-30374,	-23166,	-27542,	-24302,	-26957,	-24632,	-26774,	-24715,	-26774,	-24632,	-26957,	-24302,	-27542,	-23166,	-30374,	
	//Osc 2	Level 7
	0     ,	30476 ,	22949 ,	27909 ,	23717 ,	27909 ,	22949 ,	30476 ,	0     ,	-30476,	-22949,	-27909,	-23717,	-27909,	-22949,	-30476,	
	//Osc 2	Level 8
	0     ,	30893 ,	21844 ,	30893 ,	0     ,	-30893,	-21844,	-30893,	
	//Osc 2	Level 9
	0     ,	32767 ,	0     ,	-32767,	
	//Osc 2	Level 10
	0     ,	0     ,	
	//Osc 2	Level 11
	0     ,	0     ,	
    },
    //Osc 3	Level 0
    {
	0     ,	64    ,	128   ,	192   ,	256   ,	320   ,	384   ,	448   ,	512   ,	576   ,	640   ,	704   ,	768   ,	832   ,	896   ,	960   ,	
	1024  ,	1088  ,	1152  ,	1216  ,	1280  ,	1344  ,	1408  ,	1472  ,	1536  ,	1600  ,	1664  ,	1728  ,	1792  ,	1856  ,	1920  ,	1984  ,	
	2048  ,	2112  ,	2176  ,	2240  ,	2304  ,	2368  ,	2432  ,	2496  ,	2560  ,	2624  ,	2688  ,	2752  ,	2816  ,	2881  ,	2945  ,	3009  ,	
	3073  ,	3137  ,	3201  ,	3265  ,	3329  ,	3393  ,	3457  ,	3521  ,	3585  ,	3649  ,	3713  ,	3777  ,	3841  ,	3905  ,	3969  ,	4033  ,	
	4097  ,	4161  ,	4225  ,	4289  ,	4353  ,	4417  ,	4481  ,	4545  ,	4609  ,	4673  ,	4737  ,	4801  ,	4865  ,	4929  ,	4993  ,	5057  ,	
	5121  ,	5185  ,	5249  ,	5313  ,	5377  ,	5441  ,	5505  ,	5569  ,	5633  ,	5697  ,	5762  ,	5826  ,	5890  ,	5954  ,	6018  ,	6082  ,	
	6146  ,	6210  ,	6274  ,	6338  ,	6402  ,	6466  ,	6530  ,	6594  ,	6658  ,	6722  ,	6786  ,	6850  ,	6914  ,	6978  ,	7042  ,	7106  ,	
	7170  ,	7234  ,	7298  ,	7362  ,	7426  ,	7490  ,	7554  ,	7618  ,	7682  ,	7746  ,	7810  ,	7874  ,	7938  ,	8002  ,	8066  ,	8130  ,	
	8194  ,	8258  ,	8322  ,	8386  ,	8450  ,	8514  ,	8578  ,	8643  ,	8707  ,	8771  ,	8835  ,	8899  ,	8963  ,	9027  ,	9091  ,	9155  ,	
	9219  ,	9283  ,	9347  ,	9411  ,	9475  ,	9539  ,	9603  ,	9667  ,	9731  ,	9795  ,	9859  ,	9923  ,	9987  ,	10051 ,	10115 ,	10179 ,	
	10243 ,	10307 ,	10371 ,	10435 ,	10499 ,	10563 ,	10627 ,	10691 ,	10755 ,	10819 ,	10883 ,	10947 ,	11011 ,	11075 ,	11139 ,	11203 ,	
	11267 ,	11331 ,	11395 ,	11459 ,	11524 ,	11588 ,	11652 ,	11716 ,	11780 ,	11844 ,	11908 ,	11972 ,	12036 ,	12100 ,	12164 ,	12228 ,	
	12292 ,	12356 ,	12420 ,	12484 ,	12548 ,	12612 ,	12676 ,	12740 ,	12804 ,	12868 ,	12932 ,	12996 ,	13060 ,	13124 ,	13188 ,	13252 ,	
	13316 ,	13380 ,	13444 ,	13508 ,	13572 ,	13636 ,	13700 ,	13764 ,	13828 ,	13892 ,	13956 ,	14020 ,	14084 ,	14148 ,	14212 ,	14276 ,	
	14340 ,	14405 ,	14469 ,	14533 ,	14597 ,	14661 ,	14725 ,	14789 ,	14853 ,	14917 ,	14981 ,	15045 ,	15109 ,	15173 ,	15237 ,	15301 ,	
	15365 ,	15429 ,	15493 ,	15557 ,	15621 ,	15685 ,	15749 ,	15813 ,	15877 ,	15941 ,	16005 ,	16069 ,	16133 ,	16197 ,	16261 ,	16325 ,	
	16389 ,	16453 ,	16517 ,	16581 ,	16645 ,	16709 ,	16773 ,	16837 ,	16901 ,	16965 ,	17029 ,	17093 ,	17157 ,	17222 ,	17286 ,	17350 ,	
	17414 ,	17478 ,	17542 ,	17606 ,	17670 ,	17734 ,	17798 ,	17862 ,	17926 ,	17990 ,	18054 ,	18118 ,	18182 ,	18246 ,	18310 ,	18374 ,	
	18438 ,	18502 ,	18566 ,	18630 ,	18694 ,	18758 ,	18822 ,	18886 ,	18950 ,	19014 ,	19078 ,	19142 ,	19206 ,	19270 ,	19334 ,	19398 ,	
	19462 ,	19526 ,	19590 ,	19654 ,	19718 ,	19782 ,	19846 ,	19910 ,	19974 ,	20038 ,	20103 ,	20167 ,	20231 ,	20295 ,	20359 ,	20423 ,	
	20487 ,	20551 ,	20615 ,	20679 ,	20743 ,	20807 ,	20871 ,	20935 ,	20999 ,	21063 ,	21127 ,	21191 ,	21255 ,	21319 ,	21383 ,	21447 ,	
	21511 ,	21575 ,	21639 ,	21703 ,	21767 ,	21831 ,	21895 ,	21959 ,	22023 ,	22087 ,	22151 ,	22215 ,	22279 ,	22343 ,	22407 ,	22471 ,	
	22535 ,	22599 ,	22663 ,	22727 ,	22791 ,	22855 ,	22919 ,	22984 ,	23048 ,	23112 ,	23176 ,	23240 ,	23304 ,	23368 ,	23432 ,	23496 ,	
	23560 ,	23624 ,	23688 ,	23752 ,	23816 ,	23880 ,	23944 ,	24008 ,	24072 ,	24136 ,	24200 ,	24264 ,	24328 ,	24392 ,	24456 ,	24520 ,	
	24584 ,	24648 ,	24712 ,	24776 ,	24840 ,	24904 ,	24968 ,	25032 ,	25096 ,	25160 ,	25224 ,	25288 ,	25352 ,	25416 ,	25480 ,	25544 ,	
	25608 ,	25672 ,	25736 ,	25800 ,	25865 ,	25929 ,	25993 ,	26057 ,	26121 ,	26185 ,	26249 ,	26313 ,	26377 ,	26441 ,	26505 ,	26569 ,	
	26633 ,	26697 ,	26761 ,	26825 ,	26889 ,	26953 ,	27017 ,	27081 ,	27145 ,	27209 ,	27273 ,	27337 ,	27401 ,	27465 ,	27529 ,	27593 ,	
	27657 ,	27721 ,	27785 ,	27849 ,	27913 ,	27977 ,	28041 ,	28105 ,	28169 ,	28233 ,	28297 ,	28361 ,	28425 ,	28489 ,	28553 ,	28617 ,	
	28681 ,	28746 ,	28810 ,	28874 ,	28938 ,	29002 ,	29066 ,	29130 ,	29194 ,	29258 ,	29322 ,	29386 ,	29450 ,	29514 ,	29578 ,	29642 ,	
	29706 ,	29770 ,	29834 ,	29898 ,	29962 ,	30026 ,	30090 ,	30154 ,	30218 ,	30282 ,	30346 ,	30410 ,	30474 ,	30538 ,	30602 ,	30666 ,	
	30730 ,	30794 ,	30858 ,	30922 ,	30986 ,	31050 ,	31114 ,	31178 ,	31242 ,	31306 ,	31370 ,	31434 ,	31498 ,	31563 ,	31627 ,	31691 ,	
	31755 ,	31819 ,	31883 ,	31947 ,	32011 ,	32075 ,	32139 ,	32203 ,	32267 ,	32331 ,	32395 ,	32459 ,	32523 ,	32587 ,	32650 ,	32716 ,	
	32766 ,	32716 ,	32650 ,	32587 ,	32523 ,	32459 ,	32395 ,	32331 ,	32267 ,	32203 ,	32139 ,	32075 ,	32011 ,	31947 ,	31883 ,	31819 ,	
	31755 ,	31691 ,	31627 ,	31563 ,	31498 ,	31434 ,	31370 ,	31306 ,	31242 ,	31178 ,	31114 ,	31050 ,	30986 ,	30922 ,	30858 ,	30794 ,	
	30730 ,	30666 ,	30602 ,	30538 ,	30474 ,	30410 ,	30346 ,	30282 ,	30218 ,	30154 ,	30090 ,	30026 ,	29962 ,	29898 ,	29834 ,	29770 ,	
	29706 ,	29642 ,	29578 ,	29514 ,	29450 ,	29386 ,	29322 ,	29258 ,	29194 ,	29130 ,	29066 ,	29002 ,	28938 ,	28874 ,	28810 ,	28746 ,	
	28681 ,	28617 ,	28553 ,	28489 ,	28425 ,	28361 ,	28297 ,	28233 ,	28169 ,	28105 ,	28041 ,	27977 ,	27913 ,	27849 ,	27785 ,	27721 ,	
	27657 ,	27593 ,	27529 ,	27465 ,	27401 ,	27337 ,	27273 ,	27209 ,	27145 ,	27081 ,	27017 ,	26953 ,	26889 ,	26825 ,	26761 ,	26697 ,	
	26633 ,	26569 ,	26505 ,	26441 ,	26377 ,	26313 ,	26249 ,	26185 ,	26121 ,	26057 ,	25993 ,	25929 ,	25865 ,	25800 ,	25736 ,	25672 ,	
	25608 ,	25544 ,	25480 ,	25416 ,	25352 ,	25288 ,	25224 ,	25160 ,	25096 ,	25032 ,	24968 ,	24904 ,	24840 ,	24776 ,	24712 ,	24648 ,	
	24584 ,	24520 ,	24456 ,	24392 ,	24328 ,	24264 ,	24200 ,	24136 ,	24072 ,	24008 ,	23944 ,	23880 ,	23816 ,	23752 ,	23688 ,	23624 ,	
	23560 ,	23496 ,	23432 ,	23368 ,	23304 ,	23240 ,	23176 ,	23112 ,	23048 ,	22984 ,	22919 ,	22855 ,	22791 ,	22727 ,	22663 ,	22599 ,	
	22535 ,	22471 ,	22407 ,	22343 ,	22279 ,	22215 ,	22151 ,	22087 ,	22023 ,	21959 ,	21895 ,	21831 ,	21767 ,	21703 ,	21639 ,	21575 ,	
	21511 ,	21447 ,	21383 ,	21319 ,	21255 ,	21191 ,	21127 ,	21063 ,	20999 ,	20935 ,	20871 ,	20807 ,	20743 ,	20679 ,	20615 ,	20551 ,	
	20487 ,	20423 ,	20359 ,	20295 ,	20231 ,	20167 ,	20103 ,	20038 ,	19974 ,	19910 ,	19846 ,	19782 ,	19718 ,	19654 ,	19590 ,	19526 ,	
	19462 ,	19398 ,	19334 ,	19270 ,	19206 ,	19142 ,	19078 ,	19014 ,	18950 ,	18886 ,	18822 ,	18758 ,	18694 ,	18630 ,	18566 ,	18502 ,	
	18438 ,	18374 ,	18310 ,	18246 ,	18182 ,	18118 ,	18054 ,	17990 ,	17926 ,	17862 ,	17798 ,	17734 ,	17670 ,	17606 ,	17542 ,	17478 ,	
	17414 ,	17350 ,	17286 ,	17222 ,	17157 ,	17093 ,	17029 ,	16965 ,	16901 ,	16837 ,	16773 ,	16709 ,	16645 ,	16581 ,	16517 ,	16453 ,	
	16389 ,	16325 ,	16261 ,	16197 ,	16133 ,	16069 ,	16005 ,	15941 ,	15877 ,	15813 ,	15749 ,	15685 ,	15621 ,	15557 ,	15493 ,	15429 ,	
	15365 ,	15301 ,	15237 ,	15173 ,	15109 ,	15045 ,	14981 ,	14917 ,	14853 ,	14789 ,	14725 ,	14661 ,	14597 ,	14533 ,	14469 ,	14405 ,	
	14340 ,	14276 ,	14212 ,	14148 ,	14084 ,	14020 ,	13956 ,	13892 ,	13828 ,	13764 ,	13700 ,	13636 ,	13572 ,	13508 ,	13444 ,	13380 ,	
	13316 ,	13252 ,	13188 ,	13124 ,	13060 ,	12996 ,	12932 ,	12868 ,	12804 ,	12740 ,	12676 ,	12612 ,	12548 ,	12484 ,	12420 ,	12356 ,	
	12292 ,	12228 ,	12164 ,	12100 ,	12036 ,	11972 ,	11908 ,	11844 ,	11780 ,	11716 ,	11652 ,	11588 ,	11524 ,	11459 ,	11395 ,	11331 ,	
	11267 ,	11203 ,	11139 ,	11075 ,	11011 ,	10947 ,	10883 ,	10819 ,	10755 ,	10691 ,	10627 ,	10563 ,	10499 ,	10435 ,	10371 ,	10307 ,	
	10243 ,	10179 ,	10115 ,	10051 ,	9987  ,	9923  ,	9859  ,	9795  ,	9731  ,	9667  ,	9603  ,	9539  ,	9475  ,	9411  ,	9347  ,	9283  ,	
	9219  ,	9155  ,	9091  ,	9027  ,	8963  ,	8899  ,	8835  ,	8771  ,	8707  ,	8643  ,	8578  ,	8514  ,	8450  ,	8386  ,	8322  ,	8258  ,	
	8194  ,	8130  ,	8066  ,	8002  ,	7938  ,	7874  ,	7810  ,	7746  ,	7682  ,	7618  ,	7554  ,	7490  ,	7426  ,	7362  ,	7298  ,	7234  ,	
	7170  ,	7106  ,	7042  ,	6978  ,	6914  ,	6850  ,	6786  ,	6722  ,	6658  ,	6594  ,	6530  ,	6466  ,	6402  ,	6338  ,	6274  ,	6210  ,	
	6146  ,	6082  ,	6018  ,	5954  ,	5890  ,	5826  ,	5762  ,	5697  ,	5633  ,	5569  ,	5505  ,	5441  ,	5377  ,	5313  ,	5249  ,	5185  ,	
	5121  ,	5057  ,	4993  ,	4929  ,	4865  ,	4801  ,	4737  ,	4673  ,	4609  ,	4545  ,	4481  ,	4417  ,	4353  ,	4289  ,	4225  ,	4161  ,	
	4097  ,	4033  ,	3969  ,	3905  ,	3841  ,	3777  ,	3713  ,	3649  ,	3585  ,	3521  ,	3457  ,	3393  ,	3329  ,	3265  ,	3201  ,	3137  ,	
	3073  ,	3009  ,	2945  ,	2881  ,	2816  ,	2752  ,	2688  ,	2624  ,	2560  ,	2496  ,	2432  ,	2368  ,	2304  ,	2240  ,	2176  ,	2112  ,	
	2048  ,	1984  ,	1920  ,	1856  ,	1792  ,	1728  ,	1664  ,	1600  ,	1536  ,	1472  ,	1408  ,	1344  ,	1280  ,	1216  ,	1152  ,	1088  ,	
	1024  ,	960   ,	896   ,	832   ,	768   ,	704   ,	640   ,	576   ,	512   ,	448   ,	384   ,	320   ,	256   ,	192   ,	128   ,	64    ,	
	0     ,	-64   ,	-128  ,	-192  ,	-256  ,	-320  ,	-384  ,	-448  ,	-512  ,	-576  ,	-640  ,	-704  ,	-768  ,	-832  ,	-896  ,	-960  ,	
	-1024 ,	-1088 ,	-1152 ,	-1216 ,	-1280 ,	-1344 ,	-1408 ,	-1472 ,	-1536 ,	-1600 ,	-1664 ,	-1728 ,	-1792 ,	-1856 ,	-1920 ,	-1984 ,	
	-2048 ,	-2112 ,	-2176 ,	-2240 ,	-2304 ,	-2368 ,	-2432 ,	-2496 ,	-2560 ,	-2624 ,	-2688 ,	-2752 ,	-2816 ,	-2881 ,	-2945 ,	-3009 ,	
	-3073 ,	-3137 ,	-3201 ,	-3265 ,	-3329 ,	-3393 ,	-3457 ,	-3521 ,	-3585 ,	-3649 ,	-3713 ,	-3777 ,	-3841 ,	-3905 ,	-3969 ,	-4033 ,	
	-4097 ,	-4161 ,	-4225 ,	-4289 ,	-4353 ,	-4417 ,	-4481 ,	-4545 ,	-4609 ,	-4673 ,	-4737 ,	-4801 ,	-4865 ,	-4929 ,	-4993 ,	-5057 ,	
	-5121 ,	-5185 ,	-5249 ,	-5313 ,	-5377 ,	-5441 ,	-5505 ,	-5569 ,	-5633 ,	-5697 ,	-5762 ,	-5826 ,	-5890 ,	-5954 ,	-6018 ,	-6082 ,	
	-6146 ,	-6210 ,	-6274 ,	-6338 ,	-6402 ,	-6466 ,	-6530 ,	-6594 ,	-6658 ,	-6722 ,	-6786 ,	-6850 ,	-6914 ,	-6978 ,	-7042 ,	-7106 ,	
	-7170 ,	-7234 ,	-7298 ,	-7362 ,	-7426 ,	-7490 ,	-7554 ,	-7618 ,	-7682 ,	-7746 ,	-7810 ,	-7874 ,	-7938 ,	-8002 ,	-8066 ,	-8130 ,	
	-8194 ,	-8258 ,	-8322 ,	-8386 ,	-8450 ,	-8514 ,	-8578 ,	-8643 ,	-8707 ,	-8771 ,	-8835 ,	-8899 ,	-8963 ,	-9027 ,	-9091 ,	-9155 ,	
	-9219 ,	-9283 ,	-9347 ,	-9411 ,	-9475 ,	-9539 ,	-9603 ,	-9667 ,	-9731 ,	-9795 ,	-9859 ,	-9923 ,	-9987 ,	-10051,	-10115,	-10179,	
	-10243,	-10307,	-10371,	-10435,	-10499,	-10563,	-10627,	-10691,	-10755,	-10819,	-10883,	-10947,	-11011,	-11075,	-11139,	-11203,	
	-11267,	-11331,	-11395,	-11459,	-11524,	-11588,	-11652,	-11716,	-11780,	-11844,	-11908,	-11972,	-12036,	-12100,	-12164,	-12228,	
	-12292,	-12356,	-12420,	-12484,	-12548,	-12612,	-12676,	-12740,	-12804,	-12868,	-12932,	-12996,	-13060,	-13124,	-13188,	-13252,	
	-13316,	-13380,	-13444,	-13508,	-13572,	-13636,	-13700,	-13764,	-13828,	-13892,	-13956,	-14020,	-14084,	-14148,	-14212,	-14276,	
	-14340,	-14405,	-14469,	-14533,	-14597,	-14661,	-14725,	-14789,	-14853,	-14917,	-14981,	-15045,	-15109,	-15173,	-15237,	-15301,	
	-15365,	-15429,	-15493,	-15557,	-15621,	-15685,	-15749,	-15813,	-15877,	-15941,	-16005,	-16069,	-16133,	-16197,	-16261,	-16325,	
	-16389,	-16453,	-16517,	-16581,	-16645,	-16709,	-16773,	-16837,	-16901,	-16965,	-17029,	-17093,	-17157,	-17222,	-17286,	-17350,	
	-17414,	-17478,	-17542,	-17606,	-17670,	-17734,	-17798,	-17862,	-17926,	-17990,	-18054,	-18118,	-18182,	-18246,	-18310,	-18374,	
	-18438,	-18502,	-18566,	-18630,	-18694,	-18758,	-18822,	-18886,	-18950,	-19014,	-19078,	-19142,	-19206,	-19270,	-19334,	-19398,	
	-19462,	-19526,	-19590,	-19654,	-19718,	-19782,	-19846,	-19910,	-19974,	-20038,	-20103,	-20167,	-20231,	-20295,	-20359,	-20423,	
	-20487,	-20551,	-20615,	-20679,	-20743,	-20807,	-20871,	-20935,	-20999,	-21063,	-21127,	-21191,	-21255,	-21319,	-21383,	-21447,	
	-21511,	-21575,	-21639,	-21703,	-21767,	-21831,	-21895,	-21959,	-22023,	-22087,	-22151,	-22215,	-22279,	-22343,	-22407,	-22471,	
	-22535,	-22599,	-22663,	-22727,	-22791,	-22855,	-22919,	-22984,	-23048,	-23112,	-23176,	-23240,	-23304,	-23368,	-23432,	-23496,	
	-23560,	-23624,	-23688,	-23752,	-23816,	-23880,	-23944,	-24008,	-24072,	-24136,	-24200,	-24264,	-24328,	-24392,	-24456,	-24520,	
	-24584,	-24648,	-24712,	-24776,	-24840,	-24904,	-24968,	-25032,	-25096,	-25160,	-25224,	-25288,	-25352,	-25416,	-25480,	-25544,	
	-25608,	-25672,	-25736,	-25800,	-25865,	-25929,	-25993,	-26057,	-26121,	-26185,	-26249,	-26313,	-26377,	-26441,	-26505,	-26569,	
	-26633,	-26697,	-26761,	-26825,	-26889,	-26953,	-27017,	-27081,	-27145,	-27209,	-27273,	-27337,	-27401,	-27465,	-27529,	-27593,	
	-27657,	-27721,	-27785,	-27849,	-27913,	-27977,	-28041,	-28105,	-28169,	-28233,	-28297,	-28361,	-28425,	-28489,	-28553,	-28617,	
	-28681,	-28746,	-28810,	-28874,	-28938,	-29002,	-29066,	-29130,	-29194,	-29258,	-29322,	-29386,	-29450,	-29514,	-29578,	-29642,	
	-29706,	-29770,	-29834,	-29898,	-29962,	-30026,	-30090,	-30154,	-30218,	-30282,	-30346,	-30410,	-30474,	-30538,	-30602,	-30666,	
	-30730,	-30794,	-30858,	-30922,	-30986,	-31050,	-31114,	-31178,	-31242,	-31306,	-31370,	-31434,	-31498,	-31563,	-31627,	-31691,	
	-31755,	-31819,	-31883,	-31947,	-32011,	-32075,	-32139,	-32203,	-32267,	-32331,	-32395,	-32459,	-32523,	-32587,	-32650,	-32716,	
	-32766,	-32716,	-32650,	-32587,	-32523,	-32459,	-32395,	-32331,	-32267,	-32203,	-32139,	-32075,	-32011,	-31947,	-31883,	-31819,	
	-31755,	-31691,	-31627,	-31563,	-31498,	-31434,	-31370,	-31306,	-31242,	-31178,	-31114,	-31050,	-30986,	-30922,	-30858,	-30794,	
	-30730,	-30666,	-30602,	-30538,	-30474,	-30410,	-30346,	-30282,	-30218,	-30154,	-30090,	-30026,	-29962,	-29898,	-29834,	-29770,	
	-29706,	-29642,	-29578,	-29514,	-29450,	-29386,	-29322,	-29258,	-29194,	-29130,	-29066,	-29002,	-28938,	-28874,	-28810,	-28746,	
	-28681,	-28617,	-28553,	-28489,	-28425,	-28361,	-28297,	-28233,	-28169,	-28105,	-28041,	-27977,	-27913,	-27849,	-27785,	-27721,	
	-27657,	-27593,	-27529,	-27465,	-27401,	-27337,	-27273,	-27209,	-27145,	-27081,	-27017,	-26953,	-26889,	-26825,	-26761,	-26697,	
	-26633,	-26569,	-26505,	-26441,	-26377,	-26313,	-26249,	-26185,	-26121,	-26057,	-25993,	-25929,	-25865,	-25800,	-25736,	-25672,	
	-25608,	-25544,	-25480,	-25416,	-25352,	-25288,	-25224,	-25160,	-25096,	-25032,	-24968,	-24904,	-24840,	-24776,	-24712,	-24648,	
	-24584,	-24520,	-24456,	-24392,	-24328,	-24264,	-24200,	-24136,	-24072,	-24008,	-23944,	-23880,	-23816,	-23752,	-23688,	-23624,	
	-23560,	-23496,	-23432,	-23368,	-23304,	-23240,	-23176,	-23112,	-23048,	-22984,	-22919,	-22855,	-22791,	-22727,	-22663,	-22599,	
	-22535,	-22471,	-22407,	-22343,	-22279,	-22215,	-22151,	-22087,	-22023,	-21959,	-21895,	-21831,	-21767,	-21703,	-21639,	-21575,	
	-21511,	-21447,	-21383,	-21319,	-21255,	-21191,	-21127,	-21063,	-20999,	-20935,	-20871,	-20807,	-20743,	-20679,	-20615,	-20551,	
	-20487,	-20423,	-20359,	-20295,	-20231,	-20167,	-20103,	-20038,	-19974,	-19910,	-19846,	-19782,	-19718,	-19654,	-19590,	-19526,	
	-19462,	-19398,	-19334,	-19270,	-19206,	-19142,	-19078,	-19014,	-18950,	-18886,	-18822,	-18758,	-18694,	-18630,	-18566,	-18502,	
	-18438,	-18374,	-18310,	-18246,	-18182,	-18118,	-18054,	-17990,	-17926,	-17862,	-17798,	-17734,	-17670,	-17606,	-17542,	-17478,	
	-17414,	-17350,	-17286,	-17222,	-17157,	-17093,	-17029,	-16965,	-16901,	-16837,	-16773,	-16709,	-16645,	-16581,	-16517,	-16453,	
	-16389,	-16325,	-16261,	-16197,	-16133,	-16069,	-16005,	-15941,	-15877,	-15813,	-15749,	-15685,	-15621,	-15557,	-15493,	-15429,	
	-15365,	-15301,	-15237,	-15173,	-15109,	-15045,	-14981,	-14917,	-14853,	-14789,	-14725,	-14661,	-14597,	-14533,	-14469,	-14405,	
	-14340,	-14276,	-14212,	-14148,	-14084,	-14020,	-13956,	-13892,	-13828,	-13764,	-13700,	-13636,	-13572,	-13508,	-13444,	-13380,	
	-13316,	-13252,	-13188,	-13124,	-13060,	-12996,	-12932,	-12868,	-12804,	-12740,	-12676,	-12612,	-12548,	-12484,	-12420,	-12356,	
	-12292,	-12228,	-12164,	-12100,	-12036,	-11972,	-11908,	-11844,	-11780,	-11716,	-11652,	-11588,	-11524,	-11459,	-11395,	-11331,	
	-11267,	-11203,	-11139,	-11075,	-11011,	-10947,	-10883,	-10819,	-10755,	-10691,	-10627,	-10563,	-10499,	-10435,	-10371,	-10307,	
	-10243,	-10179,	-10115,	-10051,	-9987 ,	-9923 ,	-9859 ,	-9795 ,	-9731 ,	-9667 ,	-9603 ,	-9539 ,	-9475 ,	-9411 ,	-9347 ,	-9283 ,	
	-9219 ,	-9155 ,	-9091 ,	-9027 ,	-8963 ,	-8899 ,	-8835 ,	-8771 ,	-8707 ,	-8643 ,	-8578 ,	-8514 ,	-8450 ,	-8386 ,	-8322 ,	-8258 ,	
	-8194 ,	-8130 ,	-8066 ,	-8002 ,	-7938 ,	-7874 ,	-7810 ,	-7746 ,	-7682 ,	-7618 ,	-7554 ,	-7490 ,	-7426 ,	-7362 ,	-7298 ,	-7234 ,	
	-7170 ,	-7106 ,	-7042 ,	-6978 ,	-6914 ,	-6850 ,	-6786 ,	-6722 ,	-6658 ,	-6594 ,	-6530 ,	-6466 ,	-6402 ,	-6338 ,	-6274 ,	-6210 ,	
	-6146 ,	-6082 ,	-6018 ,	-5954 ,	-5890 ,	-5826 ,	-5762 ,	-5697 ,	-5633 ,	-5569 ,	-5505 ,	-5441 ,	-5377 ,	-5313 ,	-5249 ,	-5185 ,	
	-5121 ,	-5057 ,	-4993 ,	-4929 ,	-4865 ,	-4801 ,	-4737 ,	-4673 ,	-4609 ,	-4545 ,	-4481 ,	-4417 ,	-4353 ,	-4289 ,	-4225 ,	-4161 ,	
	-4097 ,	-4033 ,	-3969 ,	-3905 ,	-3841 ,	-3777 ,	-3713 ,	-3649 ,	-3585 ,	-3521 ,	-3457 ,	-3393 ,	-3329 ,	-3265 ,	-3201 ,	-3137 ,	
	-3073 ,	-3009 ,	-2945 ,	-2881 ,	-2816 ,	-2752 ,	-2688 ,	-2624 ,	-2560 ,	-2496 ,	-2432 ,	-2368 ,	-2304 ,	-2240 ,	-2176 ,	-2112 ,	
	-2048 ,	-1984 ,	-1920 ,	-1856 ,	-1792 ,	-1728 ,	-1664 ,	-1600 ,	-1536 ,	-1472 ,	-1408 ,	-1344 ,	-1280 ,	-1216 ,	-1152 ,	-1088 ,	
	-1024 ,	-960  ,	-896  ,	-832  ,	-768  ,	-704  ,	-640  ,	-576  ,	-512  ,	-448  ,	-384  ,	-320  ,	-256  ,	-192  ,	-128  ,	-64   ,	
	//Osc 3	Level 1
	0     ,	128   ,	256   ,	384   ,	512   ,	640   ,	768   ,	896   ,	1024  ,	1152  ,	1280  ,	1408  ,	1536  ,	1664  ,	1792  ,	1920  ,	
	2048  ,	2176  ,	2304  ,	2432  ,	2560  ,	2688  ,	2816  ,	2945  ,	3073  ,	3201  ,	3329  ,	3457  ,	3585  ,	3713  ,	3841  ,	3969  ,	
	4097  ,	4225  ,	4353  ,	4481  ,	4609  ,	4737  ,	4865  ,	4993  ,	5121  ,	5249  ,	5377  ,	5505  ,	5633  ,	5762  ,	5890  ,	6018  ,	
	6146  ,	6274  ,	6402  ,	6530  ,	6658  ,	6786  ,	6914  ,	7042  ,	7170  ,	7298  ,	7426  ,	7554  ,	7682  ,	7810  ,	7938  ,	8066  ,	
	8194  ,	8322  ,	8450  ,	8578  ,	8707  ,	8835  ,	8963  ,	9091  ,	9219  ,	9347  ,	9475  ,	9603  ,	9731  ,	9859  ,	9987  ,	10115 ,	
	10243 ,	10371 ,	10499 ,	10627 ,	10755 ,	10883 ,	11011 ,	11139 ,	11267 ,	11395 ,	11524 ,	11652 ,	11780 ,	11908 ,	12036 ,	12164 ,	
	12292 ,	12420 ,	12548 ,	12676 ,	12804 ,	12932 ,	13060 ,	13188 ,	13316 ,	13444 ,	13572 ,	13700 ,	13828 ,	13956 ,	14084 ,	14212 ,	
	14340 ,	14469 ,	14597 ,	14725 ,	14853 ,	14981 ,	15109 ,	15237 ,	15365 ,	15493 ,	15621 ,	15749 ,	15877 ,	16005 ,	16133 ,	16261 ,	
	16389 ,	16517 ,	16645 ,	16773 ,	16901 ,	17029 ,	17157 ,	17286 ,	17414 ,	17542 ,	17670 ,	17798 ,	17926 ,	18054 ,	18182 ,	18310 ,	
	18438 ,	18566 ,	18694 ,	18822 ,	18950 ,	19078 ,	19206 ,	19334 ,	19462 ,	19590 ,	19718 ,	19846 ,	19974 ,	20103 ,	20231 ,	20359 ,	
	20487 ,	20615 ,	20743 ,	20871 ,	20999 ,	21127 ,	21255 ,	21383 ,	21511 ,	21639 ,	21767 ,	21895 ,	22023 ,	22151 ,	22279 ,	22407 ,	
	22535 ,	22663 ,	22791 ,	22919 ,	23048 ,	23176 ,	23304 ,	23432 ,	23560 ,	23688 ,	23816 ,	23944 ,	24072 ,	24200 ,	24328 ,	24456 ,	
	24584 ,	24712 ,	24840 ,	24968 ,	25096 ,	25224 ,	25352 ,	25480 ,	25608 ,	25736 ,	25865 ,	25993 ,	26121 ,	26249 ,	26377 ,	26505 ,	
	26633 ,	26761 ,	26889 ,	27017 ,	27145 ,	27273 ,	27401 ,	27529 ,	27657 ,	27785 ,	27913 ,	28041 ,	28169 ,	28297 ,	28425 ,	28553 ,	
	28681 ,	28810 ,	28938 ,	29066 ,	29194 ,	29322 ,	29450 ,	29578 ,	29706 ,	29834 ,	29962 ,	30090 ,	30218 ,	30346 ,	30474 ,	30602 ,	
	30730 ,	30858 ,	30986 ,	31114 ,	31242 ,	31370 ,	31498 ,	31627 ,	31754 ,	31883 ,	32011 ,	32139 ,	32266 ,	32395 ,	32522 ,	32654 ,	
	32753 ,	32654 ,	32522 ,	32395 ,	32266 ,	32139 ,	32011 ,	31883 ,	31754 ,	31627 ,	31498 ,	31370 ,	31242 ,	31114 ,	30986 ,	30858 ,	
	30730 ,	30602 ,	30474 ,	30346 ,	30218 ,	30090 ,	29962 ,	29834 ,	29706 ,	29578 ,	29450 ,	29322 ,	29194 ,	29066 ,	28938 ,	28810 ,	
	28681 ,	28553 ,	28425 ,	28297 ,	28169 ,	28041 ,	27913 ,	27785 ,	27657 ,	27529 ,	27401 ,	27273 ,	27145 ,	27017 ,	26889 ,	26761 ,	
	26633 ,	26505 ,	26377 ,	26249 ,	26121 ,	25993 ,	25865 ,	25736 ,	25608 ,	25480 ,	25352 ,	25224 ,	25096 ,	24968 ,	24840 ,	24712 ,	
	24584 ,	24456 ,	24328 ,	24200 ,	24072 ,	23944 ,	23816 ,	23688 ,	23560 ,	23432 ,	23304 ,	23176 ,	23048 ,	22919 ,	22791 ,	22663 ,	
	22535 ,	22407 ,	22279 ,	22151 ,	22023 ,	21895 ,	21767 ,	21639 ,	21511 ,	21383 ,	21255 ,	21127 ,	20999 ,	20871 ,	20743 ,	20615 ,	
	20487 ,	20359 ,	20231 ,	20103 ,	19974 ,	19846 ,	19718 ,	19590 ,	19462 ,	19334 ,	19206 ,	19078 ,	18950 ,	18822 ,	18694 ,	18566 ,	
	18438 ,	18310 ,	18182 ,	18054 ,	17926 ,	17798 ,	17670 ,	17542 ,	17414 ,	17286 ,	17157 ,	17029 ,	16901 ,	16773 ,	16645 ,	16517 ,	
	16389 ,	16261 ,	16133 ,	16005 ,	15877 ,	15749 ,	15621 ,	15493 ,	15365 ,	15237 ,	15109 ,	14981 ,	14853 ,	14725 ,	14597 ,	14469 ,	
	14340 ,	14212 ,	14084 ,	13956 ,	13828 ,	13700 ,	13572 ,	13444 ,	13316 ,	13188 ,	13060 ,	12932 ,	12804 ,	12676 ,	12548 ,	12420 ,	
	12292 ,	12164 ,	12036 ,	11908 ,	11780 ,	11652 ,	11524 ,	11395 ,	11267 ,	11139 ,	11011 ,	10883 ,	10755 ,	10627 ,	10499 ,	10371 ,	
	10243 ,	10115 ,	9987  ,	9859  ,	9731  ,	9603  ,	9475  ,	9347  ,	9219  ,	9091  ,	8963  ,	8835  ,	8707  ,	8578  ,	8450  ,	8322  ,	
	8194  ,	8066  ,	7938  ,	7810  ,	7682  ,	7554  ,	7426  ,	7298  ,	7170  ,	7042  ,	6914  ,	6786  ,	6658  ,	6530  ,	6402  ,	6274  ,	
	6146  ,	6018  ,	5890  ,	5762  ,	5633  ,	5505  ,	5377  ,	5249  ,	5121  ,	4993  ,	4865  ,	4737  ,	4609  ,	4481  ,	4353  ,	4225  ,	
	4097  ,	3969  ,	3841  ,	3713  ,	3585  ,	3457  ,	3329  ,	3201  ,	3073  ,	2945  ,	2816  ,	2688  ,	2560  ,	2432  ,	2304  ,	2176  ,	
	2048  ,	1920  ,	1792  ,	1664  ,	1536  ,	1408  ,	1280  ,	1152  ,	1024  ,	896   ,	768   ,	640   ,	512   ,	384   ,	256   ,	128   ,	
	0     ,	-128  ,	-256  ,	-384  ,	-512  ,	-640  ,	-768  ,	-896  ,	-1024 ,	-1152 ,	-1280 ,	-1408 ,	-1536 ,	-1664 ,	-1792 ,	-1920 ,	
	-2048 ,	-2176 ,	-2304 ,	-2432 ,	-2560 ,	-2688 ,	-2816 ,	-2945 ,	-3073 ,	-3201 ,	-3329 ,	-3457 ,	-3585 ,	-3713 ,	-3841 ,	-3969 ,	
	-4097 ,	-4225 ,	-4353 ,	-4481 ,	-4609 ,	-4737 ,	-4865 ,	-4993 ,	-5121 ,	-5249 ,	-5377 ,	-5505 ,	-5633 ,	-5762 ,	-5890 ,	-6018 ,	
	-6146 ,	-6274 ,	-6402 ,	-6530 ,	-6658 ,	-6786 ,	-6914 ,	-7042 ,	-7170 ,	-7298 ,	-7426 ,	-7554 ,	-7682 ,	-7810 ,	-7938 ,	-8066 ,	
	-8194 ,	-8322 ,	-8450 ,	-8578 ,	-8707 ,	-8835 ,	-8963 ,	-9091 ,	-9219 ,	-9347 ,	-9475 ,	-9603 ,	-9731 ,	-9859 ,	-9987 ,	-10115,	
	-10243,	-10371,	-10499,	-10627,	-10755,	-10883,	-11011,	-11139,	-11267,	-11395,	-11524,	-11652,	-11780,	-11908,	-12036,	-12164,	
	-12292,	-12420,	-12548,	-12676,	-12804,	-12932,	-13060,	-13188,	-13316,	-13444,	-13572,	-13700,	-13828,	-13956,	-14084,	-14212,	
	-14340,	-14469,	-14597,	-14725,	-14853,	-14981,	-15109,	-15237,	-15365,	-15493,	-15621,	-15749,	-15877,	-16005,	-16133,	-16261,	
	-16389,	-16517,	-16645,	-16773,	-16901,	-17029,	-17157,	-17286,	-17414,	-17542,	-17670,	-17798,	-17926,	-18054,	-18182,	-18310,	
	-18438,	-18566,	-18694,	-18822,	-18950,	-19078,	-19206,	-19334,	-19462,	-19590,	-19718,	-19846,	-19974,	-20103,	-20231,	-20359,	
	-20487,	-20615,	-20743,	-20871,	-20999,	-21127,	-21255,	-21383,	-21511,	-21639,	-21767,	-21895,	-22023,	-22151,	-22279,	-22407,	
	-22535,	-22663,	-22791,	-22919,	-23048,	-23176,	-23304,	-23432,	-23560,	-23688,	-23816,	-23944,	-24072,	-24200,	-24328,	-24456,	
	-24584,	-24712,	-24840,	-24968,	-25096,	-25224,	-25352,	-25480,	-25608,	-25736,	-25865,	-25993,	-26121,	-26249,	-26377,	-26505,	
	-26633,	-26761,	-26889,	-27017,	-27145,	-27273,	-27401,	-27529,	-27657,	-27785,	-27913,	-28041,	-28169,	-28297,	-28425,	-28553,	
	-28681,	-28810,	-28938,	-29066,	-29194,	-29322,	-29450,	-29578,	-29706,	-29834,	-29962,	-30090,	-30218,	-30346,	-30474,	-30602,	
	-30730,	-30858,	-30986,	-31114,	-31242,	-31370,	-31498,	-31627,	-31754,	-31883,	-32011,	-32139,	-32266,	-32395,	-32522,	-32654,	
	-32753,	-32654,	-32522,	-32395,	-32266,	-32139,	-32011,	-31883,	-31754,	-31627,	-31498,	-31370,	-31242,	-31114,	-30986,	-30858,	
	-30730,	-30602,	-30474,	-30346,	-30218,	-30090,	-29962,	-29834,	-29706,	-29578,	-29450,	-29322,	-29194,	-29066,	-28938,	-28810,	
	-28681,	-28553,	-28425,	-28297,	-28169,	-28041,	-27913,	-27785,	-27657,	-27529,	-27401,	-27273,	-27145,	-27017,	-26889,	-26761,	
	-26633,	-26505,	-26377,	-26249,	-26121,	-25993,	-25865,	-25736,	-25608,	-25480,	-25352,	-25224,	-25096,	-24968,	-24840,	-24712,	
	-24584,	-24456,	-24328,	-24200,	-24072,	-23944,	-23816,	-23688,	-23560,	-23432,	-23304,	-23176,	-23048,	-22919,	-22791,	-22663,	
	-22535,	-22407,	-22279,	-22151,	-22023,	-21895,	-21767,	-21639,	-21511,	-21383,	-21255,	-21127,	-20999,	-20871,	-20743,	-20615,	
	-20487,	-20359,	-20231,	-20103,	-19974,	-19846,	-19718,	-19590,	-19462,	-19334,	-19206,	-19078,	-18950,	-18822,	-18694,	-18566,	
	-18438,	-18310,	-18182,	-18054,	-17926,	-17798,	-17670,	-17542,	-17414,	-17286,	-17157,	-17029,	-16901,	-16773,	-16645,	-16517,	
	-16389,	-16261,	-16133,	-16005,	-15877,	-15749,	-15621,	-15493,	-15365,	-15237,	-15109,	-14981,	-14853,	-14725,	-14597,	-14469,	
	-14340,	-14212,	-14084,	-13956,	-13828,	-13700,	-13572,	-13444,	-13316,	-13188,	-13060,	-12932,	-12804,	-12676,	-12548,	-12420,	
	-12292,	-12164,	-12036,	-11908,	-11780,	-11652,	-11524,	-11395,	-11267,	-11139,	-11011,	-10883,	-10755,	-10627,	-10499,	-10371,	
	-10243,	-10115,	-9987 ,	-9859 ,	-9731 ,	-9603 ,	-9475 ,	-9347 ,	-9219 ,	-9091 ,	-8963 ,	-8835 ,	-8707 ,	-8578 ,	-8450 ,	-8322 ,	
	-8194 ,	-8066 ,	-7938 ,	-7810 ,	-7682 ,	-7554 ,	-7426 ,	-7298 ,	-7170 ,	-7042 ,	-6914 ,	-6786 ,	-6658 ,	-6530 ,	-6402 ,	-6274 ,	
	-6146 ,	-6018 ,	-5890 ,	-5762 ,	-5633 ,	-5505 ,	-5377 ,	-5249 ,	-5121 ,	-4993 ,	-4865 ,	-4737 ,	-4609 ,	-4481 ,	-4353 ,	-4225 ,	
	-4097 ,	-3969 ,	-3841 ,	-3713 ,	-3585 ,	-3457 ,	-3329 ,	-3201 ,	-3073 ,	-2945 ,	-2816 ,	-2688 ,	-2560 ,	-2432 ,	-2304 ,	-2176 ,	
	-2048 ,	-1920 ,	-1792 ,	-1664 ,	-1536 ,	-1408 ,	-1280 ,	-1152 ,	-1024 ,	-896  ,	-768  ,	-640  ,	-512  ,	-384  ,	-256  ,	-128  ,	
	//Osc 3	Level 2
	0     ,	256   ,	512   ,	768   ,	1024  ,	1280  ,	1536  ,	1792  ,	2048  ,	2304  ,	2560  ,	2816  ,	3073  ,	3329  ,	3585  ,	3841  ,	
	4097  ,	4353  ,	4609  ,	4865  ,	5121  ,	5377  ,	5633  ,	5890  ,	6146  ,	6402  ,	6658  ,	6914  ,	7170  ,	7426  ,	7682  ,	7938  ,	
	8194  ,	8450  ,	8707  ,	8963  ,	9219  ,	9475  ,	9731  ,	9987  ,	10243 ,	10499 ,	10755 ,	11011 ,	11267 ,	11524 ,	11780 ,	12036 ,	
	12292 ,	12548 ,	12804 ,	13060 ,	13316 ,	13572 ,	13828 ,	14084 ,	14340 ,	14597 ,	14853 ,	15109 ,	15365 ,	15621 ,	15877 ,	16133 ,	
	16389 ,	16645 ,	16901 ,	17157 ,	17414 ,	17670 ,	17926 ,	18182 ,	18438 ,	18694 ,	18950 ,	19206 ,	19462 ,	19718 ,	19974 ,	20231 ,	
	20487 ,	20743 ,	20999 ,	21255 ,	21511 ,	21767 ,	22023 ,	22279 ,	22535 ,	22791 ,	23048 ,	23304 ,	23560 ,	23816 ,	24072 ,	24328 ,	
	24584 ,	24840 ,	25096 ,	25352 ,	25608 ,	25865 ,	26121 ,	26377 ,	26633 ,	26889 ,	27145 ,	27401 ,	27657 ,	27913 ,	28169 ,	28425 ,	
	28681 ,	28938 ,	29194 ,	29450 ,	29706 ,	29962 ,	30218 ,	30474 ,	30730 ,	30987 ,	31242 ,	31499 ,	31754 ,	32012 ,	32265 ,	32529 ,	
	32727 ,	32529 ,	32265 ,	32012 ,	31754 ,	31499 ,	31242 ,	30987 ,	30730 ,	30474 ,	30218 ,	29962 ,	29706 ,	29450 ,	29194 ,	28938 ,	
	28681 ,	28425 ,	28169 ,	27913 ,	27657 ,	27401 ,	27145 ,	26889 ,	26633 ,	26377 ,	26121 ,	25865 ,	25608 ,	25352 ,	25096 ,	24840 ,	
	24584 ,	24328 ,	24072 ,	23816 ,	23560 ,	23304 ,	23048 ,	22791 ,	22535 ,	22279 ,	22023 ,	21767 ,	21511 ,	21255 ,	20999 ,	20743 ,	
	20487 ,	20231 ,	19974 ,	19718 ,	19462 ,	19206 ,	18950 ,	18694 ,	18438 ,	18182 ,	17926 ,	17670 ,	17414 ,	17157 ,	16901 ,	16645 ,	
	16389 ,	16133 ,	15877 ,	15621 ,	15365 ,	15109 ,	14853 ,	14597 ,	14340 ,	14084 ,	13828 ,	13572 ,	13316 ,	13060 ,	12804 ,	12548 ,	
	12292 ,	12036 ,	11780 ,	11524 ,	11267 ,	11011 ,	10755 ,	10499 ,	10243 ,	9987  ,	9731  ,	9475  ,	9219  ,	8963  ,	8707  ,	8450  ,	
	8194  ,	7938  ,	7682  ,	7426  ,	7170  ,	6914  ,	6658  ,	6402  ,	6146  ,	5890  ,	5633  ,	5377  ,	5121  ,	4865  ,	4609  ,	4353  ,	
	4097  ,	3841  ,	3585  ,	3329  ,	3073  ,	2816  ,	2560  ,	2304  ,	2048  ,	1792  ,	1536  ,	1280  ,	1024  ,	768   ,	512   ,	256   ,	
	0     ,	-256  ,	-512  ,	-768  ,	-1024 ,	-1280 ,	-1536 ,	-1792 ,	-2048 ,	-2304 ,	-2560 ,	-2816 ,	-3073 ,	-3329 ,	-3585 ,	-3841 ,	
	-4097 ,	-4353 ,	-4609 ,	-4865 ,	-5121 ,	-5377 ,	-5633 ,	-5890 ,	-6146 ,	-6402 ,	-6658 ,	-6914 ,	-7170 ,	-7426 ,	-7682 ,	-7938 ,	
	-8194 ,	-8450 ,	-8707 ,	-8963 ,	-9219 ,	-9475 ,	-9731 ,	-9987 ,	-10243,	-10499,	-10755,	-11011,	-11267,	-11524,	-11780,	-12036,	
	-12292,	-12548,	-12804,	-13060,	-13316,	-13572,	-13828,	-14084,	-14340,	-14597,	-14853,	-15109,	-15365,	-15621,	-15877,	-16133,	
	-16389,	-16645,	-16901,	-17157,	-17414,	-17670,	-17926,	-18182,	-18438,	-18694,	-18950,	-19206,	-19462,	-19718,	-19974,	-20231,	
	-20487,	-20743,	-20999,	-21255,	-21511,	-21767,	-22023,	-22279,	-22535,	-22791,	-23048,	-23304,	-23560,	-23816,	-24072,	-24328,	
	-24584,	-24840,	-25096,	-25352,	-25608,	-25865,	-26121,	-26377,	-26633,	-26889,	-27145,	-27401,	-27657,	-27913,	-28169,	-28425,	
	-28681,	-28938,	-29194,	-29450,	-29706,	-29962,	-30218,	-30474,	-30730,	-30987,	-31242,	-31499,	-31754,	-32012,	-32265,	-32529,	
	-32727,	-32529,	-32265,	-32012,	-31754,	-31499,	-31242,	-30987,	-30730,	-30474,	-30218,	-29962,	-29706,	-29450,	-29194,	-28938,	
	-28681,	-28425,	-28169,	-27913,	-27657,	-27401,	-27145,	-26889,	-26633,	-26377,	-26121,	-25865,	-25608,	-25352,	-25096,	-24840,	
	-24584,	-24328,	-24072,	-23816,	-23560,	-23304,	-23048,	-22791,	-22535,	-22279,	-22023,	-21767,	-21511,	-21255,	-20999,	-20743,	
	-20487,	-20231,	-19974,	-19718,	-19462,	-19206,	-18950,	-18694,	-18438,	-18182,	-17926,	-17670,	-17414,	-17157,	-16901,	-16645,	
	-16389,	-16133,	-15877,	-15621,	-15365,	-15109,	-14853,	-14597,	-14340,	-14084,	-13828,	-13572,	-13316,	-13060,	-12804,	-12548,	
	-12292,	-12036,	-11780,	-11524,	-11267,	-11011,	-10755,	-10499,	-10243,	-9987 ,	-9731 ,	-9475 ,	-9219 ,	-8963 ,	-8707 ,	-8450 ,	
	-8194 ,	-7938 ,	-7682 ,	-7426 ,	-7170 ,	-6914 ,	-6658 ,	-6402 ,	-6146 ,	-5890 ,	-5633 ,	-5377 ,	-5121 ,	-4865 ,	-4609 ,	-4353 ,	
	-4097 ,	-3841 ,	-3585 ,	-3329 ,	-3073 ,	-2816 ,	-2560 ,	-2304 ,	-2048 ,	-1792 ,	-1536 ,	-1280 ,	-1024 ,	-768  ,	-512  ,	-256  ,	
	//Osc 3	Level 3
	0     ,	512   ,	1024  ,	1536  ,	2048  ,	2560  ,	3073  ,	3585  ,	4097  ,	4609  ,	5121  ,	5633  ,	6146  ,	6658  ,	7170  ,	7682  ,	
	8194  ,	8707  ,	9219  ,	9731  ,	10243 ,	10755 ,	11267 ,	11780 ,	12292 ,	12804 ,	13316 ,	13828 ,	14340 ,	14853 ,	15365 ,	15877 ,	
	16389 ,	16901 ,	17414 ,	17926 ,	18438 ,	18950 ,	19462 ,	19974 ,	20487 ,	20999 ,	21511 ,	22023 ,	22535 ,	23048 ,	23560 ,	24072 ,	
	24584 ,	25096 ,	25608 ,	26121 ,	26633 ,	27145 ,	27657 ,	28170 ,	28681 ,	29194 ,	29705 ,	30219 ,	30729 ,	31244 ,	31750 ,	32279 ,	
	32675 ,	32279 ,	31750 ,	31244 ,	30729 ,	30219 ,	29705 ,	29194 ,	28681 ,	28170 ,	27657 ,	27145 ,	26633 ,	26121 ,	25608 ,	25096 ,	
	24584 ,	24072 ,	23560 ,	23048 ,	22535 ,	22023 ,	21511 ,	20999 ,	20487 ,	19974 ,	19462 ,	18950 ,	18438 ,	17926 ,	17414 ,	16901 ,	
	16389 ,	15877 ,	15365 ,	14853 ,	14340 ,	13828 ,	13316 ,	12804 ,	12292 ,	11780 ,	11267 ,	10755 ,	10243 ,	9731  ,	9219  ,	8707  ,	
	8194  ,	7682  ,	7170  ,	6658  ,	6146  ,	5633  ,	5121  ,	4609  ,	4097  ,	3585  ,	3073  ,	2560  ,	2048  ,	1536  ,	1024  ,	512   ,	
	0     ,	-512  ,	-1024 ,	-1536 ,	-2048 ,	-2560 ,	-3073 ,	-3585 ,	-4097 ,	-4609 ,	-5121 ,	-5633 ,	-6146 ,	-6658 ,	-7170 ,	-7682 ,	
	-8194 ,	-8707 ,	-9219 ,	-9731 ,	-10243,	-10755,	-11267,	-11780,	-12292,	-12804,	-13316,	-13828,	-14340,	-14853,	-15365,	-15877,	
	-16389,	-16901,	-17414,	-17926,	-18438,	-18950,	-19462,	-19974,	-20487,	-20999,	-21511,	-22023,	-22535,	-23048,	-23560,	-24072,	
	-24584,	-25096,	-25608,	-26121,	-26633,	-27145,	-27657,	-28170,	-28681,	-29194,	-29705,	-30219,	-30729,	-31244,	-31750,	-32279,	
	-32675,	-32279,	-31750,	-31244,	-30729,	-30219,	-29705,	-29194,	-28681,	-28170,	-27657,	-27145,	-26633,	-26121,	-25608,	-25096,	
	-24584,	-24072,	-23560,	-23048,	-22535,	-22023,	-21511,	-20999,	-20487,	-19974,	-19462,	-18950,	-18438,	-17926,	-17414,	-16901,	
	-16389,	-15877,	-15365,	-14853,	-14340,	-13828,	-13316,	-12804,	-12292,	-11780,	-11267,	-10755,	-10243,	-9731 ,	-9219 ,	-8707 ,	
	-8194 ,	-7682 ,	-7170 ,	-6658 ,	-6146 ,	-5633 ,	-5121 ,	-4609 ,	-4097 ,	-3585 ,	-3073 ,	-2560 ,	-2048 ,	-1536 ,	-1024 ,	-512  ,	
	//Osc 3	Level 4
	0     ,	1024  ,	2048  ,	3073  ,	4097  ,	5121  ,	6146  ,	7170  ,	8194  ,	9219  ,	10243 ,	11267 ,	12292 ,	13316 ,	14340 ,	15365 ,	
	16389 ,	17414 ,	18438 ,	19463 ,	20486 ,	21511 ,	22535 ,	23560 ,	24583 ,	25609 ,	26632 ,	27659 ,	28679 ,	29710 ,	30722 ,	31779 ,	
	32571 ,	31779 ,	30722 ,	29710 ,	28679 ,	27659 ,	26632 ,	25609 ,	24583 ,	23560 ,	22535 ,	21511 ,	20486 ,	19463 ,	18438 ,	17414 ,	
	16389 ,	15365 ,	14340 ,	13316 ,	12292 ,	11267 ,	10243 ,	9219  ,	8194  ,	7170  ,	6146  ,	5121  ,	4097  ,	3073  ,	2048  ,	1024  ,	
	0     ,	-1024 ,	-2048 ,	-3073 ,	-4097 ,	-5121 ,	-6146 ,	-7170 ,	-8194 ,	-9219 ,	-10243,	-11267,	-12292,	-13316,	-14340,	-15365,	
	-16389,	-17414,	-18438,	-19463,	-20486,	-21511,	-22535,	-23560,	-24583,	-25609,	-26632,	-27659,	-28679,	-29710,	-30722,	-31779,	
	-32571,	-31779,	-30722,	-29710,	-28679,	-27659,	-26632,	-25609,	-24583,	-23560,	-22535,	-21511,	-20486,	-19463,	-18438,	-17414,	
	-16389,	-15365,	-14340,	-13316,	-12292,	-11267,	-10243,	-9219 ,	-8194 ,	-7170 ,	-6146 ,	-5121 ,	-4097 ,	-3073 ,	-2048 ,	-1024 ,	
	//Osc 3	Level 5
	0     ,	2048  ,	4097  ,	6146  ,	8194  ,	10244 ,	12291 ,	14341 ,	16388 ,	18439 ,	20485 ,	22538 ,	24579 ,	26641 ,	28665 ,	30779 ,	
	32364 ,	30779 ,	28665 ,	26641 ,	24579 ,	22538 ,	20485 ,	18439 ,	16388 ,	14341 ,	12291 ,	10244 ,	8194  ,	6146  ,	4097  ,	2048  ,	
	0     ,	-2048 ,	-4097 ,	-6146 ,	-8194 ,	-10244,	-12291,	-14341,	-16388,	-18439,	-20485,	-22538,	-24579,	-26641,	-28665,	-30779,	
	-32364,	-30779,	-28665,	-26641,	-24579,	-22538,	-20485,	-18439,	-16388,	-14341,	-12291,	-10244,	-8194 ,	-6146 ,	-4097 ,	-2048 ,	
	//Osc 3	Level 6
	0     ,	4098  ,	8192  ,	12297 ,	16381 ,	20502 ,	24551 ,	28777 ,	31950 ,	28777 ,	24551 ,	20502 ,	16381 ,	12297 ,	8192  ,	4098  ,	
	0     ,	-4098 ,	-8192 ,	-12297,	-16381,	-20502,	-24551,	-28777,	-31950,	-28777,	-24551,	-20502,	-16381,	-12297,	-8192 ,	-4098 ,	
	//Osc 3	Level 7
	0     ,	8214  ,	16332 ,	24769 ,	31127 ,	24769 ,	16332 ,	8214  ,	0     ,	-8214 ,	-16332,	-24769,	-31127,	-24769,	-16332,	-8214 ,	
	//Osc 3	Level 8
	0     ,	16700 ,	29522 ,	16700 ,	0     ,	-16700,	-29522,	-16700,	
	//Osc 3	Level 9
	0     ,	26570 ,	0     ,	-26570,	
	//Osc 3	Level 10
	0     ,	0     ,	
	//Osc 3	Level 11
	0     ,	0     ,	
    },
    //Osc 4	Level 0
    {
	-25049,	-30331,	11797 ,	32285 ,	-2156 ,	28100 ,	-32487,	15921 ,	26285 ,	14680 ,	-877  ,	25906 ,	1323  ,	2240  ,	32278 ,	-32178,	
	-14181,	21237 ,	12617 ,	-31901,	6878  ,	17887 ,	20584 ,	-1657 ,	-15702,	29404 ,	13505 ,	-21119,	7176  ,	19264 ,	-18632,	-31666,	
	-24364,	27856 ,	-7996 ,	13213 ,	16703 ,	-16826,	27375 ,	18004 ,	3152  ,	23504 ,	4186  ,	-3831 ,	10335 ,	21393 ,	-21194,	13961 ,	
	-25703,	12830 ,	12236 ,	23636 ,	25727 ,	-8445 ,	-9994 ,	12062 ,	25191 ,	18747 ,	-13148,	-26800,	-29191,	-7237 ,	-3496 ,	-634  ,	
	435   ,	29160 ,	-23126,	-241  ,	21094 ,	-23524,	-18747,	29296 ,	-18505,	-31706,	15080 ,	15328 ,	1183  ,	12743 ,	11494 ,	29133 ,	
	-4117 ,	-4298 ,	23974 ,	20822 ,	-21316,	-612  ,	13475 ,	-32049,	-11513,	18840 ,	-16275,	11841 ,	-26601,	-6212 ,	5927  ,	-8217 ,	
	22279 ,	-7922 ,	-30969,	15537 ,	-5816 ,	20360 ,	-26918,	-31035,	20257 ,	-13671,	22141 ,	-3591 ,	10281 ,	-23646,	32612 ,	18523 ,	
	-1073 ,	29306 ,	25879 ,	24233 ,	20947 ,	-3606 ,	13744 ,	-10023,	6859  ,	-21455,	-30114,	16018 ,	26783 ,	-2174 ,	-14363,	-8271 ,	
	-2291 ,	-15743,	-12516,	-30523,	-31707,	12489 ,	32110 ,	1940  ,	-1842 ,	1897  ,	32089 ,	-108  ,	24896 ,	26979 ,	-6414 ,	-29070,	
	-19065,	-7125 ,	12383 ,	16526 ,	29190 ,	19502 ,	-4517 ,	-10884,	-14   ,	26952 ,	-6986 ,	-11131,	28115 ,	-3251 ,	-6445 ,	-3803 ,	
	-2042 ,	24193 ,	-30680,	16267 ,	24894 ,	-2016 ,	7361  ,	-18149,	-25858,	21207 ,	-30275,	-28433,	-16863,	-31928,	-6705 ,	-10158,	
	21330 ,	11402 ,	27071 ,	29508 ,	-5228 ,	23719 ,	-20250,	-8967 ,	-30532,	14621 ,	18870 ,	15449 ,	-10766,	-1187 ,	-27089,	18561 ,	
	12339 ,	15695 ,	31851 ,	32065 ,	32466 ,	-27189,	26387 ,	8092  ,	-9230 ,	1314  ,	-27160,	-28084,	3341  ,	12691 ,	15932 ,	31291 ,	
	-13455,	29654 ,	-1163 ,	-19701,	-9026 ,	-19563,	3984  ,	5006  ,	-1175 ,	5102  ,	-3172 ,	-32177,	3900  ,	-4109 ,	14395 ,	-9721 ,	
	-18989,	-22743,	-18907,	-25047,	6945  ,	-17908,	-29019,	32599 ,	-24087,	-18806,	31770 ,	-20502,	-9147 ,	29827 ,	29303 ,	-30610,	
	21539 ,	8784  ,	4035  ,	31779 ,	-23614,	-24263,	23706 ,	23933 ,	-8646 ,	-19971,	23722 ,	29349 ,	-14351,	29005 ,	28471 ,	23031 ,	
	24359 ,	9297  ,	32663 ,	-16766,	13419 ,	-10974,	-31306,	23690 ,	-27869,	-16561,	-10604,	22025 ,	31240 ,	3161  ,	-15166,	-10454,	
	-7256 ,	24630 ,	-28439,	-30004,	24290 ,	13777 ,	-21949,	-8442 ,	30573 ,	-29816,	-16609,	6557  ,	28242 ,	-8275 ,	-25247,	15503 ,	
	-15763,	-761  ,	-7424 ,	14988 ,	-30480,	5966  ,	32391 ,	31607 ,	-27168,	14257 ,	-108  ,	-20247,	29847 ,	31059 ,	14172 ,	31407 ,	
	-20416,	5578  ,	-22235,	-9401 ,	27741 ,	16799 ,	19147 ,	-921  ,	19780 ,	-10030,	-27333,	17270 ,	12446 ,	23379 ,	25851 ,	13841 ,	
	-18969,	-18039,	-21856,	11911 ,	-26895,	-3890 ,	27478 ,	24669 ,	20577 ,	-2063 ,	4444  ,	11467 ,	-26064,	31667 ,	-29562,	18237 ,	
	-20437,	-5301 ,	-15687,	10707 ,	-5516 ,	21731 ,	-12174,	23010 ,	-23041,	-28136,	6463  ,	31857 ,	32021 ,	17533 ,	10308 ,	15036 ,	
	-12332,	8729  ,	-8008 ,	-2380 ,	7341  ,	4580  ,	-411  ,	-12419,	-22299,	6222  ,	26156 ,	-2578 ,	-1771 ,	-27719,	18046 ,	20757 ,	
	-26198,	18682 ,	-30748,	29361 ,	14181 ,	16347 ,	-29320,	23478 ,	2012  ,	-4196 ,	17770 ,	-28468,	503   ,	-17555,	-30340,	32464 ,	
	-6539 ,	-16650,	-12410,	12114 ,	6244  ,	-5425 ,	-22029,	-13035,	-14932,	28936 ,	6210  ,	-1902 ,	24453 ,	419   ,	10118 ,	-5002 ,	
	-7428 ,	-10475,	-7450 ,	29215 ,	29042 ,	4809  ,	5150  ,	9763  ,	14621 ,	27037 ,	-11268,	-29495,	-21115,	-24478,	-5404 ,	30350 ,	
	4104  ,	-10144,	-32436,	-19295,	-14249,	-21552,	8256  ,	7527  ,	3318  ,	6752  ,	-32288,	-7944 ,	23488 ,	-14925,	12765 ,	-21088,	
	16993 ,	32222 ,	-512  ,	-23457,	-2342 ,	-25108,	-18781,	7529  ,	-16383,	-18341,	-16587,	15527 ,	-20994,	5020  ,	-4422 ,	-10700,	
	-23857,	-2409 ,	16457 ,	-23839,	-21819,	17701 ,	-11379,	17586 ,	9476  ,	27797 ,	15685 ,	-25761,	-17401,	8232  ,	10180 ,	26835 ,	
	11802 ,	26004 ,	17265 ,	-14928,	-6690 ,	29060 ,	-30905,	26057 ,	-7480 ,	21526 ,	16726 ,	11430 ,	29090 ,	30044 ,	-2240 ,	4612  ,	
	-19191,	25052 ,	-26946,	-10669,	-530  ,	-6384 ,	-2535 ,	-30922,	29717 ,	32743 ,	-23375,	-11257,	3737  ,	4418  ,	-29831,	-19888,	
	23653 ,	30327 ,	-8839 ,	21074 ,	-25412,	-8750 ,	-10166,	-7294 ,	-22605,	29967 ,	-11106,	-22265,	-22862,	-6687 ,	9910  ,	-8642 ,	
	-25354,	-23954,	20201 ,	-5322 ,	-16366,	-32304,	31268 ,	-5836 ,	8297  ,	-21354,	21092 ,	30512 ,	8630  ,	22849 ,	-24770,	-8618 ,	
	-15484,	22728 ,	13912 ,	-31098,	14774 ,	29460 ,	15341 ,	15060 ,	21760 ,	-27771,	13133 ,	-16887,	-17556,	17771 ,	-8358 ,	-20704,	
	28887 ,	141   ,	-3316 ,	-16950,	12145 ,	-14938,	-28178,	-20757,	-28607,	2787  ,	-24417,	12570 ,	-31842,	30822 ,	25938 ,	293   ,	
	-26186,	29894 ,	30798 ,	-8565 ,	6923  ,	396   ,	-31633,	-12288,	-3855 ,	-6216 ,	22435 ,	-18452,	-8686 ,	-19398,	17262 ,	-18196,	
	1771  ,	1146  ,	-12954,	-5553 ,	19020 ,	8912  ,	12216 ,	-9061 ,	-5669 ,	-3316 ,	-22111,	28166 ,	-32111,	12016 ,	8182  ,	28413 ,	
	21820 ,	-3407 ,	3484  ,	5793  ,	-8452 ,	6522  ,	17424 ,	18244 ,	-15930,	27112 ,	31713 ,	-23824,	31971 ,	-28017,	-19151,	-4127 ,	
	30066 ,	30323 ,	26680 ,	19718 ,	-12574,	-13936,	-31295,	13956 ,	-27783,	32083 ,	-14422,	-9677 ,	-21296,	-737  ,	-11928,	-17377,	
	11349 ,	15049 ,	-24447,	11016 ,	25543 ,	2844  ,	19729 ,	1250  ,	-12867,	21078 ,	6726  ,	-13482,	-14816,	169   ,	-10525,	-30657,	
	4780  ,	24250 ,	-29248,	-32210,	-17549,	10789 ,	-31159,	-16153,	13146 ,	504   ,	-27397,	-7711 ,	-12134,	9011  ,	-17430,	-17206,	
	-27327,	-2737 ,	6974  ,	-10240,	18350 ,	26292 ,	12720 ,	11545 ,	23320 ,	-26303,	27922 ,	15709 ,	-22520,	24264 ,	-30011,	-2489 ,	
	-2854 ,	1423  ,	-14272,	26119 ,	20032 ,	29904 ,	-7280 ,	16387 ,	-20545,	-26311,	-5166 ,	12625 ,	31792 ,	-24211,	-7749 ,	1342  ,	
	-14784,	2690  ,	10257 ,	-26166,	-5904 ,	-895  ,	17455 ,	9258  ,	28694 ,	30441 ,	-4475 ,	-15035,	20698 ,	-13012,	-3307 ,	28215 ,	
	-3525 ,	29488 ,	25080 ,	5330  ,	1415  ,	6607  ,	-28713,	-18408,	-20762,	-25768,	26225 ,	13505 ,	-560  ,	14348 ,	-31460,	27067 ,	
	13714 ,	8866  ,	-20164,	11429 ,	-6706 ,	23747 ,	5838  ,	-29100,	21239 ,	-7282 ,	-10016,	28494 ,	-20775,	-21482,	-3563 ,	-7087 ,	
	8463  ,	-4129 ,	25894 ,	27341 ,	8074  ,	18788 ,	-17060,	-4762 ,	-26863,	8340  ,	-8424 ,	-26509,	25532 ,	26448 ,	-22453,	32386 ,	
	-26248,	9711  ,	24830 ,	3282  ,	-25466,	-10309,	31691 ,	-12329,	2556  ,	6001  ,	9826  ,	1977  ,	28738 ,	7108  ,	10757 ,	3285  ,	
	-10346,	987   ,	7180  ,	1082  ,	6793  ,	29646 ,	24161 ,	-7123 ,	-29057,	301   ,	28677 ,	-14169,	-973  ,	-4230 ,	3466  ,	-26670,	
	-6095 ,	15530 ,	-24169,	30351 ,	11098 ,	-601  ,	-31384,	3315  ,	23396 ,	2769  ,	4427  ,	6853  ,	-31913,	-904  ,	32035 ,	23553 ,	
	-21487,	-2204 ,	-28439,	15704 ,	-19262,	-14002,	-23258,	-8018 ,	31601 ,	-10908,	29562 ,	29083 ,	-10891,	20680 ,	-18664,	-13845,	
	22525 ,	20242 ,	-25272,	-6626 ,	28809 ,	7881  ,	1508  ,	-22040,	-12945,	30190 ,	-27685,	-2894 ,	-27049,	28274 ,	3505  ,	1559  ,	
	-2882 ,	-11590,	-29187,	-19864,	-5001 ,	14882 ,	1001  ,	-6360 ,	-31707,	30072 ,	-31818,	-111  ,	15811 ,	19324 ,	26422 ,	26893 ,	
	24348 ,	-31385,	15951 ,	-26690,	-30125,	19297 ,	3967  ,	-13577,	9821  ,	20744 ,	-6061 ,	8640  ,	-26750,	-11792,	-16914,	32598 ,	
	-14369,	-8674 ,	7560  ,	-16472,	32743 ,	-2420 ,	-21268,	-17444,	3805  ,	31145 ,	-1287 ,	-24888,	-15524,	-8235 ,	8226  ,	-30343,	
	13263 ,	18409 ,	12015 ,	-30801,	22265 ,	21421 ,	-2951 ,	-11169,	-5010 ,	-11168,	-30479,	28208 ,	-19176,	-14540,	12314 ,	31742 ,	
	-1100 ,	-24113,	2507  ,	346   ,	27986 ,	28363 ,	-28050,	25352 ,	-15912,	-17865,	-3196 ,	15232 ,	-19328,	-12780,	-23522,	-146  ,	
	-13227,	-16679,	-9883 ,	-3534 ,	29882 ,	-14353,	-14573,	-5536 ,	26083 ,	-1995 ,	-20489,	-6591 ,	23898 ,	-20867,	18038 ,	28752 ,	
	-22917,	-6643 ,	-8955 ,	21438 ,	-3335 ,	-11488,	-6481 ,	-24338,	-31913,	-12446,	18325 ,	506   ,	-24721,	5752  ,	-2711 ,	24364 ,	
	-8466 ,	21109 ,	-6158 ,	-11386,	-15914,	30822 ,	-9844 ,	-3782 ,	6395  ,	29895 ,	22437 ,	22067 ,	16007 ,	-22517,	9024  ,	-28533,	
	7798  ,	-19687,	-7818 ,	-11502,	-28902,	-27703,	-25616,	-1587 ,	31128 ,	-28309,	4462  ,	24180 ,	21098 ,	31041 ,	22084 ,	31987 ,	
	25051 ,	11007 ,	17623 ,	26603 ,	-9075 ,	30034 ,	-16860,	-29394,	19446 ,	-15785,	-17863,	-13754,	-14625,	5151  ,	-22342,	20719 ,	
	-1564 ,	20785 ,	8542  ,	-9320 ,	-9    ,	-7928 ,	-7056 ,	12773 ,	2781  ,	-26479,	-21682,	-720  ,	-9297 ,	-2385 ,	18669 ,	27908 ,	
	-29861,	12471 ,	-26029,	-21599,	8992  ,	3828  ,	18203 ,	8827  ,	1301  ,	-26333,	20981 ,	-28997,	9378  ,	-27912,	-1756 ,	-6724 ,	
	3846  ,	-14185,	-6402 ,	-30321,	-15408,	11036 ,	12911 ,	19831 ,	-8859 ,	15636 ,	-20618,	-13715,	-30336,	-12542,	-28762,	-31842,	
	20909 ,	3035  ,	21158 ,	23272 ,	13262 ,	-10870,	1714  ,	-10911,	2711  ,	-3731 ,	-9960 ,	12241 ,	17937 ,	1238  ,	30396 ,	-15566,	
	29722 ,	-7797 ,	-17259,	-18121,	6371  ,	8774  ,	-18387,	4290  ,	-10383,	-26827,	30757 ,	29292 ,	27165 ,	-32133,	11438 ,	-11007,	
	27412 ,	-23379,	6161  ,	-3583 ,	-4905 ,	-26282,	-12504,	2593  ,	-7492 ,	-31884,	-13853,	31176 ,	22891 ,	-30215,	-15420,	-25198,	
	-158  ,	9291  ,	27747 ,	1744  ,	32114 ,	-18748,	26603 ,	6     ,	7999  ,	32563 ,	8091  ,	-7828 ,	19396 ,	20825 ,	-7610 ,	13677 ,	
	19917 ,	-23700,	-11053,	-21205,	-4997 ,	-5480 ,	-19779,	-6919 ,	21444 ,	-14471,	-8556 ,	30944 ,	19696 ,	674   ,	-15749,	-5861 ,	
	-14563,	22809 ,	168   ,	-12645,	-20548,	6360  ,	-3096 ,	-8317 ,	-25839,	-29362,	24    ,	17325 ,	15543 ,	15324 ,	12972 ,	-18141,	
	12314 ,	28761 ,	-19668,	-30553,	-28421,	-26226,	946   ,	-13781,	-7184 ,	-2630 ,	-28307,	-1702 ,	20193 ,	3855  ,	5409  ,	-9715 ,	
	8587  ,	2100  ,	17317 ,	11479 ,	-20991,	-18239,	-12700,	13178 ,	28966 ,	-26170,	13276 ,	1391  ,	2869  ,	-32188,	24610 ,	-19358,	
	2106  ,	-19534,	7516  ,	-16205,	30870 ,	-18822,	21573 ,	-8713 ,	-9858 ,	1657  ,	-25427,	1908  ,	19836 ,	3971  ,	7671  ,	-6999 ,	
	9453  ,	31196 ,	-16487,	-572  ,	13953 ,	-14656,	-22113,	-16342,	1983  ,	-17188,	5416  ,	21234 ,	-14978,	9426  ,	27879 ,	15210 ,	
	-29587,	-10823,	15780 ,	-11887,	396   ,	4507  ,	30392 ,	-31589,	15024 ,	-19979,	-1387 ,	-4239 ,	-2301 ,	9275  ,	32571 ,	15662 ,	
	-22654,	-18863,	-16700,	23970 ,	18301 ,	-19693,	-2086 ,	2515  ,	1307  ,	-12594,	-16837,	6263  ,	14803 ,	25541 ,	6972  ,	8827  ,	
	13043 ,	32429 ,	-446  ,	30592 ,	-13795,	-17615,	32075 ,	25177 ,	19910 ,	28783 ,	25955 ,	15758 ,	14773 ,	-21128,	6959  ,	-10276,	
	16266 ,	-31276,	19302 ,	10418 ,	7988  ,	-20996,	27475 ,	21685 ,	20345 ,	-6178 ,	2389  ,	573   ,	-2445 ,	-16547,	-4769 ,	32214 ,	
	-19955,	5838  ,	2424  ,	-20800,	12426 ,	893   ,	-17860,	23408 ,	6398  ,	31269 ,	-10407,	-16883,	-15405,	-13445,	-27629,	26867 ,	
	-15547,	28836 ,	-20544,	31539 ,	15334 ,	-22598,	30284 ,	9489  ,	3356  ,	24652 ,	-28489,	-892  ,	18846 ,	-2085 ,	-23150,	-24134,	
	32762 ,	18013 ,	-13946,	13202 ,	21266 ,	-1347 ,	16333 ,	-27616,	-7526 ,	-14503,	-30026,	-724  ,	923   ,	24195 ,	19493 ,	25779 ,	
	-14092,	16129 ,	-2543 ,	12645 ,	-9260 ,	-12146,	-13563,	16165 ,	-23487,	20566 ,	11935 ,	13197 ,	16788 ,	-29315,	17940 ,	-23961,	
	21242 ,	-2663 ,	-5974 ,	-32203,	-28683,	-3789 ,	-8131 ,	28841 ,	-20263,	-28598,	31162 ,	-14547,	10063 ,	1745  ,	-6745 ,	32605 ,	
	9942  ,	-1748 ,	26777 ,	-6264 ,	-707  ,	6326  ,	23484 ,	10036 ,	-17622,	-28610,	32079 ,	-27754,	11414 ,	16517 ,	4390  ,	21533 ,	
	8526  ,	-13118,	20774 ,	-10519,	-31373,	-2274 ,	11724 ,	5452  ,	18939 ,	-12999,	24230 ,	-22448,	7471  ,	-23389,	17112 ,	11568 ,	
	29483 ,	-6301 ,	4505  ,	31197 ,	24161 ,	-20364,	23219 ,	8571  ,	14357 ,	-18365,	22279 ,	18657 ,	6370  ,	4402  ,	-30458,	-13539,	
	8500  ,	13336 ,	11577 ,	-21010,	-28211,	-9025 ,	-1350 ,	26184 ,	13377 ,	13924 ,	13241 ,	27859 ,	4985  ,	-10181,	1528  ,	8812  ,	
	1075  ,	-28184,	15183 ,	-31581,	32128 ,	-30713,	-17879,	-19909,	16709 ,	8357  ,	22021 ,	16302 ,	21690 ,	-16443,	-4106 ,	-9306 ,	
	18670 ,	-11300,	26403 ,	-15484,	21314 ,	12885 ,	-9912 ,	-30755,	-18967,	-15347,	13107 ,	8440  ,	-1937 ,	-32296,	4424  ,	21330 ,	
	-4049 ,	-16133,	-4099 ,	25626 ,	-26406,	20400 ,	-21410,	7605  ,	-17161,	24997 ,	-11125,	9275  ,	-4514 ,	19580 ,	-14283,	6648  ,	
	-12612,	-27571,	-22235,	5100  ,	10258 ,	18464 ,	-25675,	24140 ,	-10955,	-20876,	-10412,	-28418,	-1456 ,	-15942,	1798  ,	-3039 ,	
	3421  ,	31962 ,	-1566 ,	13443 ,	-20816,	30637 ,	-23661,	26664 ,	-11923,	21378 ,	-4904 ,	25290 ,	-19444,	30617 ,	-11260,	23124 ,	
	10460 ,	7595  ,	23934 ,	23397 ,	-20867,	-20896,	-11199,	3539  ,	22629 ,	-4649 ,	23133 ,	-14042,	1884  ,	30754 ,	18804 ,	31001 ,	
	-3584 ,	3527  ,	25407 ,	-11748,	-703  ,	12352 ,	20999 ,	-10795,	-6938 ,	-29060,	31020 ,	10138 ,	13318 ,	-16036,	-27231,	12536 ,	
	-29296,	22582 ,	-20882,	-27088,	17604 ,	13653 ,	21804 ,	-1356 ,	-14921,	14968 ,	-18803,	5550  ,	19923 ,	17743 ,	-1326 ,	-27014,	
	29781 ,	-1023 ,	-2478 ,	-9945 ,	-32051,	27048 ,	10746 ,	-5382 ,	-25182,	-5421 ,	-27705,	-8469 ,	15499 ,	-5629 ,	20302 ,	-3546 ,	
	29463 ,	27695 ,	1589  ,	139   ,	2342  ,	27968 ,	-20297,	18734 ,	-7315 ,	3221  ,	9764  ,	728   ,	-17418,	-30335,	-674  ,	-16252,	
	-21859,	-28728,	-17059,	9699  ,	32149 ,	-11226,	-8788 ,	-5159 ,	25057 ,	199   ,	-26902,	-19202,	-9253 ,	-3632 ,	-31926,	-19939,	
	4017  ,	-15915,	-28909,	5816  ,	-9757 ,	-22944,	14625 ,	-8830 ,	14278 ,	7281  ,	9058  ,	23779 ,	-32764,	-6920 ,	-3238 ,	-21640,	
	-5351 ,	20828 ,	671   ,	21649 ,	-5160 ,	24568 ,	24414 ,	-9039 ,	-10268,	-22375,	7380  ,	5649  ,	-8137 ,	-26366,	29654 ,	17694 ,	
	22942 ,	-32408,	-19639,	-27402,	-10949,	-3851 ,	-32598,	23535 ,	-30462,	25161 ,	-6008 ,	12304 ,	-30659,	14325 ,	16133 ,	-13419,	
	-13304,	2302  ,	20569 ,	-16017,	3030  ,	-17056,	24911 ,	450   ,	26090 ,	31368 ,	32709 ,	11878 ,	-10274,	24537 ,	9008  ,	-16537,	
	1823  ,	4904  ,	-25322,	-2171 ,	-9873 ,	-25280,	-9837 ,	10421 ,	23906 ,	5727  ,	-4139 ,	18589 ,	-32031,	8886  ,	-32097,	-10981,	
	-23637,	16109 ,	28874 ,	2239  ,	-9265 ,	23709 ,	-10817,	-8371 ,	-19917,	20180 ,	-9730 ,	-5571 ,	-28400,	-31083,	-11366,	-2758 ,	
	3699  ,	-24746,	-18757,	-1370 ,	1214  ,	15232 ,	22042 ,	26644 ,	-1243 ,	-20238,	29577 ,	-19764,	-8655 ,	1405  ,	-24471,	-17333,	
	2112  ,	15209 ,	-4559 ,	-31040,	6659  ,	-4624 ,	-4370 ,	14737 ,	-23809,	15806 ,	-31298,	-2604 ,	6669  ,	3447  ,	-30893,	31446 ,	
	-23078,	-29136,	10870 ,	6808  ,	13672 ,	-25611,	18561 ,	32332 ,	-6005 ,	27202 ,	28132 ,	15068 ,	18540 ,	138   ,	-17759,	13668 ,	
	20489 ,	-31053,	-27951,	-10317,	17587 ,	-7785 ,	-24803,	-27442,	24207 ,	8069  ,	7492  ,	-17043,	-16106,	-19266,	156   ,	9340  ,	
	-15467,	2041  ,	-7543 ,	5019  ,	-30291,	-12577,	-15608,	-28770,	-5164 ,	-17777,	-26329,	-4850 ,	-20526,	29723 ,	13193 ,	-19290,	
	-28347,	26890 ,	26855 ,	-10281,	6686  ,	-6188 ,	6282  ,	-19132,	19234 ,	3177  ,	-1325 ,	27975 ,	5225  ,	-854  ,	16819 ,	1642  ,	
	-25118,	29934 ,	2355  ,	-7697 ,	24526 ,	-23426,	-26643,	-32695,	-29888,	-9702 ,	28561 ,	-27232,	17060 ,	-32654,	11617 ,	28241 ,	
	-24012,	-5459 ,	-17739,	-23701,	6276  ,	28902 ,	19831 ,	7988  ,	-28936,	-9046 ,	14504 ,	29090 ,	-7607 ,	-23173,	-29478,	-2846 ,	
	11011 ,	32080 ,	-30540,	-15916,	22026 ,	11539 ,	22898 ,	29837 ,	-29424,	16674 ,	-21662,	16596 ,	28448 ,	1486  ,	-30105,	22182 ,	
	6423  ,	21471 ,	-28038,	-26958,	-474  ,	11533 ,	-4060 ,	-26915,	-28591,	10377 ,	-20219,	-2370 ,	-18189,	-20622,	25680 ,	-31709,	
	-24264,	-30368,	2893  ,	12171 ,	-13663,	14557 ,	-9770 ,	-12118,	30595 ,	10215 ,	-14630,	15081 ,	-7288 ,	-23441,	27869 ,	8675  ,	
	19501 ,	-21283,	14966 ,	-12823,	18754 ,	-29558,	-3377 ,	-24449,	30062 ,	-14268,	-471  ,	26844 ,	-6488 ,	-9522 ,	-30122,	2158  ,	
	-2369 ,	-16035,	31548 ,	26451 ,	23507 ,	22556 ,	11097 ,	-18207,	-28455,	-31063,	-966  ,	-28641,	-29157,	-17258,	14082 ,	17482 ,	
	20918 ,	-16919,	15593 ,	9554  ,	-18406,	16284 ,	1978  ,	-32678,	-23410,	21533 ,	-1452 ,	29755 ,	-1623 ,	10191 ,	298   ,	-27135,	
	-7718 ,	3464  ,	708   ,	-6803 ,	-6175 ,	23313 ,	8251  ,	-28303,	24403 ,	-27223,	-14912,	-29513,	-25318,	-4478 ,	-29930,	29211 ,	
	32754 ,	-28862,	25620 ,	-18132,	18670 ,	-18813,	8484  ,	15023 ,	17393 ,	9300  ,	-16441,	-31461,	-16331,	-10570,	2830  ,	-32482,	
	22728 ,	-27105,	3106  ,	26135 ,	3337  ,	20987 ,	-13635,	32410 ,	-22224,	19750 ,	-8785 ,	15600 ,	32451 ,	-25997,	-13478,	8084  ,	
	-4830 ,	-5848 ,	-17866,	-6729 ,	-17924,	-24193,	-3763 ,	-27716,	14807 ,	-11993,	-22336,	-14403,	18572 ,	26561 ,	10817 ,	24068 ,	
	4553  ,	-15516,	-15977,	26003 ,	10638 ,	-29414,	-738  ,	-7011 ,	-2896 ,	-6816 ,	15940 ,	-4854 ,	24920 ,	-8023 ,	-26100,	-32521,	
	-4219 ,	21468 ,	-30321,	18227 ,	-30330,	-3887 ,	27254 ,	-28733,	11393 ,	-19752,	20353 ,	-22432,	24815 ,	-25806,	8452  ,	244   ,	
	-31971,	15766 ,	3428  ,	-24544,	23469 ,	7342  ,	18846 ,	-6216 ,	-30701,	22167 ,	-24128,	10565 ,	-19687,	-24219,	-9874 ,	2691  ,	
	7515  ,	-26724,	23647 ,	14817 ,	-2613 ,	-11080,	16094 ,	29444 ,	558   ,	24998 ,	-29111,	-11452,	-26723,	-3768 ,	-3691 ,	32300 ,	
	25349 ,	27894 ,	-26168,	4606  ,	424   ,	-12041,	637   ,	27693 ,	-5735 ,	-9972 ,	612   ,	-16926,	-23996,	31974 ,	11200 ,	-3976 ,	
	//Osc 4	Level 1
	-13084,	15530 ,	-793  ,	23040 ,	-757  ,	-17036,	-7995 ,	16829 ,	24862 ,	13777 ,	32601 ,	13481 ,	-17706,	-21948,	-8650 ,	-22034,	
	10176 ,	-1598 ,	20739 ,	-2194 ,	14781 ,	14902 ,	-17924,	-27076,	24451 ,	-6914 ,	-26001,	-18656,	7451  ,	-11412,	-3264 ,	-22761,	
	-27551,	-29883,	30054 ,	976   ,	23943 ,	-9403 ,	619   ,	16432 ,	12177 ,	-14438,	31984 ,	-1841 ,	22746 ,	-14747,	26918 ,	-26503,	
	-30834,	-13252,	-8874 ,	19631 ,	-7633 ,	10410 ,	16986 ,	18979 ,	28688 ,	-19795,	25634 ,	-7873 ,	20957 ,	17719 ,	21040 ,	-7522 ,	
	-13807,	2990  ,	4124  ,	-11375,	-27267,	7788  ,	-27119,	29340 ,	-27704,	28480 ,	-24242,	3063  ,	16362 ,	-31253,	21670 ,	7694  ,	
	-1872 ,	3235  ,	-22272,	19969 ,	6459  ,	11411 ,	-21033,	-21468,	-7807 ,	-17831,	6587  ,	-14209,	11978 ,	12935 ,	-21809,	-26801,	
	-31692,	1572  ,	22345 ,	-23164,	25391 ,	-18648,	19958 ,	-25278,	29698 ,	17667 ,	-14669,	-26016,	32325 ,	26902 ,	-23820,	-12565,	
	-20124,	9015  ,	-8639 ,	30628 ,	-17118,	5682  ,	-12620,	-24450,	14868 ,	13379 ,	13692 ,	14625 ,	25122 ,	-17507,	-24739,	-1686 ,	
	-26358,	743   ,	5422  ,	-27160,	-15139,	-27207,	7258  ,	17504 ,	30335 ,	-24285,	-30881,	-28598,	-7637 ,	-20442,	-27054,	-174  ,	
	10220 ,	14393 ,	-6311 ,	1496  ,	27685 ,	-2618 ,	-18641,	-13455,	16395 ,	6314  ,	-3676 ,	-16540,	23078 ,	-16200,	-28133,	-723  ,	
	-24876,	18999 ,	21514 ,	253   ,	30917 ,	27231 ,	13181 ,	-21448,	-32385,	-25632,	15763 ,	-26122,	-1572 ,	23388 ,	-20225,	17282 ,	
	4744  ,	-19480,	28297 ,	29918 ,	1155  ,	-25713,	-18038,	-28355,	-1627 ,	-24626,	-14220,	-22648,	-15083,	25113 ,	-23225,	22234 ,	
	27600 ,	-7084 ,	-8675 ,	-31996,	32041 ,	9563  ,	1440  ,	22793 ,	-17597,	-29317,	910   ,	-23646,	5016  ,	-21769,	-19140,	28604 ,	
	-6282 ,	-16764,	24079 ,	-32523,	9341  ,	6093  ,	-6139 ,	5667  ,	-21214,	16880 ,	29738 ,	-563  ,	4399  ,	32766 ,	-17629,	-1360 ,	
	-27072,	6527  ,	15783 ,	-1989 ,	4168  ,	30444 ,	17665 ,	3859  ,	-30198,	-29133,	-19568,	-9840 ,	-16992,	-24777,	-23225,	6206  ,	
	23800 ,	16461 ,	-8147 ,	9822  ,	10833 ,	-17728,	-27426,	15970 ,	24771 ,	14158 ,	-4344 ,	3700  ,	-4940 ,	-17751,	30191 ,	7407  ,	
	29796 ,	-3593 ,	-17175,	-796  ,	12386 ,	20306 ,	-7198 ,	-11625,	-27628,	30280 ,	-6182 ,	10240 ,	17971 ,	-1956 ,	17250 ,	-28342,	
	-5811 ,	-7804 ,	-8413 ,	-24233,	13377 ,	-27479,	21079 ,	-20934,	23238 ,	30762 ,	29517 ,	26044 ,	-14875,	29273 ,	14313 ,	12760 ,	
	7290  ,	13820 ,	26146 ,	-4802 ,	-25673,	-8499 ,	5251  ,	-6188 ,	16289 ,	-8709 ,	31402 ,	-17616,	15250 ,	-18777,	-28212,	-4321 ,	
	-15691,	-30104,	1327  ,	28194 ,	-24436,	30151 ,	-3409 ,	18924 ,	-24211,	15555 ,	31545 ,	20453 ,	19201 ,	-14514,	9043  ,	-4695 ,	
	-6972 ,	28111 ,	914   ,	25994 ,	20616 ,	5534  ,	-14046,	21258 ,	-19726,	7563  ,	1602  ,	32610 ,	27643 ,	-26025,	21190 ,	1534  ,	
	-8336 ,	25401 ,	15507 ,	18686 ,	3443  ,	28250 ,	-30682,	13750 ,	31480 ,	32090 ,	16653 ,	22831 ,	27208 ,	-26167,	-26004,	-15196,	
	-7295 ,	-7762 ,	8058  ,	-15866,	-29420,	-23548,	13313 ,	22649 ,	21574 ,	-13000,	25826 ,	-24363,	26032 ,	9132  ,	2190  ,	-5595 ,	
	-2625 ,	-11209,	12174 ,	11819 ,	-9932 ,	-12637,	25852 ,	-10790,	-4699 ,	29229 ,	16136 ,	-12837,	20987 ,	2569  ,	16244 ,	27401 ,	
	28402 ,	-26149,	1048  ,	7924  ,	20379 ,	31295 ,	18271 ,	-926  ,	-13859,	-15038,	12488 ,	-29751,	30448 ,	-27929,	-2714 ,	-4138 ,	
	-1055 ,	1443  ,	18528 ,	23018 ,	8721  ,	-22815,	7026  ,	-12649,	16310 ,	-27778,	12138 ,	-17880,	-4008 ,	30798 ,	29868 ,	21782 ,	
	7509  ,	24213 ,	15278 ,	-10093,	-10658,	-14193,	13693 ,	771   ,	31224 ,	-25110,	17462 ,	27774 ,	-20997,	26694 ,	-25715,	11088 ,	
	10262 ,	-8260 ,	-20150,	-14214,	17993 ,	18259 ,	32199 ,	1070  ,	30570 ,	6540  ,	-29581,	27222 ,	29601 ,	-31528,	23634 ,	-18675,	
	-15124,	14365 ,	-28549,	-29916,	-24676,	-203  ,	28825 ,	28831 ,	2773  ,	-20626,	-18069,	-20683,	-9966 ,	-7157 ,	15684 ,	28884 ,	
	-3937 ,	-30014,	-11125,	-18917,	25629 ,	-16324,	7739  ,	6878  ,	23297 ,	-872  ,	-28572,	-5467 ,	18965 ,	-28696,	-10072,	1325  ,	
	31734 ,	-4430 ,	3264  ,	4838  ,	-5739 ,	-12688,	10997 ,	-30349,	25270 ,	-28144,	27303 ,	-32723,	-31116,	-31115,	23753 ,	21664 ,	
	3002  ,	-4363 ,	23651 ,	7949  ,	22987 ,	25049 ,	-12529,	-2329 ,	28860 ,	-2848 ,	13692 ,	-30890,	8693  ,	14780 ,	-29714,	-3146 ,	
	-26445,	2708  ,	-1349 ,	3096  ,	-19831,	9856  ,	-10544,	-11840,	10202 ,	7696  ,	-3542 ,	-13402,	1121  ,	4037  ,	-17314,	-21770,	
	-4183 ,	-19306,	13074 ,	-16496,	17813 ,	-17300,	-23935,	15497 ,	32474 ,	31398 ,	13819 ,	-13145,	-5761 ,	-7530 ,	22626 ,	-2327 ,	
	12644 ,	-11261,	25774 ,	-11523,	14520 ,	14245 ,	9834  ,	-29241,	-16254,	27564 ,	10805 ,	15841 ,	-7911 ,	-32711,	24130 ,	-30699,	
	-11605,	-15389,	-32040,	-27675,	-31302,	-24524,	27347 ,	-12284,	-29797,	17961 ,	-29663,	-31013,	-12555,	10934 ,	-8122 ,	17156 ,	
	7240  ,	-11457,	5336  ,	-31790,	-1437 ,	-3552 ,	-29692,	-15929,	21228 ,	21286 ,	11527 ,	-15587,	-5411 ,	-26605,	-31562,	16446 ,	
	-21759,	17694 ,	-18954,	22603 ,	14459 ,	-25231,	14916 ,	21913 ,	23871 ,	20394 ,	-3537 ,	-15825,	-16234,	-3494 ,	-31271,	19529 ,	
	28575 ,	20617 ,	5498  ,	31449 ,	13769 ,	1584  ,	14813 ,	12801 ,	-15014,	-4931 ,	21728 ,	-30822,	-20501,	-10349,	12792 ,	-6225 ,	
	-20758,	-24441,	-2389 ,	2306  ,	-17386,	-31644,	-7403 ,	12679 ,	-1530 ,	-12441,	-7580 ,	-13595,	-4957 ,	-9788 ,	27483 ,	-14600,	
	425   ,	21536 ,	12499 ,	-11183,	-5846 ,	-7147 ,	8757  ,	-7501 ,	15883 ,	4273  ,	15361 ,	30616 ,	32389 ,	32503 ,	10314 ,	-11606,	
	-11098,	32348 ,	-20680,	25163 ,	11981 ,	-6837 ,	-2172 ,	2062  ,	10289 ,	15778 ,	-26880,	11579 ,	-16037,	-16077,	29453 ,	-22705,	
	-5977 ,	-22972,	28962 ,	27770 ,	21191 ,	-17393,	30540 ,	6175  ,	9024  ,	22339 ,	-17239,	16215 ,	25835 ,	-29055,	27115 ,	5486  ,	
	21109 ,	-14625,	2523  ,	-8091 ,	28383 ,	4200  ,	-13869,	15726 ,	28159 ,	21146 ,	2627  ,	-19085,	27902 ,	-14104,	16174 ,	8592  ,	
	31448 ,	-12490,	-24406,	24468 ,	28895 ,	-417  ,	11107 ,	-10620,	-25801,	6322  ,	-3816 ,	19224 ,	-20133,	-14736,	14620 ,	1084  ,	
	-24937,	-23985,	28886 ,	-16496,	6797  ,	-27141,	-5054 ,	30184 ,	4528  ,	1680  ,	-2450 ,	28621 ,	-8756 ,	20769 ,	12798 ,	-22022,	
	-12676,	5940  ,	18856 ,	2528  ,	433   ,	-9404 ,	28856 ,	-7646 ,	-29646,	-4802 ,	13198 ,	-14566,	29207 ,	9988  ,	-26597,	13138 ,	
	28493 ,	-1811 ,	-29080,	31756 ,	4117  ,	17986 ,	12559 ,	-27205,	6533  ,	-28221,	21952 ,	10375 ,	16901 ,	-1504 ,	-4675 ,	29901 ,	
	14803 ,	-31104,	-18850,	1949  ,	896   ,	-15618,	-18035,	16186 ,	7280  ,	-21209,	-25013,	-24675,	-2722 ,	28797 ,	-14038,	-2318 ,	
	-17706,	-3337 ,	-13103,	-11750,	28089 ,	-20097,	-21892,	16679 ,	-13379,	-5006 ,	-7559 ,	-5149 ,	2026  ,	9252  ,	21675 ,	30282 ,	
	-11490,	25945 ,	28939 ,	13579 ,	-19319,	26061 ,	14370 ,	12811 ,	12850 ,	28845 ,	-29808,	226   ,	-13968,	8988  ,	20104 ,	-7332 ,	
	-18574,	-1873 ,	22098 ,	-16904,	-28232,	-22543,	10952 ,	-9107 ,	-20840,	-12576,	-26919,	-31200,	-8774 ,	-4243 ,	-30455,	-7504 ,	
	-3941 ,	15360 ,	17391 ,	11882 ,	4878  ,	13298 ,	-8523 ,	-16683,	-3146 ,	-28655,	-27236,	-10457,	-17266,	-224  ,	27254 ,	19662 ,	
	23394 ,	12884 ,	5418  ,	31721 ,	6739  ,	-17960,	-15309,	-29749,	2134  ,	-20150,	11553 ,	895   ,	-20043,	15420 ,	27926 ,	-20929,	
	-22387,	21172 ,	14666 ,	-12293,	-8882 ,	-8788 ,	-8312 ,	-22056,	18238 ,	9106  ,	5807  ,	20142 ,	-8969 ,	-31543,	-24782,	-14454,	
	-8988 ,	-30682,	13209 ,	2090  ,	-6712 ,	-18571,	18685 ,	13187 ,	-8393 ,	-13326,	-24689,	12350 ,	-19941,	10960 ,	8978  ,	3383  ,	
	-11983,	12725 ,	7005  ,	13821 ,	4489  ,	-11461,	11482 ,	30549 ,	-11511,	880   ,	-22262,	21431 ,	-1813 ,	29783 ,	-20738,	-22578,	
	-19910,	8806  ,	7135  ,	-24836,	4697  ,	12550 ,	19303 ,	30677 ,	-1668 ,	5911  ,	-22426,	-26465,	19757 ,	7017  ,	3390  ,	29656 ,	
	200   ,	8515  ,	29799 ,	-17232,	-4608 ,	17631 ,	30956 ,	-5237 ,	-680  ,	18412 ,	-22805,	4736  ,	7850  ,	-12789,	-25575,	477   ,	
	-28253,	-5805 ,	30780 ,	-17248,	32325 ,	30413 ,	7600  ,	-17153,	23908 ,	-13575,	-15901,	2273  ,	-20182,	11847 ,	19929 ,	-27037,	
	3475  ,	10654 ,	-29016,	-32683,	-3855 ,	8921  ,	13820 ,	2746  ,	-5015 ,	18757 ,	10900 ,	30539 ,	-25483,	-11740,	-22332,	10740 ,	
	29024 ,	-31443,	-19727,	7509  ,	18380 ,	-26358,	21016 ,	-22717,	20783 ,	24536 ,	9799  ,	-29371,	19538 ,	-15445,	18211 ,	26903 ,	
	-29231,	-27897,	29792 ,	-8918 ,	-10082,	7528  ,	-27060,	6434  ,	-31106,	8123  ,	-29115,	11863 ,	138   ,	226   ,	-10435,	13397 ,	
	-30800,	-8652 ,	30269 ,	-17061,	19759 ,	26619 ,	-17696,	6880  ,	23326 ,	3573  ,	-12333,	29193 ,	-13083,	-1069 ,	-25764,	-24524,	
	//Osc 4	Level 2
	-10301,	26045 ,	-4144 ,	-4239 ,	-23737,	9420  ,	-29669,	6916  ,	-3626 ,	-23666,	27708 ,	-23580,	-26325,	6790  ,	27078 ,	-2754 ,	
	-13613,	-25431,	-21408,	22771 ,	11437 ,	29666 ,	27206 ,	-17386,	-16016,	-12913,	-1850 ,	17263 ,	8484  ,	14081 ,	-21308,	-20485,	
	423   ,	-5632 ,	2871  ,	-27799,	3882  ,	-5819 ,	18857 ,	21662 ,	5298  ,	27903 ,	-24901,	1074  ,	-2920 ,	8014  ,	-7522 ,	-32526,	
	28937 ,	-22325,	-101  ,	-5028 ,	-15226,	-29442,	-19828,	28453 ,	-30107,	-10522,	7009  ,	19894 ,	30542 ,	5493  ,	-25188,	19627 ,	
	25023 ,	-22511,	4309  ,	25939 ,	-25975,	23316 ,	-16073,	18994 ,	5457  ,	-11188,	-16383,	-17534,	24847 ,	-12420,	1030  ,	11182 ,	
	28818 ,	10970 ,	-9683 ,	-19498,	13050 ,	-15473,	9713  ,	-10162,	31805 ,	8762  ,	29154 ,	7455  ,	15779 ,	-2195 ,	20515 ,	27268 ,	
	3658  ,	-6098 ,	2794  ,	16749 ,	931   ,	-21896,	-23292,	-16384,	-9742 ,	29111 ,	-21938,	30227 ,	27858 ,	-21681,	20540 ,	-30284,	
	32687 ,	-29930,	-6570 ,	-21599,	-10678,	26582 ,	5814  ,	-9264 ,	7481  ,	26572 ,	30347 ,	-536  ,	8804  ,	-725  ,	-6503 ,	-16954,	
	23944 ,	-19815,	17335 ,	-15367,	-14152,	18353 ,	26448 ,	14918 ,	-30504,	7552  ,	-2078 ,	8229  ,	-6624 ,	29448 ,	-30334,	-4286 ,	
	-27489,	29120 ,	-29098,	-28674,	19637 ,	2577  ,	-26855,	-25109,	-19561,	-24613,	25499 ,	-941  ,	5071  ,	-30994,	-15553,	-17743,	
	26042 ,	-12398,	17787 ,	-14026,	-22519,	25343 ,	14939 ,	-698  ,	2112  ,	-4123 ,	-32002,	26105 ,	-9415 ,	-22810,	-19945,	28827 ,	
	-6750 ,	-14569,	-914  ,	-8917 ,	29819 ,	-1406 ,	-1700 ,	-32032,	-14951,	679   ,	-19629,	25759 ,	-16346,	-19210,	-30636,	5510  ,	
	-737  ,	-14505,	-9610 ,	28005 ,	8148  ,	-4957 ,	4198  ,	3391  ,	32364 ,	16680 ,	26081 ,	13262 ,	6750  ,	-30935,	-29636,	25084 ,	
	26873 ,	-19621,	6876  ,	20331 ,	27612 ,	18793 ,	20415 ,	-20755,	-26241,	-30608,	8177  ,	17164 ,	5544  ,	26500 ,	6168  ,	-15740,	
	14839 ,	25130 ,	3305  ,	3268  ,	28251 ,	-27428,	-25681,	11890 ,	20890 ,	10632 ,	-1333 ,	13796 ,	-20018,	5137  ,	6703  ,	22439 ,	
	-11038,	-24884,	-27678,	-7429 ,	4377  ,	-14588,	27776 ,	1620  ,	-19065,	26999 ,	-23625,	-7205 ,	-15722,	16087 ,	5323  ,	30187 ,	
	-3454 ,	-22454,	-22766,	17301 ,	-28195,	19434 ,	-12680,	-6883 ,	10253 ,	325   ,	23549 ,	-10117,	28617 ,	3550  ,	-25038,	-23077,	
	-24673,	-20053,	20928 ,	21532 ,	625   ,	917   ,	-7711 ,	-21164,	-8205 ,	7675  ,	30948 ,	-11445,	-19153,	-25809,	-8019 ,	9212  ,	
	-17151,	25079 ,	13107 ,	28184 ,	-14181,	16909 ,	23297 ,	-2686 ,	-6142 ,	-8032 ,	25525 ,	-14381,	25231 ,	29905 ,	6788  ,	-7976 ,	
	32623 ,	-11210,	32436 ,	-24817,	-25052,	20315 ,	545   ,	2094  ,	7938  ,	24124 ,	-26183,	-8804 ,	7090  ,	7372  ,	7679  ,	-32522,	
	-4173 ,	6001  ,	31627 ,	-22389,	4308  ,	-6266 ,	13192 ,	25568 ,	14267 ,	8152  ,	-21451,	-4051 ,	22625 ,	2345  ,	-11930,	23774 ,	
	27283 ,	11952 ,	1280  ,	-32749,	626   ,	14998 ,	-8320 ,	15137 ,	-18188,	8826  ,	-16268,	-28914,	25698 ,	9199  ,	12032 ,	-32487,	
	-24360,	4345  ,	2651  ,	20272 ,	-22328,	27796 ,	-30129,	29815 ,	-649  ,	22317 ,	-28739,	32200 ,	24445 ,	-13530,	17686 ,	-20946,	
	5962  ,	-22186,	3811  ,	-3224 ,	-29284,	5511  ,	-13250,	-21907,	13322 ,	-23818,	-6313 ,	-19486,	-17028,	20694 ,	-18960,	22693 ,	
	-22864,	22222 ,	10721 ,	-442  ,	3767  ,	-16009,	-11883,	-21624,	24438 ,	-8481 ,	-22389,	23780 ,	17957 ,	31496 ,	14294 ,	-22265,	
	31699 ,	27753 ,	1693  ,	-19121,	24033 ,	28780 ,	23196 ,	-1454 ,	-10622,	-10257,	18593 ,	22615 ,	-27326,	964   ,	-27376,	31706 ,	
	-26756,	12592 ,	25695 ,	4621  ,	225   ,	-27025,	15259 ,	19794 ,	17400 ,	-12498,	20705 ,	-17982,	-25959,	-26352,	11237 ,	25001 ,	
	-12687,	-8150 ,	5743  ,	-15865,	20865 ,	-25721,	23769 ,	-28912,	-22882,	31141 ,	24210 ,	-14163,	6643  ,	23798 ,	-4449 ,	-24839,	
	18811 ,	-22432,	-31724,	-22843,	-633  ,	-9283 ,	-17761,	-8683 ,	-11970,	-32677,	-23810,	-32608,	11031 ,	25981 ,	25476 ,	11348 ,	
	1377  ,	-21288,	-22376,	21968 ,	1724  ,	10008 ,	-6859 ,	3304  ,	-5474 ,	-32680,	-7317 ,	4388  ,	-17969,	15533 ,	-23331,	13889 ,	
	-11539,	-31588,	-27839,	-26449,	-15640,	-15968,	-32541,	-24047,	-4729 ,	-30043,	-1758 ,	24000 ,	-31263,	24719 ,	-7951 ,	7497  ,	
	-10523,	-17740,	26456 ,	-4886 ,	23507 ,	-7331 ,	-14863,	-10215,	-22336,	-23479,	20843 ,	32253 ,	8982  ,	-15574,	23050 ,	-2574 ,	
	//Osc 4	Level 3
	2578  ,	20006 ,	-9180 ,	-31734,	20292 ,	-18344,	166   ,	-25209,	16147 ,	17996 ,	-4723 ,	15714 ,	31030 ,	19079 ,	-6546 ,	-30521,	
	14652 ,	-19972,	-17169,	17302 ,	28421 ,	-8040 ,	4427  ,	5347  ,	-22714,	-8777 ,	-7470 ,	7031  ,	-15351,	20652 ,	-3994 ,	-11699,	
	1322  ,	19774 ,	26879 ,	17686 ,	24796 ,	28709 ,	-5080 ,	-27466,	11298 ,	-13423,	23168 ,	-13372,	4950  ,	9123  ,	30266 ,	-31986,	
	25254 ,	31474 ,	-11362,	22034 ,	-24942,	28424 ,	-26235,	-22650,	27759 ,	-6942 ,	-28192,	-18990,	-13593,	-31372,	2610  ,	32657 ,	
	-25994,	-30174,	1042  ,	30739 ,	-2577 ,	22856 ,	13738 ,	-29730,	-9483 ,	29363 ,	23098 ,	29992 ,	-23934,	11301 ,	-11626,	24670 ,	
	18787 ,	15829 ,	5539  ,	-8032 ,	2234  ,	7917  ,	28894 ,	13379 ,	-16773,	-19957,	-26410,	22862 ,	-23056,	-15936,	-30291,	29182 ,	
	-8139 ,	-13036,	-18533,	-1726 ,	19645 ,	-23552,	-28821,	18239 ,	12747 ,	-11278,	18171 ,	26061 ,	-19207,	-7092 ,	-576  ,	-19208,	
	9140  ,	-7450 ,	11584 ,	-8320 ,	-29762,	16519 ,	27031 ,	8025  ,	9131  ,	-656  ,	-3597 ,	21036 ,	-31900,	-23086,	-28393,	-8748 ,	
	11432 ,	-25005,	19932 ,	25826 ,	-7290 ,	-16243,	-5205 ,	-13542,	-10524,	-14450,	15108 ,	-30221,	6395  ,	3161  ,	-17926,	-10981,	
	26584 ,	4707  ,	-31563,	-28944,	17885 ,	-7145 ,	5614  ,	3336  ,	25150 ,	16211 ,	-10377,	-21333,	20868 ,	-28183,	-32079,	-18604,	
	5645  ,	-14817,	20755 ,	-26829,	-1910 ,	24367 ,	-854  ,	23469 ,	-20352,	-6712 ,	4244  ,	-29221,	23752 ,	-23414,	-30333,	21767 ,	
	-13297,	13454 ,	-14784,	27442 ,	5463  ,	-9764 ,	18469 ,	24977 ,	-32652,	-20493,	17314 ,	13579 ,	16015 ,	-22971,	-32582,	12988 ,	
	-3418 ,	19640 ,	-29821,	-21387,	2570  ,	28711 ,	-19287,	-710  ,	-6944 ,	-31010,	-7701 ,	-8765 ,	-12639,	27937 ,	-20836,	2300  ,	
	18074 ,	-3674 ,	23587 ,	12421 ,	6252  ,	12822 ,	4732  ,	16690 ,	-15219,	18321 ,	28853 ,	-2164 ,	-18235,	-15577,	-4750 ,	-15282,	
	22706 ,	31327 ,	-30871,	233   ,	22085 ,	9140  ,	-14874,	29697 ,	-9661 ,	-15598,	2377  ,	9709  ,	31941 ,	26206 ,	-21629,	1339  ,	
	-29257,	-19989,	-3939 ,	-9431 ,	11613 ,	-17146,	18225 ,	-28627,	-19255,	15979 ,	-10001,	-16273,	28263 ,	2254  ,	27417 ,	8266  ,	
	//Osc 4	Level 4
	-24974,	-10413,	-28921,	12494 ,	-9349 ,	27158 ,	8867  ,	17472 ,	-18711,	29348 ,	-24338,	21144 ,	13684 ,	20607 ,	17018 ,	-25085,	
	6056  ,	-25186,	28142 ,	10079 ,	29289 ,	-29973,	-1914 ,	29378 ,	5993  ,	-29501,	-18800,	7155  ,	19891 ,	-10374,	23535 ,	15086 ,	
	23076 ,	-21548,	11420 ,	-26524,	-10259,	-3187 ,	-736  ,	12857 ,	-7918 ,	11730 ,	-31973,	-28667,	-30994,	11206 ,	-2624 ,	-6252 ,	
	6829  ,	7422  ,	32343 ,	4454  ,	-14896,	-5115 ,	30906 ,	-13009,	29356 ,	-5416 ,	984   ,	22104 ,	1259  ,	20331 ,	25141 ,	-14212,	
	25098 ,	35    ,	-21912,	-11284,	18905 ,	12378 ,	18331 ,	-15829,	32511 ,	19678 ,	18959 ,	19059 ,	-16525,	14450 ,	1942  ,	13870 ,	
	3332  ,	22603 ,	-29673,	-10882,	17874 ,	28820 ,	-9715 ,	-15434,	-29486,	-12053,	31496 ,	31710 ,	-32178,	20706 ,	-8150 ,	-17101,	
	19555 ,	7294  ,	-27989,	16292 ,	-4223 ,	-12100,	-19370,	-18345,	-2321 ,	-6137 ,	20490 ,	-20958,	-4796 ,	-2365 ,	31290 ,	-25070,	
	9455  ,	-18491,	-16018,	-4121 ,	-12112,	-5928 ,	-4417 ,	14998 ,	27676 ,	30522 ,	5726  ,	-10042,	29725 ,	-995  ,	30734 ,	19795 ,	
	//Osc 4	Level 5
	28527 ,	2343  ,	-20570,	-2098 ,	18213 ,	17651 ,	-19056,	6395  ,	-4318 ,	22413 ,	12109 ,	-22702,	-8544 ,	9977  ,	-28690,	-3201 ,	
	22701 ,	25517 ,	2204  ,	-25374,	1193  ,	-6894 ,	-14063,	22031 ,	22217 ,	-10745,	4125  ,	31054 ,	18583 ,	-20130,	3106  ,	27933 ,	
	-7825 ,	3678  ,	2968  ,	22697 ,	3843  ,	15679 ,	-630  ,	-22439,	19928 ,	13233 ,	-15850,	-7613 ,	8648  ,	-13995,	-13583,	19125 ,	
	-8578 ,	17474 ,	3041  ,	22701 ,	16381 ,	13697 ,	-17598,	31329 ,	-11495,	-23151,	-7550 ,	-22087,	-20997,	4325  ,	16037 ,	-12081,	
	//Osc 4	Level 6
	30882 ,	-19359,	28865 ,	32374 ,	-15011,	-22047,	-382  ,	27312 ,	14674 ,	21682 ,	-23897,	-13514,	-31494,	7702  ,	-4732 ,	30708 ,	
	11426 ,	-32316,	-19074,	-8310 ,	8428  ,	-5531 ,	-10350,	-13363,	-22708,	-8679 ,	18383 ,	30276 ,	4748  ,	31472 ,	-3625 ,	27819 ,	
	//Osc 4	Level 7
	-13496,	-15502,	-5791 ,	17779 ,	-22414,	-17641,	-5446 ,	9280  ,	6095  ,	-11568,	11072 ,	-29078,	5752  ,	9596  ,	31205 ,	3965  ,	
	//Osc 4	Level 8
	-1702 ,	-31629,	12210 ,	-21063,	1463  ,	21503 ,	28738 ,	11922 ,	
	//Osc 4	Level 9
	22947 ,	14302 ,	-17854,	-21711,	
	//Osc 4	Level 10
	-23417,	-28735,	
	//Osc 4	Level 11
	-23417,	-28735,	
    },
    //Osc 5	Level 0
    {
	0     ,	0     ,	-1    ,	0     ,	8     ,	28    ,	63    ,	110   ,	165   ,	223   ,	279   ,	332   ,	382   ,	432   ,	482   ,	533   ,	
	583   ,	631   ,	678   ,	725   ,	772   ,	819   ,	867   ,	913   ,	957   ,	1001  ,	1046  ,	1092  ,	1139  ,	1185  ,	1229  ,	1274  ,	
	1318  ,	1363  ,	1410  ,	1458  ,	1506  ,	1551  ,	1594  ,	1636  ,	1678  ,	1720  ,	1762  ,	1804  ,	1846  ,	1887  ,	1928  ,	1969  ,	
	2012  ,	2056  ,	2099  ,	2140  ,	2179  ,	2216  ,	2251  ,	2287  ,	2325  ,	2367  ,	2410  ,	2453  ,	2496  ,	2537  ,	2577  ,	2616  ,	
	2655  ,	2695  ,	2736  ,	2775  ,	2812  ,	2847  ,	2882  ,	2919  ,	2956  ,	2993  ,	3028  ,	3062  ,	3097  ,	3134  ,	3172  ,	3211  ,	
	3249  ,	3283  ,	3315  ,	3346  ,	3380  ,	3417  ,	3455  ,	3491  ,	3523  ,	3553  ,	3583  ,	3616  ,	3653  ,	3692  ,	3729  ,	3764  ,	
	3794  ,	3823  ,	3854  ,	3887  ,	3921  ,	3953  ,	3983  ,	4011  ,	4040  ,	4070  ,	4104  ,	4139  ,	4173  ,	4205  ,	4235  ,	4265  ,	
	4295  ,	4325  ,	4356  ,	4386  ,	4416  ,	4446  ,	4474  ,	4501  ,	4526  ,	4551  ,	4576  ,	4602  ,	4629  ,	4658  ,	4687  ,	4716  ,	
	4745  ,	4775  ,	4805  ,	4835  ,	4866  ,	4895  ,	4923  ,	4950  ,	4975  ,	5001  ,	5027  ,	5053  ,	5080  ,	5107  ,	5135  ,	5161  ,	
	5186  ,	5210  ,	5232  ,	5255  ,	5280  ,	5306  ,	5333  ,	5359  ,	5384  ,	5407  ,	5430  ,	5452  ,	5475  ,	5500  ,	5526  ,	5551  ,	
	5575  ,	5598  ,	5622  ,	5645  ,	5668  ,	5690  ,	5711  ,	5731  ,	5751  ,	5772  ,	5794  ,	5819  ,	5844  ,	5869  ,	5892  ,	5915  ,	
	5937  ,	5957  ,	5978  ,	6000  ,	6022  ,	6046  ,	6069  ,	6092  ,	6114  ,	6132  ,	6150  ,	6167  ,	6187  ,	6208  ,	6230  ,	6252  ,	
	6273  ,	6292  ,	6310  ,	6329  ,	6350  ,	6370  ,	6389  ,	6406  ,	6423  ,	6442  ,	6462  ,	6481  ,	6500  ,	6517  ,	6535  ,	6553  ,	
	6573  ,	6594  ,	6614  ,	6632  ,	6647  ,	6663  ,	6680  ,	6700  ,	6720  ,	6738  ,	6752  ,	6763  ,	6775  ,	6790  ,	6808  ,	6828  ,	
	6846  ,	6863  ,	6880  ,	6897  ,	6915  ,	6935  ,	6955  ,	6973  ,	6988  ,	7001  ,	7014  ,	7030  ,	7048  ,	7066  ,	7081  ,	7095  ,	
	7108  ,	7122  ,	7137  ,	7153  ,	7171  ,	7187  ,	7203  ,	7217  ,	7231  ,	7245  ,	7258  ,	7271  ,	7284  ,	7299  ,	7316  ,	7333  ,	
	7348  ,	7360  ,	7371  ,	7382  ,	7395  ,	7411  ,	7428  ,	7445  ,	7459  ,	7472  ,	7483  ,	7496  ,	7510  ,	7525  ,	7539  ,	7550  ,	
	7558  ,	7567  ,	7578  ,	7592  ,	7608  ,	7625  ,	7640  ,	7653  ,	7665  ,	7677  ,	7690  ,	7703  ,	7714  ,	7723  ,	7732  ,	7742  ,	
	7756  ,	7770  ,	7784  ,	7797  ,	7808  ,	7819  ,	7830  ,	7842  ,	7854  ,	7865  ,	7874  ,	7883  ,	7892  ,	7902  ,	7915  ,	7927  ,	
	7937  ,	7946  ,	7953  ,	7961  ,	7970  ,	7980  ,	7991  ,	8002  ,	8013  ,	8023  ,	8033  ,	8045  ,	8058  ,	8070  ,	8081  ,	8091  ,	
	8100  ,	8110  ,	8121  ,	8133  ,	8144  ,	8154  ,	8162  ,	8169  ,	8176  ,	8184  ,	8192  ,	8202  ,	8213  ,	8223  ,	8233  ,	8242  ,	
	8249  ,	8256  ,	8265  ,	8276  ,	8288  ,	8299  ,	8308  ,	8313  ,	8317  ,	8321  ,	8328  ,	8339  ,	8352  ,	8364  ,	8373  ,	8378  ,	
	8383  ,	8389  ,	8397  ,	8407  ,	8417  ,	8426  ,	8433  ,	8439  ,	8445  ,	8452  ,	8459  ,	8467  ,	8475  ,	8483  ,	8491  ,	8497  ,	
	8503  ,	8509  ,	8517  ,	8526  ,	8536  ,	8546  ,	8555  ,	8563  ,	8568  ,	8571  ,	8575  ,	8579  ,	8586  ,	8594  ,	8603  ,	8609  ,	
	8615  ,	8619  ,	8624  ,	8630  ,	8636  ,	8644  ,	8653  ,	8661  ,	8668  ,	8673  ,	8678  ,	8682  ,	8688  ,	8695  ,	8703  ,	8712  ,	
	8721  ,	8727  ,	8730  ,	8732  ,	8737  ,	8744  ,	8752  ,	8760  ,	8767  ,	8772  ,	8775  ,	8779  ,	8784  ,	8791  ,	8799  ,	8805  ,	
	8809  ,	8812  ,	8815  ,	8820  ,	8827  ,	8835  ,	8841  ,	8844  ,	8844  ,	8845  ,	8849  ,	8857  ,	8867  ,	8876  ,	8883  ,	8886  ,	
	8889  ,	8891  ,	8895  ,	8899  ,	8904  ,	8908  ,	8912  ,	8916  ,	8921  ,	8928  ,	8934  ,	8940  ,	8945  ,	8949  ,	8953  ,	8957  ,	
	8962  ,	8967  ,	8972  ,	8977  ,	8983  ,	8990  ,	8998  ,	9004  ,	9007  ,	9008  ,	9007  ,	9008  ,	9011  ,	9016  ,	9023  ,	9030  ,	
	9034  ,	9037  ,	9039  ,	9041  ,	9045  ,	9050  ,	9056  ,	9063  ,	9069  ,	9073  ,	9074  ,	9073  ,	9072  ,	9071  ,	9073  ,	9078  ,	
	9083  ,	9087  ,	9090  ,	9092  ,	9094  ,	9098  ,	9104  ,	9111  ,	9116  ,	9119  ,	9119  ,	9118  ,	9119  ,	9123  ,	9129  ,	9136  ,	
	9140  ,	9143  ,	9144  ,	9145  ,	9146  ,	9147  ,	9149  ,	9151  ,	9154  ,	9159  ,	9165  ,	9170  ,	9175  ,	9176  ,	9176  ,	9175  ,	
	9177  ,	9180  ,	9184  ,	9187  ,	9188  ,	9187  ,	9185  ,	9187  ,	9191  ,	9197  ,	9203  ,	9207  ,	9210  ,	9211  ,	9213  ,	9215  ,	
	9218  ,	9220  ,	9221  ,	9223  ,	9225  ,	9229  ,	9233  ,	9237  ,	9239  ,	9240  ,	9242  ,	9245  ,	9249  ,	9254  ,	9258  ,	9259  ,	
	9258  ,	9257  ,	9256  ,	9258  ,	9260  ,	9262  ,	9263  ,	9264  ,	9264  ,	9266  ,	9268  ,	9273  ,	9278  ,	9283  ,	9287  ,	9289  ,	
	9290  ,	9291  ,	9291  ,	9290  ,	9291  ,	9293  ,	9296  ,	9298  ,	9298  ,	9296  ,	9292  ,	9291  ,	9294  ,	9302  ,	9311  ,	9318  ,	
	9320  ,	9316  ,	9310  ,	9305  ,	9305  ,	9309  ,	9315  ,	9320  ,	9321  ,	9319  ,	9317  ,	9316  ,	9317  ,	9320  ,	9323  ,	9325  ,	
	9326  ,	9326  ,	9326  ,	9327  ,	9328  ,	9329  ,	9329  ,	9328  ,	9328  ,	9328  ,	9329  ,	9332  ,	9336  ,	9341  ,	9343  ,	9342  ,	
	9339  ,	9337  ,	9337  ,	9339  ,	9342  ,	9345  ,	9346  ,	9347  ,	9348  ,	9350  ,	9352  ,	9353  ,	9352  ,	9349  ,	9346  ,	9345  ,	
	9347  ,	9353  ,	9359  ,	9364  ,	9365  ,	9363  ,	9359  ,	9356  ,	9353  ,	9352  ,	9353  ,	9355  ,	9356  ,	9358  ,	9358  ,	9358  ,	
	9358  ,	9357  ,	9357  ,	9359  ,	9361  ,	9363  ,	9365  ,	9366  ,	9365  ,	9364  ,	9363  ,	9364  ,	9365  ,	9367  ,	9369  ,	9371  ,	
	9372  ,	9371  ,	9369  ,	9367  ,	9366  ,	9367  ,	9368  ,	9369  ,	9368  ,	9366  ,	9364  ,	9364  ,	9365  ,	9367  ,	9368  ,	9366  ,	
	9364  ,	9362  ,	9362  ,	9365  ,	9368  ,	9370  ,	9369  ,	9366  ,	9362  ,	9360  ,	9360  ,	9362  ,	9364  ,	9364  ,	9362  ,	9360  ,	
	9359  ,	9362  ,	9367  ,	9373  ,	9377  ,	9378  ,	9375  ,	9371  ,	9367  ,	9365  ,	9366  ,	9368  ,	9369  ,	9369  ,	9368  ,	9365  ,	
	9362  ,	9360  ,	9359  ,	9361  ,	9366  ,	9371  ,	9374  ,	9375  ,	9371  ,	9366  ,	9361  ,	9359  ,	9361  ,	9365  ,	9367  ,	9367  ,	
	9364  ,	9361  ,	9359  ,	9359  ,	9359  ,	9359  ,	9357  ,	9354  ,	9353  ,	9355  ,	9358  ,	9360  ,	9361  ,	9358  ,	9355  ,	9353  ,	
	9353  ,	9355  ,	9356  ,	9353  ,	9350  ,	9348  ,	9347  ,	9349  ,	9350  ,	9351  ,	9350  ,	9348  ,	9346  ,	9348  ,	9351  ,	9352  ,	
	9349  ,	9343  ,	9336  ,	9332  ,	9333  ,	9337  ,	9341  ,	9343  ,	9341  ,	9338  ,	9337  ,	9339  ,	9341  ,	9343  ,	9343  ,	9341  ,	
	9339  ,	9338  ,	9338  ,	9340  ,	9340  ,	9340  ,	9339  ,	9338  ,	9338  ,	9339  ,	9339  ,	9335  ,	9330  ,	9325  ,	9323  ,	9323  ,	
	9325  ,	9328  ,	9330  ,	9331  ,	9330  ,	9327  ,	9324  ,	9320  ,	9315  ,	9310  ,	9307  ,	9307  ,	9311  ,	9317  ,	9321  ,	9322  ,	
	9318  ,	9312  ,	9307  ,	9304  ,	9304  ,	9307  ,	9310  ,	9311  ,	9310  ,	9307  ,	9304  ,	9301  ,	9301  ,	9301  ,	9302  ,	9303  ,	
	9302  ,	9299  ,	9296  ,	9293  ,	9292  ,	9293  ,	9294  ,	9294  ,	9291  ,	9286  ,	9283  ,	9281  ,	9282  ,	9284  ,	9285  ,	9285  ,	
	9283  ,	9280  ,	9278  ,	9276  ,	9276  ,	9274  ,	9272  ,	9268  ,	9266  ,	9264  ,	9264  ,	9263  ,	9263  ,	9262  ,	9261  ,	9263  ,	
	9264  ,	9266  ,	9265  ,	9261  ,	9258  ,	9255  ,	9255  ,	9257  ,	9259  ,	9259  ,	9257  ,	9252  ,	9249  ,	9247  ,	9248  ,	9250  ,	
	9251  ,	9249  ,	9245  ,	9240  ,	9238  ,	9238  ,	9239  ,	9241  ,	9242  ,	9241  ,	9240  ,	9239  ,	9238  ,	9236  ,	9235  ,	9232  ,	
	9230  ,	9227  ,	9226  ,	9225  ,	9224  ,	9222  ,	9222  ,	9221  ,	9221  ,	9221  ,	9221  ,	9218  ,	9216  ,	9212  ,	9209  ,	9205  ,	
	9203  ,	9202  ,	9203  ,	9206  ,	9207  ,	9208  ,	9206  ,	9201  ,	9195  ,	9190  ,	9188  ,	9191  ,	9193  ,	9195  ,	9193  ,	9188  ,	
	9183  ,	9179  ,	9179  ,	9183  ,	9185  ,	9185  ,	9181  ,	9175  ,	9170  ,	9167  ,	9168  ,	9172  ,	9175  ,	9176  ,	9175  ,	9172  ,	
	9171  ,	9170  ,	9168  ,	9167  ,	9165  ,	9163  ,	9161  ,	9160  ,	9159  ,	9158  ,	9155  ,	9151  ,	9145  ,	9142  ,	9142  ,	9143  ,	
	9143  ,	9142  ,	9138  ,	9134  ,	9130  ,	9130  ,	9132  ,	9134  ,	9134  ,	9132  ,	9128  ,	9125  ,	9124  ,	9125  ,	9126  ,	9124  ,	
	9119  ,	9113  ,	9108  ,	9106  ,	9108  ,	9110  ,	9113  ,	9112  ,	9109  ,	9106  ,	9104  ,	9104  ,	9104  ,	9104  ,	9101  ,	9099  ,	
	9096  ,	9095  ,	9094  ,	9094  ,	9092  ,	9090  ,	9086  ,	9083  ,	9080  ,	9079  ,	9077  ,	9077  ,	9079  ,	9081  ,	9083  ,	9082  ,	
	9079  ,	9074  ,	9068  ,	9065  ,	9066  ,	9069  ,	9073  ,	9074  ,	9071  ,	9066  ,	9062  ,	9061  ,	9062  ,	9062  ,	9060  ,	9057  ,	
	9052  ,	9049  ,	9049  ,	9049  ,	9049  ,	9047  ,	9042  ,	9037  ,	9034  ,	9033  ,	9034  ,	9033  ,	9030  ,	9026  ,	9021  ,	9019  ,	
	9020  ,	9022  ,	9024  ,	9023  ,	9021  ,	9020  ,	9020  ,	9020  ,	9019  ,	9017  ,	9013  ,	9009  ,	9005  ,	9005  ,	9006  ,	9007  ,	
	9005  ,	9002  ,	8998  ,	8996  ,	8997  ,	8998  ,	8999  ,	8998  ,	8995  ,	8992  ,	8988  ,	8987  ,	8987  ,	8986  ,	8984  ,	8980  ,	
	8974  ,	8969  ,	8966  ,	8967  ,	8969  ,	8970  ,	8968  ,	8964  ,	8958  ,	8954  ,	8953  ,	8954  ,	8957  ,	8959  ,	8959  ,	8958  ,	
	8954  ,	8949  ,	8944  ,	8940  ,	8938  ,	8938  ,	8937  ,	8936  ,	8934  ,	8933  ,	8931  ,	8931  ,	8930  ,	8930  ,	8929  ,	8927  ,	
	8924  ,	8920  ,	8916  ,	8913  ,	8911  ,	8910  ,	8911  ,	8911  ,	8911  ,	8911  ,	8909  ,	8908  ,	8905  ,	8902  ,	8898  ,	8896  ,	
	8894  ,	8894  ,	8895  ,	8895  ,	8894  ,	8892  ,	8889  ,	8886  ,	8883  ,	8881  ,	8879  ,	8878  ,	8877  ,	8876  ,	8874  ,	8874  ,	
	8875  ,	8877  ,	8877  ,	8876  ,	8871  ,	8864  ,	8856  ,	8851  ,	8847  ,	8847  ,	8848  ,	8850  ,	8851  ,	8850  ,	8847  ,	8844  ,	
	8841  ,	8839  ,	8838  ,	8837  ,	8835  ,	8833  ,	8830  ,	8828  ,	8827  ,	8827  ,	8825  ,	8823  ,	8820  ,	8818  ,	8817  ,	8816  ,	
	8814  ,	8811  ,	8806  ,	8800  ,	8796  ,	8795  ,	8797  ,	8798  ,	8797  ,	8793  ,	8789  ,	8785  ,	8785  ,	8786  ,	8789  ,	8790  ,	
	8789  ,	8785  ,	8782  ,	8780  ,	8781  ,	8782  ,	8781  ,	8778  ,	8774  ,	8769  ,	8766  ,	8766  ,	8767  ,	8766  ,	8764  ,	8760  ,	
	8755  ,	8751  ,	8749  ,	8749  ,	8749  ,	8749  ,	8747  ,	8745  ,	8743  ,	8741  ,	8739  ,	8738  ,	8736  ,	8734  ,	8732  ,	8730  ,	
	8728  ,	8727  ,	8725  ,	8724  ,	8723  ,	8722  ,	8721  ,	8719  ,	8717  ,	8715  ,	8715  ,	8716  ,	8717  ,	8715  ,	8711  ,	8705  ,	
	8699  ,	8696  ,	8697  ,	8700  ,	8702  ,	8701  ,	8698  ,	8692  ,	8688  ,	8684  ,	8683  ,	8683  ,	8682  ,	8679  ,	8675  ,	8672  ,	
	8670  ,	8670  ,	8669  ,	8667  ,	8665  ,	8662  ,	8660  ,	8659  ,	8660  ,	8660  ,	8659  ,	8657  ,	8654  ,	8650  ,	8648  ,	8646  ,	
	8643  ,	8639  ,	8636  ,	8633  ,	8631  ,	8630  ,	8631  ,	8631  ,	8630  ,	8629  ,	8627  ,	8625  ,	8622  ,	8619  ,	8617  ,	8616  ,	
	8615  ,	8615  ,	8614  ,	8613  ,	8610  ,	8605  ,	8602  ,	8599  ,	8598  ,	8598  ,	8597  ,	8597  ,	8596  ,	8595  ,	8593  ,	8591  ,	
	8589  ,	8585  ,	8582  ,	8579  ,	8579  ,	8579  ,	8579  ,	8577  ,	8573  ,	8570  ,	8567  ,	8567  ,	8568  ,	8569  ,	8568  ,	8564  ,	
	8558  ,	8553  ,	8551  ,	8552  ,	8553  ,	8553  ,	8551  ,	8546  ,	8543  ,	8542  ,	8543  ,	8544  ,	8543  ,	8538  ,	8532  ,	8525  ,	
	8522  ,	8521  ,	8523  ,	8526  ,	8528  ,	8528  ,	8527  ,	8524  ,	8519  ,	8514  ,	8509  ,	8506  ,	8504  ,	8504  ,	8504  ,	8503  ,	
	8499  ,	8494  ,	8491  ,	8490  ,	8491  ,	8494  ,	8496  ,	8495  ,	8491  ,	8486  ,	8482  ,	8480  ,	8478  ,	8476  ,	8472  ,	8469  ,	
	8465  ,	8463  ,	8463  ,	8463  ,	8463  ,	8462  ,	8460  ,	8457  ,	8456  ,	8456  ,	8457  ,	8457  ,	8456  ,	8455  ,	8453  ,	8450  ,	
	8448  ,	8445  ,	8443  ,	8440  ,	8438  ,	8436  ,	8434  ,	8434  ,	8433  ,	8433  ,	8431  ,	8428  ,	8424  ,	8420  ,	8416  ,	8415  ,	
	8415  ,	8415  ,	8414  ,	8409  ,	8403  ,	8398  ,	8396  ,	8397  ,	8401  ,	8403  ,	8403  ,	8398  ,	8391  ,	8384  ,	8381  ,	8381  ,	
	8383  ,	8384  ,	8383  ,	8380  ,	8376  ,	8374  ,	8372  ,	8371  ,	8368  ,	8365  ,	8360  ,	8357  ,	8357  ,	8360  ,	8362  ,	8363  ,	
	8360  ,	8355  ,	8351  ,	8349  ,	8348  ,	8348  ,	8347  ,	8343  ,	8339  ,	8335  ,	8333  ,	8334  ,	8335  ,	8336  ,	8335  ,	8332  ,	
	8329  ,	8326  ,	8323  ,	8320  ,	8318  ,	8316  ,	8315  ,	8316  ,	8317  ,	8317  ,	8316  ,	8312  ,	8307  ,	8303  ,	8301  ,	8301  ,	
	8302  ,	8302  ,	8299  ,	8295  ,	8289  ,	8285  ,	8283  ,	8282  ,	8281  ,	8280  ,	8278  ,	8276  ,	8275  ,	8275  ,	8274  ,	8273  ,	
	8270  ,	8267  ,	8263  ,	8260  ,	8258  ,	8257  ,	8257  ,	8258  ,	8259  ,	8259  ,	8258  ,	8256  ,	8254  ,	8252  ,	8251  ,	8247  ,	
	8242  ,	8237  ,	8233  ,	8233  ,	8234  ,	8234  ,	8230  ,	8224  ,	8217  ,	8215  ,	8217  ,	8222  ,	8224  ,	8220  ,	8211  ,	8203  ,	
	8199  ,	8202  ,	8208  ,	8210  ,	8205  ,	8196  ,	8191  ,	8194  ,	8202  ,	8206  ,	8201  ,	8189  ,	8178  ,	8177  ,	8185  ,	8196  ,	
	8198  ,	8186  ,	8169  ,	8161  ,	8167  ,	8183  ,	8191  ,	8182  ,	8159  ,	8141  ,	8144  ,	8168  ,	8192  ,	8193  ,	8166  ,	8130  ,	
	8117  ,	8140  ,	8183  ,	8207  ,	8184  ,	8124  ,	8073  ,	8078  ,	8142  ,	8216  ,	8233  ,	8167  ,	8060  ,	8000  ,	8047  ,	8175  ,	
	8283  ,	8266  ,	8112  ,	7930  ,	7875  ,	8023  ,	8281  ,	8434  ,	8308  ,	7939  ,	7602  ,	7637  ,	8148  ,	8766  ,	8679  ,	6940  ,	
	2949  ,	-3188 ,	-10616,	-18049,	-24282,	-28637,	-31106,	-32189,	-32538,	-32647,	-32726,	-32768,	-32735,	-32609,	-32472,	-32408,	
	-32442,	-32526,	-32585,	-32576,	-32516,	-32457,	-32440,	-32464,	-32495,	-32498,	-32469,	-32429,	-32407,	-32412,	-32430,	-32438,	
	-32426,	-32401,	-32381,	-32378,	-32387,	-32396,	-32393,	-32378,	-32360,	-32351,	-32350,	-32352,	-32347,	-32335,	-32320,	-32311,	
	-32310,	-32312,	-32310,	-32299,	-32281,	-32264,	-32255,	-32252,	-32252,	-32249,	-32241,	-32230,	-32221,	-32215,	-32210,	-32202,	
	-32191,	-32179,	-32171,	-32169,	-32171,	-32174,	-32171,	-32161,	-32146,	-32131,	-32121,	-32116,	-32113,	-32109,	-32100,	-32085,	
	-32068,	-32052,	-32042,	-32038,	-32038,	-32040,	-32041,	-32039,	-32033,	-32025,	-32017,	-32009,	-32001,	-31991,	-31979,	-31966,	
	-31955,	-31946,	-31939,	-31931,	-31923,	-31915,	-31908,	-31901,	-31895,	-31890,	-31885,	-31881,	-31878,	-31876,	-31873,	-31867,	
	-31857,	-31844,	-31830,	-31821,	-31817,	-31815,	-31812,	-31805,	-31793,	-31780,	-31769,	-31763,	-31763,	-31764,	-31763,	-31758,	
	-31751,	-31743,	-31734,	-31724,	-31713,	-31700,	-31690,	-31683,	-31680,	-31679,	-31674,	-31665,	-31652,	-31639,	-31632,	-31631,	
	-31629,	-31621,	-31603,	-31582,	-31565,	-31560,	-31568,	-31581,	-31589,	-31584,	-31569,	-31551,	-31540,	-31537,	-31538,	-31534,	
	-31521,	-31501,	-31483,	-31474,	-31473,	-31478,	-31480,	-31475,	-31462,	-31448,	-31436,	-31429,	-31425,	-31420,	-31413,	-31404,	
	-31396,	-31391,	-31386,	-31379,	-31367,	-31352,	-31339,	-31331,	-31329,	-31329,	-31327,	-31319,	-31306,	-31292,	-31279,	-31272,	
	-31269,	-31266,	-31261,	-31252,	-31242,	-31235,	-31231,	-31230,	-31229,	-31215,	-31174,	-31096,	-30974,	-30812,	-30620,	-30415,	
	-30211,	-30016,	-29831,	-29651,	-29469,	-29283,	-29091,	-28897,	-28703,	-28513,	-28325,	-28140,	-27957,	-27776,	-27598,	-27421,	
	-27242,	-27061,	-26879,	-26700,	-26524,	-26352,	-26180,	-26007,	-25831,	-25655,	-25480,	-25307,	-25136,	-24966,	-24796,	-24627,	
	-24460,	-24296,	-24131,	-23965,	-23796,	-23627,	-23460,	-23299,	-23143,	-22991,	-22838,	-22681,	-22520,	-22357,	-22194,	-22035,	
	-21880,	-21728,	-21578,	-21426,	-21272,	-21116,	-20961,	-20809,	-20661,	-20514,	-20365,	-20215,	-20066,	-19920,	-19777,	-19637,	
	-19495,	-19350,	-19201,	-19054,	-18910,	-18769,	-18628,	-18486,	-18345,	-18209,	-18077,	-17947,	-17815,	-17678,	-17538,	-17401,	
	-17269,	-17141,	-17012,	-16879,	-16743,	-16610,	-16482,	-16359,	-16235,	-16108,	-15977,	-15849,	-15726,	-15606,	-15482,	-15352,	
	-15220,	-15096,	-14983,	-14876,	-14764,	-14639,	-14501,	-14364,	-14240,	-14132,	-14029,	-13918,	-13796,	-13672,	-13556,	-13451,	
	-13347,	-13234,	-13111,	-12987,	-12873,	-12772,	-12675,	-12569,	-12450,	-12325,	-12209,	-12106,	-12009,	-11905,	-11791,	-11676,	
	-11573,	-11481,	-11392,	-11290,	-11174,	-11053,	-10943,	-10852,	-10767,	-10668,	-10552,	-10436,	-10336,	-10254,	-10175,	-10083,	
	-9971 ,	-9852 ,	-9747 ,	-9666 ,	-9593 ,	-9503 ,	-9388 ,	-9268 ,	-9170 ,	-9097 ,	-9034 ,	-8953 ,	-8843 ,	-8714 ,	-8603 ,	-8529 ,	
	-8475 ,	-8400 ,	-8291 ,	-8171 ,	-8070 ,	-8000 ,	-7947 ,	-7881 ,	-7779 ,	-7649 ,	-7533 ,	-7465 ,	-7427 ,	-7366 ,	-7259 ,	-7133 ,	
	-7025 ,	-6955 ,	-6913 ,	-6867 ,	-6778 ,	-6645 ,	-6520 ,	-6456 ,	-6433 ,	-6385 ,	-6280 ,	-6150 ,	-6038 ,	-5969 ,	-5938 ,	-5911 ,	
	-5833 ,	-5692 ,	-5554 ,	-5494 ,	-5492 ,	-5463 ,	-5365 ,	-5231 ,	-5112 ,	-5037 ,	-5013 ,	-5007 ,	-4942 ,	-4790 ,	-4633 ,	-4573 ,	
	-4595 ,	-4590 ,	-4499 ,	-4361 ,	-4234 ,	-4156 ,	-4149 ,	-4178 ,	-4136 ,	-3969 ,	-3780 ,	-3713 ,	-3760 ,	-3785 ,	-3708 ,	-3563 ,	
	-3414 ,	-3312 ,	-3309 ,	-3378 ,	-3371 ,	-3194 ,	-2968 ,	-2888 ,	-2959 ,	-3012 ,	-2946 ,	-2799 ,	-2629 ,	-2502 ,	-2506 ,	-2626 ,	
	-2661 ,	-2459 ,	-2174 ,	-2078 ,	-2193 ,	-2303 ,	-2268 ,	-2113 ,	-1899 ,	-1717 ,	-1726 ,	-1934 ,	-2049 ,	-1819 ,	-1433 ,	-1289 ,	
	-1449 ,	-1634 ,	-1647 ,	-1491 ,	-1208 ,	-925  ,	-928  ,	-1286 ,	-1552 ,	-1277 ,	-700  ,	-452  ,	-696  ,	-1046 ,	-1174 ,	-1017 ,	
	-555  ,	-3    ,	21    ,	-735  ,	-1439 ,	-1047 ,	172   ,	887   ,	417   ,	-707  ,	-1672 ,	-1684 ,	365   ,	4729  ,	8978  ,	9397  ,	
	//Osc 5	Level 1
	0     ,	-1    ,	21    ,	95    ,	206   ,	317   ,	417   ,	518   ,	617   ,	711   ,	805   ,	899   ,	988   ,	1078  ,	1171  ,	1260  ,	
	1349  ,	1443  ,	1537  ,	1623  ,	1707  ,	1791  ,	1874  ,	1956  ,	2042  ,	2127  ,	2204  ,	2275  ,	2353  ,	2439  ,	2524  ,	2603  ,	
	2682  ,	2762  ,	2835  ,	2906  ,	2981  ,	3051  ,	3121  ,	3198  ,	3272  ,	3335  ,	3404  ,	3479  ,	3543  ,	3604  ,	3678  ,	3752  ,	
	3813  ,	3875  ,	3942  ,	4001  ,	4059  ,	4126  ,	4194  ,	4254  ,	4314  ,	4375  ,	4435  ,	4491  ,	4542  ,	4592  ,	4647  ,	4705  ,	
	4764  ,	4824  ,	4884  ,	4940  ,	4991  ,	5043  ,	5097  ,	5151  ,	5201  ,	5246  ,	5296  ,	5349  ,	5398  ,	5443  ,	5490  ,	5541  ,	
	5589  ,	5636  ,	5681  ,	5723  ,	5763  ,	5809  ,	5859  ,	5906  ,	5949  ,	5991  ,	6036  ,	6083  ,	6125  ,	6160  ,	6199  ,	6243  ,	
	6284  ,	6321  ,	6362  ,	6399  ,	6434  ,	6473  ,	6510  ,	6545  ,	6585  ,	6625  ,	6656  ,	6691  ,	6731  ,	6759  ,	6783  ,	6819  ,	
	6856  ,	6889  ,	6926  ,	6965  ,	6995  ,	7023  ,	7058  ,	7089  ,	7116  ,	7146  ,	7180  ,	7211  ,	7239  ,	7265  ,	7292  ,	7325  ,	
	7355  ,	7377  ,	7403  ,	7437  ,	7466  ,	7490  ,	7518  ,	7545  ,	7563  ,	7585  ,	7617  ,	7647  ,	7671  ,	7697  ,	7719  ,	7737  ,	
	7763  ,	7791  ,	7814  ,	7836  ,	7860  ,	7879  ,	7897  ,	7921  ,	7942  ,	7957  ,	7975  ,	7997  ,	8018  ,	8039  ,	8064  ,	8086  ,	
	8105  ,	8127  ,	8149  ,	8166  ,	8180  ,	8197  ,	8218  ,	8238  ,	8253  ,	8270  ,	8294  ,	8311  ,	8319  ,	8333  ,	8358  ,	8376  ,	
	8386  ,	8402  ,	8422  ,	8436  ,	8448  ,	8463  ,	8479  ,	8494  ,	8506  ,	8521  ,	8541  ,	8559  ,	8570  ,	8577  ,	8590  ,	8606  ,	
	8617  ,	8627  ,	8640  ,	8657  ,	8671  ,	8680  ,	8691  ,	8707  ,	8724  ,	8731  ,	8740  ,	8756  ,	8770  ,	8777  ,	8787  ,	8802  ,	
	8811  ,	8817  ,	8831  ,	8843  ,	8845  ,	8852  ,	8871  ,	8885  ,	8890  ,	8897  ,	8906  ,	8914  ,	8924  ,	8937  ,	8947  ,	8955  ,	
	8964  ,	8974  ,	8986  ,	9001  ,	9008  ,	9008  ,	9013  ,	9026  ,	9036  ,	9040  ,	9047  ,	9059  ,	9071  ,	9074  ,	9072  ,	9075  ,	
	9085  ,	9091  ,	9096  ,	9107  ,	9118  ,	9119  ,	9121  ,	9132  ,	9142  ,	9145  ,	9147  ,	9150  ,	9156  ,	9167  ,	9176  ,	9176  ,	
	9178  ,	9186  ,	9188  ,	9186  ,	9193  ,	9205  ,	9211  ,	9214  ,	9219  ,	9222  ,	9227  ,	9235  ,	9240  ,	9243  ,	9251  ,	9259  ,	
	9258  ,	9257  ,	9261  ,	9264  ,	9265  ,	9270  ,	9280  ,	9288  ,	9291  ,	9291  ,	9292  ,	9297  ,	9298  ,	9292  ,	9296  ,	9314  ,	
	9320  ,	9309  ,	9306  ,	9317  ,	9321  ,	9317  ,	9318  ,	9324  ,	9327  ,	9327  ,	9329  ,	9329  ,	9328  ,	9330  ,	9338  ,	9343  ,	
	9339  ,	9338  ,	9343  ,	9347  ,	9349  ,	9353  ,	9352  ,	9346  ,	9349  ,	9361  ,	9365  ,	9359  ,	9353  ,	9354  ,	9357  ,	9359  ,	
	9358  ,	9358  ,	9362  ,	9366  ,	9365  ,	9364  ,	9366  ,	9370  ,	9372  ,	9369  ,	9367  ,	9369  ,	9368  ,	9364  ,	9366  ,	9368  ,	
	9364  ,	9363  ,	9369  ,	9369  ,	9362  ,	9361  ,	9365  ,	9362  ,	9360  ,	9369  ,	9378  ,	9375  ,	9367  ,	9367  ,	9370  ,	9368  ,	
	9362  ,	9360  ,	9367  ,	9375  ,	9371  ,	9361  ,	9362  ,	9368  ,	9364  ,	9359  ,	9360  ,	9357  ,	9354  ,	9359  ,	9361  ,	9355  ,	
	9354  ,	9356  ,	9350  ,	9348  ,	9351  ,	9350  ,	9347  ,	9352  ,	9349  ,	9336  ,	9334  ,	9342  ,	9341  ,	9338  ,	9342  ,	9343  ,	
	9339  ,	9339  ,	9341  ,	9339  ,	9339  ,	9339  ,	9330  ,	9323  ,	9326  ,	9331  ,	9330  ,	9324  ,	9315  ,	9307  ,	9312  ,	9322  ,	
	9318  ,	9307  ,	9305  ,	9311  ,	9310  ,	9304  ,	9301  ,	9303  ,	9302  ,	9296  ,	9293  ,	9295  ,	9291  ,	9283  ,	9283  ,	9286  ,	
	9283  ,	9278  ,	9276  ,	9272  ,	9266  ,	9264  ,	9263  ,	9262  ,	9265  ,	9265  ,	9258  ,	9256  ,	9260  ,	9257  ,	9249  ,	9249  ,	
	9251  ,	9245  ,	9238  ,	9240  ,	9242  ,	9240  ,	9238  ,	9235  ,	9230  ,	9226  ,	9224  ,	9222  ,	9222  ,	9221  ,	9216  ,	9209  ,	
	9203  ,	9204  ,	9208  ,	9206  ,	9195  ,	9189  ,	9194  ,	9193  ,	9183  ,	9180  ,	9186  ,	9181  ,	9170  ,	9169  ,	9176  ,	9175  ,	
	9171  ,	9169  ,	9166  ,	9162  ,	9160  ,	9156  ,	9146  ,	9142  ,	9144  ,	9139  ,	9131  ,	9132  ,	9135  ,	9129  ,	9124  ,	9126  ,	
	9120  ,	9109  ,	9108  ,	9113  ,	9110  ,	9105  ,	9105  ,	9102  ,	9097  ,	9095  ,	9093  ,	9087  ,	9081  ,	9078  ,	9079  ,	9083  ,	
	9080  ,	9069  ,	9066  ,	9073  ,	9072  ,	9063  ,	9062  ,	9061  ,	9053  ,	9049  ,	9050  ,	9043  ,	9035  ,	9034  ,	9031  ,	9022  ,	
	9020  ,	9024  ,	9022  ,	9020  ,	9020  ,	9014  ,	9006  ,	9006  ,	9006  ,	8999  ,	8997  ,	8999  ,	8996  ,	8989  ,	8987  ,	8985  ,	
	8975  ,	8967  ,	8969  ,	8969  ,	8959  ,	8953  ,	8957  ,	8960  ,	8955  ,	8945  ,	8939  ,	8938  ,	8935  ,	8932  ,	8931  ,	8930  ,	
	8925  ,	8917  ,	8912  ,	8911  ,	8912  ,	8910  ,	8906  ,	8899  ,	8895  ,	8895  ,	8895  ,	8890  ,	8884  ,	8880  ,	8878  ,	8875  ,	
	8875  ,	8878  ,	8872  ,	8858  ,	8848  ,	8848  ,	8851  ,	8848  ,	8842  ,	8839  ,	8836  ,	8831  ,	8828  ,	8826  ,	8821  ,	8818  ,	
	8815  ,	8807  ,	8797  ,	8797  ,	8798  ,	8790  ,	8785  ,	8789  ,	8790  ,	8783  ,	8781  ,	8782  ,	8775  ,	8767  ,	8767  ,	8765  ,	
	8756  ,	8750  ,	8750  ,	8748  ,	8744  ,	8740  ,	8737  ,	8733  ,	8729  ,	8726  ,	8724  ,	8722  ,	8718  ,	8715  ,	8717  ,	8713  ,	
	8701  ,	8697  ,	8702  ,	8699  ,	8689  ,	8684  ,	8683  ,	8676  ,	8671  ,	8670  ,	8666  ,	8661  ,	8660  ,	8660  ,	8655  ,	8649  ,	
	8644  ,	8637  ,	8632  ,	8631  ,	8631  ,	8628  ,	8623  ,	8618  ,	8616  ,	8615  ,	8611  ,	8603  ,	8599  ,	8598  ,	8597  ,	8594  ,	
	8590  ,	8583  ,	8579  ,	8580  ,	8575  ,	8568  ,	8568  ,	8569  ,	8560  ,	8552  ,	8553  ,	8552  ,	8544  ,	8543  ,	8544  ,	8534  ,	
	8523  ,	8523  ,	8528  ,	8528  ,	8521  ,	8511  ,	8505  ,	8505  ,	8501  ,	8492  ,	8491  ,	8496  ,	8493  ,	8484  ,	8479  ,	8474  ,	
	8467  ,	8463  ,	8464  ,	8461  ,	8457  ,	8457  ,	8457  ,	8454  ,	8449  ,	8444  ,	8439  ,	8435  ,	8434  ,	8432  ,	8426  ,	8418  ,	
	8415  ,	8415  ,	8406  ,	8397  ,	8400  ,	8404  ,	8394  ,	8382  ,	8383  ,	8384  ,	8378  ,	8373  ,	8370  ,	8362  ,	8357  ,	8362  ,	
	8362  ,	8353  ,	8349  ,	8348  ,	8341  ,	8334  ,	8335  ,	8336  ,	8331  ,	8325  ,	8319  ,	8316  ,	8317  ,	8317  ,	8309  ,	8302  ,	
	8302  ,	8301  ,	8292  ,	8284  ,	8282  ,	8279  ,	8276  ,	8275  ,	8272  ,	8265  ,	8259  ,	8257  ,	8259  ,	8259  ,	8255  ,	8252  ,	
	8245  ,	8235  ,	8234  ,	8233  ,	8220  ,	8216  ,	8224  ,	8216  ,	8200  ,	8206  ,	8208  ,	8193  ,	8199  ,	8205  ,	8183  ,	8181  ,	
	8199  ,	8177  ,	8163  ,	8190  ,	8170  ,	8140  ,	8183  ,	8181  ,	8119  ,	8164  ,	8201  ,	8092  ,	8108  ,	8236  ,	8109  ,	8012  ,	
	8244  ,	8196  ,	7877  ,	8160  ,	8406  ,	7733  ,	7860  ,	8871  ,	5132  ,	-7005 ,	-21521,	-30138,	-32425,	-32689,	-32768,	-32534,	
	-32415,	-32564,	-32549,	-32443,	-32482,	-32487,	-32415,	-32421,	-32435,	-32390,	-32382,	-32397,	-32369,	-32350,	-32351,	-32328,	
	-32310,	-32313,	-32291,	-32259,	-32253,	-32246,	-32226,	-32213,	-32198,	-32175,	-32170,	-32174,	-32155,	-32126,	-32115,	-32106,	
	-32078,	-32047,	-32038,	-32041,	-32037,	-32022,	-32006,	-31986,	-31961,	-31943,	-31928,	-31912,	-31899,	-31888,	-31880,	-31875,	
	-31864,	-31838,	-31819,	-31815,	-31801,	-31775,	-31763,	-31765,	-31756,	-31740,	-31720,	-31696,	-31682,	-31678,	-31660,	-31636,	
	-31631,	-31615,	-31574,	-31563,	-31586,	-31579,	-31546,	-31538,	-31530,	-31494,	-31473,	-31480,	-31471,	-31443,	-31428,	-31418,	
	-31401,	-31390,	-31375,	-31347,	-31330,	-31329,	-31315,	-31287,	-31271,	-31265,	-31249,	-31233,	-31231,	-31204,	-31056,	-30744,	
	-30340,	-29948,	-29585,	-29214,	-28827,	-28445,	-28074,	-27713,	-27358,	-26997,	-26638,	-26292,	-25946,	-25594,	-25248,	-24908,	
	-24570,	-24240,	-23908,	-23570,	-23246,	-22940,	-22628,	-22303,	-21983,	-21679,	-21376,	-21065,	-20761,	-20466,	-20167,	-19874,	
	-19592,	-19303,	-19008,	-18725,	-18442,	-18168,	-17907,	-17635,	-17360,	-17102,	-16838,	-16571,	-16322,	-16069,	-15812,	-15570,	
	-15313,	-15062,	-14845,	-14600,	-14327,	-14103,	-13884,	-13638,	-13422,	-13201,	-12954,	-12746,	-12538,	-12292,	-12080,	-11875,	
	-11647,	-11458,	-11261,	-11022,	-10830,	-10639,	-10408,	-10234,	-10056,	-9823 ,	-9648 ,	-9476 ,	-9241 ,	-9082 ,	-8929 ,	-8684 ,	
	-8516 ,	-8377 ,	-8144 ,	-7987 ,	-7861 ,	-7618 ,	-7456 ,	-7345 ,	-7105 ,	-6944 ,	-6852 ,	-6613 ,	-6450 ,	-6366 ,	-6122 ,	-5960 ,	
	-5900 ,	-5658 ,	-5492 ,	-5448 ,	-5203 ,	-5028 ,	-5001 ,	-4753 ,	-4575 ,	-4578 ,	-4333 ,	-4149 ,	-4179 ,	-3927 ,	-3717 ,	-3778 ,	
	-3533 ,	-3303 ,	-3388 ,	-3147 ,	-2895 ,	-3009 ,	-2767 ,	-2491 ,	-2647 ,	-2404 ,	-2089 ,	-2309 ,	-2078 ,	-1701 ,	-1973 ,	-1751 ,	
	-1301 ,	-1651 ,	-1451 ,	-898  ,	-1355 ,	-1185 ,	-465  ,	-1086 ,	-963  ,	53    ,	-885  ,	-880  ,	890   ,	-885  ,	-1532 ,	5478  ,	
	//Osc 5	Level 2
	-755  ,	-733  ,	-556  ,	-342  ,	-151  ,	36    ,	215   ,	394   ,	571   ,	754   ,	923   ,	1086  ,	1252  ,	1411  ,	1558  ,	1726  ,	
	1881  ,	2033  ,	2171  ,	2316  ,	2456  ,	2593  ,	2724  ,	2859  ,	2992  ,	3115  ,	3234  ,	3363  ,	3482  ,	3601  ,	3705  ,	3808  ,	
	3922  ,	4040  ,	4145  ,	4249  ,	4349  ,	4443  ,	4542  ,	4632  ,	4729  ,	4818  ,	4899  ,	4992  ,	5080  ,	5165  ,	5251  ,	5324  ,	
	5407  ,	5481  ,	5555  ,	5625  ,	5700  ,	5771  ,	5839  ,	5896  ,	5961  ,	6034  ,	6098  ,	6159  ,	6217  ,	6278  ,	6336  ,	6389  ,	
	6447  ,	6497  ,	6556  ,	6607  ,	6652  ,	6701  ,	6759  ,	6800  ,	6846  ,	6895  ,	6938  ,	6977  ,	7017  ,	7052  ,	7092  ,	7137  ,	
	7178  ,	7220  ,	7250  ,	7288  ,	7321  ,	7360  ,	7387  ,	7421  ,	7453  ,	7484  ,	7513  ,	7541  ,	7569  ,	7602  ,	7631  ,	7650  ,	
	7677  ,	7699  ,	7729  ,	7749  ,	7780  ,	7799  ,	7825  ,	7845  ,	7867  ,	7886  ,	7903  ,	7924  ,	7949  ,	7959  ,	7982  ,	8001  ,	
	8020  ,	8042  ,	8064  ,	8069  ,	8093  ,	8102  ,	8128  ,	8129  ,	8142  ,	8155  ,	8175  ,	8180  ,	8201  ,	8206  ,	8218  ,	8234  ,	
	8242  ,	8249  ,	8257  ,	8275  ,	8282  ,	8294  ,	8305  ,	8319  ,	8327  ,	8330  ,	8336  ,	8351  ,	8364  ,	8367  ,	8371  ,	8375  ,	
	8396  ,	8387  ,	8401  ,	8399  ,	8411  ,	8412  ,	8416  ,	8424  ,	8432  ,	8431  ,	8446  ,	8444  ,	8449  ,	8462  ,	8455  ,	8459  ,	
	8463  ,	8468  ,	8474  ,	8476  ,	8485  ,	8482  ,	8485  ,	8485  ,	8487  ,	8491  ,	8492  ,	8490  ,	8495  ,	8509  ,	8506  ,	8507  ,	
	8505  ,	8511  ,	8519  ,	8510  ,	8520  ,	8511  ,	8517  ,	8518  ,	8521  ,	8517  ,	8520  ,	8523  ,	8524  ,	8514  ,	8525  ,	8525  ,	
	8532  ,	8530  ,	8538  ,	8528  ,	8529  ,	8536  ,	8524  ,	8526  ,	8535  ,	8525  ,	8535  ,	8528  ,	8534  ,	8528  ,	8531  ,	8524  ,	
	8532  ,	8523  ,	8524  ,	8518  ,	8530  ,	8524  ,	8531  ,	8524  ,	8529  ,	8522  ,	8530  ,	8529  ,	8527  ,	8522  ,	8528  ,	8524  ,	
	8518  ,	8525  ,	8519  ,	8518  ,	8518  ,	8517  ,	8515  ,	8516  ,	8525  ,	8517  ,	8522  ,	8509  ,	8512  ,	8506  ,	8512  ,	8509  ,	
	8508  ,	8501  ,	8510  ,	8505  ,	8508  ,	8504  ,	8501  ,	8502  ,	8509  ,	8500  ,	8512  ,	8503  ,	8507  ,	8499  ,	8500  ,	8492  ,	
	8494  ,	8496  ,	8502  ,	8493  ,	8497  ,	8494  ,	8500  ,	8494  ,	8491  ,	8486  ,	8488  ,	8484  ,	8494  ,	8478  ,	8486  ,	8481  ,	
	8487  ,	8473  ,	8485  ,	8478  ,	8480  ,	8479  ,	8481  ,	8473  ,	8484  ,	8479  ,	8468  ,	8470  ,	8474  ,	8467  ,	8470  ,	8465  ,	
	8468  ,	8455  ,	8461  ,	8455  ,	8465  ,	8462  ,	8464  ,	8457  ,	8459  ,	8451  ,	8459  ,	8451  ,	8456  ,	8451  ,	8456  ,	8455  ,	
	8454  ,	8450  ,	8455  ,	8443  ,	8448  ,	8440  ,	8448  ,	8442  ,	8443  ,	8432  ,	8442  ,	8434  ,	8440  ,	8435  ,	8434  ,	8434  ,	
	8437  ,	8429  ,	8434  ,	8429  ,	8433  ,	8424  ,	8432  ,	8426  ,	8423  ,	8423  ,	8431  ,	8414  ,	8422  ,	8412  ,	8428  ,	8410  ,	
	8415  ,	8406  ,	8418  ,	8411  ,	8422  ,	8405  ,	8419  ,	8404  ,	8413  ,	8397  ,	8408  ,	8398  ,	8400  ,	8396  ,	8398  ,	8387  ,	
	8403  ,	8389  ,	8396  ,	8384  ,	8400  ,	8379  ,	8397  ,	8381  ,	8393  ,	8377  ,	8383  ,	8372  ,	8386  ,	8366  ,	8385  ,	8374  ,	
	8382  ,	8361  ,	8373  ,	8356  ,	8370  ,	8349  ,	8374  ,	8348  ,	8372  ,	8344  ,	8366  ,	8342  ,	8370  ,	8338  ,	8360  ,	8339  ,	
	8341  ,	8352  ,	8250  ,	8583  ,	4828  ,	-20745,	-32637,	-32157,	-32397,	-32139,	-32288,	-32097,	-32190,	-32056,	-32125,	-32008,	
	-32053,	-31952,	-31969,	-31890,	-31897,	-31827,	-31846,	-31761,	-31761,	-31674,	-31710,	-31634,	-31625,	-31548,	-31551,	-31494,	
	-31504,	-31427,	-31433,	-31360,	-31383,	-31304,	-31302,	-31238,	-31237,	-31153,	-31174,	-31123,	-31109,	-31039,	-31049,	-30978,	
	-30979,	-30912,	-30901,	-30846,	-30832,	-30774,	-30785,	-30573,	-29888,	-29095,	-28367,	-27579,	-26888,	-26139,	-25469,	-24739,	
	-24091,	-23390,	-22761,	-22104,	-21491,	-20846,	-20262,	-19634,	-19083,	-18472,	-17930,	-17358,	-16848,	-16285,	-15797,	-15260,	
	-14786,	-14274,	-13811,	-13303,	-12887,	-12389,	-11989,	-11497,	-11117,	-10661,	-10282,	-9833 ,	-9489 ,	-9049 ,	-8713 ,	-8296 ,	
	-7967 ,	-7561 ,	-7265 ,	-6856 ,	-6573 ,	-6181 ,	-5916 ,	-5522 ,	-5277 ,	-4898 ,	-4667 ,	-4285 ,	-4073 ,	-3708 ,	-3524 ,	-3150 ,	
	-2985 ,	-2611 ,	-2466 ,	-2083 ,	-1966 ,	-1574 ,	-1507 ,	-1087 ,	-1058 ,	-603  ,	-652  ,	-120  ,	-297  ,	412   ,	-107  ,	1431  ,	
	//Osc 5	Level 3
	-868  ,	-901  ,	-403  ,	-96   ,	301   ,	621   ,	973   ,	1267  ,	1601  ,	1880  ,	2174  ,	2434  ,	2708  ,	2947  ,	3202  ,	3417  ,	
	3639  ,	3861  ,	4065  ,	4256  ,	4446  ,	4619  ,	4798  ,	4967  ,	5125  ,	5274  ,	5420  ,	5558  ,	5683  ,	5822  ,	5939  ,	6061  ,	
	6167  ,	6281  ,	6377  ,	6482  ,	6573  ,	6667  ,	6742  ,	6824  ,	6907  ,	6985  ,	7052  ,	7124  ,	7183  ,	7250  ,	7302  ,	7368  ,	
	7409  ,	7468  ,	7512  ,	7567  ,	7603  ,	7649  ,	7684  ,	7728  ,	7762  ,	7810  ,	7831  ,	7874  ,	7885  ,	7926  ,	7942  ,	7977  ,	
	7989  ,	8018  ,	8033  ,	8067  ,	8079  ,	8101  ,	8117  ,	8137  ,	8145  ,	8166  ,	8167  ,	8188  ,	8191  ,	8215  ,	8216  ,	8235  ,	
	8228  ,	8253  ,	8250  ,	8267  ,	8258  ,	8277  ,	8269  ,	8298  ,	8281  ,	8308  ,	8291  ,	8312  ,	8298  ,	8319  ,	8304  ,	8323  ,	
	8317  ,	8337  ,	8319  ,	8336  ,	8320  ,	8343  ,	8324  ,	8344  ,	8323  ,	8341  ,	8323  ,	8351  ,	8326  ,	8354  ,	8330  ,	8354  ,	
	8329  ,	8353  ,	8327  ,	8353  ,	8333  ,	8359  ,	8323  ,	8355  ,	8324  ,	8355  ,	8327  ,	8355  ,	8328  ,	8363  ,	8331  ,	8358  ,	
	8323  ,	8364  ,	8326  ,	8367  ,	8324  ,	8360  ,	8324  ,	8361  ,	8322  ,	8361  ,	8323  ,	8364  ,	8325  ,	8364  ,	8317  ,	8365  ,	
	8313  ,	8358  ,	8314  ,	8369  ,	8310  ,	8367  ,	8309  ,	8371  ,	8312  ,	8373  ,	8304  ,	8373  ,	8302  ,	8370  ,	8301  ,	8374  ,	
	8299  ,	8377  ,	8295  ,	8380  ,	8291  ,	8384  ,	8283  ,	8387  ,	8277  ,	8389  ,	8280  ,	8396  ,	8270  ,	8396  ,	8259  ,	8400  ,	
	8250  ,	8411  ,	8237  ,	8424  ,	8223  ,	8434  ,	8198  ,	8457  ,	8175  ,	8481  ,	8125  ,	8532  ,	8059  ,	8624  ,	7917  ,	8849  ,	
	7481  ,	9892  ,	139   ,	-31591,	-31964,	-32567,	-31870,	-32349,	-31824,	-32154,	-31726,	-31991,	-31612,	-31822,	-31503,	-31652,	
	-31389,	-31514,	-31269,	-31378,	-31131,	-31233,	-31018,	-31095,	-30883,	-30955,	-30733,	-30833,	-29854,	-28358,	-26820,	-25467,	
	-24018,	-22764,	-21423,	-20255,	-19005,	-17922,	-16771,	-15779,	-14713,	-13789,	-12800,	-11951,	-11030,	-10246,	-9394 ,	-8669 ,	
	-7879 ,	-7206 ,	-6477 ,	-5847 ,	-5174 ,	-4587 ,	-3965 ,	-3427 ,	-2867 ,	-2348 ,	-1836 ,	-1346 ,	-906  ,	-405  ,	-84   ,	572   ,	
	//Osc 5	Level 4
	-749  ,	-652  ,	288   ,	817   ,	1564  ,	2038  ,	2669  ,	3071  ,	3605  ,	3945  ,	4405  ,	4679  ,	5088  ,	5302  ,	5652  ,	5825  ,	
	6135  ,	6264  ,	6541  ,	6629  ,	6872  ,	6940  ,	7152  ,	7191  ,	7383  ,	7399  ,	7578  ,	7569  ,	7739  ,	7721  ,	7867  ,	7830  ,	
	7970  ,	7920  ,	8062  ,	7998  ,	8131  ,	8052  ,	8181  ,	8100  ,	8223  ,	8134  ,	8255  ,	8154  ,	8287  ,	8175  ,	8304  ,	8185  ,	
	8324  ,	8200  ,	8333  ,	8204  ,	8340  ,	8201  ,	8352  ,	8206  ,	8358  ,	8201  ,	8367  ,	8198  ,	8366  ,	8195  ,	8377  ,	8196  ,	
	8380  ,	8192  ,	8390  ,	8181  ,	8397  ,	8175  ,	8409  ,	8165  ,	8412  ,	8152  ,	8428  ,	8140  ,	8446  ,	8126  ,	8458  ,	8106  ,	
	8480  ,	8085  ,	8506  ,	8054  ,	8537  ,	8017  ,	8584  ,	7955  ,	8647  ,	7873  ,	8750  ,	7731  ,	8934  ,	7452  ,	9356  ,	6677  ,	
	11192 ,	-5260 ,	-32768,	-30690,	-32768,	-31141,	-32437,	-31122,	-31976,	-30999,	-31599,	-30823,	-31243,	-30664,	-30144,	-26618,	
	-24334,	-21257,	-19281,	-16628,	-14961,	-12672,	-11260,	-9279 ,	-8091 ,	-6366 ,	-5369 ,	-3856 ,	-3049 ,	-1708 ,	-1078 ,	169   ,	
	//Osc 5	Level 5
	-611  ,	29    ,	1567  ,	2527  ,	3594  ,	4287  ,	5064  ,	5541  ,	6109  ,	6428  ,	6844  ,	7044  ,	7354  ,	7465  ,	7706  ,	7756  ,	
	7935  ,	7944  ,	8093  ,	8059  ,	8187  ,	8129  ,	8244  ,	8170  ,	8278  ,	8194  ,	8294  ,	8200  ,	8308  ,	8201  ,	8312  ,	8200  ,	
	8325  ,	8196  ,	8331  ,	8190  ,	8338  ,	8177  ,	8356  ,	8164  ,	8371  ,	8145  ,	8395  ,	8113  ,	8428  ,	8061  ,	8474  ,	8047  ,	
	7588  ,	-26139,	-32768,	-31150,	-32004,	-30905,	-31397,	-29460,	-24277,	-18954,	-14908,	-10995,	-8057 ,	-5129 ,	-3031 ,	-775  ,	
	//Osc 5	Level 6
	-516  ,	1408  ,	3505  ,	5052  ,	5987  ,	6871  ,	7210  ,	7751  ,	7774  ,	8159  ,	7997  ,	8331  ,	8057  ,	8412  ,	8042  ,	8468  ,	
	7993  ,	8546  ,	7898  ,	8677  ,	7710  ,	8979  ,	7148  ,	10315 ,	-300  ,	-32768,	-30419,	-31984,	-24033,	-14988,	-7779 ,	-3038 ,	
	//Osc 5	Level 7
	-355  ,	3627  ,	5817  ,	7586  ,	7532  ,	8533  ,	7724  ,	8827  ,	7489  ,	9253  ,	6726  ,	11116 ,	-5338 ,	-32768,	-22746,	-8623 ,	
	//Osc 5	Level 8
	-298  ,	6835  ,	6748  ,	9718  ,	6037  ,	12157 ,	-9291 ,	-25375,	
	//Osc 5	Level 9
	-1390 ,	5500  ,	6077  ,	11215 ,	
	//Osc 5	Level 10
	-1390 ,	4139  ,	
	//Osc 5	Level 11
	-1390 ,	4139
    }
};
