###########################################################
#
# BogoSec - Source Code Security Quality Metric Calculator
#   * lintian plugin
#
# (C) Copyright Canonical, Ltd. 2008
#
# HISTORY:
#	10/2008 Dustin Kirkland <kirkland@canonical.com> - initial revision
###########################################################

package BogoLintian;

use strict;
use File::Temp;

my $SCANNER = "lintian";
my $DEFAULT_ARGS = "-I";
my @RESULTS = ();

sub exists() {
	`which $SCANNER`;
	if ($? != 0) {
		print "Warning: cannot find $SCANNER binary (please include location in PATH if you wish to use it)\n";
		return undef;
	}
	return 1;
}

# this function simply returns 1 if scanner is compiler based, and 0 otherwise.
sub does_compile() {
        return 1;
}

sub run($$;$) {
	my $logfile = shift;
	my $target_file = shift;
	my $target_dir = shift;
	`$SCANNER $DEFAULT_ARGS $target_file >$logfile 2>/dev/null`;
}

sub sloc($) {
	my $target_dir = shift;
	my $sloc = 0;
	my @files = `find $target_dir -type f | grep "/debian/" | xargs -i wc -l {}`;
	foreach my $file (@files) {
		my ($count, $filename) = split(/ /, $file);
		$sloc += $count;
	}
	return $sloc;
}

sub get_args() {
	return $DEFAULT_ARGS;
}

sub name() {
	return $SCANNER;
}

sub analyze($$$$) {
	my ($logfile, $target, $sev_range_max, $ex_vuln) = @_;
	my $ignore = undef;
	# open temp file
	open(FH, $logfile);
	foreach (<FH>) {
		# I: or W: or E:
		if (m/^[IEW]:/) {
			chomp;
			my ($type, $pkg, $pkg_type, $vulnerability, $file) = split(/[: ]+/);
			my $score = calc_score($type, $sev_range_max);
			my $temp = "$file:0:$score:$vulnerability";
			push(@RESULTS, $temp);
		}
	}
	# push SLOC onto front of results array
	unshift(@RESULTS, sloc($target));
	close(FH);
	return \@RESULTS;
}

sub calc_score($$) {
	my $type = shift;
	my $max = shift;
	if ($type =~ /E/) {
		return $max * 3/3;
	} elsif ($type =~ /W/) {
		return $max * 2/3;
	} elsif ($type =~ /I/) {
		return $max * 1/3;
	} else {
		return 0;
	}
}

sub debug {
	foreach (@RESULTS) {
		print "$_\n";
	}
}

1;
