###########################################################
#
# Licensed Material - Property of IBM
#
# BogoSec - Source Code Security Quality Metric Calculator
#
# (C) Copyright IBM Corp. 2004-2008
#
# HISTORY:
#       07/2004 originated by Tony Petz (petz.agoston@gmail.com)
#	07/2004 Dustin Kirkland (dustin.kirkland@us.ibm.com) - consistency improvements
#       01/2005 Loulwa Salem (loulwa@us.ibm.com) - added does_compile()
#       01/2005 Loulwa Salem (loulwa@us.ibm.com) - Changed global variable to all CAPS
#	07/2005 Loulwa Salem - Code to exclude vulnerabilities and track their type
###########################################################

package BogoRats;

use strict;
use File::Temp;

my $SCANNER = "rats";
my $DEFAULT_ARGS = "-w 3";
my @RESULTS = ();

sub exists() {
	`which $SCANNER`;
	my $exists = !$?;
	if (!$exists) {
		print "Warning: cannot find $SCANNER binary (please include location in PATH if you wish to use it)\n";
		return undef;
	}
	return 1;
}

# this function simply returns 1 if scanner is compiler based, and 0 otherwise.
sub does_compile() {
        return 0;
}

sub get_args() {
	return $DEFAULT_ARGS;
}

sub name() {
	return $SCANNER;
}

sub analyze($$$$) {
	my ($logfile, $target, $sev_range_max, $ex_vuln) = @_;
	my $sloc = undef;
	my $ignore = undef;

# open temp file
	open(FH, $logfile);

	my @Excl_vuln = split(/:/, $ex_vuln);
	foreach (<FH>) {
		if (m/$target/ && ! m/Analyzing/) {
			chomp;
# Splitting line on delimeter ": " or ":"
			my @temp = split(/:\s*/);
			foreach my $vuln (@Excl_vuln) {
				if ($vuln eq $temp[3]) {
					#print "RATS: Ignoring $temp[3]\n";
					$ignore = 1;
					last;
				}
			}
			if ($ignore==undef) {
				$temp[2] = calc_score($temp[2],$sev_range_max);
			} else {
				$temp[2] = 0;
			}
			my $temp = join(":", @temp);
			push(@RESULTS, $temp);
		} elsif (m/Total lines analyzed/) {
			my ($tmp_sloc) = m/^.*:\s*(.*)/;
			$sloc += $tmp_sloc;
		}
	$ignore = undef;
	}
# Added conditional to avoid getting a -1 for lines when actually no lines were scanned
# We decrement because rats line counting is off by 1
	if ( $sloc != 0 ) {
		$sloc = $sloc - 1;
	}
	unshift @RESULTS, $sloc;
		close(FH);
	return \@RESULTS;
}

sub calc_score($$) {
	($_, my $max) = @_;
	if (m/High/) {
		return $max * 3/3;
	}
	elsif (m/Medium/) {
		return $max * 2/3;
	}
	elsif (m/Low/) {
		return $max * 1/3;
	} else {
		return 0;
	}
}

sub debug {
	foreach (@RESULTS) {
		print "$_\n";
	}
}

1;
