//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/RoughnessItemCatalog.h
//! @brief     Defines class RoughnessItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMCATALOG_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMCATALOG_H

#include "GUI/Support/Type/UiInfo.h"
#include <QVector>

class RoughnessItem;

class RoughnessItemCatalog {
public:
    // used in SelectionProperty<Catalog>
    using CatalogedType = RoughnessItem;

    // Do not change the numbering! It is serialized!
    enum class Type : uint8_t { None = 0, Basic = 1 };

    //! Creates the item of the given type.
    static RoughnessItem* create(Type type);

    //! List of available types, sorted as expected in the UI.
    static QVector<Type> types();

    //! UiInfo on the given type.
    static UiInfo uiInfo(Type t);

    //! Returns the enum type of the given item.
    static Type type(const RoughnessItem* item);
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_ROUGHNESSITEMCATALOG_H
