//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Type/VariantUtil.h
//! @brief     Defines namespace GUI::Util::Variant
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_TYPE_VARIANTUTIL_H
#define BORNAGAIN_GUI_SUPPORT_TYPE_VARIANTUTIL_H

#include <QString>
#include <QVariant>
#include <heinz/Vectors3D.h>

namespace GUI::Util::Variant {

//! Returns type of variant (additionally checks for user type).
int VariantType(const QVariant& variant);

//! Returns true if variants has compatible types.
bool CompatibleVariantTypes(const QVariant& oldValue, const QVariant& newValue);

//! Returns true if given variants have same type and value.
//! For custom variants (e.g. ComboProperty) will always return false (see
//! explanations in cpp file).

bool IsTheSame(const QVariant& var1, const QVariant& var2);

} // namespace GUI::Util::Variant

#endif // BORNAGAIN_GUI_SUPPORT_TYPE_VARIANTUTIL_H
