//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/LineViews.h
//! @brief     Defines classes VerticalLineView and HorizontalLineView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_LINEVIEWS_H
#define BORNAGAIN_GUI_VIEW_MASK_LINEVIEWS_H

#include "GUI/View/Mask/IShape2DView.h"

class VerticalLineItem;
class HorizontalLineItem;

//! This is a view of VerticalLineItem mask

class VerticalLineView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::VERTICALLINE; }

    explicit VerticalLineView(VerticalLineItem* item);

    QPainterPath shape() const override;
    MaskItemObject* parameterizedItem() const override;

protected slots:
    void update_view() override;
    void onChangedX() override;
    void onPropertyChange() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;
    QVariant itemChange(GraphicsItemChange change, const QVariant& value) override;

private:
    VerticalLineItem* m_item;
};


//! This is a view of HorizontalLineItem mask

class HorizontalLineView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::HORIZONTALLINE; }

    explicit HorizontalLineView(HorizontalLineItem* item);

    QPainterPath shape() const override;
    MaskItemObject* parameterizedItem() const override;

protected slots:
    void update_view() override;
    void onChangedY() override;
    void onPropertyChange() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;
    QVariant itemChange(GraphicsItemChange change, const QVariant& value) override;

private:
    HorizontalLineItem* m_item;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_LINEVIEWS_H
