//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotComparison/FitComparisonWidget1D.h
//! @brief     Defines class FitComparisonWidget1D
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET1D_H
#define BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET1D_H

#include "GUI/View/Common/DataAccessWidget.h"

class FitFlowWidget;
class JobRealBase;
class PlotStatusLabel;
class QAction;
class SpecularDataItem;
class SpecularDataPropertyWidget;
class SpecularPlotCanvas;

//! The FitComparisonWidget class plots real data, simulated data and their relative difference
//! during the course of the fit.

class FitComparisonWidget1D : public DataAccessWidget {
    Q_OBJECT
public:
    explicit FitComparisonWidget1D(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

    QList<QAction*> actionList() override;

private:
    void onResetViewAction();
    void connectItems();
    void updateDiffData();

    SpecularPlotCanvas* m_data_canvas;
    SpecularPlotCanvas* m_diff_canvas;
    FitFlowWidget* m_fitFlowWidget;
    PlotStatusLabel* m_statusLabel;
    SpecularDataPropertyWidget* m_propertyWidget;

    QAction* m_resetViewAction;
    QAction* m_togglePropertiesAction;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITCOMPARISONWIDGET1D_H
