//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/SampleListView.h
//! @brief     Defines class SampleListView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTVIEW_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTVIEW_H

#include <QListView>

class SampleListModel;
class SampleItem;
class ProjectDocument;

//! List view to select one sample (left side of layer-oriented sample editor)
class SampleListView : public QListView {
    Q_OBJECT
public:
    SampleListView(QWidget* parent, ProjectDocument* document);

    void setCurrentSample(SampleItem* sample);
    SampleItem* currentSampleItem();

    void restoreSelection();

    QAction* newSampleAction();
    QAction* importSampleAction();
    QAction* chooseFromLibraryAction();

    QSize sizeHint() const override;

signals:
    void currentSampleChanged(SampleItem* current);

public slots:
    void onSampleModified();

private:
    void createNewSample();
    void createSampleFromLibrary(const QString& classname, const QString& title,
                                 const QString& description);
    void importSampleFromPython();
    QList<QAction*> getOverlayActions(const QModelIndex& index, bool asHover);
    void onCurrentChanged(const QModelIndex& index);
    void removeSample(SampleItem* item);

    QAction* createRemoveAction(QObject* parent, SampleItem* item);

    void showContextMenu(const QPoint& pos);

private:
    SampleListModel* m_model;
    ProjectDocument* m_document;
    QAction* m_newSampleAction;
    QAction* m_importSampleAction;
    QAction* m_chooseFromLibraryAction;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTVIEW_H
