//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Pixel/RectangularPixel.h
//! @brief     Defines class RectangularPixel.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_BASE_PIXEL_RECTANGULARPIXEL_H
#define BORNAGAIN_BASE_PIXEL_RECTANGULARPIXEL_H

#include "Base/Pixel/IPixel.h"

class Scale;

//! A pixel in a RectangularDetector.

class RectangularPixel : public IPixel {
public:
    RectangularPixel(const R3& corner_pos, const R3& width, const R3& height);

    RectangularPixel* clone() const override;
    RectangularPixel* createZeroSizePixel(double x, double y) const override;
    R3 getK(double x, double y, double wavelength) const override;
    R3 getPosition(double x, double y) const;
    double integrationFactor(double x, double y) const override;
    double solidAngle() const override;

    Scale* createAxis(size_t n) const;

private:
    R3 normalizeLength(R3 direction, double length) const;
    double calculateSolidAngle() const;

    const R3 m_corner_pos;
    const R3 m_width;
    const R3 m_height;
    const R3 m_normal;
    mutable double m_solid_angle;
};

#endif // BORNAGAIN_BASE_PIXEL_RECTANGULARPIXEL_H
