//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/RealDataPresenter.h
//! @brief     Defines class RealDataPresenter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPRESENTER_H
#define BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPRESENTER_H

#include "GUI/View/Widget/ItemComboWidget.h"

//! Presents imported data (RealItem) using stack of different widgets and combo box in the
//! right top corner of ImportDataView, to switch between widgets.

class RealDataPresenter : public ItemComboWidget {
    Q_OBJECT
public:
    explicit RealDataPresenter(QWidget* parent = nullptr);

    void setPresentation(const QString& presentationType) override;
    void setModel(QObject*) {}

protected:
    QStringList activePresentationList() const override;
    QString itemPresentation() const override;
};

#endif // BORNAGAIN_GUI_VIEW_IMPORT_REALDATAPRESENTER_H
