//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sim/Contrib/DWBAContribution.cpp
//! @brief     Implements function dwbaContribution.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Sim/Contrib/DWBAContribution.h"
#include "Resample/Element/DiffuseElement.h"
#include "Resample/Interparticle/IInterparticleStrategy.h"
#include "Resample/Processed/ReLayout.h"

double Compute::dwbaContribution(const ReLayout& relayout, const DiffuseElement& ele)
{
    return relayout.interparticle_strategy()->evaluate(ele) * relayout.surfaceDensity();
}
