
#define POLY_WHITE 0x00b8bab7
#define BLUE_WHITE 0x00d0d0ff
#define BLUE_WHITE2 0x00c4e4ff
#define OFF_WHITE 0x00d0d0d0
#define OFF_WHITER 0x00eeeeee

bvgCoords potCoords[17] = {
	{28, 5},
	{75, 100},
	{-1, -1},
	{7, 25},
	{95, 75},
	{-1, -1},
	{72, 5},
	{25, 100},
	{-1, -1},
	{93, 25},
	{7, 75},
	{-1, -1},
	{0, 50},
	{100, 50},
	{-1, -1},
	{50, 0},
	{50, 50},
};
bvgVect pot = {
	17,
	potCoords
};

bvgCoords sharpCoords[11] = {
	{30, 10},
	{30, 100},
	{-1, -1},
	{70, 0},
	{70, 90},
	{-1, -1},
	{10, 30},
	{100, 30},
	{-1, -1},
	{0, 80},
	{90, 80},
};
bvgVect sharp = {
	11,
	sharpCoords
};

bvgCoords flatCoords[6] = {
	{0, 0},
	{0, 80},
	{20, 100},
	{60, 60},
	{40, 40},
	{0, 60},
};
bvgVect flat = {
	6,
	flatCoords
};

bvgCoords invenvCoords[5] = {
	{0, 0},
	{20, 0},
	{20, 100},
	{80, 0},
	{100, 0},
};
bvgVect invenv = {
	5,
	invenvCoords
};

bvgCoords envCoords[5] = {
	{0, 100},
	{20, 100},
	{20, 0},
	{80, 100},
	{100, 100},
};
bvgVect env = {
	5,
	envCoords
};

bvgCoords gateCoords[6] = {
	{0, 100},
	{10, 100},
	{10, 0},
	{80, 0},
	{80, 100},
	{100, 100},
};
bvgVect gate = {
	6,
	gateCoords
};

bvgCoords pulseWaveCoords[10] = {
	{0, 100},
	{0, 0},
	{40, 0},
	{40, 100},
	{100, 100},
	{100, 0},
	{-1, -1},
	{50, 0},
	{70, 0},
	{70, 60},
};
bvgVect pulseWave = {
	10,
	pulseWaveCoords
};

bvgCoords pWaveCoords[6] = {
	{0, 100},
	{0, 0},
	{30, 0},
	{30, 100},
	{100, 100},
	{100, 0},
};
bvgVect pWave = {
	6,
	pWaveCoords
};

bvgCoords sineWaveCoords[12] = {
	{0, 60},
	{0, 40},
	{16, 10}, // 16
	{24, 0}, // 8
	{32, 10}, // 8
	{48, 40}, // 16
	{48, 60},
	{64, 94}, // 16
	{72, 100},//8
	{80, 94},//8
	{96, 60},
	{96, 30},
};
bvgVect sineWave = {
	12,
	sineWaveCoords
};

bvgCoords squareWaveCoords[6] = {
	{0, 100},
	{0, 0},
	{50, 0},
	{50, 100},
	{100, 100},
	{100, 0},
};
bvgVect squareWave = {
	6,
	squareWaveCoords
};

bvgCoords triWaveCoords[3] = {
	{0, 100},
	{50, 0},
	{100, 100},
};
bvgVect triWave = {
	3,
	triWaveCoords
};

bvgCoords biRampWaveCoords[5] = {
	{0, 100},
	{70, 20},
	{70, 80},
	{100, 0},
	{100, 100},
};
bvgVect biRampWave = {
	5,
	biRampWaveCoords
};

bvgCoords sawWaveCoords[4] = {
	{0, 0},
	{0, 100},
	{100, 0},
	{100, 100},
};
bvgVect sawWave = {
	4,
	sawWaveCoords
};

bvgCoords rampWaveCoords[4] = {
	{0, 100},
	{0, 0},
	{100, 100},
	{100, 0},
};
bvgVect rampWave = {
	4,
	rampWaveCoords
};

/*
 * Stuff for the ARP. There will be lots, might break it out
 */
#define aPAC 103
bvgCoords arpPABoxCoords[aPAC] = {
	{14, 2},
	{35, 2},
	{35, 85},
	{14, 85},
	{14, 112},
	{69, 112},
	{69, 85},
	{33, 85},
	{-1, -1},
	{69, 101},
	{71, 101},
	{71, 98},
	{74, 101},
	{71, 104},
	{71, 99},
	// Env Follower
	{-1, -1},
	{2, 144},
	{2, 170},
	{43, 170},
	{43, 144},
	{2, 144},
	{-1, -1},
	{47, 144},
	{47, 170},
	{68, 170},
	{68, 144},
	{47, 144},
	{-1, -1},
	{69, 158},
	{71, 158},
	{71, 155},
	{74, 158},
	{71, 161},
	{71, 155},
	// First Arrow
	{-1, -1},
	{9, 228},
	{9, 179},
	{7, 179},
	{9, 174},
	{11, 179},
	{9, 179},
	{-1, -1},
	{27, 270},
	{27, 179},
	{25, 179},
	{27, 174},
	{29, 179},
	{27, 179},
	{-1, -1},
	{46, 228},
	{53, 205},
	{53, 179},
	{51, 179},
	{53, 174},
	{55, 179},
	{51, 179},
	{-1, -1},
	{84, 228},
	{63, 205},
	{63, 179},
	{61, 179},
	{63, 174},
	{65, 179},
	{63, 179},
	{-1, -1},
	{0, 415},
	{0, 447},
	{18, 447},
	{18, 415},
	{0, 415},
	{-1, -1},
	{9, 415},
	{9, 407},
	{7, 407},
	{9, 403},
	{11, 407},
	{9, 407},
	{-1, -1},
	{36, 415},
	{36, 447},
	{55, 447},
	{55, 415},
	{36, 415},
	{-1, -1},
	{45, 415},
	{45, 407},
	{43, 407},
	{45, 403},
	{47, 407},
	{45, 407},
	{-1, -1},
	{75, 415},
	{75, 447},
	{93, 447},
	{93, 415},
	{75, 415},
	{-1, -1},
	{84, 415},
	{84, 407},
	{83, 407},
	{84, 403},
	{85, 407},
	{84, 407},
};
bvgVect arpPABox = {
	aPAC,
	arpPABoxCoords
};

/*
 * Stuff for the ARP. There will be lots, might break it out
 */
#define aVCO1 105
bvgCoords arpVCO1BoxCoords[aVCO1] = {
	{0, 10},
	{0, 200},
	{-1, -1},
	{36, 82},
	{36, 97},
	{128, 97},
	{128, 82},
	{36, 82},
	{-1, -1},
	{128, 84},
	{134, 84},
	{138, 82},
	{-1, -1},
	{128, 95},
	{134, 95},
	{138, 97},
	{-1, -1},
	{12, 128},
	{12, 115},
	{58, 107},
	{58, 100},
	{55, 100},
	{58, 98},
	{61, 100},
	{58, 100},
	{-1, -1},
	{68, 115},
	{74, 107},
	{74, 100},
	{71, 100},
	{74, 98},
	{77, 100},
	{71, 100},
	{-1, -1},
	{109, 115},
	{92, 107},
	{92, 100},
	{89, 100},
	{92, 98},
	{95, 100},
	{89, 100},
	{-1, -1},
	{152, 115},
	{110, 107},
	{110, 100},
	{107, 100},
	{110, 98},
	{113, 100},
	{107, 100},
	{-1, -1},
	{8, 187},
	{8, 199},
	{48, 199},
	{48, 187},
	{8, 187},
	{28, 187},
	{28, 184},
	{26, 184},
	{28, 182},
	{30, 184},
	{26, 184},
	{-1, -1},
	{52, 187},
	{52, 199},
	{87, 199},
	{87, 187},
	{52, 187},
	{71, 187},
	{71, 184},
	{69, 184},
	{71, 182},
	{73, 184},
	{69, 184},
	{-1, -1},
	{90, 187},
	{90, 199},
	{130, 199},
	{130, 187},
	{90, 187},
	{110, 187},
	{110, 184},
	{108, 184},
	{110, 182},
	{112, 184},
	{108, 184},
	{-1, -1},
	{136, 187},
	{136, 199},
	{175, 199},
	{175, 187},
	{136, 187},
	{157, 187},
	{157, 184},
	{155, 184},
	{157, 182},
	{159, 184},
	{155, 184},
	{-1, -1},
	{153, 169},
	{153, 167},
	{143, 167},
	{-1, -1},
	{26, 169},
	{26, 167},
	{36, 167},
};
bvgVect arpVCO1Box = {
	aVCO1,
	arpVCO1BoxCoords
};

#define aVCO1a 19
bvgCoords arpVCO1aBoxCoords[aVCO1a] = {
	{179, 187},
	{179, 199},
	{215, 199},
	{215, 187},
	{179, 187},
	{198, 187},
	{198, 184},
	{196, 184},
	{198, 182},
	{200, 184},
	{198, 184},
	{-1, -1},
	{129, 87},
	{180, 87},
	{185, 84},
	{-1, -1},
	{129, 92},
	{180, 92},
	{185, 95},
};
bvgVect arpVCO1aBox = {
	aVCO1a,
	arpVCO1aBoxCoords
};

#define aMOD 241
bvgCoords arpMODBoxCoords[aMOD] = {
	// NOISE
	{109, 4}, {109, 22}, {253, 22}, {253, 4}, {109, 4},
	{-1, -1}, {270, 0}, {270, 290}, {-1, -1}, // VOLTAGE PROCESSING
	{385, 4}, {385, 22}, {554, 22}, {554, 4}, {385, 4}, {-1, -1},
	{340, 65}, {386, 65}, {386, 62}, {394, 65}, {386, 68}, {386, 65}, {-1, -1},
	{340, 123}, {386, 123}, {386, 120}, {394, 123}, {386, 126}, {386, 123}, {-1, -1},
	{340, 180}, {386, 180}, {386, 177}, {394, 180}, {386, 183}, {386, 180}, {-1, -1},
	{340, 235}, {386, 235}, {386, 232}, {394, 235}, {386, 238}, {386, 235}, {-1, -1},
	{552, 65}, {655, 65}, {655, 42}, {633, 42}, {-1, -1},
	{655, 65}, {655, 96}, {633, 96}, {-1, -1},
	{655, 96}, {655, 123}, {552, 123}, {-1, -1},
	{655, 80}, {665, 80}, {665, 75}, {675, 80}, {665, 85}, {665, 80}, {-1, -1},
	{675, 80}, {685, 80}, {-1, -1},
	{552, 180}, {635, 180}, {635, 175}, {645, 180}, {635, 185}, {635, 180}, {-1, -1},
	{610, 180}, {610, 170}, {-1, -1},
	{645, 180}, {675, 180}, {-1, -1},
	{655, 180}, {655, 140}, {675, 140}, {-1, -1},
	{552, 235}, {594, 235}, {594, 225}, {628, 225}, {628, 245}, {594, 245}, {594, 235}, {-1, -1},
	{628, 235}, {675, 235}, {-1, -1},
	{745, 0}, {745, 290}, {-1, -1}, // S&H
	{808, 12}, {812, 12}, {812, 9}, {819, 12}, {812, 15}, {812, 12}, {-1, -1},
	{930, 12}, {936, 12}, {936, 9}, {943, 12}, {936, 15}, {936, 12}, {-1, -1},
	{820, 4}, {820, 22}, {930, 22}, {930, 4}, {820, 4}, {-1, -1},
	{755, 37}, {755, 68}, {815, 68}, {815, 37}, {755, 37}, {790, 37}, {790, 34}, {-1, -1},
	{780, 155}, {770, 165}, {770, 285}, {936, 285}, {936, 233}, {-1, -1},
	{780, 245}, {770, 255}, {-1, -1},
	{790, 249}, {790, 260}, {872, 260}, {872, 30}, {869, 30}, {872, 25}, {875, 30}, {872, 30}, {-1, -1},
	// The Electroswitch and connections
	{943, 100}, {940, 100}, {940, 187}, {955, 187}, {-1, -1},
	{977, 143}, {983, 143}, {983, 187}, {970, 187}, {-1, -1},
	{963, 182}, {963, 234}, {-1, -1},
	{950, 198}, {946, 202}, {-1, -1},
	{1004, 0}, {1004, 290}, {-1, -1}, // FX
	{1046, 4}, {1046, 22}, {1130, 22}, {1130, 4}, {1046, 4}, {-1, -1},
	{1200, 4}, {1200, 22}, {1285, 22}, {1285, 4}, {1200, 4}, {-1, -1},
	{1037, 70},
	{1050, 45},
	{1050, 28},
	{1048, 28},
	{1050, 25},
	{1052, 28},
	{1050, 28},
	{-1, -1},
	{1071, 70},
	{1076, 45},
	{1076, 28},
	{1074, 28},
	{1076, 25},
	{1078, 28},
	{1076, 28},
	{-1, -1},
	{1105, 70},
	{1100, 45},
	{1100, 28},
	{1098, 28},
	{1100, 25},
	{1102, 28},
	{1100, 28},
	{-1, -1},
	{1139, 70},
	{1123, 45},
	{1123, 28},
	{1121, 28},
	{1123, 25},
	{1125, 28},
	{1123, 28},
	{-1, -1},
	{1037 + 158, 70},
	{1208, 45},
	{1208, 28},
	{1206, 28},
	{1208, 25},
	{1210, 28},
	{1208, 28},
	{-1, -1},
	{158 + 1071, 70},
	{158 + 1076, 45},
	{158 + 1076, 28},
	{158 + 1074, 28},
	{158 + 1076, 25},
	{158 + 1078, 28},
	{158 + 1076, 28},
	{-1, -1},
	{158 + 1105, 70},
	{158 + 1100, 45},
	{158 + 1100, 28},
	{158 + 1098, 28},
	{158 + 1100, 25},
	{158 + 1102, 28},
	{158 + 1100, 28},
	{-1, -1},
	{158 + 1139, 70},
	{158 + 1123, 45},
	{158 + 1123, 28},
	{158 + 1121, 28},
	{158 + 1123, 25},
	{158 + 1125, 28},
	{158 + 1123, 28},
	{-1, -1},

	{1334, 0}, {1334, 290}, {-1, -1},// PROG 
	// IN/OUT
};
bvgVect arpMODBox = {
	aMOD,
	arpMODBoxCoords
};

#define aMIX 158
bvgCoords arpMIXBoxCoords[aMIX] = {
	{0, 10},
	{0, 200},
	// Main Box
	{-1, -1}, {11, 83}, {11, 95}, {80, 95}, {80, 83}, {11, 83},
	// Mix Arrows
	{-1, -1}, {26, 116}, {26, 114}, {24, 114}, {26, 112}, {28, 114}, {24, 114},
	{-1, -1}, {68, 116}, {68, 114}, {66, 114}, {68, 112}, {70, 114}, {66, 114},
	{-1, -1}, {26, 95}, {26, 98}, {24, 98}, {26, 100}, {28, 98}, {24, 98},
	{-1, -1}, {68, 95}, {68, 98}, {66, 98}, {68, 100}, {70, 98}, {66, 98},
	// Diverse lines
	{-1, -1}, {47, 83}, {47, 79},
	{-1, -1}, {47, 68}, {47, 66}, {56, 61},
	{-1, -1}, {76, 52}, {85, 47},
	{-1, -1}, {110, 69}, {110, 64}, {73, 47}, {6, 47}, {6, 25}, {13, 25}, {13, 20}, {29, 25}, {13, 30}, {13, 22},
	{-1, -1}, {6, 41}, {16, 41},
	{-1, -1}, {6, 47}, {16, 52},
	// Pan lines
	{-1, -1}, {77, 35}, {30, 35}, {30, 34}, {24, 35}, {30, 36}, {30, 35},
	{-1, -1}, {110, 35}, {150, 35}, {150, 34}, {156, 35}, {150, 36}, {150, 35},
	// Delay lines and box
	{-1, -1}, {95, 134}, {95, 143}, {165, 143}, {165, 134}, {95, 134},
	{-1, -1}, {110, 134}, {110, 121}, {108, 121}, {110, 118}, {112, 121}, {110, 121},
	{-1, -1}, {152, 134}, {152, 121}, {150, 121}, {152, 118}, {154, 121}, {152, 121},
	{-1, -1}, {110, 170}, {110, 147}, {108, 147}, {110, 144}, {112, 147}, {110, 147},
	// Outer line
	{-1, -1},
	{163, 155},
	{172, 152},
	{172, 25},
	{162, 25},
	{162, 20},
	{146, 25},
	{162, 30},
	{162, 25},
	{-1, -1},
	{172, 41},
	{166, 41},
	{-1, -1},
	{172, 57},
	{169, 57},
	{-1, -1},
	{172, 64},
	{154, 70},
	// Input Arrows
	{-1, -1},
	{6, 187},
	{6, 199},
	{43, 199},
	{43, 187},
	{6, 187},
	{27, 187},
	{27, 184},
	{25, 184},
	{27, 182},
	{29, 184},
	{26, 184},
	{-1, -1},
	{47, 187},
	{47, 199},
	{87, 199},
	{87, 187},
	{47, 187},
	{71, 187},
	{71, 184},
	{69, 184},
	{71, 182},
	{73, 184},
	{69, 184},
	{-1, -1},
	{90, 187},
	{90, 199},
	{134, 199},
	{134, 187},
	{90, 187},
	{110, 187},
	{110, 184},
	{108, 184},
	{110, 182},
	{112, 184},
	{108, 184},
};
bvgVect arpMIXBox = {
	aMIX,
	arpMIXBoxCoords
};

#define aVCA 97
bvgCoords arpVCABoxCoords[aVCA] = {
	{0, 10},
	{0, 200},
	// Main Box
	{-1, -1},
	{38, 82},
	{38, 97},
	{126, 97},
	{126, 82},
	{38, 82},
	{-1, -1},
	{126, 90},
	{132, 90},
	{132, 89},
	{139, 90},
	{132, 91},
	{132, 90},
	// Input Arrows
	{-1, -1},
	{28, 115},
	{10, 96},
	{10, 84},
	{30, 84},
	{30, 83},
	{37, 84},
	{30, 85},
	{30, 84},
	{-1, -1},
	{70, 115},
	{21, 96},
	{21, 93},
	{30, 93},
	{30, 92},
	{37, 93},
	{30, 94},
	{30, 93},
	{-1, -1},
	{110, 115},
	{68, 102},
	{68, 100},
	{66, 100},
	{68, 98},
	{70, 100},
	{68, 100},
	{-1, -1},
	{150, 115},
	{108, 102},
	{108, 100},
	{106, 100},
	{108, 98},
	{110, 100},
	{108, 100},
	{-1, -1},
	{6, 187},
	{6, 199},
	{43, 199},
	{43, 187},
	{6, 187},
	{27, 187},
	{27, 184},
	{25, 184},
	{27, 182},
	{29, 184},
	{26, 184},
	{-1, -1},
	{47, 187},
	{47, 199},
	{87, 199},
	{87, 187},
	{47, 187},
	{71, 187},
	{71, 184},
	{69, 184},
	{71, 182},
	{73, 184},
	{69, 184},
	{-1, -1},
	{90, 187},
	{90, 199},
	{130, 199},
	{130, 187},
	{90, 187},
	{110, 187},
	{110, 184},
	{108, 184},
	{110, 182},
	{112, 184},
	{108, 184},
	{-1, -1},
	{134, 187},
	{134, 199},
	{173, 199},
	{173, 187},
	{134, 187},
	{152, 187},
	{152, 184},
	{150, 184},
	{152, 182},
	{154, 184},
	{153, 184},
};
bvgVect arpVCABox = {
	aVCA,
	arpVCABoxCoords
};

/*
 * Stuff for the ARP. There will be lots, might break it out
 */
#define aVCF 196
bvgCoords arpVCFBoxCoords[aVCF] = {
	{0, 10},
	{0, 200},
	// Main Box
	{-1, -1},
	{156, 82},
	{156, 97},
	{284, 97},
	{284, 82},
	{156, 82},
	{-1, -1},
	{284, 90},
	{293, 90},
	{293, 89},
	{300, 90},
	{293, 91},
	{293, 90},
	// Input Arrows
	{-1, -1},
	{30, 115},
	{30, 110},
	{98, 84},
	//{152, 84},
	{147, 84},
	{147, 83},
	{152, 84},
	{147, 85},
	{147, 84},
	{-1, -1},
	{70, 115},
	{70, 110},
	{102, 87},
	{147, 87},
	{147, 86},
	{152, 87},
	{147, 88},
	{147, 87},
	{-1, -1},
	{110, 115},
	{110, 110},
	{110, 90},
	{147, 90},
	{147, 89},
	{152, 90},
	{147, 91},
	{147, 90},
	{-1, -1},
	{152, 115},
	{152, 110},
	{123, 93},
	{147, 93},
	{147, 92},
	{152, 93},
	{147, 94},
	{-1, -1},
	{194, 115},
	{194, 110},
	{135, 96},
	{147, 96},
	{147, 95},
	{152, 96},
	{147, 97},
	{147, 96},
	{-1, -1},
	{237, 115},
	{237, 100},
	{234, 100},
	{237, 98},
	{240, 100},
	{237, 100},
	{-1, -1},
	{280, 115},
	{280, 112},
	{254, 106},
	{254, 100},
	{251, 100},
	{254, 98},
	{257, 100},
	{254, 100},
	{-1, -1},
	{321, 115},
	{321, 112},
	{270, 106},
	{270, 100},
	{267, 100},
	{270, 98},
	{273, 100},
	{270, 100},
	{-1, -1},
	{27, 170},
	{27, 167},
	{81, 167},
	{-1, -1},
	{194, 170},
	{194, 167},
	{139, 167},
	{-1, -1},
	{235, 170},
	{235, 167},
	{244, 167},
	{-1, -1},
	{320, 170},
	{320, 167},
	{313, 167},
	{-1, -1},
	{6, 187},
	{6, 199},
	{48, 199},
	{48, 187},
	{6, 187},
	{27, 187},
	{27, 184},
	{25, 184},
	{27, 182},
	{29, 184},
	{26, 184},
	{-1, -1},
	{52, 187},
	{52, 199},
	{87, 199},
	{87, 187},
	{52, 187},
	{71, 187},
	{71, 184},
	{69, 184},
	{71, 182},
	{73, 184},
	{69, 184},
	{-1, -1},
	{90, 187},
	{90, 199},
	{130, 199},
	{130, 187},
	{90, 187},
	{110, 187},
	{110, 184},
	{108, 184},
	{110, 182},
	{112, 184},
	{108, 184},
	{-1, -1},
	{134, 187},
	{134, 199},
	{170, 199},
	{170, 187},
	{134, 187},
	{152, 187},
	{152, 184},
	{150, 184},
	{152, 182},
	{154, 184},
	{153, 184},
	{-1, -1},
	{174, 187},
	{174, 199},
	{216, 199},
	{216, 187},
	{174, 187},
	{195, 187},
	{195, 184},
	{191, 184},
	{195, 182},
	{197, 184},
	{193, 184},
	{-1, -1},
	{220, 187},
	{220, 199},
	{256, 199},
	{256, 187},
	{220, 187},
	{232, 187},
	{232, 184},
	{230, 184},
	{232, 182},
	{234, 184},
	{232, 184},
	{-1, -1},
	{260, 187},
	{260, 199},
	{302, 199},
	{302, 187},
	{260, 187},
	{278, 187},
	{278, 184},
	{276, 184},
	{278, 182},
	{280, 184},
	{278, 184},
	{-1, -1},
	{306, 187},
	{306, 199},
	{344, 199},
	{344, 187},
	{306, 187},
	{321, 187},
	{321, 184},
	{319, 184},
	{321, 182},
	{323, 184},
	{321, 184},
};
bvgVect arpVCFBox = {
	aVCF,
	arpVCFBoxCoords
};

#define aADSR 85
bvgCoords arpADSRBoxCoords[aADSR] = {
	{0, 10},
	{0, 200},
	{-1, -1},
	{15, 82},
	{15, 97},
	{110, 97},
	{110, 82},
	{15, 82},
	{-1, -1},
	{110, 90},
	{120, 90},
	{120, 89},
	{127, 90},
	{120, 91},
	{120, 89},
	{-1, -1},
	{72, 153},
	{72, 165},
	{140, 165},
	{140, 153},
	{72, 153},
	{105, 153},
	{105, 149},
	{80, 149},
	{80, 150},
	{72, 149},
	{80, 148},
	{80, 150},
	{-1, -1},
	{87, 165},
	{87, 167},
	{96, 170},
	{-1, -1},
	{125, 165},
	{125, 167},
	{134, 170},
	{-1, -1},
	{66, 170},
	{58, 167},
	{58, 160},
	{56, 160},
	{58, 158},
	{60, 160},
	{58, 160},
	// AR BOX
	{-1, -1},
	{55, 129},
	{55, 140},
	{130, 140},
	{130, 129},
	{55, 129},
	{-1, -1},
	{58, 145},
	{58, 143},
	{56, 143},
	{58, 141},
	{60, 143},
	{58, 140},
	{-1, -1},
	{110, 129},
	{110, 127},
	{-1, -1},
	{105, 193},
	{107, 193},
	{107, 191},
	{114, 191},
	{114, 193},
	{116, 193},
	{-1, -1},
	{140, 193},
	{142, 193},
	{142, 191},
	{142, 193},
	{155, 193},
	{-1, -1},
	{48, 187},
	{48, 199},
	{87, 199},
	{87, 187},
	{48, 187},
	{71, 187},
	{71, 184},
	{69, 184},
	{71, 182},
	{73, 184},
	{69, 184},
};
bvgVect arpADSRBox = {
	aADSR,
	arpADSRBoxCoords
};

bvgImage arpImage = {
	1771, 1000,
	0x00000000,
	204,
	{
		{{BVG_STRING, BLUE_WHITE2, 47, 74, 20, 8, "on"}}, // ODD MODS
		{{BVG_STRING, BLUE_WHITE2, 113, 135, 130, 8, "MAX        GLIDE"}},
		{{BVG_STRING, BLUE_WHITE2, 75, 214, 110, 8, "PREAMPLIFIER"}},
		{{BVG_STRING, BLUE_WHITE2, 195, 245, 25, 6, "OUT"}},
		{{BVG_VECT, BLUE_WHITE2, 38, 101, 200, 120, (char *) &arpPABox}},
		{{BVG_STRING, BLUE_WHITE2, 47, 278, 80, 8, "ENVELOPE"}},
		{{BVG_STRING, BLUE_WHITE2, 47, 290, 80, 8, "FOLLOWER"}},
		{{BVG_STRING, BLUE_WHITE2, 136, 278, 40, 8, "RING"}},
		{{BVG_STRING, BLUE_WHITE2, 140, 290, 30, 8, "MOD"}},
		{{BVG_STRING, BLUE_WHITE2, 195, 310, 25, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 185, 345, 45, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 82, 470, 25, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 199, 533, 18, 7, "DC"}},
		{{BVG_STRING, BLUE_WHITE2, 44, 607, 28, 8, "PRE"}},
		{{BVG_STRING, BLUE_WHITE2, 44, 621, 28, 8, "AMP"}},
		{{BVG_STRING, BLUE_WHITE2, 115, 607, 36, 8, "VCO1"}},
		{{BVG_STRING, BLUE_WHITE2, 190, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 116, 620, 24, 9, (char *) &rampWave}},
		{{BVG_VECT|2, BLUE_WHITE2, 195, 620, 24, 9, (char *) &sineWave}},
		{{BVG_STRING, BLUE_WHITE2, 240, 45, 200, 8, "INITIAL OSC FREQUENCY"}},
		{{BVG_STRING, BLUE_WHITE2, 240, 63, 200, 8, "  -7             +7  "}},
		{{BVG_STRING, BLUE_WHITE2, 240, 74, 200, 8, " .03   0.3  3.0  30  "}},
		{{BVG_STRING, BLUE_WHITE2, 240, 115, 200, 8, "      FINE TUNE      "}},
		{{BVG_STRING, BLUE_WHITE2, 240, 155, 200, 8, " OSCILLATOR SYNC "}},
		{{BVG_STRING, BLUE_WHITE2, 304, 200, 80, 8, "1<-2 SYNC"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 185, 25, 8, "2'"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 201, 25, 8, "4'"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 218, 25, 8, "8'"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 234, 30, 8, "16'"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 252, 35, 8, "32'"}},
		{{BVG_STRING, BLUE_WHITE2, 372, 230, 30, 6, "SAW"}},
		{{BVG_STRING, BLUE_WHITE2, 372, 288, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 358, 346, 60, 6, "SQUARE"}},
		{{BVG_VECT, BLUE_WHITE2, 232, 10, 100, 315, (char *) &arpVCO1Box}},
		{{BVG_STRING|3, BLUE_WHITE2, 278, 280, 85, 20, "VCO1"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 430, 30, 8, "LFO"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 445, 40, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 258, 460, 30, 8, "KBD"}},
		{{BVG_STRING, BLUE_WHITE2, 280, 530, 100, 8, "FM CONTROL"}},
		{{BVG_STRING, BLUE_WHITE2, 250, 607, 28, 8, "KBD"}},
		{{BVG_STRING, BLUE_WHITE2, 254, 621, 18, 8, "CV"}},
		{{BVG_STRING, BLUE_WHITE2, 290, 607, 28, 8, "S/H"}},
		{{BVG_STRING, BLUE_WHITE2, 290, 621, 28, 8, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 326, 612, 36, 8, "ADSR"}},
		{{BVG_STRING, BLUE_WHITE2, 372, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 374, 620, 24, 9, (char *) &sineWave}},
		{{BVG_VECT, BLUE_WHITE2, 413, 10, 100, 315, (char *) &arpVCO1Box}},
		{{BVG_STRING|3, BLUE_WHITE2, 454, 280, 85, 20, "VCO2"}},
		{{BVG_STRING, BLUE_WHITE2, 440, 45, 200, 8, "INITIAL OSC FREQUENCY"}},
		{{BVG_STRING, BLUE_WHITE2, 440, 63, 200, 8, "  -7             +7  "}},
		{{BVG_STRING, BLUE_WHITE2, 440, 74, 200, 8, " .03   0.3  3.0  30  "}},
		{{BVG_STRING, BLUE_WHITE2, 440, 115, 200, 8, "      FINE TUNE      "}},
		{{BVG_STRING, BLUE_WHITE2, 440, 165, 200, 8, " 10%   50%   90% "}},
		{{BVG_STRING, BLUE_WHITE2, 440, 190, 200, 8, "   PULSE WIDTH   "}},
		{{BVG_STRING, BLUE_WHITE2, 438, 185, 25, 8, "2'"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 201, 25, 8, "4'"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 218, 25, 8, "8'"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 234, 30, 8, "16'"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 252, 35, 8, "32'"}},
		{{BVG_STRING, BLUE_WHITE2, 547, 230, 100, 6, "TRIANGLE  SAW"}},
		{{BVG_STRING, BLUE_WHITE2, 552, 288, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 552, 346, 90, 6, "SINE  PULSE"}},
		{{BVG_STRING, BLUE_WHITE2, 552, 360, 90, 6, "       PWM "}},
		{{BVG_STRING, BLUE_WHITE2, 438, 430, 30, 8, "LFO"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 445, 40, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 438, 460, 30, 8, "KBD"}},
		{{BVG_STRING, BLUE_WHITE2, 455, 530, 190, 8, "FM CONTROL    PWM"}},
		{{BVG_STRING, BLUE_WHITE2, 430, 607, 28, 8, "KBD"}}, // 180
		{{BVG_STRING, BLUE_WHITE2, 434, 621, 18, 8, "CV"}},
		{{BVG_STRING, BLUE_WHITE2, 470, 607, 28, 8, "S/H"}},
		{{BVG_STRING, BLUE_WHITE2, 470, 621, 28, 8, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 506, 612, 36, 8, "ADSR"}},
		{{BVG_STRING, BLUE_WHITE2, 553, 607, 36, 8, "VCO1"}},
		{{BVG_VECT|2, BLUE_WHITE2, 554, 620, 24, 9, (char *) &squareWave}},
		{{BVG_STRING, BLUE_WHITE2, 596, 607, 36, 8, "NOISE"}},
		{{BVG_STRING, BLUE_WHITE2, 596, 621, 36, 8, " GEN "}},
		{{BVG_VECT, BLUE_WHITE2, 413, 10, 100, 315, (char *) &arpVCO1aBox}},
		{{BVG_VECT, BLUE_WHITE2, 635, 10, 100, 315, (char *) &arpVCO1Box}},
		{{BVG_STRING|3, BLUE_WHITE2, 222 + 454, 280, 85, 20, "VCO3"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 45, 200, 8, "INITIAL OSC FREQUENCY"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 63, 200, 8, "  -7             +7  "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 74, 200, 8, " .03   0.3  3.0  30  "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 115, 200, 8, "      FINE TUNE      "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 165, 200, 8, " 10%   50%   90% "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 440, 190, 200, 8, "   PULSE WIDTH   "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 185, 25, 8, "2'"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 201, 25, 8, "4'"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 218, 25, 8, "8'"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 234, 30, 8, "16'"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 252, 35, 8, "32'"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 547, 230, 100, 6, "TRIANGLE  SAW"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 552, 288, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 552, 346, 90, 6, "SINE  PULSE"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 552, 360, 90, 6, "       PWM "}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 430, 30, 8, "LFO"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 445, 40, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 438, 460, 30, 8, "KBD"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 455, 530, 190, 8, "FM CONTROL    PWM"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 430, 607, 28, 8, "KBD"}}, // 180
		{{BVG_STRING, BLUE_WHITE2, 222 + 434, 621, 18, 8, "CV"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 467, 607, 36, 8, "NOISE"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 471, 621, 28, 8, "GEN"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 506, 612, 36, 8, "ADSR"}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 553, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 222 + 554, 620, 24, 9, (char *) &sineWave}},
		{{BVG_STRING, BLUE_WHITE2, 222 + 596, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 222 + 596, 620, 24, 9, (char *) &triWave}},
		{{BVG_VECT, BLUE_WHITE2, 222 + 413, 10, 100, 315, (char *) &arpVCO1aBox}},
		{{BVG_VECT, BLUE_WHITE2, 857, 10, 100, 315, (char *) &arpVCFBox}},
		{{BVG_STRING, BLUE_WHITE2, 950, 45, 200, 8, "INITIAL FILT FREQUENCY"}},
		{{BVG_STRING, BLUE_WHITE2, 950, 74, 200, 8, "10HZ 100HZ 1KHZ 10KHZ"}},
		{{BVG_STRING, BLUE_WHITE2, 950, 115, 200, 8, "      RESONANCE      "}},
		{{BVG_STRING|3, BLUE_WHITE2, 1038, 280, 85, 20, "VCF"}},
		{{BVG_STRING, BLUE_WHITE2, 1168, 315, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 946, 530, 250, 8, "AUDIO             CONTROL"}},
		{{BVG_STRING, BLUE_WHITE2, 869, 607, 36, 8, "RING"}}, // 180
		{{BVG_STRING, BLUE_WHITE2, 872, 621, 28, 8, "MOD"}},
		{{BVG_STRING, BLUE_WHITE2, 913, 607, 36, 8, "VCO1"}},
		{{BVG_VECT|2, BLUE_WHITE2, 913, 620, 24, 9, (char *) &squareWave}},
		{{BVG_STRING, BLUE_WHITE2, 951, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 951, 620, 24, 9, (char *) &squareWave}},
		{{BVG_STRING, BLUE_WHITE2, 995, 607, 36, 8, "VCO3"}},
		{{BVG_VECT|2, BLUE_WHITE2, 996, 620, 24, 9, (char *) &triWave}},
		{{BVG_STRING, BLUE_WHITE2, 1036, 607, 36, 8, "NOISE"}},
		{{BVG_STRING, BLUE_WHITE2, 1038, 621, 28, 8, "GEN"}},
		{{BVG_STRING, BLUE_WHITE2, 1083, 607, 28, 8, "KBD"}},
		{{BVG_STRING, BLUE_WHITE2, 1087, 621, 20, 8, "CV"}},
		{{BVG_STRING, BLUE_WHITE2, 1122, 612, 36, 8, "ADSR"}},
		{{BVG_STRING, BLUE_WHITE2, 1166, 607, 36, 8, "VCO2"}},
		{{BVG_VECT|2, BLUE_WHITE2, 1168, 620, 24, 9, (char *) &sineWave}},
		{{BVG_VECT, BLUE_WHITE2, 1205, 10, 100, 315, (char *) &arpADSRBox}},
		{{BVG_STRING, BLUE_WHITE2, 1210, 52, 200, 8, "  A     D    S    R  "}},
		{{BVG_STRING, BLUE_WHITE2, 1210, 74, 200, 8, "TIME  TIME VOLT  TIME"}},
		{{BVG_STRING|3, BLUE_WHITE2, 1225, 280, 85, 20, "ADSR"}},
		{{BVG_STRING, BLUE_WHITE2, 1348, 315, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 1210, 342, 200, 8, "  A  MANUAL       R  "}},
		{{BVG_STRING, BLUE_WHITE2, 1210, 360, 200, 8, "TIME START  OUT  TIME"}},
		{{BVG_STRING|3, BLUE_WHITE2, 1275, 425, 45, 16, "AR"}},
		{{BVG_STRING, BLUE_WHITE2, 1283, 498, 70, 8, "KEYBOARD"}},
		{{BVG_STRING, BLUE_WHITE2, 1284, 513, 70, 8, "GATE/TRIG"}},
		{{BVG_STRING, BLUE_WHITE2, 1295, 583, 90, 8, "GATE TRIG"}},
		{{BVG_STRING, BLUE_WHITE2, 1260, 607, 28, 8, "S/H"}},
		{{BVG_STRING, BLUE_WHITE2, 1256, 621, 36, 8, "GATE"}},
		{{BVG_VECT, BLUE_WHITE2, 1382, 10, 100, 315, (char *) &arpVCABox}},
		{{BVG_STRING, BLUE_WHITE2, 1400, 72, 200, 8, "MASTER VOLUME  "}},
		{{BVG_STRING, BLUE_WHITE2, 1400, 115, 200, 8, "PROGRAM VOLUME  "}},
		{{BVG_STRING, BLUE_WHITE2, 1400, 160, 200, 8, "INITIAL VOLUME  "}},
		{{BVG_STRING, BLUE_WHITE2, 1530, 315, 30, 6, "OUT"}},
		{{BVG_STRING|3, BLUE_WHITE2, 1430, 280, 70, 20, "VCA"}},
		{{BVG_STRING, BLUE_WHITE2, 1410, 530, 50, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 1396, 612, 28, 8, "VCF"}},
		{{BVG_STRING, BLUE_WHITE2, 1432, 607, 36, 8, "RING"}},
		{{BVG_STRING, BLUE_WHITE2, 1436, 621, 28, 8, "MOD"}},
		{{BVG_STRING, BLUE_WHITE2, 1476, 612, 36, 8, " AR "}},
		{{BVG_STRING, BLUE_WHITE2, 1520, 612, 36, 8, "ADSR"}},
		{{BVG_VECT, BLUE_WHITE2, 1562, 10, 100, 315, (char *) &arpMIXBox}},
		{{BVG_STRING, BLUE_WHITE2, 1585, 45, 160, 10, "LEFT    RIGHT"}},
		{{BVG_STRING, BLUE_WHITE2, 1585, 62, 160, 8, " OUT    OUT  "}},
		{{BVG_STRING, BLUE_WHITE2, 1645, 115, 28, 8, "PAN"}},
		{{BVG_STRING, BLUE_WHITE2, 1575, 207, 190, 8, "LEFT        RIGHT "}},
		{{BVG_STRING|2, BLUE_WHITE2, 1580, 285, 60, 10, "MIXER"}},
		{{BVG_STRING|2, BLUE_WHITE2, 1667, 440, 60, 10, "DELAY"}},
		{{BVG_STRING, BLUE_WHITE2, 1584, 530, 50, 8, "AUDIO"}},
		{{BVG_STRING, BLUE_WHITE2, 1574, 612, 28, 8, "VCF"}},
		{{BVG_STRING, BLUE_WHITE2, 1618, 612, 28, 8, "VCA"}},
		{{BVG_STRING, BLUE_WHITE2, 1658, 607, 40, 8, "MIXER"}},
		{{BVG_STRING, BLUE_WHITE2, 1658, 621, 40, 8, " OUT "}},
		{{BVG_VECT, BLUE_WHITE2, 40, 660, 100, 100, (char *) &arpMODBox}},
		{{BVG_STRING, BLUE_WHITE2, 155, 669, 160, 10, "NOISE GENERATOR"}},
		{{BVG_STRING, BLUE_WHITE2, 175, 717, 88, 8, "WHITE MAX"}},
		{{BVG_STRING, BLUE_WHITE2, 145, 795, 42, 8, "PINK"}},
		{{BVG_STRING, BLUE_WHITE2, 165, 883, 96, 8, "LO-FREQ  MIN"}},
		{{BVG_STRING, BLUE_WHITE2, 245, 774, 52, 6, "NOISE"}},
		{{BVG_STRING, BLUE_WHITE2, 255, 825, 30, 6, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 430, 669, 180, 10, "VOLTAGE PROCESSORS"}},
		{{BVG_STRING, BLUE_WHITE2, 450, 755, 160, 10, "INVERTING MIXER"}},
		{{BVG_STRING, BLUE_WHITE2, 450, 853, 160, 10, "INVERTING MIXER"}},
		{{BVG_STRING, BLUE_WHITE2, 460, 907, 140, 10, "LAG PROCESSOR"}},
		{{BVG_STRING, BLUE_WHITE2, 640, 888, 28, 10, "LAG"}},
		{{BVG_STRING, BLUE_WHITE2, 750, 767, 28, 10, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 750, 860, 28, 10, "OUT"}},
		{{BVG_STRING, BLUE_WHITE2, 867, 669, 120, 10, "SAMPLE+HOLD"}},
		{{BVG_STRING, BLUE_WHITE2, 800, 700, 58, 10, "NOISE"}},
		{{BVG_STRING, BLUE_WHITE2, 800, 715, 58, 10, " GEN "}},
		{{BVG_STRING, BLUE_WHITE2, 880, 718, 90, 10, "LVL RATE"}},
		{{BVG_STRING, BLUE_WHITE2, 973, 718, 70, 8, "ELECTRO"}},
		{{BVG_STRING, BLUE_WHITE2, 974, 730, 70, 8, "SWITCH"}},
		{{BVG_STRING, BLUE_WHITE2, 953, 828, 30, 8, "EXT"}},
		{{BVG_STRING, BLUE_WHITE2, 953, 840, 30, 8, "CLK"}},
		{{BVG_STRING, BLUE_WHITE2, 810, 758, 58, 8, "CLOCK"}},
		{{BVG_STRING, BLUE_WHITE2, 810, 773, 58, 8, " OUT "}},
		{{BVG_STRING, BLUE_WHITE2, 923, 902, 50, 8, "SYNC"}},
		{{BVG_STRING, BLUE_WHITE2, 850, 888, 58, 8, "CLOCK"}},
		{{BVG_STRING, BLUE_WHITE2, 850, 903, 58, 8, " IN  "}},
		{{BVG_STRING, BLUE_WHITE2, 1020, 755, 10, 8, "A"}},
		{{BVG_STRING, BLUE_WHITE2, 1020, 793, 10, 8, "B"}},
		{{BVG_STRING, BLUE_WHITE2, 1020, 895, 10, 8, "C"}},
		{{BVG_STRING, BLUE_WHITE2, 850, 950, 120, 8, "INTERNAL CLOCK"}},
		{{BVG_STRING, BLUE_WHITE2, 1095, 669, 80, 10, "CHORUS"}},
		{{BVG_STRING, BLUE_WHITE2, 1252, 669, 70, 10, "DELAY"}},
		{{BVG_STRING, BLUE_WHITE2, 1060, 885, 160, 8, "RATE DEPTH SPIN GAIN"}},
		{{BVG_STRING, BLUE_WHITE2, 1220, 885, 160, 8, "TIME FEED CROSS GAIN"}},
		{{BVG_STRING, BLUE_WHITE2, 1480, 885, 50, 8, "PROG"}},
		{{BVG_STRING, BLUE_WHITE2, 1480, 910, 50, 8, "MIDI"}},
	}
};

bvgImage odysseyMemImage = {
	1200, 100,
	0x00000000,
	4,
	{
		{{BVG_STRING, BVG_WHITE, 20, 80, 200, 12, "MARK I/II  DOWN   UP"}},
		{{BVG_STRING, BVG_WHITE, 148, 45, 35, 12, "MIDI"}},
		{{BVG_STRING, BVG_WHITE, 225, 80, 440, 12, "LOAD     1    2    3    4    5    6    7    8"}},
		{{BVG_STRING, BVG_WHITE, 643, 80, 440, 12, "1    2    3    4    5    6    7    8     SAVE"}},
	}
};

bvgImage odysseyImage = {
	1200, 600,
	0x00000000,
	68,
	{
		{{BVG_STRING, BVG_WHITE, 150, 22, 360, 8, "FREQUENCY              FREQUENCY       "}},
		{{BVG_STRING, BVG_WHITE, 94, 35, 420, 8, "NOISE  COARSE FINE KBD        COARSE FINE SYNC"}},
		{{BVG_STRING, BVG_WHITE, 60, 60, 40, 8, "PINK"}},
		{{BVG_STRING, BVG_WHITE, 55, 77, 45, 8, "WHITE"}},
		{{BVG_STRING, BVG_WHITE, 94, 103, 420, 8, "                   LFO                   OFF  "}},
		{{BVG_STRING, BVG_WHITE, 420, 196, 40, 8, "DUAL"}},
		{{BVG_STRING, BVG_WHITE, 96, 230, 420, 8, "         VOLTAGE                VOLTAGE       "}},
		{{BVG_STRING, BVG_WHITE, 96, 242, 420, 8, "        CONTROLLED             CONTROLLED     "}},
		{{BVG_STRING, BVG_WHITE, 96, 254, 420, 8, "        OSCILLATOR             OSCILLATOR     "}},
		{{BVG_STRING, BVG_WHITE, 96, 266, 420, 8, "            1                      2          "}},
		{{BVG_STRING, BVG_WHITE, 240, 307, 360, 8, "PW PWM            PW PWM        "}},
		{{BVG_VECT|2, OFF_WHITE, 280, 230, 24, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 280, 270, 24, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 460, 230, 24, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 460, 270, 24, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 617, 100, 16, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 617, 140, 16, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 63, 307, 90, 8, "TRANSPOSE"}},
		{{BVG_STRING, BVG_WHITE, 100, 345, 20, 8, "+1"}},
		{{BVG_STRING, BVG_WHITE, 100, 445, 20, 8, "-1"}},
		{{BVG_STRING, BVG_WHITE, 25, 463, 50, 8, "GLIDE"}},
		{{BVG_STRING, BVG_WHITE, 25, 560, 130, 8, "PITCH CONTROL"}},
		{{BVG_STRING, BVG_WHITE, 507, 19, 800, 8, "                   LFO   VCF   VCF                    HPF           VCA   ENV                       "}},
		{{BVG_STRING, BVG_WHITE, 507, 35, 800, 8, "                  FREQ   FREQ  RES                    FREQ          GAIN   A     R                  "}},
		{{BVG_STRING, BVG_WHITE, 510, 290, 800, 8, "                                                                                ENV                 "}},
		{{BVG_STRING, BVG_WHITE, 510, 109, 800, 8, "    LOW                                                                                             "}},
		{{BVG_STRING, BVG_WHITE, 512, 123, 800, 8, " FREQUENCY                                                                                          "}},
		{{BVG_STRING, BVG_WHITE, 510, 137, 800, 8, " OSCILLATOR                                                                                         "}},
		{{BVG_STRING, BVG_WHITE, 510, 236, 800, 8, "                                       VOLTAGE     HIGH      VOLTAGE                                "}},
		{{BVG_STRING, BVG_WHITE, 510, 250, 800, 8, "    SH          SH         AUDIO     CONTROLLED    PASS     CONTROLLED                              "}},
		{{BVG_STRING, BVG_WHITE, 510, 264, 800, 8, "   MIXER                   MIXER       FILTER     FILTER    AMPLIFIER                               "}},
		{{BVG_STRING, BVG_WHITE, 510, 307, 800, 8, "                 OUTPUT                                                    A    D     S     R       "}},
		{{BVG_STRING, BVG_WHITE, 155, 465, 420, 8, "   FM                        FM                   "}},
		{{BVG_STRING, BVG_WHITE, 153, 481, 420, 8, " LFO   SH         LFO      LFO   SH         LFO   "}},
		{{BVG_VECT|2, OFF_WHITE, 158, 495, 20, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 280, 495, 20, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 342, 495, 20, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 462, 495, 20, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 522, 495, 20, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 726, 495, 20, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 766, 495, 20, 10, (char *) &sawWave}},
		{{BVG_STRING, BVG_WHITE, 155, 560, 420, 8, " LFO  ADSR        ADSR     SH   ADSR        ADSR  "}},
		{{BVG_VECT|2, OFF_WHITE, 158, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 198, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 282, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 376, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 465, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 524, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 562, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 727, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 768, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 850, 574, 20, 10, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 889, 495, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 985, 495, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 889, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 985, 574, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 1028, 574, 20, 10, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 1150, 574, 20, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 155, 574, 420, 8, "                          MIX                     "}},
		{{BVG_STRING, BVG_WHITE, 510, 481, 800, 8, " VCO1 NOISE  TRIG       NOISE  VCO1 VCO2  KBD   SH   ADSR           AR         ADSR         AR      "}},
		{{BVG_STRING, BVG_WHITE, 510, 495, 800, 8, "             KBD                                                          KBD         KBD   KBD     "}},
		{{BVG_STRING, BVG_WHITE, 507, 560, 800, 8, "                         RING  VCO1  VCO2   SH   LFO   AR           ADSR REPEAT       AUTO REPEAT   "}},
		{{BVG_STRING, BVG_WHITE, 507, 574, 800, 8, "                         MOD               MIX                                                      "}},
		{{BVG_VECT|2, OFF_WHITE, 1060, 16, 20, 10, (char *) &env}},
		{{BVG_VECT|2, OFF_WHITE, 1100, 285, 20, 10, (char *) &env}},
		{{BVG_VECT, OFF_WHITE, 40, 495, 12, 10, (char *) &flat}},
		{{BVG_VECT, OFF_WHITE, 73, 495, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 106, 495, 10, 10, (char *) &sharp}},
	}
};

bvgImage subMiniImage = {
	680, 400,
	0x00000000,
	2,
	{
		{{BVG_VECT, OFF_WHITE, 0, 0, 34, 53, (char *) &pot}},
		{{BVG_STRING, OFF_WHITE, 4, 55, 35, 8, "O    1O"}},
	}
};

bvgImage subMiniImage2 = {
	680, 400,
	0x00000000,
	3,
	{
		{{BVG_VECT, BVG_WHITE, 0, 0, 46, 70, (char *) &pot}},
		{{BVG_STRING, OFF_WHITE, 0, 4, 57, 8, "-3       3"}},
		{{BVG_STRING, OFF_WHITE, 0, 75, 55, 8, "-7     7"}},
	}
};

bvgImage subMiniImage3 = {
	680, 400,
	0x00000000,
	3,
	{
		{{BVG_STRING, OFF_WHITE, 8, 0, 38, 8,   "8    4"}},
		{{BVG_STRING, OFF_WHITE, 0, 25, 55, 8, "16      2"}},
		{{BVG_STRING, OFF_WHITE, 7, 50, 45, 8, "32     1"}},
	}
};

bvgImage subMiniImage4 = {
	680, 400,
	0x00000000,
	6,
	{
		{{BVG_VECT, OFF_WHITE, 5, 48, 7, 8, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 0, 23, 7, 8, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 5, 0, 7, 8, (char *) &pWave}},
		{{BVG_VECT, OFF_WHITE, 30, 0, 7, 8, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 37, 23, 7, 8, (char *) &triWave}},
		{{BVG_VECT, BVG_WHITE, 34, 48, 7, 8, (char *) &biRampWave}},
	}
};

bvgImage pro1Pot = {
	1000, 600,
	0x00000000,
	6,
	{
		{{BVG_STRING, BVG_WHITE, 45, 17, 8, 9,   "5"}},
		{{BVG_STRING, BVG_WHITE, 29, 21, 60, 9,   " 4   6  "}},
		{{BVG_STRING, BVG_WHITE, 20, 36, 80, 9,   " 3      7 "}},
		{{BVG_STRING, BVG_WHITE, 15, 56, 90, 9,   "  2         8  "}},
		{{BVG_STRING, BVG_WHITE, 21, 78, 80, 9,   " 1      9  "}},
		{{BVG_STRING, BVG_WHITE, 32, 93, 50, 9,   " O    1O"}},
	}
};

bvgImage pro1ModPot = {
	1000, 600,
	0x00000000,
	10,
	{
		{{BVG_STRING, BVG_WHITE, 45, 17, 8, 9,   "5"}},
		{{BVG_STRING, BVG_WHITE, 29, 21, 60, 9,   " 4   6  "}},
		{{BVG_STRING, BVG_WHITE, 20, 36, 80, 9,   " 3      7 "}},
		{{BVG_STRING, BVG_WHITE, 15, 56, 90, 9,   "  2         8  "}},
		{{BVG_STRING, BVG_WHITE, 21, 78, 80, 9,   " 1      9  "}},
		{{BVG_STRING, BVG_WHITE, 32, 93, 50, 9,   " O    1O"}},
		{{BVG_STRING, BVG_WHITE, 30, 117, 55, 10,   "AMOUNT"}},
		{{BVG_STRING, BVG_WHITE, 84, 16, 45, 9,   "WHEEL"}},
		{{BVG_STRING, BVG_WHITE, 85, 100, 45, 9,   "DIRECT"}},
		{{BVG_STRING, BVG_WHITE, 85, 117, 45, 9,   "ROUTE"}},
	}
};

bvgImage pro1ModSwitch = {
	1000, 600,
	0x00000000,
	3,
	{
		{{BVG_STRING, BVG_WHITE, 0, 0, 40, 9, "WHEEL"}},
		{{BVG_STRING, BVG_WHITE, 0, 25, 40, 9," OFF "}},
		{{BVG_STRING, BVG_WHITE, 0, 50, 40, 9,"ROUTE"}},
	}
};

bvgImage bmeEnvSel = {
	1000, 400,
	0x00000000,
	2,
	{
		{{BVG_VECT|2, OFF_WHITE, 1, 0, 30, 12, (char *) &triWave}},
		{{BVG_VECT|2, OFF_WHITE, 1, 74, 30, 12, (char *) &squareWave}},
	}
};

bvgCoords obxLogoCoords[31] = {
	{0, 0},
	{40, 0},
	{50, 5},
	{64, 14},
	{64, 28},
	{54, 39},
	{66, 48},
	{74, 70},
	{74, 82},
	{70, 90},
	{60, 100},
	{0, 100},
	{14, 96},
	{14, 4},
	{0, 0},
	{-1, -1},
	{28, 12},
	{36, 12},
	{46, 20},
	{46, 29},
	{35, 37},
	{28, 37},
	{28, 12},
	{-1, -1},
	{28, 52},
	{41, 52},
	{51, 70},
	{51, 79},
	{40, 92},
	{28, 92},
	{28, 52},
};
bvgVect obxLogo = {
	31,
	obxLogoCoords
};

bvgCoords obxXCoords[21] = {
	{0, 0},
	{40, 0},
	{38, 10},
	{53, 34},
	{70, 15},
	{75, 0},
	{85, 0},
	{80, 15},
	{57, 40},
	{90, 96},
	{100, 100},
	{60, 100},
	{62, 90},
	{43, 56},
	{15, 85},
	{10, 100},
	{00, 100},
	{5, 85},
	{40, 49},
	{15, 10},
	{0, 0},
};
bvgVect obxX = {
	21,
	obxXCoords
};

bvgCoords obxHiphenCoords[7] = {
	{30, 40},
	{70, 40},
	{60, 45},
	{50, 60},
	{0, 60},
	{20, 55},
	{30, 40},
};
bvgVect obxHiphen = {
	7,
	obxHiphenCoords
};

bvgImage obxLogoImage = {
	900, 150,
	0x00000000,
	4,
	{
		{{BVG_VECT, OFF_WHITE, 200, 5, 45, 120, (char *) &obxLogo}},
		{{BVG_VECT, OFF_WHITE, 230, 5, 45, 120, (char *) &obxLogo}},
		{{BVG_VECT, OFF_WHITE, 265, 5, 35, 120, (char *) &obxHiphen}},
		{{BVG_VECT, OFF_WHITE, 278, 5, 45, 120, (char *) &obxX}},
	}
};

bvgImage obxModImage = {
	200, 200,
	0x00000000,
	1,
	{
		{{BVG_STRING, BVG_WHITE, 15, 140, 190, 10, "NARROW OSC2 TRANS"}},
	}
};

#define obxText(x, y, w, h, W, text) \
	{{BVG_SQUARE, BVG_BLACK, x - 1, y - 1, x + W + 1, y + h + 1}}, \
	{{BVG_STRING, BVG_WHITE, x, y, w, h, text}}

bvgImage obxImage = {
	750, 200,
	0x00000000,
	81,
	{
		{{BVG_STRING, BVG_WHITE, 54, 10, 40, 5, "MANUAL"}},
		obxText(54, 30, 40, 5, 28, "VOLUME"),
		obxText(39, 75, 80, 5, 58, "AUTO HOLD RESET"),
		obxText(50, 110, 50, 5, 38, "MASTERTUNE"),
		{{BVG_STRING, BVG_WHITE, 127, 10, 45, 5, "CONTROL"}},
		obxText(130, 30, 30, 5, 23, "GLIDE"),
		obxText(127, 75, 40, 5, 28, "UNISON"),
		obxText(122, 110, 60, 5, 42, "OSC2 DETUNE"),
		{{BVG_STRING, BVG_WHITE, 210, 10, 65, 5, "MODULATION"}},
		obxText(184, 30, 23, 5, 17, "LFO"),
		obxText(183, 75, 25, 5, 19, "SINE"),
		obxText(178, 110, 45, 5, 35, "SQUARE"),
		obxText(184, 144, 23, 5, 17, "S/H"),
		obxText(223, 30, 38, 5, 29, "DEPTH"),
		obxText(229, 75, 25, 5, 17, "OSC1"),
		obxText(229, 110, 25, 5, 19, "OSC2"),
		obxText(229, 144, 23, 5, 15, "FILT"),
		obxText(269, 30, 23, 5, 17, "PWM"),
		obxText(268, 75, 25, 5, 17, "OSC1"),
		obxText(268, 110, 25, 5, 19, "OSC2"),
		{{BVG_STRING, BVG_WHITE, 350, 10, 75, 5, "OSCILLATORS"}},
		obxText(308, 30, 35, 5, 26, "FREQ1"),
		obxText(303, 75, 45, 5, 35, "SAW PULSE"),
		obxText(342, 30, 60, 5, 48, "PULSEWIDTH"),
		obxText(345, 75, 55, 5, 42, "XMOD SYNC"),
		obxText(398, 30, 35, 5, 29, "FREQ2"),
		obxText(393, 75, 45, 5, 35, "SAW PULSE"),
		{{BVG_STRING, BVG_WHITE, 477, 10, 50, 5, "FILTER"}},
		obxText(443, 30, 30, 5, 23, "FREQ"),
		obxText(434, 75, 55, 5, 39, "OSC1 KBD"),
		obxText(475, 30, 55, 5, 43, "RESONANCE"),
		obxText(480, 75, 45, 5, 35, "HALF FULL"),
		obxText(535, 30, 25, 5, 20, "MOD"),
		obxText(527, 75, 45, 5, 35, "HALF FULL"),
		{{BVG_STRING, BVG_WHITE, 612, 10, 100, 5, "FILTER ENVELOPE"}},
		obxText(580, 30, 180, 5, 139, "ATTACK DECAY SUSTAIN RELEASE"),
		obxText(580, 75, 180, 5, 139, "ATTACK DECAY SUSTAIN RELEASE"),
		{{BVG_STRING, BVG_WHITE, 608, 115, 110, 5, "AMPLIFIER ENVELOPE"}},
		{{BVG_STRING, BVG_WHITE, 450, 135, 65, 5, "PROGRAMMER"}},
		obxText(310, 144, 25, 5, 18, "LOAD"),
		obxText(338, 144, 170, 5, 130, "1  2  3  4  5  6  7  8"),
		obxText(485, 144, 170, 5, 130, "1  2  3  4  5  6  7  8"),
		obxText(628, 144, 25, 5, 18, "SAVE"),
		{{BVG_STRING, BVG_WHITE, 692, 135, 25, 5, "MIDI"}},
		obxText(686, 144, 45, 5, 34, "DOWN UP"),
	}
};

bvgImage BME700ModImage = {
	100, 100,
	0x00000000,
	4,
	{
		{{BVG_STRING|2, BVG_WHITE, 28, 8, 55, 6, "MEMORY"}},
		{{BVG_STRING, BVG_WHITE, 15, 33, 110, 3, "  1    2    3    4 "}},
		{{BVG_STRING, BVG_WHITE, 15, 58, 110, 3, "  5    6    7    8 "}},
		{{BVG_STRING, BVG_WHITE, 18, 83, 110, 3, "LOAD SAVE  UP  MOD "}},
	}
};

bvgImage BME700Image = {
	1000, 400,
	0x00000000,
	51,
	{
		{{BVG_STRING|2, BVG_WHITE, 59, 5, 60, 15, "MOD1"}},
		{{BVG_STRING|2, BVG_WHITE, 193, 5, 60, 15, "MOD2"}},
		{{BVG_IMAGE, BVG_WHITE, 48, 36, 48, 70, (char *) &bmeEnvSel}},
		{{BVG_IMAGE, BVG_WHITE, 243, 36, 48, 70, (char *) &bmeEnvSel}},
		{{BVG_STRING, BVG_WHITE, 102, 25, 120, 8, "CYCLE   CYCLE"}},
		{{BVG_STRING, BVG_WHITE, 91, 90, 140, 8, "1Oms  1Os  1Oms  1Os"}},
		{{BVG_STRING, BVG_WHITE, 263, 63, 25, 8, "PWM"}},
		{{BVG_STRING, BVG_WHITE, 122, 112, 70, 8, "VIBRA MIX"}},
		{{BVG_STRING, BVG_WHITE, 220, 122, 40, 8, "SINGLE"}},
		{{BVG_IMAGE, BVG_WHITE, 256, 122, 48, 70, (char *) &bmeEnvSel}},
		{{BVG_STRING, BVG_WHITE, 78, 176, 210, 8, "ENV1  MOD2 MOD2    DOUBLE"}},
		{{BVG_STRING|2, BVG_WHITE, 391, 5, 70, 15, "MIXER"}},
		{{BVG_STRING, BVG_WHITE, 395, 28, 70, 8, "S/N RATIO"}},
		{{BVG_STRING, BVG_WHITE, 356, 87, 180, 8, "WHITE NOISE      VCO OUTPUT"}},
		{{BVG_STRING|2, BVG_WHITE, 630, 5, 60, 15, "ENV1"}},
		{{BVG_STRING, BVG_WHITE, 578, 25, 200, 7, "MODE       RISE      FALL  "}},
		{{BVG_STRING, BVG_WHITE, 630, 90, 140, 7, "2ms  2Os  2Oms  2s"}},
		{{BVG_STRING, BVG_WHITE, 630, 112, 70, 8, "ENV MIX VCF"}},
		{{BVG_STRING, BVG_WHITE, 630, 177, 70, 8, "ENV1/ENV2"}},
		{{BVG_STRING|2, BVG_WHITE, 865, 5, 60, 15, "ENV2"}},
		{{BVG_STRING, BVG_WHITE, 820, 25, 200, 7, "MODE       RISE      FALL  "}},
		{{BVG_STRING, BVG_WHITE, 872, 90, 140, 7, "2ms  2Os  2Oms  2s"}},
		{{BVG_STRING, BVG_WHITE, 865, 112, 70, 8, "ENV MIX VCF"}},
		{{BVG_STRING, BVG_WHITE, 866, 177, 70, 8, "ENV1/ENV2"}},
		{{BVG_STRING|2, BVG_WHITE, 131, 189, 50, 15, "VCO"}},
		{{BVG_STRING, BVG_WHITE, 40, 208, 280, 8, "SPEED    RATIO    VIBRA     -  + "}},
		{{BVG_STRING, BVG_WHITE, 40, 297, 280, 8, "GLIDE    PULSE    SHAPE     TUNE "}},
		{{BVG_STRING, BVG_WHITE, 40, 310, 280, 7, " ON     MAN  ENV            8  16"}},
		{{BVG_STRING, BVG_WHITE, 40, 362, 280, 7, " OFF   AUTO  MOD                4"}},
		{{BVG_VECT|2, OFF_WHITE, 160, 360, 10, 8, (char *) &squareWave}},
		{{BVG_VECT|2, OFF_WHITE, 200, 360, 10, 8, (char *) &triWave}},
		{{BVG_STRING|2, BVG_WHITE, 388, 189, 80, 15, "RES FILT"}},
		{{BVG_STRING, BVG_WHITE, 410, 208, 30, 8, "MODE"}},
		{{BVG_STRING, BVG_WHITE, 408, 221, 36, 8, "SHARP"}},
		{{BVG_STRING, BVG_WHITE, 410, 276, 30, 8, "FLAT"}},
		{{BVG_STRING, BVG_WHITE, 395, 295, 70, 8, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 360, 310, 160, 7, "1    2    4    8   16 "}},
		{{BVG_STRING, BVG_WHITE, 360, 362, 160, 7, "O    O    O    O    O "}},
		{{BVG_STRING|2, BVG_WHITE, 631, 189, 50, 15, "VCF"}},
		{{BVG_STRING, BVG_WHITE, 563, 208, 200, 7, "RESONANCE    BASIS      ENV"}},
		{{BVG_STRING, BVG_WHITE, 561, 272, 220, 7, " O    6    O   6   MOD ENV "}},
		{{BVG_STRING, BVG_WHITE, 561, 296, 220, 7, "                   MOD MIX "}},
		{{BVG_IMAGE, BVG_WHITE, 582, 310, 48, 70, (char *) &bmeEnvSel}},
		{{BVG_STRING, BVG_WHITE, 561, 310, 220, 7, "        MOD1  KBD          "}},
		{{BVG_STRING, BVG_WHITE, 561, 362, 220, 7, "        MOD2  MOD  MOD ENV "}},
		{{BVG_STRING|2, BVG_WHITE, 868, 189, 50, 15, "VCA"}},
		{{BVG_STRING, BVG_WHITE, 805, 208, 220, 7, "FILTER-MIX  OUTPUT   MOD-MIX"}},
		{{BVG_STRING, BVG_WHITE, 803, 272, 220, 7, "VCF  RES   O   6   MOD ENV "}},
		{{BVG_STRING, BVG_WHITE, 803, 310, 220, 7, "       MOD1                "}},
		{{BVG_STRING, BVG_WHITE, 803, 362, 220, 7, "       MOD2                "}},
		{{BVG_IMAGE, BVG_WHITE, 923, 310, 48, 70, (char *) &bmeEnvSel}},
		{{BVG_STRING|2, BVG_RED, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
		{{BVG_STRING|2, BVG_GREEN, 290, 110, 60, 15, "MOD2"}},
	}
};

bvgImage Prophet1Image = {
	1000, 600,
	0x00000000,
	100,
	{
		{{BVG_STRING, BVG_WHITE, 61, 34, 70, 10, "MODULATION"}},
		{{BVG_STRING, BVG_WHITE, 54, 53, 30, 8, "FROM"}},
		{{BVG_STRING, BVG_WHITE, 134, 53, 15, 8, "TO"}},
		{{BVG_IMAGE, BVG_BLACK, 10, 70, 85, 84, (char *) &pro1ModPot}},
		{{BVG_IMAGE, BVG_BLACK, 10, 218, 85, 84, (char *) &pro1ModPot}},
		{{BVG_IMAGE, BVG_BLACK, 10, 366, 85, 84, (char *) &pro1ModPot}},
		{{BVG_IMAGE, BVG_BLACK, 118, 71, 85, 84, (char *) &pro1ModSwitch}},
		{{BVG_IMAGE, BVG_BLACK, 118, 159, 85, 84, (char *) &pro1ModSwitch}},
		{{BVG_IMAGE, BVG_BLACK, 118, 242, 85, 84, (char *) &pro1ModSwitch}},
		{{BVG_IMAGE, BVG_BLACK, 118, 330, 85, 84, (char *) &pro1ModSwitch}},
		{{BVG_IMAGE, BVG_BLACK, 118, 413, 85, 84, (char *) &pro1ModSwitch}},
		{{BVG_STRING, BVG_WHITE, 35, 180, 60, 10, "FILTER ENV"}},
		{{BVG_STRING, BVG_WHITE, 35, 330, 35, 10, "OSC-B"}},
		{{BVG_STRING, BVG_WHITE, 35, 478, 25, 10, "LFO"}},
		{{BVG_STRING, BVG_WHITE, 118, 130, 50, 9, "OSC-A FREQ"}},
		{{BVG_STRING, BVG_WHITE, 118, 214, 50, 9, "OSC-A PW"}},
		{{BVG_STRING, BVG_WHITE, 118, 300, 50, 9, "OSC-B FREQ"}},
		{{BVG_STRING, BVG_WHITE, 118, 386, 50, 9, "OSC-B PW"}},
		{{BVG_STRING, BVG_WHITE, 125, 470, 35, 9, "FILTER"}},
		{{BVG_STRING, BVG_WHITE, 287, 53, 76, 10, "OSCILLATOR A"}},
		{{BVG_STRING, BVG_WHITE, 245, 75, 76, 8, "   1   2   "}},
		{{BVG_STRING, BVG_WHITE, 245, 89, 76, 8, "O         3"}},
		{{BVG_VECT|2, OFF_WHITE, 310, 80, 12, 12, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 340, 80, 12, 12, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 185, 170, 60, 9, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 368, 170, 66, 9, "PULSE WIDTH"}},
		{{BVG_STRING, BVG_WHITE, 258, 150, 40, 8, "OCTAVE"}},
		{{BVG_STRING, BVG_WHITE, 321, 150, 27, 8, "SHAPE"}},
		{{BVG_STRING, BVG_WHITE, 430, 88, 25, 8, "SYNC"}},
		{{BVG_STRING, BVG_WHITE, 433, 150, 20, 8, "OFF"}},
		{{BVG_STRING, BVG_WHITE, 550, 53, 30, 10, "MIXER"}}, 
		{{BVG_STRING, BVG_WHITE, 480, 170, 210, 9, "OSC A    OSC B    NOISE "}},
		{{BVG_STRING, BVG_WHITE, 317, 200, 76, 10, "OSCILLATOR B"}},
		{{BVG_STRING, BVG_WHITE, 245, 222, 76, 8, "   1   2   "}},
		{{BVG_STRING, BVG_WHITE, 245, 237, 76, 8, "O         3"}},
		{{BVG_VECT|2, OFF_WHITE, 310, 227, 12, 12, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 340, 227, 12, 12, (char *) &triWave}},
		{{BVG_VECT|2, OFF_WHITE, 370, 227, 12, 12, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 185, 317, 60, 9, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 400, 317, 66, 9, "PULSE WIDTH"}},
		{{BVG_STRING, BVG_WHITE, 258, 297, 40, 8, "OCTAVE"}},
		{{BVG_STRING, BVG_WHITE, 337, 297, 27, 8, "SHAPE"}},
		{{BVG_STRING, BVG_WHITE, 460, 234, 60, 8, "LOFREQ KEY"}},
		{{BVG_STRING, BVG_WHITE, 460, 297, 60, 8, "NORMAL OFF"}},
		{{BVG_STRING, BVG_WHITE, 579, 200, 35, 10, "GLIDE"}},
		{{BVG_STRING, BVG_WHITE, 610, 234, 40, 8, " KEY  "}},
		{{BVG_STRING, BVG_WHITE, 605, 297, 44, 8, "NORMAL"}},
		{{BVG_STRING, BVG_WHITE, 565, 317, 30, 9, "RATE"}},
		{{BVG_STRING, BVG_WHITE, 780, 53, 36, 10, "FILTER"}}, 
		{{BVG_STRING, BVG_WHITE, 680, 170, 300, 9, "CUTOFF RESONANCE ENVELOPE KEYBOARD "}},
		{{BVG_STRING, BVG_WHITE, 680, 183, 300, 9, "                  AMOUNT   AMOUNT  "}},
		{{BVG_STRING, BVG_WHITE, 680, 318, 350, 9, "ATTACK   DECAY   SUSTAIN  RELEASE     TUNE "}},
		{{BVG_STRING, BVG_WHITE, 245, 350, 18, 10, "LFO"}}, 
		{{BVG_VECT|2, OFF_WHITE, 247, 374, 12, 12, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 276, 374, 12, 12, (char *) &triWave}},
		{{BVG_VECT|2, OFF_WHITE, 307, 374, 12, 12, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 185, 467, 60, 9, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 274, 444, 27, 8, "SHAPE"}},
		{{BVG_STRING, BVG_WHITE, 371, 350, 64, 10, "SEQUENCER"}}, 
		{{BVG_STRING, BVG_WHITE, 370, 375, 80, 8, "ON    RECORD"}},
		{{BVG_STRING, BVG_WHITE, 370, 450, 80, 8, "OFF   PLAY "}},
		{{BVG_STRING, BVG_WHITE, 451, 350, 60, 10, "ARPEGGIATE"}}, 
		{{BVG_STRING, BVG_WHITE, 460, 375, 50, 8, "  UP   "}},
		{{BVG_STRING, BVG_WHITE, 490, 415, 50, 8, "OFF    "}},
		{{BVG_STRING, BVG_WHITE, 460, 460, 50, 8, "UP/DOWN"}},
		{{BVG_STRING, BVG_WHITE, 577, 350, 30, 10, "MODE"}}, 
		{{BVG_STRING, BVG_WHITE, 536, 375, 140, 8, "RETRIG  REPEAT  DRONE"}},
		{{BVG_STRING, BVG_WHITE, 536, 450, 140, 8, "NORMAL  NORMAL   OFF "}},
		{{BVG_STRING, BVG_WHITE, 774, 350, 56, 10, "AMPLIFIER"}}, 
		{{BVG_STRING, BVG_WHITE, 680, 467, 350, 9, "ATTACK   DECAY   SUSTAIN  RELEASE    VOLUME"}},
		{{BVG_STRING, BVG_WHITE, 28, 530, 100, 9, "DOWN        UP"}},
		{{BVG_STRING, BVG_WHITE, 59, 550, 30, 9, "MIDI"}},
		{{BVG_STRING, BVG_WHITE, 50, 565, 50, 9, "CHANNEL"}},
		{{BVG_STRING, BVG_WHITE, 183, 530, 100, 9, "LOAD SAVE BANK"}},
		{{BVG_STRING, BVG_WHITE, 335, 530, 100, 9, " PROGRAMMER   "}},
		{{BVG_STRING, BVG_WHITE, 494, 530, 180, 9, "1   2   3   4   5   6   7   8"}},
		{{BVG_STRING, BVG_WHITE, 655, 530, 100, 9, "DOWN  UP  FIND"}},
		{{BVG_IMAGE, BVG_BLACK, 166, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 355, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 456, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 520, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 582, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 535, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 166, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 384, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 166, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 657, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 720, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 782, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 845, 70, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 657, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 720, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 782, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 845, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 657, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 720, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 782, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 845, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 917, 218, 85, 84, (char *) &pro1Pot}},
		{{BVG_IMAGE, BVG_BLACK, 917, 368, 85, 84, (char *) &pro1Pot}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
		{{BVG_VECT, BVG_GREEN, 500, 300, 20, 10, (char *) &biRampWave}},
	}
};

bvgImage Prophet52Image = {
	1024, 400,
	0x00000000,
	39,
	{
		{{BVG_STRING, OFF_WHITE, 70, 34, 85, 10, "POLY  MOD"}},
		{{BVG_STRING, OFF_WHITE, 115, 50, 100, 10, "FREQA PWA FILT"}},
		{{BVG_STRING, OFF_WHITE, 9, 109, 120, 10, "FILT       OSCB"}},
		{{BVG_STRING, OFF_WHITE, 39, 119, 50, 10, "AMOUNT"}},
		{{BVG_STRING, OFF_WHITE, 145, 114, 35, 10, "DEST"}},
		{{BVG_STRING, OFF_WHITE, 266, 34, 110, 10, "OSCILLATOR A"}},
		{{BVG_VECT, OFF_WHITE, 263, 50, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 294, 50, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 218, 111, 220, 10, "FREQ  SHAPE  PULSE SYNC"}},
		{{BVG_STRING, OFF_WHITE, 468, 34, 45, 10, "MIXER"}},
		{{BVG_STRING, OFF_WHITE, 419, 111, 155, 10, "OSC-A OSC-B NOISE"}},
		{{BVG_STRING, OFF_WHITE, 642, 34, 50, 10, "FILTER"}},
		{{BVG_STRING, OFF_WHITE, 575, 111, 200, 10, "CUTOFF RES   ENV   KBD"}},
		{{BVG_STRING, OFF_WHITE, 572, 226, 220, 10, "ATTACK  DECAY  SUSTAIN  RELEASE"}},
		{{BVG_STRING, OFF_WHITE, 910, 34, 40, 10, "MIDI"}},
		{{BVG_STRING, OFF_WHITE, 778, 111, 280, 10, "TUNE   A440    DOWN     UP    TUNE"}},
		{{BVG_STRING, OFF_WHITE, 110, 145, 22, 10, "LFO"}},
		{{BVG_VECT, OFF_WHITE, 120, 160, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 150, 160, 10, 10, (char *) &triWave}},
		{{BVG_VECT, OFF_WHITE, 180, 160, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 65, 226, 130, 10, "FREQ     SHAPE"}},
		{{BVG_STRING, OFF_WHITE, 305, 145, 110, 10, "OSCILLATOR B"}},
		{{BVG_VECT, OFF_WHITE, 320, 160, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 350, 160, 10, 10, (char *) &triWave}},
		{{BVG_VECT, OFF_WHITE, 382, 160, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 222, 226, 350, 10, "FREQ  FINE    SHAPE     PULSE  LFO KBD"}},
		{{BVG_STRING, OFF_WHITE, 837, 145, 80, 10, "AMPLIFIER"}},
		{{BVG_STRING, OFF_WHITE, 765, 226, 280, 10, " ATTACK  DECAY SUSTAIN RELEASE  REL"}},
		{{BVG_STRING, OFF_WHITE, 60, 256, 90, 10, "WHEEL  MOD"}},
		{{BVG_STRING, OFF_WHITE, 62, 274, 180, 10, "FRQA  FRQB  PWA  PWB  FILT"}},
		{{BVG_STRING, OFF_WHITE, 21, 340, 150, 10, "MIX          DEST"}},
		{{BVG_STRING, OFF_WHITE, 220, 340, 120, 10, "GLIDE    UNISON"}},
		{{BVG_STRING, OFF_WHITE, 528, 256, 90, 10, "PROGRAMMER"}},
		{{BVG_STRING, OFF_WHITE, 590, 274, 180, 10, "1  2  3  4  5  6  7  8"}},
		{{BVG_STRING, OFF_WHITE, 366, 340, 110, 10, "LOAD SAVE BANK"}},
		{{BVG_STRING, OFF_WHITE, 652, 340, 50, 10, "SELECT"}},
		{{BVG_STRING, OFF_WHITE, 847, 256, 50, 10, "CHORUS"}},
		{{BVG_STRING, OFF_WHITE, 775, 340, 230, 10, "SPEED  DEPTH PHASE  GAIN"}},
		{{BVG_STRING, OFF_WHITE, 980, 340, 50, 10, "VOLUME"}},
	}
};

bvgImage ProphetImage = {
	1024, 400,
	0x00000000,
	37,
	{
		{{BVG_STRING, OFF_WHITE, 75, 34, 85, 10, "POLY  MOD"}},
		{{BVG_STRING, OFF_WHITE, 120, 50, 100, 10, "FREQA PWA FILT"}},
		{{BVG_STRING, OFF_WHITE, 10, 109, 120, 10, "FILT       OSCB"}},
		{{BVG_STRING, OFF_WHITE, 42, 119, 50, 10, "AMOUNT"}},
		{{BVG_STRING, OFF_WHITE, 150, 114, 35, 10, "DEST"}},
		{{BVG_STRING, OFF_WHITE, 286, 34, 110, 10, "OSCILLATOR A"}},
		{{BVG_VECT, OFF_WHITE, 283, 50, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 315, 50, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 240, 111, 220, 10, "FREQ  SHAPE  PULSE SYNC"}},
		{{BVG_STRING, OFF_WHITE, 494, 34, 45, 10, "MIXER"}},
		{{BVG_STRING, OFF_WHITE, 449, 111, 155, 10, "OSC-A OSC-B NOISE"}},
		{{BVG_STRING, OFF_WHITE, 672, 34, 50, 10, "FILTER"}},
		{{BVG_STRING, OFF_WHITE, 605, 111, 200, 10, "CUTOFF RES   ENV   KBD"}},
		{{BVG_STRING, OFF_WHITE, 602, 226, 220, 10, "ATTACK  DECAY  SUSTAIN  RELEASE"}},
		{{BVG_STRING, OFF_WHITE, 952, 34, 40, 10, "MIDI"}},
		{{BVG_STRING, OFF_WHITE, 818, 111, 220, 10, "TUNE   A440     DOWN    UP"}},
		{{BVG_STRING, OFF_WHITE, 115, 145, 22, 10, "LFO"}},
		{{BVG_VECT, OFF_WHITE, 124, 160, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 155, 160, 10, 10, (char *) &triWave}},
		{{BVG_VECT, OFF_WHITE, 185, 160, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 70, 226, 130, 10, "FREQ     SHAPE"}},
		{{BVG_STRING, OFF_WHITE, 325, 145, 110, 10, "OSCILLATOR B"}},
		{{BVG_VECT, OFF_WHITE, 340, 160, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 370, 160, 10, 10, (char *) &triWave}},
		{{BVG_VECT, OFF_WHITE, 402, 160, 10, 10, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 242, 226, 350, 10, "FREQ  FINE    SHAPE     PULSE  LFO KBD"}},
		{{BVG_STRING, OFF_WHITE, 877, 145, 80, 10, "AMPLIFIER"}},
		{{BVG_STRING, OFF_WHITE, 806, 226, 250, 10, " ATTACK  DECAY SUSTAIN RELEASE "}},
		{{BVG_STRING, OFF_WHITE, 63, 256, 90, 10, "WHEEL  MOD"}},
		{{BVG_STRING, OFF_WHITE, 56, 274, 180, 10, "FRQA FRQB PWA PWB FILT"}},
		{{BVG_STRING, OFF_WHITE, 24, 340, 150, 10, "MIX          DEST"}},
		{{BVG_STRING, OFF_WHITE, 238, 340, 120, 10, "GLIDE    UNISON"}},
		{{BVG_STRING, OFF_WHITE, 552, 256, 90, 10, "PROGRAMMER"}},
		{{BVG_STRING, OFF_WHITE, 620, 274, 180, 10, "1  2  3  4  5  6  7  8"}},
		{{BVG_STRING, OFF_WHITE, 396, 340, 110, 10, "LOAD SAVE BANK"}},
		{{BVG_STRING, OFF_WHITE, 687, 340, 50, 10, "SELECT"}},
		{{BVG_STRING, OFF_WHITE, 808, 340, 250, 10, "RELEASE     VOLUME      TUNE   "}},
	}
};

bvgImage AxxePhatImage = {
	800, 400, 0x00000000,
	61,
	{
		{{BVG_STRING, BVG_WHITE, 60, 56, 40, 8, "NOISE"}},
		{{BVG_STRING, BVG_WHITE, 50, 70, 70, 8, "GENERATOR"}},
		{{BVG_STRING, BVG_WHITE, 143, 45, 34, 8, "WHITE"}},
		{{BVG_STRING, BVG_WHITE, 143, 72, 30, 8, "PINK"}},
		{{BVG_STRING, BVG_WHITE, 178, 56, 140, 8, "VOLTAGE CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 206, 70, 70, 8, "OSCILLATOR"}},
		{{BVG_VECT|2, OFF_WHITE, 300, 40, 17, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 300, 77, 17, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 347, 42, 26, 8, "LOW"}},
		{{BVG_STRING, BVG_WHITE, 326, 56, 75, 8, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 327, 70, 75, 8, "OSCILLATOR"}},
		{{BVG_VECT|2, OFF_WHITE, 400, 40, 19, 14, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 400, 77, 17, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 424, 56, 40, 8, "AUDIO"}},
		{{BVG_STRING, BVG_WHITE, 424, 70, 40, 8, "MIXER"}},
		{{BVG_STRING, BVG_WHITE, 476, 56, 140, 8, "VOLTAGE CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 510, 70, 40, 8, "FILTER"}},
		{{BVG_STRING, BVG_WHITE, 615, 42, 50, 8, "VOLTAGE"}},
		{{BVG_STRING, BVG_WHITE, 606, 56, 75, 8, "CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 605, 70, 75, 8, "AMPLIFIER"}},
		{{BVG_STRING, BVG_WHITE, 696, 42, 110, 8, "GATE   SINGLE"}},
		{{BVG_STRING, BVG_WHITE, 696, 70, 110, 8, "AUTO  MULTI "}},
		{{BVG_STRING, BVG_WHITE, 715, 94, 55, 8, "LFO/TRIG"}},
		{{BVG_STRING, BVG_WHITE, 262, 160, 130, 8, "PW  PWM   FREQ"}},
		{{BVG_STRING, BVG_WHITE, 478, 144, 28, 8, "VCF"}},
		{{BVG_STRING, BVG_WHITE, 462, 160, 70, 8, "FREQ RES"}},
		{{BVG_STRING, BVG_WHITE, 613, 160, 32, 8, "GAIN"}},
		{{BVG_STRING, BVG_WHITE, 710, 144, 28, 8, "ENV"}},
		{{BVG_STRING, BVG_WHITE, 680, 160, 100, 8, "A  D  S  R"}},
		{{BVG_STRING, BVG_WHITE, 100, 160, 65, 8, "TRANSPOSE"}},
		{{BVG_STRING, BVG_WHITE, 122, 190, 18, 8, "+1"}},
		{{BVG_STRING, BVG_WHITE, 122, 280, 18, 8, "-1"}},
		{{BVG_VECT, OFF_WHITE, 28, 190, 8, 10, (char *) &flat}},
		{{BVG_VECT, OFF_WHITE, 50, 190, 10, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 73, 190, 8, 10, (char *) &sharp}},
		{{BVG_STRING, BVG_WHITE, 22, 245, 90, 8, "PITCH CONTROL"}},
		{{BVG_STRING, BVG_WHITE, 90, 315, 30, 8, "GLIDE"}},
		{{BVG_STRING, BVG_WHITE, 148, 315, 125, 8, "LFO LFO S/H ADSR"}},
		{{BVG_VECT, OFF_WHITE, 148, 328, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 173, 328, 16, 10, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 222, 328, 16, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 286, 315, 60, 8, "LFO ADSR"}},
		{{BVG_VECT, OFF_WHITE, 286, 328, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 313, 328, 16, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 375, 315, 100, 8, "NOISE VCO VCO"}},
		{{BVG_VECT, OFF_WHITE, 411, 328, 16, 10, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 434, 328, 16, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 525, 315, 100, 8, "KBD LFO ADSR"}},
		{{BVG_VECT, OFF_WHITE, 555, 328, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 584, 328, 17, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 636, 315, 32, 8, "ADSR"}},
		{{BVG_VECT, OFF_WHITE, 639, 328, 17, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 50, 362, 32, 8, "MIDI"}},
		{{BVG_STRING, BVG_WHITE, 20, 384, 32, 8, "DOWN"}},
		{{BVG_STRING, BVG_WHITE, 83, 384, 16, 8, "UP"}},
		{{BVG_STRING, BVG_WHITE, 130, 384, 32, 8, "LOAD"}},
		{{BVG_STRING, BVG_WHITE, 176, 384, 250, 8, "1   2   3   4   5   6   7   8  "}},
		{{BVG_STRING, BVG_WHITE, 405, 384, 250, 8, "1   2   3   4   5   6   7   8  "}},
		{{BVG_STRING, BVG_WHITE, 627, 384, 32, 8, "SAVE"}},
		{{BVG_STRING|3, BVG_WHITE, 670, 364, 55, 18, "ARP"}},
		{{BVG_STRING|3, 0x00ff6900, 723, 364, 70, 18, "AXXE"}},
	}
};

bvgImage AxxeImage = {
	800, 400,
	0x00000000,
	61,
	{
		{{BVG_STRING, BVG_WHITE, 60, 100, 40, 8, "NOISE"}},
		{{BVG_STRING, BVG_WHITE, 50, 112, 70, 8, "GENERATOR"}},
		{{BVG_STRING, BVG_WHITE, 143, 90, 34, 8, "WHITE"}},
		{{BVG_STRING, BVG_WHITE, 143, 116, 30, 8, "PINK"}},
		{{BVG_STRING, BVG_WHITE, 178, 100, 140, 8, "VOLTAGE CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 206, 112, 70, 8, "OSCILLATOR"}},
		{{BVG_VECT|2, OFF_WHITE, 300, 84, 17, 10, (char *) &sawWave}},
		{{BVG_VECT|2, OFF_WHITE, 300, 117, 17, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 347, 89, 26, 8, "LOW"}},
		{{BVG_STRING, BVG_WHITE, 326, 100, 75, 8, "FREQUENCY"}},
		{{BVG_STRING, BVG_WHITE, 327, 112, 75, 8, "OSCILLATOR"}},
		{{BVG_VECT|2, OFF_WHITE, 400, 84, 19, 14, (char *) &sineWave}},
		{{BVG_VECT|2, OFF_WHITE, 400, 117, 17, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 424, 100, 40, 8, "AUDIO"}},
		{{BVG_STRING, BVG_WHITE, 424, 112, 40, 8, "MIXER"}},
		{{BVG_STRING, BVG_WHITE, 476, 100, 140, 8, "VOLTAGE CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 510, 112, 40, 8, "FILTER"}},
		{{BVG_STRING, BVG_WHITE, 615, 89, 50, 8, "VOLTAGE"}},
		{{BVG_STRING, BVG_WHITE, 606, 100, 75, 8, "CONTROLLED"}},
		{{BVG_STRING, BVG_WHITE, 605, 112, 75, 8, "AMPLIFIER"}},
		{{BVG_STRING, BVG_WHITE, 696, 89, 110, 8, "GATE   SINGLE"}},
		{{BVG_STRING, BVG_WHITE, 696, 116, 110, 8, "AUTO  MULTI "}},
		{{BVG_STRING, BVG_WHITE, 715, 133, 55, 8, "LFO/TRIG"}},
		{{BVG_STRING, BVG_WHITE, 262, 190, 130, 8, "PW  PWM   FREQ"}},
		{{BVG_STRING, BVG_WHITE, 478, 175, 28, 8, "VCF"}},
		{{BVG_STRING, BVG_WHITE, 462, 190, 70, 8, "FREQ RES"}},
		{{BVG_STRING, BVG_WHITE, 613, 190, 32, 8, "GAIN"}},
		{{BVG_STRING, BVG_WHITE, 710, 175, 28, 8, "ENV"}},
		{{BVG_STRING, BVG_WHITE, 680, 190, 100, 8, "A  D  S  R"}},
		{{BVG_STRING, BVG_WHITE, 100, 190, 65, 8, "TRANSPOSE"}},
		{{BVG_STRING, BVG_WHITE, 122, 215, 18, 8, "+1"}},
		{{BVG_STRING, BVG_WHITE, 122, 300, 18, 8, "-1"}},
		{{BVG_VECT, OFF_WHITE, 28, 215, 8, 10, (char *) &flat}},
		{{BVG_VECT, OFF_WHITE, 50, 215, 10, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 73, 215, 8, 10, (char *) &sharp}},
		{{BVG_STRING, BVG_WHITE, 22, 270, 90, 8, "PITCH CONTROL"}},
		{{BVG_STRING, BVG_WHITE, 90, 322, 30, 8, "GLIDE"}},
		{{BVG_STRING, BVG_WHITE, 148, 322, 125, 8, "LFO LFO S/H ADSR"}},
		{{BVG_VECT, OFF_WHITE, 148, 334, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 173, 334, 16, 10, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 222, 334, 16, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 286, 322, 60, 8, "LFO ADSR"}},
		{{BVG_VECT, OFF_WHITE, 286, 334, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 313, 334, 16, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 375, 322, 100, 8, "NOISE VCO VCO"}},
		{{BVG_VECT, OFF_WHITE, 411, 334, 16, 10, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 434, 334, 16, 10, (char *) &squareWave}},
		{{BVG_STRING, BVG_WHITE, 525, 322, 100, 8, "KBD LFO ADSR"}},
		{{BVG_VECT, OFF_WHITE, 555, 334, 16, 10, (char *) &sineWave}},
		{{BVG_VECT, OFF_WHITE, 584, 334, 17, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 636, 322, 32, 8, "ADSR"}},
		{{BVG_VECT, OFF_WHITE, 639, 334, 17, 10, (char *) &env}},
		{{BVG_STRING, BVG_WHITE, 50, 367, 32, 8, "MIDI"}},
		{{BVG_STRING, BVG_WHITE, 20, 386, 32, 8, "DOWN"}},
		{{BVG_STRING, BVG_WHITE, 83, 386, 16, 8, "UP"}},
		{{BVG_STRING, BVG_WHITE, 130, 386, 32, 8, "LOAD"}},
		{{BVG_STRING, BVG_WHITE, 176, 386, 250, 8, "1   2   3   4   5   6   7   8  "}},
		{{BVG_STRING, BVG_WHITE, 405, 386, 250, 8, "1   2   3   4   5   6   7   8  "}},
		{{BVG_STRING, BVG_WHITE, 627, 386, 32, 8, "SAVE"}},
		{{BVG_STRING|3, BVG_WHITE, 670, 367, 55, 18, "ARP"}},
		{{BVG_STRING|3, 0x00ff6900, 723, 367, 70, 18, "AXXE"}},
	}
};

bvgImage MemoryMoogImage = {
	800, 180,
	0x00000000,
	62,
	{
		{{BVG_STRING, OFF_WHITE, 25, 14, 40, 6, "GLOBAL"}},
		{{BVG_STRING, OFF_WHITE, 12, 47, 30, 6, "AUTO"}},
		{{BVG_STRING, OFF_WHITE, 42, 47, 30, 6, "TUNE"}},
		{{BVG_STRING, OFF_WHITE, 14, 73, 80, 6, "MONO HOLD MULT"}},
		{{BVG_STRING, OFF_WHITE, 18, 101, 60, 6, "GLIDE  ON"}},
		{{BVG_STRING, OFF_WHITE, 20, 131, 50, 6, "OCTAVE"}},
		{{BVG_STRING, OFF_WHITE, 16, 159, 65, 6, "PITCH MOD"}},

		{{BVG_STRING, OFF_WHITE, 95, 14, 60, 6, "PROGRAMMER"}},
		{{BVG_STRING, OFF_WHITE, 95, 32, 60, 6, "DOWN  UP"}},
		{{BVG_STRING, OFF_WHITE, 80, 88, 105, 6, "1     2     3  "}},
		{{BVG_STRING, OFF_WHITE, 80, 112, 105, 6, "4     5     6  "}},
		{{BVG_STRING, OFF_WHITE, 80, 136, 105, 6, "7     8     9  "}},
		{{BVG_STRING, OFF_WHITE, 80, 160, 105, 6, "L     0     S  "}},

		{{BVG_STRING, OFF_WHITE, 166, 14, 50, 6, "PRESSURE"}},
		{{BVG_STRING, OFF_WHITE, 166, 25, 50, 6, "AMOUNT 1"}},
		{{BVG_STRING, OFF_WHITE, 166, 70, 50, 6, "PITCH FILT"}},
		{{BVG_STRING, OFF_WHITE, 166, 95, 45, 6, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 166, 113, 50, 6, "AMOUNT 2"}},
		{{BVG_STRING, OFF_WHITE, 166, 160, 50, 6, "MOD OSC2"}},

		{{BVG_STRING, OFF_WHITE, 270, 14, 60, 6, "MODIFIERS"}},
		{{BVG_STRING, OFF_WHITE, 227, 47, 28, 6, "FREQ"}},
		{{BVG_VECT, OFF_WHITE, 262, 47, 10, 6, (char *) &triWave}},
		{{BVG_VECT, OFF_WHITE, 281, 47, 10, 6, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 300, 47, 10, 6, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 320, 47, 10, 6, (char *) &squareWave}},
		{{BVG_STRING, OFF_WHITE, 338, 47, 22, 6, "S/H"}},
		{{BVG_STRING, OFF_WHITE, 220, 83, 180, 6, "FM1 FM2 FM3 PW1 PW2 PW3 FILT"}},
		{{BVG_STRING, OFF_WHITE, 228, 122, 170, 6, "OSC3    ENV CONTOUR INVERT"}},
		{{BVG_STRING, OFF_WHITE, 240, 160, 130, 6, "FM1 FM2 PW1 PW2 FILT"}},

		{{BVG_STRING, OFF_WHITE, 445, 14, 80, 6, "OSCILLATORS"}},
		{{BVG_STRING, OFF_WHITE, 372, 47, 156, 6, "16 8 4 2 SYNC PW"}},
		{{BVG_VECT, OFF_WHITE, 513, 47, 10, 6, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 534, 47, 10, 6, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 555, 47, 10, 6, (char *) &triWave}},
		{{BVG_STRING, OFF_WHITE, 372, 83, 156, 6, "16 8 4 2 SYNC PW"}},
		{{BVG_VECT, OFF_WHITE, 513, 83, 10, 6, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 534, 83, 10, 6, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 555, 83, 10, 6, (char *) &triWave}},
		{{BVG_STRING, OFF_WHITE, 372, 122, 156, 6, "16 8 4 2 SYNC PW"}},
		{{BVG_VECT, OFF_WHITE, 513, 122, 10, 6, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 534, 122, 10, 6, (char *) &sawWave}},
		{{BVG_VECT, OFF_WHITE, 555, 122, 10, 6, (char *) &triWave}},
		{{BVG_STRING, OFF_WHITE, 385, 160, 25, 6, "LFO"}},
		{{BVG_STRING, OFF_WHITE, 428, 160, 25, 6, "KBD"}},

		{{BVG_STRING, OFF_WHITE, 575, 14, 30, 6, "MIXER"}},
		{{BVG_STRING, OFF_WHITE, 575, 47, 30, 6, "OSC-1"}},
		{{BVG_STRING, OFF_WHITE, 575, 83, 30, 6, "OSC-2"}},
		{{BVG_STRING, OFF_WHITE, 575, 122, 30, 6, "OSC-3"}},
		{{BVG_STRING, OFF_WHITE, 575, 160, 30, 6, "NOISE"}},

		{{BVG_STRING, OFF_WHITE, 675, 14, 36, 6, "FILTER"}},
		{{BVG_STRING, OFF_WHITE, 623, 45, 36, 6, "1/3 2/3"}},
		{{BVG_STRING, OFF_WHITE, 629, 52, 20, 6, "KBD"}},
		{{BVG_STRING, OFF_WHITE, 656, 47, 120, 6, "CUTOFF RES ENV"}},
		{{BVG_STRING, OFF_WHITE, 620, 83, 180, 6, "ATTACK DECAY SUSTAIN RELEASE"}},
		{{BVG_STRING, OFF_WHITE, 621, 120, 160, 6, "ZERO  COND  KBD   REL"}},
		{{BVG_STRING, OFF_WHITE, 620, 132, 180, 6, "ATTACK DECAY SUSTAIN RELEASE"}},

		{{BVG_STRING, OFF_WHITE, 763, 14, 36, 6, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 763, 47, 36, 6, "MASTER"}},
		{{BVG_STRING, OFF_WHITE, 763, 56, 36, 6, " PROG "}},
		{{BVG_STRING, OFF_WHITE, 763, 89, 36, 6, "CHORUS"}},
		{{BVG_STRING, OFF_WHITE, 763, 121, 36, 6, " GAIN "}},
		{{BVG_STRING, OFF_WHITE, 764, 132, 32, 6, "DEPTH"}},
	}
};

bvgImage Sonic6Image = {
	900, 800,
	0x00000000,
	102,
	{
		{{BVG_VECT, BVG_BLACK, 92, 65, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_WHITE, 98, 58, 22, 10, "LFO"}},
		{{BVG_STRING, BVG_BLACK, 88, 125, 50, 10, "MIX X/Y"}},
		{{BVG_VECT, BVG_BLACK, 275, 65, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_WHITE, 265, 58, 66, 10, "OSCILLATOR"}},
		{{BVG_STRING, BVG_BLACK, 268, 125, 50, 10, "MIX A/B"}},
		{{BVG_STRING, BVG_WHITE, 48, 167, 150, 10, "LFO X           LFO Y"}},
		{{BVG_VECT, BVG_BLACK, 28, 206, 8, 10, (char *) &triWave}},
		{{BVG_VECT, BVG_BLACK, 35, 192, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, BVG_BLACK, 54, 192, 10, 10, (char *) &sawWave}},
		{{BVG_VECT, BVG_BLACK, 62, 206, 10, 10, (char *) &squareWave}},
		{{BVG_VECT, BVG_BLACK, 143, 206, 8, 10, (char *) &triWave}},
		{{BVG_VECT, BVG_BLACK, 150, 192, 10, 10, (char *) &rampWave}},
		{{BVG_VECT, BVG_BLACK, 169, 192, 10, 10, (char *) &sawWave}},
		{{BVG_VECT, BVG_BLACK, 175, 206, 10, 10, (char *) &biRampWave}},
		{{BVG_STRING, BVG_BLACK, 50, 295, 36, 10, "MASTER"}},
		{{BVG_STRING, BVG_BLACK, 50, 313, 36, 10, "MOD   "}},
		{{BVG_STRING, BVG_BLACK, 50, 331, 36, 10, "ADSR  "}},
		{{BVG_STRING, BVG_BLACK, 139, 295, 36, 10, "MASTER"}},
		{{BVG_STRING, BVG_BLACK, 139, 313, 36, 10, "   MOD"}},
		{{BVG_STRING, BVG_BLACK, 139, 331, 36, 10, "  ADSR"}},
		{{BVG_STRING, BVG_BLACK, 77, 342, 80, 10, "RATE   RATE"}},
		{{BVG_STRING, BVG_BLACK, 99, 532, 22, 10, "LFO"}},
		{{BVG_STRING, BVG_BLACK, 92, 550, 36, 10, "MASTER"}},
		{{BVG_STRING, BVG_WHITE, 215, 167, 75, 10, "OSCILLATOR A"}},
		{{BVG_VECT, BVG_BLACK, 205, 204, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 205, 285, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_BLACK, 204, 260, 100, 10, "FREQUENCY  16 8 4 "}},
		{{BVG_STRING, BVG_BLACK, 205, 342, 35, 10, "WIDTH"}},
		{{BVG_VECT, BVG_BLACK, 248, 342, 8, 10, (char *) &triWave}},
		{{BVG_VECT, BVG_BLACK, 258, 342, 8, 10, (char *) &rampWave}},
		{{BVG_VECT, BVG_BLACK, 268, 342, 8, 10, (char *) &pWave}},
		{{BVG_STRING, BVG_WHITE, 210, 378, 85, 10, "PITCH CONTROL"}},
		{{BVG_VECT, BVG_BLACK, 205, 410, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 254, 410, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_BLACK, 210, 471, 90, 10, "X/Y      ADSR"}},
		{{BVG_STRING, BVG_BLACK, 220, 546, 70, 10, " LOW OFF HIGH"}},
		{{BVG_STRING, BVG_WHITE, 310, 167, 75, 10, "OSCILLATOR B"}},
		{{BVG_VECT, BVG_BLACK, 348, 204, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 348, 285, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_BLACK, 296, 260, 100, 10, "  16 8 4   FREQUENCY"}},
		{{BVG_STRING, BVG_BLACK, 348, 342, 35, 10, "WIDTH"}},
		{{BVG_VECT, BVG_BLACK, 300, 342, 8, 10, (char *) &triWave}},
		{{BVG_VECT, BVG_BLACK, 310, 342, 8, 10, (char *) &rampWave}},
		{{BVG_VECT, BVG_BLACK, 320, 342, 8, 10, (char *) &pWave}},
		{{BVG_STRING, BVG_WHITE, 302, 378, 85, 10, "PITCH CONTROL"}},
		{{BVG_VECT, BVG_BLACK, 298, 410, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 348, 410, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 323, 489, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_BLACK, 298, 471, 96, 10, "OSC-A     X/Y"}},
		{{BVG_STRING, BVG_BLACK, 326, 546, 24, 10, "PWM"}},
		{{BVG_STRING, BVG_WHITE, 410, 167, 50, 10, "RINGMOD"}},
		{{BVG_STRING, BVG_BLACK, 395, 205, 80, 10, "OSCA    EXT"}},
		{{BVG_STRING, BVG_BLACK, 395, 290, 80, 10, "X/Y    OSCB"}},
		{{BVG_STRING, BVG_WHITE, 412, 378, 35, 10, "NOISE"}},
		{{BVG_STRING, BVG_BLACK, 420, 448, 25, 10, "PINK"}},
		{{BVG_STRING, BVG_BLACK, 420, 525, 25, 10, "WHITE"}},
		{{BVG_STRING, BVG_WHITE, 490, 167, 35, 10, "MIXER"}},
		{{BVG_VECT, BVG_BLACK, 490, 203, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 490, 291, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 490, 380, 27, 60, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 490, 470, 27, 60, (char *) &pot}},
		{{BVG_STRING, BVG_BLACK, 490, 270, 45, 10, "MIX A/B"}},
		{{BVG_STRING, BVG_BLACK, 485, 360, 50, 10, "RINGMOD"}},
		{{BVG_STRING, BVG_BLACK, 485, 450, 50, 10, "EXTERNAL"}},
		{{BVG_STRING, BVG_BLACK, 490, 540, 35, 10, "NOISE"}},
		{{BVG_VECT, BVG_BLACK, 559, 67, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 606, 67, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 654, 67, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 700, 67, 27, 58, (char *) &pot}},
		{{BVG_STRING, BVG_WHITE, 620, 58, 55, 10, "ENVELOPE"}},
		{{BVG_STRING, BVG_BLACK, 560, 125, 210, 10, "ATTACK    DECAY   SUSTAIN  RELEASE"}},
		{{BVG_VECT, BVG_BLACK, 758, 67, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 799, 67, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 839, 67, 27, 58, (char *) &pot}},
		{{BVG_STRING, BVG_WHITE, 765, 58, 120, 10, "DIRECT OUTPUT MIXER"}},
		{{BVG_STRING, BVG_BLACK, 757, 125, 140, 10, "OSC-A OSC-B RINGMOD"}},
		{{BVG_STRING, BVG_WHITE, 578, 167, 38, 10, "BYPASS"}},
		{{BVG_STRING, BVG_WHITE, 568, 228, 70, 10, "ARTICULATOR"}},
		{{BVG_STRING, BVG_WHITE, 575, 300, 50, 10, "ENVELOPE"}},
		{{BVG_STRING, BVG_BLACK, 575, 318, 50, 10, "ASR ADSD"}},
		{{BVG_STRING, BVG_BLACK, 565, 340, 80, 10, "AR     ADSR"}},
		{{BVG_STRING, BVG_BLACK, 575, 426, 50, 10, "VELOCITY"}},
		{{BVG_STRING, BVG_WHITE, 560, 460, 90, 10, "TRIGGER INPUTS"}},
		{{BVG_STRING, BVG_BLACK, 558, 550, 90, 10, "KBD LFO-X LFO-Y"}},
		{{BVG_STRING, BVG_WHITE, 678, 167, 38, 10, "FILTER"}},
		{{BVG_STRING, BVG_BLACK, 658, 426, 90, 10, "FREQ RESONANCE"}},
		{{BVG_VECT, BVG_BLACK, 652, 488, 27, 58, (char *) &pot}},
		{{BVG_VECT, BVG_BLACK, 706, 488, 27, 58, (char *) &pot}},
		{{BVG_STRING, BVG_WHITE, 652, 460, 110, 10, "PITCH CONTROL INPUTS"}},
		{{BVG_STRING, BVG_BLACK, 652, 550, 100, 10, "ADSR KBD  X/Y"}},
		{{BVG_STRING, BVG_WHITE, 765, 283, 110, 10, "1  2  3  4 "}},
		{{BVG_STRING, BVG_WHITE, 765, 350, 110, 10, "5  6  7  8 "}},
		{{BVG_STRING, BVG_WHITE, 760, 416, 130, 10, "LOAD SAVE MEM MIDI"}},
		{{BVG_STRING, BVG_WHITE, 760, 475, 60, 10, "BANK FIND"}},
		{{BVG_STRING, BVG_WHITE, 835, 378, 8, 10, "U"}},
		{{BVG_STRING, BVG_WHITE, 835, 450, 8, 10, "D"}},
		{{BVG_STRING|2, BVG_BLACK, 779, 500, 70, 23, "bristol"}},
		{{BVG_STRING, BVG_WHITE, 781, 532, 70, 14, "SONIC VX"}},
		{{BVG_STRING, BVG_WHITE, 776, 554, 80, 10, "SYNTHESIZER"}},
		{{BVG_STRING, OFF_WHITE, 56, 767, 130, 10, "TUNE        X  Y"}},
		{{BVG_STRING, OFF_WHITE, 779, 767, 32, 10, "REVERB"}},
	}
};

bvgImage PolyImage = {
	1500, 400,
	0x00000000,
	50,
	{
		{{BVG_STRING, POLY_WHITE, 15, 15, 130, 14, "OUTPUT PHONES"}},
		{{BVG_STRING, POLY_WHITE, 140, 15, 80, 14, "IN   OUT"}},
		{{BVG_STRING, POLY_WHITE, 160, 25, 20, 14, "CV"}},
		{{BVG_STRING, POLY_WHITE, 218, 15, 90, 14, "IN    OUT"}},
		{{BVG_STRING, POLY_WHITE, 240, 25, 30, 14, "TRIG"}},
		{{BVG_STRING, POLY_WHITE, 315, 15, 30, 14, "VCO"}},
		{{BVG_STRING, POLY_WHITE, 355, 15, 30, 14, "VCF"}},
		{{BVG_STRING, POLY_WHITE, 405, 12, 150, 14, "IN   THRU   OUT"}},
		{{BVG_STRING, POLY_WHITE, 455, 28, 35, 14, "MIDI"}},
		{{BVG_STRING, POLY_WHITE, 40, 355, 80, 16, "BEND  MG"}},

		{{BVG_STRING, POLY_WHITE, 25, 148, 150, 16, "VOLUME  TUNE"}},
		{{BVG_STRING, POLY_WHITE, 30, 255, 140, 16, "GLIDE   BEND"}},

		{{BVG_STRING, POLY_WHITE, 312, 52, 35, 16, "VCO"}},
		{{BVG_STRING, POLY_WHITE, 175, 148, 270, 16, "OCTAVE WAVE PW/PWM FREQ"}},
		{{BVG_STRING, POLY_WHITE, 190, 65, 30, 16, "1 2"}},
		{{BVG_STRING, POLY_WHITE, 176, 80, 60, 16, "0    3"}},
		{{BVG_VECT, POLY_WHITE, 235, 80, 10, 16, (char *) &triWave}},
		{{BVG_VECT, POLY_WHITE, 250, 65, 10, 16, (char *) &sawWave}},
		{{BVG_VECT, POLY_WHITE, 268, 65, 10, 16, (char *) &squareWave}},
		{{BVG_VECT, POLY_WHITE, 285, 80, 10, 16, (char *) &pulseWave}},
		{{BVG_STRING, POLY_WHITE, 445, 80, 35, 16, "OFF"}},
		{{BVG_STRING, POLY_WHITE, 445, 110, 38, 16, "SUB1"}},
		{{BVG_STRING, POLY_WHITE, 445, 140, 38, 16, "SUB2"}},

		{{BVG_STRING, POLY_WHITE, 175, 255, 280, 16, "NOISE FREQ DELAY LEVEL"}},
		{{BVG_STRING, POLY_WHITE, 445, 190, 35, 16, "VCO"}},
		{{BVG_STRING, POLY_WHITE, 445, 220, 35, 16, "VCF"}},
		{{BVG_STRING, POLY_WHITE, 445, 250, 35, 16, "VCA"}},
		{{BVG_STRING, POLY_WHITE, 340, 284, 28, 16, "MG"}},

		{{BVG_STRING, POLY_WHITE, 590, 52, 35, 16, "VCF"}},
		{{BVG_STRING, POLY_WHITE, 490, 148, 250, 16, "FREQ  RES  ENV  KBD"}},
		{{BVG_STRING, POLY_WHITE, 550, 255, 190, 16, "HOLD MONO POLY"}},
		{{BVG_STRING, POLY_WHITE, 620, 284, 50, 16, "MODE"}},

		{{BVG_STRING, POLY_WHITE, 815, 52, 90, 16, "ENVELOPE"}},
		{{BVG_STRING, POLY_WHITE, 738, 148, 280, 16, "ATTACK DECAY SUSTAIN RELEASE"}},
		{{BVG_STRING, POLY_WHITE, 738, 255, 280, 16, "ATTACK DECAY SUSTAIN RELEASE"}},

		{{BVG_STRING, POLY_WHITE, 1035, 52, 45, 16, "VCA"}},
		{{BVG_STRING, POLY_WHITE, 1028, 86, 35, 16, "ENV"}},
		{{BVG_STRING, POLY_WHITE, 1028, 116, 38, 16, "GATE"}},
		{{BVG_STRING, POLY_WHITE, 1072, 148, 40, 16, "GAIN"}},
		{{BVG_STRING, POLY_WHITE, 1013, 180, 40, 16, "1   2"}},
		{{BVG_STRING, POLY_WHITE, 1000, 200, 65, 16, "0     3"}},
		{{BVG_STRING, POLY_WHITE, 1008, 255, 130, 16, "MODE INTENSITY"}},
		{{BVG_STRING, POLY_WHITE, 1025, 284, 80, 16, "EFFECTS"}},

		{{BVG_STRING, POLY_WHITE, 1255, 52, 120, 16, "MEMORY"}},
		{{BVG_STRING, POLY_WHITE, 1133, 148, 320, 16, "L 1 2 3 4 5 6 7 8"}},
		{{BVG_STRING, POLY_WHITE, 1133, 255, 320, 16, "S 1 2 3 4 5 6 7 8"}},

		{{BVG_STRING, POLY_WHITE, 1448, 52, 40, 16, "MIDI"}},
		{{BVG_STRING, POLY_WHITE, 1448, 148, 40, 16, " U "}},
		{{BVG_STRING, POLY_WHITE, 1448, 255, 40, 16, " D "}},

		{{BVG_STRING, POLY_WHITE, 1435, 16, 60, 14, "POWER"}},
	}
};

bvgImage MiniPhatImage = {
	680, 400,
	0x00000000,
	78,
	{
		{{BVG_STRING|2, OFF_WHITER, 5, 370, 100, 13, "CONTROLLERS"}},
		{{BVG_STRING, OFF_WHITE, 36, 80, 25, 11, "TUNE"}},
		{{BVG_STRING, OFF_WHITE, 44, 94, 7, 10, "O"}},
		{{BVG_STRING, OFF_WHITE, 30, 157, 45, 10, "-1     1"}},
		{{BVG_STRING, OFF_WHITE, 14, 195, 30, 11, "GLIDE"}},
		{{BVG_STRING, OFF_WHITE, 58, 195, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 48, 284, 20, 10, "OSC"}},
		{{BVG_STRING, OFF_WHITE, 72, 284, 20, 10, "NSE"}},
		{{BVG_STRING, OFF_WHITE, 17, 310, 42, 10, "RELEASE"}},
		{{BVG_STRING, OFF_WHITE, 27, 332, 34, 10, "MULTI"}},
		{{BVG_STRING, OFF_WHITE, 86, 127, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 88, 268, 24, 11, "LFO"}},

		{{BVG_STRING|2, OFF_WHITER, 120, 370, 140, 13, "OSCILLATOR BANK"}},
		{{BVG_STRING, OFF_WHITE, 115, 23, 175, 11, "RANGE OSCILLATOR-1 WAVEFORM"}},
		{{BVG_STRING, OFF_WHITE, 145, 123, 90, 11, "OSCILLATOR-2"}},
		{{BVG_STRING, OFF_WHITE, 145, 238, 90, 11, "OSCILLATOR-3"}},

		{{BVG_STRING|2, OFF_WHITER, 325, 370, 50, 13, "MIXER"}},
		{{BVG_STRING, OFF_WHITE, 270, 23, 38, 11, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 365, 85, 60, 11, "EXTERNAL"}},
		{{BVG_STRING, OFF_WHITE, 370, 194, 40, 11, "NOISE"}},
		{{BVG_STRING, OFF_WHITE, 413, 266, 24, 9, "PINK"}},
		{{BVG_STRING, OFF_WHITE, 340, 90, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 148, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 206, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 262, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 318, 12, 8, "ON"}},

		{{BVG_STRING|2, OFF_WHITER, 470, 370, 100, 13, "MODIFIERS"}},
		{{BVG_STRING, OFF_WHITER, 500, 6, 55, 12, "FILTER"}},
		{{BVG_STRING, OFF_WHITE, 442, 23, 190, 11, "FREQUENCY EMPHASIS CONTOUR"}},
		{{BVG_STRING, OFF_WHITE, 422, 46, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 422, 146, 24, 11, "KBD"}},
		{{BVG_STRING, OFF_WHITE, 455, 138, 170, 9, "ATTACK   DECAY   SUSTAIN"}},
		{{BVG_STRING, OFF_WHITE, 470, 240, 130, 11, "LOUDNESS CONTOUR"}},
		{{BVG_STRING, OFF_WHITE, 455, 254, 170, 9, "ATTACK   DECAY   SUSTAIN"}},

		{{BVG_STRING|2, OFF_WHITER, 620, 370, 55, 13, "OUTPUT"}},
		{{BVG_STRING, OFF_WHITE, 620, 34, 38, 9, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 654, 22, 12, 9, "ON"}},
		{{BVG_STRING, OFF_WHITE, 630, 345, 25, 9, "MEM"}},

		{{BVG_LINE|2, OFF_WHITE, 95, 6, 95, 90}},
		{{BVG_LINE|2, OFF_WHITE, 95, 175, 95, 255}},
		{{BVG_LINE|2, OFF_WHITE, 95, 340, 95, 390}},

		{{BVG_LINE|2, OFF_WHITE, 258, 6, 258, 390}},

		{{BVG_LINE|2, OFF_WHITE, 435, 6, 435, 35}},
		{{BVG_LINE|2, OFF_WHITE, 435, 86, 435, 110}},
		{{BVG_LINE|2, OFF_WHITE, 435, 190, 435, 390}},
		{{BVG_LINE|2, OFF_WHITE, 436, 232, 599, 232}},
		{{BVG_LINE|2, OFF_WHITE, 600, 6, 600, 390}},

		{{BVG_LINE, OFF_WHITE, 310, 75, 320, 75}},
		{{BVG_LINE, OFF_WHITE, 310, 190, 320, 190}},
		{{BVG_LINE, OFF_WHITE, 310, 303, 320, 303}},
		{{BVG_LINE, OFF_WHITE, 345, 131, 360, 131}},
		{{BVG_LINE, OFF_WHITE, 345, 248, 360, 248}},

		{{BVG_VECT, BVG_WHITE, 29, 104, 34, 53, (char *) &pot}},
		{{BVG_IMAGE, BVG_WHITE, 10, 218, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_WHITE, 52, 218, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 208, 46, 100, 100, (char *) &subMiniImage4}},
		{{BVG_IMAGE, BVG_GREEN, 208, 161, 100, 100, (char *) &subMiniImage4}},
		{{BVG_IMAGE, BVG_GREEN, 208, 276, 100, 100, (char *) &subMiniImage4}},

		{{BVG_IMAGE, BVG_GREEN, 105, 46, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_GREEN, 105, 163, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_GREEN, 105, 276, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_WHITE, 156, 149, 100, 100, (char *) &subMiniImage2}},
		{{BVG_IMAGE, BVG_WHITE, 156, 260, 100, 100, (char *) &subMiniImage2}},
		//{{BVG_VECT, BVG_WHITE, 156, 260, 46, 70, (char *) &pot}},

		{{BVG_IMAGE, BVG_GREEN, 268, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 268, 161, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 268, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 370, 105, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 370, 218, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 455, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 455, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 455, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 276, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 612, 47, 142, 142, (char *) &subMiniImage}},
	}
};

bvgImage MiniImage = {
	680, 400,
	0x00000000,
	80,
	{
		{{BVG_STRING|2, OFF_WHITER, 5, 370, 100, 13, "CONTROLLERS"}},
		{{BVG_STRING, OFF_WHITE, 36, 80, 25, 11, "TUNE"}},
		{{BVG_STRING, OFF_WHITE, 44, 94, 7, 10, "O"}},
		{{BVG_STRING, OFF_WHITE, 30, 157, 45, 10, "-1     1"}},
		{{BVG_STRING, OFF_WHITE, 14, 195, 30, 11, "GLIDE"}},
		{{BVG_STRING, OFF_WHITE, 58, 195, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 48, 284, 20, 10, "OSC"}},
		{{BVG_STRING, OFF_WHITE, 72, 284, 20, 10, "NSE"}},
		{{BVG_STRING, OFF_WHITE, 17, 310, 42, 10, "RELEASE"}},
		{{BVG_STRING, OFF_WHITE, 27, 332, 34, 10, "MULTI"}},
		{{BVG_STRING, OFF_WHITE, 86, 127, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 88, 268, 24, 11, "LFO"}},

		{{BVG_STRING|2, OFF_WHITER, 120, 370, 140, 13, "OSCILLATOR BANK"}},
		{{BVG_STRING, OFF_WHITE, 115, 23, 175, 11, "RANGE OSCILLATOR-1 WAVEFORM"}},
		{{BVG_STRING, OFF_WHITE, 145, 123, 90, 11, "OSCILLATOR-2"}},
		{{BVG_STRING, OFF_WHITE, 145, 238, 90, 11, "OSCILLATOR-3"}},

		{{BVG_STRING|2, OFF_WHITER, 325, 370, 50, 13, "MIXER"}},
		{{BVG_STRING, OFF_WHITE, 270, 23, 38, 11, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 365, 85, 60, 11, "EXTERNAL"}},
		{{BVG_STRING, OFF_WHITE, 370, 194, 40, 11, "NOISE"}},
		{{BVG_STRING, OFF_WHITE, 413, 266, 24, 9, "PINK"}},
		{{BVG_STRING, OFF_WHITE, 340, 90, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 148, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 206, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 262, 12, 8, "ON"}},
		{{BVG_STRING, OFF_WHITE, 340, 318, 12, 8, "ON"}},

		{{BVG_STRING|2, OFF_WHITER, 470, 370, 100, 13, "MODIFIERS"}},
		{{BVG_STRING, OFF_WHITER, 500, 6, 55, 12, "FILTER"}},
		{{BVG_STRING, OFF_WHITE, 442, 23, 190, 11, "FREQUENCY EMPHASIS CONTOUR"}},
		{{BVG_STRING, OFF_WHITE, 422, 46, 24, 11, "MOD"}},
		{{BVG_STRING, OFF_WHITE, 422, 146, 24, 11, "KBD"}},
		{{BVG_STRING, OFF_WHITE, 455, 138, 170, 9, "ATTACK   DECAY   SUSTAIN"}},
		{{BVG_STRING, OFF_WHITE, 470, 240, 130, 11, "LOUDNESS CONTOUR"}},
		{{BVG_STRING, OFF_WHITE, 455, 254, 170, 9, "ATTACK   DECAY   SUSTAIN"}},

		{{BVG_STRING|2, OFF_WHITER, 620, 370, 55, 13, "OUTPUT"}},
		{{BVG_STRING, OFF_WHITE, 620, 34, 38, 9, "VOLUME"}},
		{{BVG_STRING, OFF_WHITE, 654, 22, 12, 9, "ON"}},
		{{BVG_STRING, OFF_WHITE, 653, 140, 28, 11, "A440"}},
		{{BVG_STRING, OFF_WHITE, 605, 175, 28, 11, "MIDI"}},
		{{BVG_STRING, OFF_WHITE, 630, 345, 25, 9, "MEM"}},

		{{BVG_LINE|2, OFF_WHITE, 95, 6, 95, 90}},
		{{BVG_LINE|2, OFF_WHITE, 95, 175, 95, 255}},
		{{BVG_LINE|2, OFF_WHITE, 95, 340, 95, 390}},

		{{BVG_LINE|2, OFF_WHITE, 258, 6, 258, 390}},

		{{BVG_LINE|2, OFF_WHITE, 435, 6, 435, 35}},
		{{BVG_LINE|2, OFF_WHITE, 435, 86, 435, 110}},
		{{BVG_LINE|2, OFF_WHITE, 435, 190, 435, 390}},
		{{BVG_LINE|2, OFF_WHITE, 436, 232, 599, 232}},
		{{BVG_LINE|2, OFF_WHITE, 600, 6, 600, 390}},

		{{BVG_LINE, OFF_WHITE, 310, 75, 320, 75}},
		{{BVG_LINE, OFF_WHITE, 310, 190, 320, 190}},
		{{BVG_LINE, OFF_WHITE, 310, 303, 320, 303}},
		{{BVG_LINE, OFF_WHITE, 345, 131, 360, 131}},
		{{BVG_LINE, OFF_WHITE, 345, 248, 360, 248}},

		{{BVG_VECT, BVG_WHITE, 29, 104, 34, 53, (char *) &pot}},
		{{BVG_IMAGE, BVG_WHITE, 10, 218, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_WHITE, 52, 218, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 208, 46, 100, 100, (char *) &subMiniImage4}},
		{{BVG_IMAGE, BVG_GREEN, 208, 161, 100, 100, (char *) &subMiniImage4}},
		{{BVG_IMAGE, BVG_GREEN, 208, 276, 100, 100, (char *) &subMiniImage4}},

		{{BVG_IMAGE, BVG_GREEN, 105, 46, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_GREEN, 105, 163, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_GREEN, 105, 276, 100, 100, (char *) &subMiniImage3}},
		{{BVG_IMAGE, BVG_WHITE, 156, 149, 100, 100, (char *) &subMiniImage2}},
		{{BVG_IMAGE, BVG_WHITE, 156, 260, 100, 100, (char *) &subMiniImage2}},
		//{{BVG_VECT, BVG_WHITE, 156, 260, 46, 70, (char *) &pot}},

		{{BVG_IMAGE, BVG_GREEN, 268, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 268, 161, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 268, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 370, 105, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 370, 218, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 455, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 46, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 455, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 162, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 455, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 509, 276, 100, 100, (char *) &subMiniImage}},
		{{BVG_IMAGE, BVG_GREEN, 559, 276, 100, 100, (char *) &subMiniImage}},

		{{BVG_IMAGE, BVG_GREEN, 612, 47, 142, 142, (char *) &subMiniImage}},
	}
};

bvgImage JunoPhatImage = {
	788, 244,
	0x00000000,
	48,
	{
		{{BVG_STRING, BVG_BLACK, 3, 19, 30, 10, "power"}},
		{{BVG_STRING, BVG_BLACK, 61, 19, 25, 10, "tune"}},
		{{BVG_STRING, BVG_BLACK, 92, 19, 25, 10, "hold"}},
		{{BVG_STRING, OFF_WHITE, 137, 19, 70, 10, "arpeggio"}},
		{{BVG_STRING, OFF_WHITE, 225, 19, 25, 10, "lfo"}},
		{{BVG_STRING, OFF_WHITE, 325, 19, 28, 10, "dco"}},
		{{BVG_STRING, OFF_WHITE, 420, 19, 23, 10, "hpf"}},
		{{BVG_STRING, OFF_WHITE, 482, 19, 22, 10, "VCF"}},
		{{BVG_STRING, OFF_WHITE, 555, 19, 22, 10, "VCA"}},
		{{BVG_STRING, OFF_WHITE, 605, 19, 25, 10, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 648, 19, 55, 10, "chorus"}},
		{{BVG_STRING, OFF_WHITE, 718, 19, 55, 10, "memory"}},
		{{BVG_STRING, OFF_WHITE, 26, 50, 45, 8, "DCO VCF"}},
		{{BVG_STRING, OFF_WHITE, 62, 105, 28, 8, "glide"}},
		{{BVG_STRING, OFF_WHITE, 65, 150, 18, 8, "LFO"}},
		{{BVG_STRING, OFF_WHITE, 87, 50, 25, 8, "Trans"}},
		{{BVG_STRING, OFF_WHITE, 128, 50, 113, 8, "ON  MODE RANGE RATE"}},
		{{BVG_STRING, OFF_WHITE, 146, 80, 10, 8, "UP"}},
		{{BVG_STRING, OFF_WHITE, 140, 160, 30, 8, "DOWN"}},
		{{BVG_STRING, OFF_WHITE, 180, 100, 5, 8, "3"}},
		{{BVG_STRING, OFF_WHITE, 180, 117, 5, 8, "2"}},
		{{BVG_STRING, OFF_WHITE, 180, 134, 5, 8, "1"}},
		{{BVG_STRING, OFF_WHITE, 210, 50, 50, 8, "Rate Delay"}},
		{{BVG_STRING, OFF_WHITE, 245, 93, 15, 8, "MAN"}},
		{{BVG_STRING, OFF_WHITE, 242, 145, 20, 8, "AUTO"}},
		{{BVG_STRING, OFF_WHITE, 262, 50, 42, 8, "lfo pwm"}},
		{{BVG_STRING, OFF_WHITE, 308, 100, 18, 8, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 308, 117, 18, 8, "LFO"}},
		{{BVG_STRING, OFF_WHITE, 308, 134, 18, 8, "MAN"}},
		{{BVG_STRING, OFF_WHITE, 378, 50, 50, 8, "sub noise"}},
		{{BVG_STRING, OFF_WHITE, 420, 50, 24, 8, "freq"}},
		{{BVG_STRING, OFF_WHITE, 445, 50, 45, 8, "freq res"}},
		{{BVG_STRING, OFF_WHITE, 497, 50, 60, 8, "ENV LFO KBD"}},
		{{BVG_STRING, OFF_WHITE, 561, 50, 25, 8, "LEVEL"}},
		{{BVG_STRING, OFF_WHITE, 546, 82, 18, 8, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 545, 162, 21, 8, "GATE"}},
		{{BVG_STRING, OFF_WHITE, 590, 50, 67, 8, "A  D  S  R"}},
		{{BVG_STRING, OFF_WHITE, 651, 50, 55, 8, "Off I II"}},
		{{BVG_STRING, OFF_WHITE, 721, 190, 49, 8, "D MEM U"}},
		{{BVG_VECT, OFF_WHITE, 74, 55, 6, 8, (char *) &sharp}},
		{{BVG_VECT, OFF_WHITE, 64, 55, 6, 8, (char *) &flat}},
		{{BVG_VECT, OFF_WHITE, 332, 82, 10, 8, (char *) &pulseWave}},
		{{BVG_VECT, OFF_WHITE, 347, 82, 10, 8, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 362, 82, 10, 8, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 482, 90, 12, 8, (char *) &env}},
		{{BVG_VECT, OFF_WHITE, 482, 145, 12, 8, (char *) &invenv}},
		{{BVG_VECT, OFF_WHITE, 545, 96, 15, 8, (char *) &env}},
		{{BVG_VECT, OFF_WHITE, 545, 147, 15, 8, (char *) &gate}},
	}
};

bvgImage JunoImage = {
	788, 244,
	0x00000000,
	50,
	{
		{{BVG_STRING, BVG_BLACK, 3, 19, 30, 10, "power"}},
		{{BVG_STRING, BVG_BLACK, 61, 19, 25, 10, "tune"}},
		{{BVG_STRING, BVG_BLACK, 92, 19, 25, 10, "hold"}},
		{{BVG_STRING, OFF_WHITE, 137, 19, 70, 10, "arpeggio"}},
		{{BVG_STRING, OFF_WHITE, 225, 19, 25, 10, "lfo"}},
		{{BVG_STRING, OFF_WHITE, 325, 19, 28, 10, "dco"}},
		{{BVG_STRING, OFF_WHITE, 420, 19, 23, 10, "hpf"}},
		{{BVG_STRING, OFF_WHITE, 482, 19, 22, 10, "VCF"}},
		{{BVG_STRING, OFF_WHITE, 555, 19, 22, 10, "VCA"}},
		{{BVG_STRING, OFF_WHITE, 605, 19, 25, 10, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 648, 19, 55, 10, "chorus"}},
		{{BVG_STRING, OFF_WHITE, 718, 19, 55, 10, "memory"}},
		{{BVG_STRING, OFF_WHITE, 26, 50, 45, 8, "DCO VCF"}},
		{{BVG_STRING, OFF_WHITE, 62, 105, 28, 8, "glide"}},
		{{BVG_STRING, OFF_WHITE, 65, 150, 18, 8, "LFO"}},
		{{BVG_STRING, OFF_WHITE, 87, 50, 25, 8, "Trans"}},
		{{BVG_STRING, OFF_WHITE, 128, 50, 113, 8, "ON  MODE RANGE RATE"}},
		{{BVG_STRING, OFF_WHITE, 146, 80, 10, 8, "UP"}},
		{{BVG_STRING, OFF_WHITE, 140, 160, 30, 8, "DOWN"}},
		{{BVG_STRING, OFF_WHITE, 180, 100, 5, 8, "3"}},
		{{BVG_STRING, OFF_WHITE, 180, 117, 5, 8, "2"}},
		{{BVG_STRING, OFF_WHITE, 180, 134, 5, 8, "1"}},
		{{BVG_STRING, OFF_WHITE, 210, 50, 50, 8, "Rate Delay"}},
		{{BVG_STRING, OFF_WHITE, 245, 93, 15, 8, "MAN"}},
		{{BVG_STRING, OFF_WHITE, 242, 145, 20, 8, "AUTO"}},
		{{BVG_STRING, OFF_WHITE, 262, 50, 42, 8, "lfo pwm"}},
		{{BVG_STRING, OFF_WHITE, 308, 100, 18, 8, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 308, 117, 18, 8, "LFO"}},
		{{BVG_STRING, OFF_WHITE, 308, 134, 18, 8, "MAN"}},
		{{BVG_STRING, OFF_WHITE, 378, 50, 50, 8, "sub noise"}},
		{{BVG_STRING, OFF_WHITE, 420, 50, 24, 8, "freq"}},
		{{BVG_STRING, OFF_WHITE, 445, 50, 45, 8, "freq res"}},
		{{BVG_STRING, OFF_WHITE, 497, 50, 60, 8, "ENV LFO KBD"}},
		{{BVG_STRING, OFF_WHITE, 561, 50, 25, 8, "LEVEL"}},
		{{BVG_STRING, OFF_WHITE, 546, 82, 18, 8, "ENV"}},
		{{BVG_STRING, OFF_WHITE, 545, 162, 21, 8, "GATE"}},
		{{BVG_STRING, OFF_WHITE, 590, 50, 67, 8, "A  D  S  R"}},
		{{BVG_STRING, OFF_WHITE, 651, 50, 55, 8, "Off I II"}},
		{{BVG_STRING, OFF_WHITE, 707, 80, 90, 8, "MIDI  MEMORY"}},
		{{BVG_STRING, OFF_WHITE, 710, 93, 70, 8, "U D    L S"}},
		{{BVG_STRING, OFF_WHITE, 721, 190, 49, 8, "D MEM U"}},

		{{BVG_VECT, OFF_WHITE, 74, 55, 6, 8, (char *) &sharp}},
		{{BVG_VECT, OFF_WHITE, 64, 55, 6, 8, (char *) &flat}},
		{{BVG_VECT, OFF_WHITE, 332, 82, 10, 8, (char *) &pulseWave}},
		{{BVG_VECT, OFF_WHITE, 347, 82, 10, 8, (char *) &rampWave}},
		{{BVG_VECT, OFF_WHITE, 362, 82, 10, 8, (char *) &squareWave}},
		{{BVG_VECT, OFF_WHITE, 482, 90, 12, 8, (char *) &env}},
		{{BVG_VECT, OFF_WHITE, 482, 145, 12, 8, (char *) &invenv}},

		{{BVG_VECT, OFF_WHITE, 545, 96, 15, 8, (char *) &env}},
		{{BVG_VECT, OFF_WHITE, 545, 147, 15, 8, (char *) &gate}},
/*
		{{BVG_LINE, BVG_BLUE, 20, 100, 10, 10}},
		{{BVG_SQUARE, BVG_GREEN, 500, 40, 590, 200}},
		{{BVG_LINE, BVG_BLUE, 20, 100, 10, 10}},
		{{BVG_SQUARE, BVG_WHITE, 10, 20, 100, 20}},
		{{BVG_IMAGE, BVG_WHITE, 10, 10, 100, 100, (char *) &myImage}},
		{{BVG_VECT|0, BVG_RED, 100, 10, 30, 50, (char *) &boxTest}},
*/
	}
};

iMap imageMap[64] = {
	{"/juno.xpm", &JunoImage},
	{"/junophat.xpm", &JunoPhatImage},
	{"/mini.xpm", &MiniImage},
	{"/miniphat.xpm", &MiniPhatImage},
	{"/memMoog.xpm", &MemoryMoogImage},
	//{"/poly.xpm", &PolyImage},
	{"/poly6.xpm", &PolyImage},
	{"/sonic6.xpm", &Sonic6Image},
	{"/sonic6phat.xpm", &Sonic6Image},
	{"/axxe.xpm", &AxxeImage},
	{"/axxephat.xpm", &AxxePhatImage},
	{"/prophet.xpm", &ProphetImage},
	{"/pro1.xpm", &Prophet1Image},
	{"/prophet52.xpm", &Prophet52Image},
	{"/BME700.xpm", &BME700Image},
	{"/BME700mods.xpm", &BME700ModImage},
	//{"/obxlogo.xpm", &obxLogoImage},
	{"/obx.xpm", &obxImage},
	{"/obxmod.xpm", &obxModImage},
	{"/arp2600.xpm", &arpImage},
	{"/odyssey.xpm", &odysseyImage},
	{"/odyssey2.xpm", &odysseyImage},
	{"/odysseymem.xpm", &odysseyMemImage},
	{"", NULL},
};

