.TH bwctl 1 "$Date: 2012-03-26 23:09:35 -0400 (Mon, 26 Mar 2012) $"
." The first line of this file must contain the '"[e][r][t][v] line
." to tell man to run the appropriate filter "t" for table.
."
."	$Id: bwctl.man 559 2012-03-27 03:09:35Z boote $
."
."######################################################################
."#									#
."#			   Copyright (C)  2004				#
."#	     			Internet2				#
."#			   All Rights Reserved				#
."#									#
."######################################################################
."
."	File:		bwctl.1
."
."	Author:		Jeff Boote
."			Internet2
."
."	Date:		Sun Feb  8 16:01:25 MST 2004
."
."	Description:	
."
.SH NAME
bwctl \- Client application to request throughput tests.
.SH SYNOPSIS
.B bwctl 
[\fIoptions\fR] \fI\-c recvhost \-s sendhost\fR
.br
.B bwctl 
[\fIoptions\fR] \fI\-c recvhost\fR
.br
.B bwctl 
[\fIoptions\fR] \fI\-s sendhost\fR
.SH DESCRIPTION
\fBbwctl\fR is a command line client application that is used to
initiate throughput tests.
.TP
This version of \fBbwctl\fR is capable of initiating \fBIperf\fR, \fBNuttcp\fR, and \fBThrulay\fR tests.
.PP
.B bwctl
works by
contacting a \fBbwctld\fR daemon on both the receiving host and
the sending host. \fBbwctld\fR manages and schedules the resources
of the host it runs on.
In the case where only one of the receiving host or
sending host is specified, \fBbwctl\fR assumes the local host is the
other endpoint. \fBbwctl\fR will attempt to contact a local \fBbwctld\fR
if it can. If there is no local \fBbwctld\fR running, \fBbwctl\fR assumes
the local host does not require policy controls and will execute the
\fBbwctld\fR functionality required to run the test directly.
.PP
If cases where \fBbwctl\fR is directly running the throughput test
on the host, there are several configuration options that are shared
with \fBbwctld\fR. Those configuration options
can be set using the bwctlrc(5) configuration file in a way very similar
to the way they are specified in the bwctld.conf(5) file.
.PP
The \fBbwctl\fR client is used to request the desired type of throughput
test. Furthermore, it requests \fIwhen\fR the test is wanted.
\fBbwctld\fR on each endpoint either responds with a tentative
reservation or a \fBtest denied\fR message. Once \fBbwctl\fR is able to get
a matching reservation from both \fBbwctld\fR processes (one for each
host involved in the test), it confirms the
reservation. Then, the \fBbwctld\fR processes run the test and return the
results. The results are returned to the client from both sides of the
test from the respective \fBbwctld\fR processes. Additionally, the
\fBbwctld\fR processes share the results from
their respective side of the test with each other.
.PP
\fBBWCTL\fR (\fBbwctl\fR and \fBbwctld\fR) is used to enable
non-specific throughput tests
to hosts without having to give full user accounts on the given systems.
Users want the ability to run throughput tests to determine the achievable
or available bandwidth between a pair of hosts. It is often useful to test
to multiple points along a network path to determine the network
characteristics along that path. Typically, users who want to do this path
decomposition have to directly contact the network/system administrators
who control the hosts along the path. The administrator needs to either
run half of the test for the user or give them a user account on the host.
Also, network paths of interest are typically controlled by
multiple administrators. These hurdles have made this kind of testing
difficult in practice. 
.PP
\fBBWCTL\fR was designed to help with this problem. It allows an
administrator to configure a given host as an \fBIperf\fR, \fBThrulay\fR, or
\fBNuttcp\fR endpoint.  The endpoint can be a packet sender (e.g. \fBIperf\fR
client) or a packet receiver (e.g. \fBIperf\fR server). It can be shared by
multiple users without concern that those users will interfere with each other.
Specific policy limits can be applied to specific users, and individual tests
are scheduled so they will not interfere with each other. Additionally, full
user accounts are not required for the users running the tests.
.PP
\fBBWCTL\fR allows the administrator to classify incoming connections
based upon a user name and AES key combination or, alternatively, based
upon an IP/netmask.
Once the connection is classified, the \fBbwctld\fR can determine the
exact type and intensities of througput tests that will be allowed.
More information on the policy controls can be found in the bwctld(8)
man page.
.PP
\fBBWCTL\fR makes use of a distributed scheduling algorithm. Each host
maintains a schedule independently. As a client requests a test, the two
endpoints are contacted and each \fBbwctld\fR server responds with the first
available open schedule slot. This enables on-demand tests to co-exist
with regularly scheduled tests since regularly scheduled tests are implemented
by having the client request tests on regular intervals. Different
priorities can be implemented using the \fIevent_horizon\fR configuration
directive to \fBbwctld\fR. (By allowing clients that implement regularly scheduled
tests to reserve their time slots further into the future.)
.SH ARGUMENTS
.SS Connection/Authentication Arguments:
.TP
\fB\-4\fR
Forces bwctl to use IPv4 addresses only.
.RS
.IP Default:
Unspecified (IPv6 is preferred).
.RE
.TP
\fB\-6\fR
Forces bwctl to use IPv6 addresses only.
.RS
.IP Default:
Unspecified (IPv6 is preferred).
.RE
.TP
\fB\-A\fR \fIauthmethod\fB
\fIauthmethod\fR is used to specify the authentication method the
\fBbwctl\fR client is willing to use for communication with the \fBbwctld\fR
on the \fIsendhost\fR and \fIrecvhost\fR.
The authentication options of
\fBbwctl\fR are intended to be extensible. The communication from the
\fBbwctl\fR client to each \fBbwctld\fR server may take different options
for different types of authentication.
If the \fIauthmethod\fR option is specified for either the \fB\-s\fR,
or the \fB\-c\fR argument, it overrides the \fIauthmethod\fR specified
with the \fB\-A\fR option for communication with that particular host.
(Therefore, the \fB\-A\fR argument is really only useful if the same
authentication can be used with both hosts.)
.RS
.PP
Allowing different authentication methods for each connection should allow
a client to use different authentication methods with different servers
which should in turn allow cross-domain tests to occur more easily.
.PP
The format for \fIauthmethod\fR is:
.PP
\fIauthmode [authscheme schemeopts]\fR
.TP
\fIauthmode\fR
Specifies the authentication mode the client is willing to speak with
a server. It must be set as a character string with
any or all of the characters "AEO". The modes are:
.RS
.IP \fBA\fR
[\fBA\fR]uthenticated. This mode encrypts the control connection.
.IP \fBE\fR
[\fBE\fR]ncrypted. This mode encrypts the control connection. If the
test supports encryption, this mode will additionally encrypt the test
stream. (Encryption of the test stream is not currently supported, so
this mode is currently identical to authenticated.)
.IP \fBO\fR
[\fBO\fR]pen. No encryption of any kind is done.
.PP
The client can specify all the modes with which it is willing to communicate.
The most strict mode that both the server and the client are willing to use
will be selected.
.IP Default:
"AEO"
.RE
.TP
\fIauthscheme schemeopts\fR
\fIauthscheme\fR indicates the authentication scheme that should be used to
achieve the \fBauthenticated\fR or \fBencrypted\fR modes.
\fIschemeopts\fR are a list of arguments specific to each particular
authentication scheme. Supported \fIauthscheme\fR values follow
(listed with the \fIschemeopts\fR each scheme requires):
.RS
.TP
\fBAESKEY\fR \fIuserid [keyfile]\fR
This is the initial "simple" shared secret (AES key) model. \fIuserid\fR
is required to identify which shared secret the server and client should
use. \fIkeyfile\fR optionally specifies a file to retrieve the AES key
from. If \fIkeyfile\fR is not specified, the user will be prompted for a
\fIpassphrase\fR. \fIkeyfile\fR can be generated using the aespasswd(1)
application.
.IP "Default:"
Unauthenticated
.RE
.PP
\fIauthscheme\fR and \fIschemeopts\fR are only needed if authenticated
communication (\fBA\fR or \fBE\fR modes of \fIauthmode\fR)
is wanted with \fIsendhost\fR and \fIrecvhost\fR.
.RE
.TP
\fB\-B\fR \fIsrcaddr\fR
Bind the local address of the client socket to \fIsrcaddr\fR. \fIsrcaddr\fR
can be specified using a DNS name or using standard textual notations for
the IP addresses.
.RS
.IP Default:
Unspecified (wild-card address selection).
.RE
.TP
\fB\-c\fR \fIrecvhost[:port] [authmethod]\fR
Specifies the host that will run the \fBIperf\fR, \fBThrulay\fR or \fBNuttcp\fR server.
The :port suffix is optional
and is only needed if \fBbwctld\fR is being run on a non-default
port number. If an IPv6 address is being specified, note that the accepted
format contains the \fIrecvhost\fR portion of the specification in square
brackets as: [fe80::fe9f:62d8]:4823.
This ensures the port number is distinct from the address specification, and
is not needed if the :port suffix is not being used.
.RS
.PP
At least one of the \fB\-c\fR or \fB\-s\fR options must be specified. If
one of them is not specified, it is assumed to be the local host.
.PP
\fIauthmethod\fR is a specifically ordered list of keywords that
is only needed if authenticated communication is wanted with \fIrecvhost\fR.
These keywords are used
to describe the type of communication and authentication that should be
used to contact the \fIrecvhost\fR.
If \fIrecvhost\fR and \fIsendhost\fR share
the same authentication methods and identities, it is possible to
specify the authmethod for both \fIrecvhost\fR and \fIsendhost\fR
using the \fB\-A\fR argument.
An \fIauthmethod\fR specified with
the \fB\-c\fR option will override an \fIauthmethod\fR specified
with the \fB\-A\fR argument for communication with the \fIrecvhost\fR.
.PP
The format for \fIauthmethod\fR and a description of the
currently available authentication
methods are described with the \fB\-A\fR argument.
.RE
.TP
\fB\-k\fR
.br
This option has been deprecated. Originally, it was used to specify the
keyfile for authentication.
All authentication options can now be specified
using the \fB\-A\fR argument.
For the next several versions this option will
report an error. Eventually, it may be reclaimed for another purpose.
.RE
.TP
\fB\-s\fR \fIsendhost[:port] [authmethod]\fR
Specifies the host that will run the \fBIperf\fR, \fBThrulay\fR or \fBNuttcp\fR client.
The :port suffix is optional
and is only needed if \fBbwctld\fR is being run on a non-default
port number. If an IPv6 address is being specified, note that the accepted
format contains the \fIsendhost\fR portion of the specification in square
brackets as: [fe80::fe9f:62d8]:4823.
This ensures the port number is distinct from the address specification, and
is not needed if the :port suffix is not being used.
.RS
.PP
At least one of the \fB\-c\fR or \fB\-s\fR options must be specified. If
one of them is not specified, it is assumed to be the \fIlocal\fR.
.PP
\fIauthmethod\fR is a specifically ordered list of keywords that
is only needed if authenticated communication is wanted with \fIsendhost\fR.
These keywords are used
to describe the type of communication and authentication that should be
used to contact the \fIsendhost\fR.
If \fIrecvhost\fR and \fIsendhost\fR share
the same authentication methods and identities, it is possible to
specify the authmethod for both \fIrecvhost\fR and \fIsendhost\fR
using the \fB\-A\fR argument.
An \fIauthmethod\fR specified with
the \fB\-s\fR option will override an \fIauthmethod\fR specified
with the \fB\-A\fR argument for communication with the \fIsendhost\fR.
.PP
The format for \fIauthmethod\fR and a description of the
currently available authentication
methods are described with the \fB\-A\fR argument.
.RE
.TP
\fB\-U\fR
.br
This option has been deprecated. Originally, it was used to specify the username
to identify the AES key for authentication.
All authentication options can now be specified
using the \fB\-A\fR argument.
For the next several versions this option will
report an error. Eventually, it may be reclaimed for another purpose.
.SS Throughput Test Arguments:
The arguments were named to match their counterparts in \fBIperf\fR
as closely as possible.
.PP
Some of the options are not available for some of the
throughput testers. BWCTL does not support UDP tests, changing the output format or
changing the output units for either \fBNuttcp\fR or \fBThrulay\fR.
.TP
\fB\-T\fR
Specify which throughput tester to use:
.RS
.IP \fBiperf\fR
.IP \fBthrulay\fR
.IP \fBnuttcp\fR
.IP Default:
None. Selects a tool that the client and server have in common
.RE
.TP
\fB\-S\fR \fITOS\fR
.br
Set the TOS byte in the sending packets.
.IP Default:
None.
.RE
.TP
\fB\-D\fR \fIDSCP\fR
.br
Set an RFC 2474 style DSCP value for the TOS byte in the sending packets. This
can be set using a 6-bit numeric value in decimal, hex, or octal. Additionally,
the following set of symbolic
\fBDSCP\fR name constants are understood. (Example applications are taken
from RFC 4594.)
.RE
.RE
.TS
box;
cb	|	cb	|	cb	|	cb
=	|	=	|	=	|	=
lb	|	l	|	c	|	c	.
Name	Value	Service Class	Examples
NONE	000000	Standard	Undifferentiated
DEFAULT	\^	\^	\^
DF	\^	\^	\^
CS0	\^	\^	\^
_
CS1	001000	Low-Priority Data	No BW assurance
_
AF11	001010	High-Throughput Data	Store and forward
AF12	001100	\^	\^
AF13	001110	\^	\^
_
CS2	010000	OAM	OAM&P
_
AF21	010010	Low-Latency Data	Web-based ordering
AF22	010100	\^	\^
AF23	010110	\^	\^
_
CS3	011000	Broadcast Video	TV & live events
_
AF31	011010	Multimedia Streaming	Streaming video and audio
AF32	011100	\^	\^
AF33	011110	\^	\^
_
CS4	100000	Real-Time Interactive	Video conf and gaming
_
AF41	100010	Multimedia Conferencing	H.323 video conferencing
AF42	100100	\^	\^
AF43	100110	\^	\^
_
CS5	101000	Signaling	Video conf and gaming
_
EF	101110	Telephony	IP Telephony bearer
_
CS6	110000	Network Control	Network routing
_
CS7	111000
.TE
.RS
.IP Default:
Unset.
.RE
.TP
\fB\-b\fR \fIbandwidth\fR
Limit UDP send rate to \fIbandwidth\fR (bits/sec).
.RS
.IP Default:
1 Mb
.RE
.TP
\fB\-i\fR \fIinterval\fR
Report interval (seconds).
.RS
.IP Default:
unset (no intervals reported)
.RE
.TP
\fB\-l\fR \fIlen\fR
length of read/write buffers (bytes).
.RS
.IP Default:
8 KB TCP, 1470 bytes UDP
.RE
.TP
\fB\-P\fR \fInStreams\fR
Number of concurrent streams for the test. See the \fB\-P\fR option
of \fBIperf\fR for details.
.TP
\fB\-S\fR \fITOS\fR
Set the TOS (See RFC 1349) byte in packets.
.RS
.IP Default:
0 (not set)
.RE
.TP
\fB\-t\fR \fItime\fR
Duration of test (seconds).
.RS
.IP Default:
10
.RE
.TP
\fB\-u\fR
.br
UDP test.
.RS
.IP Default:
TCP test
.RE
.TP
\fB\-W\fR \fIwindow\fR
Same as the \fB\-w\fR option, except that the value is advisory. \fBbwctl\fR
will attempt to dynamically determine the appropriate TCP window, based upon
RTT information gathered from the control socket. If \fBbwctl\fR is unable
to dynamically determine a window, the value \fIwindow\fR will be used.
.RS
.IP Default:
Unset (system defaults)
.RE
.TP
\fB\-w\fR \fIwindow\fR
Socket buffer sizes (bytes). For TCP, this sets the TCP window size. For UDP,
this sets the socket receive buffer size.
.RS
.IP Default:
Unset (system defaults)
.RE
.SS Scheduling Arguments:
.TP
\fB\-a\fR \fIsyncfuzz\fR
.br
Allow \fBbwctl\fR to run without a synchronized system clock. Use this to
specify how far off the local clock is from \fBUTC\fR. \fBbwctl\fR
prefers to have an \fBNTP\fR synchronized system clock to ensure the two
endpoints of the test are actually agreeing to the same scheduled time window
for test execution.
.RS
.PP
If two systems do NOT have a close enough notion of time, then
the throughput test will eventually fail because one endpoint of the test
will attempt to run at a different time than the other.
.PP
If the operating system supports the \fBNTP\fR system calls, and the system
clock is determined to be unsynchronized, error messages will still
be reported depending upon the value of the \fI\-e\fR flag.
.PP
When calculating the time errors, this value will be aded in to account for the
difference. The maximum time offset can be bounded on the server side, using
the max_time_error directive, to prevent a denial of service attack. If set,
the server will reject any requests to test with a peer that has too high a
timestamp error.
.IP Default:
Unset (Defaults to Set for systems without the \fBNTP\fR system calls)
.RE
.TP
\fB\-I\fR \fIinterval\fR
Specifies that \fBbwctl\fR should attempt to run a throughput test every
\fIinterval\fR seconds.
.RS
.IP Default:
Unset. If it is unset, \fBbwctl\fR only runs the test once.
.RE
.TP
\fB\-L\fR \fIlongest\fR
Specifies the longest amount of time the client is willing to wait for a
reservation window. When \fBbwctl\fR requests a test from the \fBbwctld\fR
server, it specifies the earliest time and the latest time it is willing
to accept. The latest time is determined by adding this \fIlongest\fR
option to the earliest time. The earliest time is essentially 'now'.
The \fIlongest\fR time is specified as a number of seconds.
.RS
.IP Default:
If \fIinterval\fR is set, the default is 50% of \fIinterval\fR. Otherwise,
the default is twice the test duration \fItime\fR but no smaller than
5 minutes. (See \fB\-t\fR.)
.RE
.TP
\fB\-n\fR \fInIntervals\fR
Number of tests to perform if the \fB\-I\fR option is set.
.RS
.IP Default:
Continuous
.RE
.TP
\fB\-R\fR \fIalpha\fR
Randomize the start time of the test within this \fIalpha\fR percent of the
\fIinterval\fR. Valid values for \fIalpha\fR are from 0\-50. \fBbwctl\fR
will attempt to run the test every \fIinterval\fR +/\- \fIalpha\fR percent.
For example, if the \fIinterval\fR is 300 seconds and \fIalpha\fR is
set to 10 percent, then \fBbwctl\fR will attempt to run a test every
270\-330 seconds. This option is only useful with the \fB\-I\fR option.
.RS
.IP Default:
0 (no randomness)
.RE
.SS Output Arguments:
.TP
\fB\-d\fR \fIdir\fR
Specifies directory for results files if the \fB\-p\fR option is set.
.TP
\fB\-e\fR \fIfacility\fR
Syslog \fIfacility\fR to log messages to.
.RS
.IP Default:
LOG_USER
.RE
.TP
\fB\-f\fR \fIunits\fR
Specify the units for the tool to use when displaying the results. The accepted values for \fIunits\fR are tool specific.
.RS
.IP Iperf:
.RS
.IP \fBk\fR
Kilobits per second
.PP
.IP \fBK\fR
Kilobytes per second
.PP
.IP \fBm\fR
Megabits per second
.PP
.IP \fBM\fR
Megabytes per second
.PP
.RE
.RE
.TP
\fB\-h\fR
.br
Print a help message.
.TP
\fB\-p\fR
.br
Place test results in files. Print the filenames to stdout when
results are complete.
.TP
\fB\-q\fR
.br
Quiet output. Output as little as possible.
.TP
\fB\-r\fR
.br
Send syslog messages to stderr.  This is the default unless the \fB\-q\fR
option is specified so this option is only useful with the \fB\-q\fR
option.
.TP
\fB\-V\fR
.br
Print version information and exit.
.TP
\fB\-v\fR
.br
Verbose output. Specifying additional \fB\-v\fR's increases the verbosity.
.TP
\fB\-x\fR
.br
Output sender (client) results as well as receiver results.
By default, sender results are not output. If the \fB\-p\fR option is
specified, the sender results are placed in an additional file.
.TP
\fB\-y\fR \fIformat\fR
Specify the output format of the tool. The accepted values for \fIformat\fR are tool specific.
.RS
.IP Iperf:
.RS
.IP \fBc\fR
[\fBc\fR]omma-separated output
.PP
.RE
.SH ENVIRONMENT VARIABLES
.TS
lb lb lb
_ _ _
lb li li .
bwctl Environment Variable	use	default

BWCTLRC	Config file	~/.bwctlrc
BWCTL_DEBUG_TIMEOFFSET	Offset	0.0(seconds)
.TE
.SH LIMITATIONS
Only tested with versions 1.7.0 and 2.0.b of \fBIperf\fR.
.SH EXAMPLES
.LP
\fBbwctl -c somehost.example.com\fR
.IP
Run a default 10 second TCP test as soon as possible with
\fIlocal\fR as the sender and somehost.example.com as the receiver, using
whichever tools they have in common. Return the results from the receive side
of the test.
.LP
\fBbwctl -x -c somehost.example.com\fR
.IP
Like the previous test, but also return the results from the sender
side of the test.
.LP
\fBbwctl -x -c somehost.example.com -s otherhost.example.com\fR
.IP
Like the previous test, but with otherhost.example.com as the
sender instead of \fIlocal\fR.
.LP
\fBbwctl -t 30 -T iperf -s somehost.example.com\fR
.IP
Run a 30 second TCP \fBIperf\fR test with somehost.example.com as the sender
and \fIlocal\fR as the receiver.
.LP
\fBbwctl -I 3600 -R 10 -t 10 -u -b 10m -s somehost.example.com\fR
.IP
Run a 10 second UDP test about every hour (3600 +/- 360 seconds) with
the sender rate limited to 10 Mbits per second from somehost.example.com to
\fIlocal\fR.
.LP
\fBbwctl -s somehost.example.com AE AESKEY someuser\fR
.IP
Run the default 10 second TCP test. Authenticate using
the identity \fIsomeuser\fR. \fBbwctl\fR will prompt for a passphrase
that will be used to create an AES key.
.SH SEE ALSO
bwctld(8) and the \%http://e2epi.internet2.edu/bwctl/ web site.
.PP
For details on \fBIperf\fR, see the \%http://sourceforge.net/projects/iperf
web site.
.PP
For details on \fBNuttcp\fR, see the \%http://www.wcisd.hpc.mil/nuttcp/Nuttcp-HOWTO.html
web site.
.PP
For details on \fBThrulay\fR, see the \%http://e2epi.internet2.edu/thrulay/
web site.
.SH ACKNOWLEDGMENTS
This material is based in part on work supported by the National Science
Foundation (NSF) under Grant No. ANI-0314723. Any opinions, findings, and
conclusions or recommendations expressed in this material are those of
the author(s) and do not necessarily reflect the views of the NSF.
