{-# LANGUAGE NoImplicitPrelude, UnicodeSyntax #-}

module Data.Eq.Unicode ( (≡), (≢), (≠) ) where

-------------------------------------------------------------------------------
-- Imports
-------------------------------------------------------------------------------

-- from base:
import Data.Bool ( Bool )
import Data.Eq   ( Eq, (==), (/=) )


-------------------------------------------------------------------------------
-- Fixities
-------------------------------------------------------------------------------

infix  4 ≡
infix  4 ≢
infix  4 ≠

-------------------------------------------------------------------------------
-- Symbols
-------------------------------------------------------------------------------

{-|
(&#x2261;) = ('==')

U+2261, IDENTICAL TO
-}
(≡) ∷ Eq α ⇒ α → α → Bool
(≡) = (==)
{-# INLINE (≡) #-}

{-|
(&#x2262;) = ('/=')

U+2262, NOT IDENTICAL TO
-}
(≢) ∷ Eq α ⇒ α → α → Bool
(≢) = (/=)
{-# INLINE (≢) #-}

{-|
(&#x2260;) = ('/=')

U+2260, NOT EQUAL TO
-}
(≠) ∷ Eq α ⇒ α → α → Bool
(≠) = (/=)
{-# INLINE (≠) #-}
