{-# OPTIONS_GHC -w #-}
{-# OPTIONS -XMagicHash -XBangPatterns -XTypeSynonymInstances -XFlexibleInstances -cpp #-}
#if __GLASGOW_HASKELL__ >= 710
{-# OPTIONS_GHC -XPartialTypeSignatures #-}
#endif
-- |
-- Module      :  Cryptol.Parser
-- Copyright   :  (c) 2013-2016 Galois, Inc.
-- License     :  BSD3
-- Maintainer  :  cryptol@galois.com
-- Stability   :  provisional
-- Portability :  portable

{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Trustworthy #-}
module Cryptol.Parser
  ( parseModule
  , parseProgram, parseProgramWith
  , parseExpr, parseExprWith
  , parseDecl, parseDeclWith
  , parseDecls, parseDeclsWith
  , parseLetDecl, parseLetDeclWith
  , parseRepl, parseReplWith
  , parseSchema, parseSchemaWith
  , parseModName, parseHelpName
  , ParseError(..), ppError
  , Layout(..)
  , Config(..), defaultConfig
  , guessPreProc, PreProc(..)
  ) where

import           Control.Applicative as A
import           Data.Maybe(fromMaybe)
import           Data.Text(Text)
import qualified Data.Text as T
import           Control.Monad(liftM2,msum)

import Cryptol.Prims.Syntax(TFun(..))
import Cryptol.Parser.AST
import Cryptol.Parser.Position
import Cryptol.Parser.LexerUtils hiding (mkIdent)
import Cryptol.Parser.ParserUtils
import Cryptol.Parser.Unlit(PreProc(..), guessPreProc)
import Cryptol.Utils.Ident(paramInstModName)

import Paths_cryptol
import qualified Data.Array as Happy_Data_Array
import qualified Data.Bits as Bits
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.9

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn15 :: (Module PName) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> (Module PName)
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (([Located Import], [TopDecl PName])) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (([Located Import], [TopDecl PName]))
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: ([Located Import]) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> ([Located Import])
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Located Import) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (Located Import)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Maybe (Located ModName)) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (Maybe (Located ModName))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (Maybe (Located ImportSpec)) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (Maybe (Located ImportSpec))
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: ([LIdent]) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> ([LIdent])
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([Ident] -> ImportSpec) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([Ident] -> ImportSpec)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Program PName) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (Program PName)
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Program PName) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> (Program PName)
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: ([TopDecl PName]) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> ([TopDecl PName])
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (TopDecl PName) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (TopDecl PName)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (Located String) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> (Located String)
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Maybe (Located String)) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (Maybe (Located String))
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (Decl PName) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (Decl PName)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (Decl PName) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (Decl PName)
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (Newtype PName) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> (Newtype PName)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ([Named (Type PName)]) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> ([Named (Type PName)])
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([ LPName ]) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ([ LPName ])
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: (LPName) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> (LPName)
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ([Pattern PName]) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> ([Pattern PName])
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: ([Pattern PName]) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> ([Pattern PName])
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: ([Decl PName]) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> ([Decl PName])
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: ([Decl PName]) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> ([Decl PName])
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ([Decl PName]) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> ([Decl PName])
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (ReplInput PName) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> (ReplInput PName)
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Expr PName) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (Expr PName)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: ([(Expr PName, Expr PName)]) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> ([(Expr PName, Expr PName)])
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: ((Expr PName, Expr PName)) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> ((Expr PName, Expr PName))
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Expr PName) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (Expr PName)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (Expr PName) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> (Expr PName)
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (Expr PName) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (Expr PName)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (Expr PName) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (Expr PName)
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (LPName) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (LPName)
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (LPName) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (LPName)
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: (LPName) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> (LPName)
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (LPName) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> (LPName)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: ([LPName]) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> ([LPName])
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: ([Expr PName]) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> ([Expr PName])
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Expr PName) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (Expr PName)
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: ([(Bool, Integer)]) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> ([(Bool, Integer)])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: ((Bool, Integer)) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> ((Bool, Integer))
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: (Located Selector) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> (Located Selector)
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: ([Expr PName]) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> ([Expr PName])
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (Named (Expr PName)) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> (Named (Expr PName))
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ([Named (Expr PName)]) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> ([Named (Expr PName)])
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Expr PName) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (Expr PName)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: ([[Match PName]]) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> ([[Match PName]])
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: ([Match PName]) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> ([Match PName])
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (Match PName) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> (Match PName)
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Pattern PName) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (Pattern PName)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (Pattern PName) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (Pattern PName)
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (Pattern PName) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (Pattern PName)
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: ([Pattern PName]) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> ([Pattern PName])
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (Named (Pattern PName)) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> (Named (Pattern PName))
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: ([Named (Pattern PName)]) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> ([Named (Pattern PName)])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (Schema PName) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (Schema PName)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (Located [TParam PName]) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (Located [TParam PName])
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Located [Prop PName]) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> (Located [Prop PName])
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (Located Kind) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (Located Kind)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (TParam PName) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (TParam PName)
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: ([TParam PName]) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> ([TParam PName])
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (TParam PName) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> (TParam PName)
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: ([TParam PName]) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> ([TParam PName])
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (Type PName) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (Type PName)
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (Type PName) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> (Type PName)
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Type PName) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> (Type PName)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: ([ Type PName ]) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> ([ Type PName ])
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (Located [Type PName]) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (Located [Type PName])
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: ([Type PName]) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> ([Type PName])
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (Named (Type PName)) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> (Named (Type PName))
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: ([Named (Type PName)]) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> ([Named (Type PName)])
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Located Ident) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> (Located Ident)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (LPName) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> (LPName)
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (Located ModName) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> (Located ModName)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (Located ModName) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> (Located ModName)
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (Located PName) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (Located PName)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (Located PName) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> (Located PName)
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: (Type PName) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> (Type PName)
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (Named (Type PName)) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> (Named (Type PName))
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: ([Named (Type PName)]) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> ([Named (Type PName)])
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyInTok :: (Located Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Located Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyExpList :: HappyAddr
happyExpList = HappyA# "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x40\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\xe7\x01\x09\x42\x00\x01\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xcf\x01\x48\x82\x50\x22\x60\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\xce\x03\x12\x84\x00\x02\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x1e\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xe7\x00\x26\x41\x28\x11\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x07\x00\x09\x42\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x39\x00\x08\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x01\x40\x80\x00\x00\xfc\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x10\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x07\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xce\x01\x40\x82\x10\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x07\x00\x09\x42\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x60\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x00\x24\x08\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x04\x21\x80\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x80\x24\x08\x25\x02\x06\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xe7\x00\x24\x43\x28\x11\x30\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x07\x20\x09\x46\x89\xf0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x08\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x40\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x0e\x00\x02\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x03\x80\x04\xa1\x04\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x00\x24\x08\x25\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x0f\x48\x10\x02\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x90\x20\x04\x10\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xf3\x80\x04\x21\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x64\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x20\xc1\x08\x20\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x01\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xf7\x80\x04\x21\x80\x02\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x3c\x20\x41\x08\x20\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x07\x00\x01\x00\x08\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x7c\x0f\x48\x10\x02\x08\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x7b\x40\x82\x10\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x20\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x03\x80\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\x40\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\x40\x82\x11\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x20\x40\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x90\x20\x04\x10\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x03\x90\x04\xa1\x44\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x24\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x48\x10\x02\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0e\x00\x02\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x07\x00\x09\xc2\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x09\x42\x04\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x00\x24\x08\x25\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xe7\x00\x20\x41\x28\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\xc0\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x09\x42\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x38\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x0e\x00\x12\x84\x12\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x04\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x39\x00\x48\x10\x02\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x03\x80\x04\x21\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x1c\x00\x24\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xce\x01\x40\x82\x10\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\xf8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x03\x80\x04\x21\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x1c\x00\x24\x08\x01\x84\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x39\x00\x49\x10\x4a\x04\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xcf\x01\x48\x82\x50\x22\x60\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x0e\x40\x12\x84\x12\x01\x83\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x73\x00\x92\x20\x94\x08\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x80\x24\x08\x25\x02\x06\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xe7\x00\x24\x41\x28\x11\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x48\x10\x02\x08\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xcf\x01\x48\x82\x50\x22\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x80\x24\x08\x25\x02\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x07\x20\x09\x42\x89\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\xc0\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x03\x90\x04\xa1\x44\xc0\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x9c\x07\x24\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xe7\x01\x09\x42\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x80\x24\x08\x25\x02\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x20\x40\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x08\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0e\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x24\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x09\x42\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xce\x01\x40\x82\x10\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x04\x21\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xe7\x01\x09\xc2\x00\x01\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x0f\x48\x10\x02\x28\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x7b\x40\x82\x10\x40\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x1e\x90\x20\x04\x10\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x07\x00\x01\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x7b\x40\x82\x10\x40\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1c\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe6\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\xdf\x03\x12\x84\x00\x02\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x1e\x90\x20\x04\x10\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\xde\x03\x12\x84\x00\x02\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x10\x20\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x04\x21\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x07\x00\x01\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x10\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x1e\x90\x20\x0c\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x07\x20\x09\x42\x89\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x01\x02\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x39\x00\x48\x10\x02\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x0e\x40\x12\x84\x12\x01\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x20\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x0e\x40\x12\x84\x12\x01\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x07\x20\x09\x42\x89\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xce\x01\x40\x82\x10\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xf7\x80\x04\x21\x80\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xcf\x01\x48\x82\x50\x22\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x90\x20\x04\x10\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x03\x90\x04\xa1\x44\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xe7\x00\x20\x41\x08\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x38\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x0e\x40\x12\x84\x12\x01\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x10\x20\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0e\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x1c\x80\x24\x08\x25\x02\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x0e\x00\x12\x84\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x73\x00\x90\x20\x04\x10\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xf7\x80\x04\x21\x80\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x1c\x00\x24\x08\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

{-# NOINLINE happyExpListPerState #-}
happyExpListPerState st =
    token_strs_expected
  where token_strs = ["error","%dummy","%start_vmodule","%start_program","%start_programLayout","%start_expr","%start_decl","%start_decls","%start_declsLayout","%start_letDecl","%start_repl","%start_schema","%start_modName","%start_helpName","vmodule","vmod_body","vimports","import","mbAs","mbImportSpec","name_list","mbHiding","program","program_layout","top_decls","vtop_decls","vtop_decl","top_decl","private_decls","prim_bind","parameter_decls","par_decls","par_decl","doc","mbDoc","decl","let_decl","newtype","newtype_body","vars_comma","var","apats","apats1","decls","vdecls","decls_layout","repl","expr","ifBranches","ifBranch","cexpr","sig_expr","iexpr","expr10","qop","op","pat_op","other_op","ops","aexprs","aexpr","poly_terms","poly_term","selector","tuple_exprs","field_expr","field_exprs","list_expr","list_alts","matches","match","pat","ipat","apat","tuple_pats","field_pat","field_pats","schema","schema_vars","schema_quals","kind","schema_param","schema_params","tysyn_param","tysyn_params","type","app_type","atype","atypes","dimensions","tuple_types","field_type","field_types","ident","name","smodName","modName","qname","help_name","tick_ty","field_ty_val","field_ty_vals","NUM","STRLIT","CHARLIT","IDENT","QIDENT","'include'","'import'","'as'","'hiding'","'private'","'parameter'","'property'","'infix'","'infixl'","'infixr'","'type'","'newtype'","'module'","'where'","'let'","'if'","'then'","'else'","'x'","'primitive'","'constraint'","'['","']'","'<-'","'..'","'...'","'|'","'('","')'","','","';'","'.'","'{'","'}'","'<|'","'|>'","'='","'`'","':'","'->'","'=>'","'\\\\'","'_'","'v{'","'v}'","'v;'","'+'","'*'","'^^'","'-'","'~'","'#'","OP","QOP","DOC","%eof"]
        bit_start = st * 163
        bit_end = (st + 1) * 163
        read_bit = readArrayBit happyExpList
        bits = map read_bit [bit_start..bit_end - 1]
        bits_indexed = zip bits [0..162]
        token_strs_expected = concatMap f bits_indexed
        f (False, _) = []
        f (True, nr) = [token_strs !! nr]

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\xef\xff\x37\x01\xdd\xff\x7d\x03\x7e\x06\x7e\x06\xf2\xff\x51\x00\xb9\x02\xcf\x06\xce\x02\xf2\x02\x5c\x00\xce\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x00\x00\x00\x60\x07\x7a\x00\xea\x06\xea\x06\x10\x09\x8f\x00\x00\x00\x05\x07\x20\x07\x00\x00\x00\x00\x3b\x07\x99\x06\x3c\x02\x00\x00\x00\x00\xdc\x00\xde\x00\x00\x00\x00\x00\x02\x09\x00\x00\x7a\x08\x0b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x08\x7d\x03\xea\x02\x78\x02\x30\x03\x0a\x00\xe9\x03\x3e\x08\xdc\x03\xdc\x03\x17\x01\x17\x01\x31\x04\x1a\x01\xfc\xff\x3e\x08\x7a\x01\x23\x00\x13\x06\xf3\x08\x00\x00\x65\x01\x85\x01\x92\x01\x65\x04\x09\x01\xf6\x03\x61\x03\x00\x00\x75\x01\xf4\xff\x75\x01\xef\x01\x75\x01\x51\x01\x97\x01\x00\x00\x00\x00\xd2\x01\x00\x00\xe4\x01\x00\x00\xc4\x01\xce\x02\xba\x01\x9a\x01\x4e\x00\x00\x00\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x06\x86\x02\x00\x00\xce\x02\xea\x01\xf1\x01\x2f\x00\x00\x00\xd0\x01\x00\x00\xe7\x01\x16\x01\x00\x00\x60\x00\x00\x00\xd3\x00\xfb\x01\x00\x00\x29\x02\x71\x00\xeb\xff\x00\x00\x89\x00\x00\x00\x00\x08\x00\x00\xc5\x00\xb3\x01\x00\x00\xbe\x06\x95\x08\xfb\x08\xfb\x08\xfb\x08\x3e\x08\x7d\x03\x3e\x08\x24\x02\x28\x02\x3e\x08\x01\x01\xb7\x03\x56\x07\x00\x00\x00\x00\x74\x01\x00\x00\x00\x00\x00\x00\x37\x02\x00\x00\x00\x00\x00\x00\x71\x07\xb4\x06\xef\x00\x00\x00\x00\x00\x3b\x02\x00\x00\x00\x00\xe5\x00\x1b\x08\x00\x00\xf6\xff\x55\x02\x18\x02\x00\x00\xdc\x03\xdc\x03\x1f\x03\x51\x02\x62\x02\x00\x00\x40\x01\x56\x00\x00\x00\xff\x00\x3e\x08\xff\x02\x63\x02\xdc\x03\x71\x07\x00\x00\x55\x01\x00\x00\xcd\x01\x71\x02\x7d\x08\x71\x06\x20\x02\x00\x00\x87\x03\x24\x03\x00\x00\x8c\x07\x00\x00\xa7\x07\x00\x00\xa7\x07\xa7\x07\xa7\x07\x00\x00\xfb\x08\xa7\x07\x10\x09\x00\x00\x87\x02\xa5\x02\x99\x02\x00\x00\xfb\x08\x00\x00\xfb\x08\xe1\x05\x37\x06\x00\x00\x53\x08\xad\x02\x00\x00\x00\x00\xa7\x07\x00\x00\xa7\x07\x98\x03\x95\x08\x00\x00\x95\x08\x00\x00\xfb\x08\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x02\x7d\x03\xc1\x03\x7d\x03\x7d\x03\x00\x00\x7d\x03\x1b\x03\x00\x00\x3e\x08\x7d\x03\x00\x00\x00\x00\x00\x00\x7d\x03\xcb\x02\x7d\x03\x95\x08\x00\x00\xf7\x02\x00\x00\x70\x00\x64\x07\xf9\x01\xda\x02\x00\x00\x46\x02\x00\x00\x4a\x07\xc1\x03\x7e\x06\x00\x00\x7e\x06\x00\x00\x00\x00\x00\x00\xfb\x08\xdc\x01\x7d\x03\x00\x00\xd8\x02\x01\x03\xec\x02\x00\x00\x0e\x03\x0e\x03\x0e\x03\xd9\x06\x00\x00\xf4\x06\x00\x00\x95\x08\xa7\x07\x00\x00\x3e\x08\x00\x00\x3e\x08\x00\x00\xa7\x07\x00\x00\xee\x02\x3e\x08\x95\x08\x00\x00\x36\x06\x50\x04\x4f\x02\x00\x00\x4f\x02\x00\x00\x09\x03\xfb\x08\xce\x02\xde\x02\x4f\x02\x33\x03\x00\x00\x45\x03\x95\x08\xcc\x07\x00\x00\x18\x03\x1a\x03\x26\x02\x26\x02\x00\x00\x00\x00\x38\x01\x00\x00\x38\x01\x23\x03\x4f\x02\x0f\x07\x23\x08\x00\x00\x7e\x00\xce\x02\x76\x01\x7d\x01\x00\x00\xe7\x07\x50\x03\x4a\x03\xc2\x07\x00\x00\x00\x00\x82\x02\x00\x00\x5a\x06\x00\x00\x00\x00\x00\x00\x7d\x03\xfb\x08\x00\x00\x00\x00\xfb\x08\x47\x03\x00\x00\xdd\x07\x2a\x07\xdd\x07\xfb\x08\x7d\x03\x53\x03\x56\x03\x00\x00\x00\x00\x00\x00\x00\x00\x95\x08\x00\x00\xdd\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x03\x7d\x03\x67\x03\xbe\x00\x5c\x03\x69\x03\x00\x00\x71\x03\x83\x03\x83\x03\x83\x03\x00\x00\x00\x00\x83\x03\x7d\x03\x00\x00\x6e\x03\x00\x00\x7e\x03\xfb\x08\x00\x00\x00\x00\xfb\x08\xfb\x08\xdd\x07\x00\x00\x53\x08\xba\x01\x95\x03\x5f\x02\x5f\x02\xb9\x03\x7d\x03\x3e\x08\x3e\x08\x4c\x03\x00\x00\xb9\x03\xfb\x08\xa4\x03\x00\x00\x00\x00\xbd\x03\x00\x00\xfb\x08\xdd\x07\xfb\x08\x5f\x02\xbd\x03\x00\x00\x00\x00\x00\x00\xab\x03\xa9\x03\xaf\x03\x46\x08\xa7\x03\x00\x00\xa7\x03\x00\x00\x00\x00\x00\x00\xc7\x03\x00\x00\xc5\x03\x7d\x03\x45\x07\xcf\x03\x3c\x03\x3e\x03\x00\x00\x00\x00\x00\x00\x2e\x04\xcf\x03\xd8\x03\x7d\x03\x95\x08\x00\x00\x00\x00\xca\x03\xdd\x07\xf8\x07\xba\x01\xf8\x07\x85\x00\xfb\x08\xe8\x03\xd9\x03\x00\x00\xf0\x03\xdb\x03\x00\x00\x00\x00\x00\x00\xde\x03\x00\x00\xfb\x08\x5f\x02\x49\x02\x00\x00\xfa\x03\x00\x00\x81\x02\x00\x00\x00\x00\x00\x00\x95\x08\xe5\x03\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x15\x04\x83\x00\x0d\x04\xa7\x04\x66\x00\xc8\x01\xff\x03\x03\x04\x7e\x01\x7f\x08\x91\x02\xe9\x01\x00\x00\x55\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x01\x00\x00\x88\x05\x11\x09\x8d\x03\x00\x00\x00\x00\x44\x03\x26\x01\x00\x00\x00\x00\x1e\x09\x04\x09\xda\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x03\x00\x00\x1e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x72\x04\x80\x04\x60\x04\x24\x00\x6d\x01\x5a\x03\xea\xff\x15\x01\x5e\x01\x00\x00\x00\x00\xac\x00\x00\x00\x00\x00\xf7\xff\x80\x00\x00\x00\x64\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x1d\x05\x6d\x08\x42\x01\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x00\x00\x00\x13\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x03\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x02\x0e\x04\x00\x00\xba\x03\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x07\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x01\xf5\x02\x19\x04\x3b\x04\x49\x04\x3f\x00\xb5\x04\xcb\x03\x00\x00\x00\x00\x9d\x00\x00\x00\xee\xff\x8c\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x09\xcf\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x01\x23\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x00\xf0\xff\x00\x00\xae\x02\x38\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x03\x00\x00\x00\x00\xd4\x04\x34\x05\x00\x00\xd4\x03\x00\x00\x45\x09\x00\x00\x52\x09\x5f\x09\x12\x08\x00\x00\x34\x05\x6c\x09\x34\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x05\x00\x00\x34\x05\x34\x05\x34\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x09\x00\x00\x86\x09\xc2\x08\x8f\x01\x00\x00\xb2\x00\x00\x00\x34\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x04\xfb\x03\x96\x04\xdc\x04\x00\x00\xea\x04\xf9\x04\x00\x00\x8e\x02\x11\x05\x00\x00\x00\x00\x00\x00\x20\x05\x00\x00\x2e\x05\x18\x00\x00\x00\x00\x00\x00\x00\x04\x04\x34\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x05\xdf\x05\x4c\x02\x00\x00\x70\x02\x00\x00\x00\x00\x00\x00\x62\x05\x00\x00\x44\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x01\x00\x00\x4a\x01\x00\x00\xe4\x03\x93\x09\x00\x00\xb7\x04\x00\x00\xd9\x04\x00\x00\xa0\x09\x00\x00\x00\x00\x65\x05\x17\x00\x00\x00\xca\x01\xd4\x01\xe4\x00\x00\x00\xfb\x00\x00\x00\x00\x00\x97\x05\x78\x04\x89\x04\xb4\x00\x38\x04\x00\x00\x00\x00\x26\x03\x52\x02\x00\x00\x00\x00\x00\x00\x4f\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x04\xcb\x00\xc7\x01\xc7\x00\x00\x00\xe0\x02\xaa\x04\x00\x00\x00\x00\x00\x00\x3a\x03\x00\x00\x00\x00\x99\x08\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x02\x00\x00\x00\x00\x00\x00\x55\x05\xd5\x05\x00\x00\x00\x00\xd5\x05\x00\x00\x00\x00\xad\x09\x4a\x01\xba\x09\xde\x05\x63\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x01\x00\x00\xc7\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x05\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x06\x00\x00\x00\x00\x2b\x06\x2b\x06\xd4\x09\x00\x00\x00\x00\x1b\x00\x00\x00\x05\x04\x06\x04\x00\x00\x98\x05\x70\x04\x40\x04\xa7\x05\x00\x00\x00\x00\x2b\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x06\xe1\x09\x2b\x06\x0b\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x03\x4d\x06\x00\x00\x64\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x05\x4a\x01\x25\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x06\x37\x04\x00\x00\xce\x05\x04\x00\x00\x00\x00\x00\x00\x00\xee\x09\xa6\x08\x35\x00\xb3\x08\x00\x00\x9a\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x06\x0f\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x04\x00\x00\x00\x00\x00\x00\x00\x00"#

happyAdjustOffset :: Happy_GHC_Exts.Int# -> Happy_GHC_Exts.Int#
happyAdjustOffset off = off

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xfe\x83\xff\x81\xff\x7f\xff\x06\xff\x01\xff\xff\xfe\x00\x00\x0b\xff\x00\xff\x08\xff\x07\xff\x09\xff\x0a\xff\x00\x00\x7d\xff\x7e\xff\x7a\xff\x7c\xff\x7b\xff\x80\xff\x79\xff\x82\xff\x05\xff\x03\xff\x00\x00\x04\xff\x00\x00\x00\x00\x00\x00\x00\x00\x36\xff\x22\xff\x1f\xff\x00\x00\x1e\xff\x1d\xff\x1c\xff\x00\x00\x00\x00\x00\x00\x15\xff\x97\xff\x00\x00\x98\xff\x96\xff\x8d\xff\x8a\xff\x88\xff\x86\xff\x76\xff\x74\xff\x91\xff\x73\xff\x72\xff\x71\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\xff\x00\x00\x00\x00\x46\xff\xa5\xff\xae\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\xff\xbc\xff\x00\x00\xcc\xff\x00\x00\xbd\xff\x00\x00\x00\x00\x00\x00\x00\x00\xee\xff\xe9\xff\xed\xff\xd8\xff\xce\xff\xcf\xff\xcd\xff\x00\x00\x00\x00\xd5\xff\x00\x00\x09\xff\x00\x00\x00\x00\xcb\xff\x00\x00\xda\xff\x00\x00\x00\x00\xdb\xff\x00\x00\x38\xff\x00\x00\x00\x00\x3d\xff\x00\x00\x00\x00\x48\xff\x46\xff\x00\x00\x45\xff\x00\x00\x43\xff\x00\x00\x00\x00\x40\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\xff\x00\x00\x00\x00\x9f\xff\x9d\xff\x00\x00\x99\xff\x84\xff\x85\xff\x00\x00\xfc\xfe\x69\xff\xfb\xfe\x00\x00\x00\x00\x00\x00\x64\xff\x62\xff\x61\xff\x66\xff\x59\xff\x00\x00\x00\x00\x6d\xff\x00\x00\x00\x00\x00\x00\x6e\xff\x7c\xff\x7b\xff\x56\xff\x55\xff\x00\x00\x6b\xff\x00\x00\x00\x00\x90\xff\x00\x00\x45\xff\x00\x00\x75\xff\x00\x00\x00\x00\x2a\xff\x00\x00\x0d\xff\x00\x00\x2c\xff\x32\xff\x00\x00\x00\x00\x19\xff\x00\x00\x00\x00\x14\xff\x20\xff\x1e\xff\x00\x00\x21\xff\x00\x00\x00\x00\x00\x00\x30\xff\x34\xff\x00\x00\x35\xff\x02\xff\x00\x00\x00\x00\x00\x00\xfd\xfe\x33\xff\x23\xff\x24\xff\x00\x00\x00\x00\x13\xff\x12\xff\x00\x00\x17\xff\x18\xff\x00\x00\x1a\xff\x00\x00\x00\x00\x00\x00\x16\xff\x00\x00\x31\xff\x89\xff\x87\xff\x68\xff\x5f\xff\x5e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\xff\x00\x00\x00\x00\x50\xff\x00\x00\x00\x00\x6f\xff\x67\xff\x70\xff\x00\x00\x00\x00\x00\x00\x00\x00\x6c\xff\x00\x00\x65\xff\x00\x00\x00\x00\x00\x00\x06\xff\xf4\xfe\x00\x00\xf9\xfe\x00\x00\x00\x00\x00\x00\x9a\xff\x00\x00\xba\xff\xa6\xff\xa5\xff\x00\x00\xa0\xff\x00\x00\x9e\xff\x47\xff\xb9\xff\x00\x00\x78\xff\xaf\xff\xb1\xff\xb0\xff\x00\x00\x26\xff\x00\x00\x28\xff\x00\x00\x00\x00\x3e\xff\x00\x00\x3f\xff\x00\x00\x41\xff\x00\x00\x42\xff\xa4\xff\x00\x00\x00\x00\x3c\xff\x00\x00\x00\x00\x00\x00\xdc\xff\x00\x00\xd9\xff\x00\x00\x00\x00\x00\x00\xbb\xff\x00\x00\xe6\xff\xd0\xff\x00\x00\x00\x00\x00\x00\xd4\xff\x09\xff\x00\x00\x00\x00\x00\x00\xf1\xff\xeb\xff\xf0\xff\xea\xff\xef\xff\xbb\xff\x00\x00\x00\x00\x00\x00\xd3\xff\xdf\xff\x00\x00\x00\x00\x00\x00\xc3\xff\x00\x00\x00\x00\x00\x00\x00\x00\xd7\xff\xd6\xff\x00\x00\x93\xff\x00\x00\x95\xff\x37\xff\x39\xff\x00\x00\x49\xff\x3b\xff\x3a\xff\xb5\xff\x00\x00\x25\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\xff\x00\x00\x9c\xff\x9b\xff\x8b\xff\xfa\xfe\x00\x00\xf8\xfe\x00\x00\xf6\xfe\xf7\xfe\x63\xff\x60\xff\x58\xff\x5b\xff\x00\x00\x5d\xff\x5d\xff\x57\xff\x4e\xff\x4c\xff\x00\x00\x53\xff\x5c\xff\x8e\xff\x8f\xff\x8c\xff\xad\xff\x00\x00\x29\xff\x2c\xff\x0c\xff\x2b\xff\x0e\xff\x2e\xff\x2f\xff\x10\xff\x0f\xff\x00\x00\x1b\xff\x11\xff\x00\x00\x00\x00\x00\x00\x00\x00\xac\xff\x00\x00\x00\x00\x00\x00\x00\x00\x4f\xff\x5a\xff\xf5\xfe\x00\x00\xf3\xfe\xa4\xff\xb6\xff\x77\xff\xb3\xff\x00\x00\xb4\xff\x00\x00\xb8\xff\x94\xff\x92\xff\xc7\xff\x00\x00\x00\x00\x00\x00\x00\x00\xbb\xff\xc5\xff\xbb\xff\xc9\xff\xe7\xff\xe8\xff\x00\x00\xe0\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\xff\xc8\xff\xab\xff\x00\x00\x00\x00\xd1\xff\x00\x00\xe1\xff\xc1\xff\xc2\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\xff\x51\xff\x4d\xff\x4b\xff\x4a\xff\x2d\xff\xf3\xff\x27\xff\xc6\xff\x00\x00\xc0\xff\xbe\xff\x00\x00\x00\x00\xe2\xff\xd2\xff\xaa\xff\x00\x00\xa9\xff\xa8\xff\xe5\xff\x00\x00\xbf\xff\xf2\xff\xe3\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x12\x00\x01\x00\x02\x00\x03\x00\x1b\x00\x1c\x00\x13\x00\x1a\x00\x13\x00\x06\x00\x01\x00\x0b\x00\x0c\x00\x31\x00\x0e\x00\x0f\x00\x10\x00\x1b\x00\x1c\x00\x13\x00\x14\x00\x15\x00\x2c\x00\x22\x00\x23\x00\x19\x00\x1a\x00\x01\x00\x02\x00\x03\x00\x23\x00\x31\x00\x31\x00\x18\x00\x31\x00\x39\x00\x3b\x00\x0b\x00\x0c\x00\x2c\x00\x0e\x00\x0f\x00\x10\x00\x1b\x00\x1c\x00\x13\x00\x14\x00\x15\x00\x3d\x00\x3b\x00\x29\x00\x19\x00\x1a\x00\x01\x00\x02\x00\x03\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x4f\x00\x50\x00\x4f\x00\x0b\x00\x0c\x00\x13\x00\x0e\x00\x0f\x00\x10\x00\x4f\x00\x50\x00\x13\x00\x14\x00\x15\x00\x33\x00\x3b\x00\x2a\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x03\x00\x4f\x00\x3d\x00\x3a\x00\x3b\x00\x33\x00\x34\x00\x2a\x00\x0b\x00\x0c\x00\x39\x00\x0e\x00\x0f\x00\x10\x00\x4f\x00\x50\x00\x13\x00\x14\x00\x15\x00\x14\x00\x4f\x00\x4f\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x03\x00\x17\x00\x12\x00\x3a\x00\x3b\x00\x01\x00\x24\x00\x4f\x00\x0b\x00\x0c\x00\x20\x00\x0e\x00\x0f\x00\x10\x00\x3b\x00\x15\x00\x13\x00\x14\x00\x15\x00\x19\x00\x1a\x00\x33\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x26\x00\x09\x00\x18\x00\x3a\x00\x3b\x00\x08\x00\x24\x00\x0a\x00\x4f\x00\x50\x00\x0d\x00\x31\x00\x0f\x00\x22\x00\x23\x00\x15\x00\x13\x00\x14\x00\x15\x00\x19\x00\x1a\x00\x33\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x24\x00\x3a\x00\x3b\x00\x0b\x00\x0c\x00\x22\x00\x0e\x00\x0f\x00\x10\x00\x22\x00\x23\x00\x13\x00\x14\x00\x15\x00\x32\x00\x33\x00\x2d\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x3d\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x2d\x00\x3a\x00\x3b\x00\x0b\x00\x0c\x00\x15\x00\x0e\x00\x0f\x00\x10\x00\x19\x00\x1a\x00\x13\x00\x14\x00\x15\x00\x1e\x00\x1b\x00\x1c\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x13\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x0b\x00\x0c\x00\x3b\x00\x0e\x00\x0f\x00\x10\x00\x1e\x00\x1f\x00\x13\x00\x14\x00\x15\x00\x1c\x00\x1b\x00\x1c\x00\x19\x00\x1a\x00\x3a\x00\x3b\x00\x23\x00\x4f\x00\x50\x00\x3b\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x0c\x00\x13\x00\x0e\x00\x0f\x00\x10\x00\x43\x00\x23\x00\x13\x00\x14\x00\x15\x00\x27\x00\x4f\x00\x50\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x4f\x00\x3b\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x0c\x00\x23\x00\x0e\x00\x0f\x00\x10\x00\x27\x00\x04\x00\x13\x00\x14\x00\x15\x00\x08\x00\x09\x00\x0a\x00\x19\x00\x1a\x00\x4f\x00\x50\x00\x29\x00\x3d\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x3a\x00\x3b\x00\x0d\x00\x18\x00\x0f\x00\x34\x00\x1b\x00\x1c\x00\x13\x00\x14\x00\x15\x00\x2a\x00\x21\x00\x2a\x00\x19\x00\x1a\x00\x2d\x00\x26\x00\x25\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x3a\x00\x3b\x00\x00\x00\x39\x00\x30\x00\x24\x00\x04\x00\x27\x00\x06\x00\x24\x00\x08\x00\x09\x00\x0a\x00\x2d\x00\x2e\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x32\x00\x33\x00\x4f\x00\x50\x00\x2e\x00\x3a\x00\x3b\x00\x18\x00\x19\x00\x00\x00\x1b\x00\x13\x00\x3d\x00\x04\x00\x16\x00\x06\x00\x21\x00\x08\x00\x09\x00\x0a\x00\x24\x00\x26\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x01\x00\x30\x00\x53\x00\x18\x00\x19\x00\x33\x00\x1b\x00\x4f\x00\x50\x00\x49\x00\x4a\x00\x53\x00\x21\x00\x3c\x00\x3d\x00\x4f\x00\x50\x00\x26\x00\x23\x00\x53\x00\x00\x00\x4f\x00\x27\x00\x51\x00\x04\x00\x3d\x00\x3e\x00\x30\x00\x08\x00\x09\x00\x0a\x00\x27\x00\x01\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x2d\x00\x2e\x00\x3c\x00\x3d\x00\x45\x00\x27\x00\x4f\x00\x18\x00\x01\x00\x16\x00\x1b\x00\x2d\x00\x2e\x00\x24\x00\x4f\x00\x24\x00\x21\x00\x2f\x00\x30\x00\x20\x00\x21\x00\x26\x00\x24\x00\x24\x00\x25\x00\x26\x00\x27\x00\x32\x00\x33\x00\x32\x00\x33\x00\x30\x00\x2d\x00\x2e\x00\x4f\x00\x50\x00\x32\x00\x33\x00\x53\x00\x3d\x00\x45\x00\x46\x00\x45\x00\x46\x00\x3d\x00\x4f\x00\x50\x00\x00\x00\x24\x00\x53\x00\x4f\x00\x04\x00\x4f\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x32\x00\x4f\x00\x50\x00\x1c\x00\x4f\x00\x53\x00\x18\x00\x19\x00\x04\x00\x1b\x00\x23\x00\x56\x00\x08\x00\x09\x00\x0a\x00\x21\x00\x4d\x00\x15\x00\x4f\x00\x15\x00\x26\x00\x19\x00\x1a\x00\x19\x00\x1a\x00\x1d\x00\x02\x00\x1d\x00\x18\x00\x15\x00\x30\x00\x19\x00\x32\x00\x19\x00\x1a\x00\x00\x00\x23\x00\x21\x00\x1e\x00\x04\x00\x27\x00\x06\x00\x3c\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x3d\x00\x3a\x00\x3b\x00\x3a\x00\x3b\x00\x2a\x00\x18\x00\x19\x00\x2d\x00\x1b\x00\x24\x00\x45\x00\x46\x00\x3a\x00\x3b\x00\x21\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x26\x00\x4f\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x31\x00\x23\x00\x43\x00\x44\x00\x30\x00\x27\x00\x32\x00\x31\x00\x4f\x00\x50\x00\x2a\x00\x00\x00\x4d\x00\x4e\x00\x4f\x00\x04\x00\x3c\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x4f\x00\x50\x00\x22\x00\x23\x00\x53\x00\x54\x00\x18\x00\x19\x00\x04\x00\x1b\x00\x22\x00\x23\x00\x08\x00\x09\x00\x0a\x00\x21\x00\x24\x00\x15\x00\x27\x00\x22\x00\x26\x00\x19\x00\x1a\x00\x00\x00\x2d\x00\x2e\x00\x2a\x00\x04\x00\x18\x00\x06\x00\x30\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x15\x00\x3c\x00\x27\x00\x2d\x00\x19\x00\x1a\x00\x18\x00\x19\x00\x23\x00\x1b\x00\x22\x00\x23\x00\x27\x00\x3a\x00\x3b\x00\x21\x00\x36\x00\x4f\x00\x50\x00\x23\x00\x26\x00\x53\x00\x22\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x1c\x00\x30\x00\x08\x00\x09\x00\x0a\x00\x4f\x00\x50\x00\x15\x00\x3a\x00\x3b\x00\x25\x00\x19\x00\x1a\x00\x3c\x00\x06\x00\x15\x00\x2a\x00\x2b\x00\x18\x00\x15\x00\x0c\x00\x1b\x00\x35\x00\x19\x00\x1a\x00\x11\x00\x39\x00\x21\x00\x22\x00\x4f\x00\x50\x00\x2c\x00\x26\x00\x19\x00\x28\x00\x4f\x00\x50\x00\x2b\x00\x23\x00\x53\x00\x24\x00\x2f\x00\x27\x00\x22\x00\x3a\x00\x3b\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x32\x00\x33\x00\x3a\x00\x3b\x00\x13\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x4f\x00\x50\x00\x08\x00\x09\x00\x0a\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x31\x00\x4f\x00\x50\x00\x14\x00\x15\x00\x4f\x00\x50\x00\x18\x00\x04\x00\x05\x00\x1b\x00\x27\x00\x08\x00\x09\x00\x0a\x00\x2c\x00\x21\x00\x2d\x00\x2e\x00\x4f\x00\x50\x00\x26\x00\x4f\x00\x28\x00\x51\x00\x52\x00\x2b\x00\x05\x00\x18\x00\x07\x00\x2f\x00\x2a\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x37\x00\x38\x00\x08\x00\x09\x00\x0a\x00\x2a\x00\x04\x00\x05\x00\x01\x00\x2b\x00\x08\x00\x09\x00\x0a\x00\x4f\x00\x50\x00\x15\x00\x01\x00\x53\x00\x18\x00\x04\x00\x2a\x00\x1b\x00\x1c\x00\x08\x00\x09\x00\x0a\x00\x18\x00\x21\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x26\x00\x39\x00\x28\x00\x21\x00\x13\x00\x2b\x00\x2a\x00\x18\x00\x2a\x00\x2f\x00\x3c\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x37\x00\x38\x00\x08\x00\x09\x00\x0a\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x4f\x00\x50\x00\x15\x00\x23\x00\x13\x00\x18\x00\x04\x00\x2c\x00\x1b\x00\x1c\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x21\x00\x1e\x00\x1f\x00\x20\x00\x1c\x00\x26\x00\x23\x00\x28\x00\x4f\x00\x50\x00\x2b\x00\x02\x00\x18\x00\x31\x00\x2f\x00\x31\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x37\x00\x38\x00\x08\x00\x09\x00\x0a\x00\x27\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3c\x00\x24\x00\x15\x00\x24\x00\x13\x00\x18\x00\x04\x00\x13\x00\x1b\x00\x1c\x00\x08\x00\x09\x00\x0a\x00\x22\x00\x21\x00\x32\x00\x33\x00\x32\x00\x33\x00\x26\x00\x2c\x00\x28\x00\x4f\x00\x50\x00\x2b\x00\x22\x00\x18\x00\x13\x00\x2f\x00\x20\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x37\x00\x38\x00\x08\x00\x09\x00\x0a\x00\x27\x00\x4f\x00\x50\x00\x04\x00\x23\x00\x49\x00\x1d\x00\x08\x00\x09\x00\x0a\x00\x15\x00\x4f\x00\x50\x00\x18\x00\x13\x00\x53\x00\x1b\x00\x01\x00\x2c\x00\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x4f\x00\x28\x00\x51\x00\x52\x00\x2b\x00\x4f\x00\x50\x00\x2d\x00\x2f\x00\x53\x00\x27\x00\x55\x00\x18\x00\x4f\x00\x50\x00\x1b\x00\x37\x00\x38\x00\x29\x00\x2a\x00\x2b\x00\x21\x00\x4f\x00\x04\x00\x51\x00\x52\x00\x26\x00\x08\x00\x09\x00\x0a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x32\x00\x30\x00\x08\x00\x09\x00\x0a\x00\x13\x00\x35\x00\x2a\x00\x18\x00\x13\x00\x39\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x15\x00\x2c\x00\x21\x00\x18\x00\x31\x00\x2c\x00\x1b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x21\x00\x3c\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x21\x00\x28\x00\x01\x00\x13\x00\x2b\x00\x04\x00\x05\x00\x2a\x00\x2f\x00\x08\x00\x09\x00\x0a\x00\x18\x00\x26\x00\x2c\x00\x1b\x00\x37\x00\x38\x00\x04\x00\x13\x00\x23\x00\x21\x00\x08\x00\x09\x00\x0a\x00\x18\x00\x26\x00\x13\x00\x28\x00\x3a\x00\x3b\x00\x2b\x00\x2d\x00\x4f\x00\x21\x00\x51\x00\x52\x00\x13\x00\x18\x00\x26\x00\x32\x00\x1b\x00\x2d\x00\x37\x00\x38\x00\x00\x00\x09\x00\x21\x00\x22\x00\x16\x00\x4f\x00\x50\x00\x26\x00\x49\x00\x1f\x00\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\x17\x00\x30\x00\x53\x00\x2d\x00\x2e\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x04\x00\x4f\x00\x30\x00\x04\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x09\x00\x0a\x00\x04\x00\x18\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x18\x00\x42\x00\x42\x00\x18\x00\x4f\x00\x50\x00\x1b\x00\x42\x00\x53\x00\x18\x00\x00\x00\x42\x00\x21\x00\xff\xff\x04\x00\x27\x00\x4f\x00\x26\x00\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x30\x00\xff\xff\x32\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x18\x00\x04\x00\xff\xff\x1b\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x21\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x26\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\xff\xff\x18\x00\xff\xff\x1a\x00\x30\x00\x21\x00\x32\x00\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\xff\xff\x2d\x00\x2e\x00\x4f\x00\x50\x00\xff\xff\x32\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x11\x00\x12\x00\x13\x00\x14\x00\xff\xff\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\xff\xff\x2d\x00\x2e\x00\x4f\x00\x50\x00\xff\xff\x32\x00\x53\x00\xff\xff\x35\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\x4f\x00\x50\x00\x4f\x00\x50\x00\x2d\x00\x2e\x00\x53\x00\xff\xff\x4f\x00\x21\x00\x51\x00\x52\x00\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x11\x00\x12\x00\x13\x00\x14\x00\xff\xff\x2d\x00\x2e\x00\xff\xff\x4f\x00\x50\x00\x21\x00\xff\xff\x53\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x39\x00\x3a\x00\x3b\x00\x2d\x00\x2e\x00\xff\xff\x4f\x00\x50\x00\xff\xff\x4f\x00\x53\x00\x51\x00\x52\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x53\x00\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x39\x00\x3a\x00\x3b\x00\x4f\x00\x50\x00\x2d\x00\x2e\x00\x53\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4d\x00\x4e\x00\x4f\x00\xff\xff\xff\xff\x2d\x00\x2e\x00\x4f\x00\x50\x00\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\xff\xff\x2d\x00\x2e\x00\x29\x00\x2a\x00\x2b\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\x4f\x00\x50\x00\x2d\x00\x2e\x00\x53\x00\xff\xff\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x29\x00\x2a\x00\x2b\x00\xff\xff\xff\xff\x2d\x00\x2e\x00\xff\xff\x4f\x00\x50\x00\x21\x00\xff\xff\x53\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x39\x00\x3a\x00\x3b\x00\x2d\x00\x2e\x00\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x53\x00\x2d\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x29\x00\x2a\x00\x2b\x00\x4f\x00\x50\x00\x2d\x00\x2e\x00\x53\x00\x21\x00\x41\x00\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x2d\x00\x2e\x00\xff\xff\x4f\x00\x50\x00\x4f\x00\x50\x00\x53\x00\xff\xff\x53\x00\xff\xff\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x2d\x00\x2e\x00\x1c\x00\x29\x00\x2a\x00\x2b\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\x27\x00\x29\x00\x2a\x00\x2b\x00\xff\xff\xff\xff\x2d\x00\x2e\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x4f\x00\x50\x00\xff\xff\x04\x00\x53\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\xff\xff\x18\x00\x19\x00\x00\x00\x1b\x00\xff\xff\xff\xff\x04\x00\xff\xff\xff\xff\x21\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x26\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x30\x00\x3a\x00\x18\x00\xff\xff\xff\xff\x1b\x00\xff\xff\x1c\x00\x29\x00\x2a\x00\x2b\x00\x21\x00\xff\xff\xff\xff\x00\x00\xff\xff\x26\x00\x27\x00\x04\x00\x12\x00\x13\x00\x14\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x30\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x18\x00\xff\xff\xff\xff\x1b\x00\x12\x00\x13\x00\x14\x00\xff\xff\xff\xff\x21\x00\xff\xff\xff\xff\x00\x00\xff\xff\x26\x00\x27\x00\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x30\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x4d\x00\x4e\x00\x4f\x00\xff\xff\x22\x00\x23\x00\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x26\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x22\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\x29\x00\x2a\x00\x2b\x00\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x27\x00\xff\xff\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\x05\x00\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\x22\x00\xff\xff\x18\x00\x2a\x00\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x30\x00\x23\x00\xff\xff\x18\x00\xff\xff\x27\x00\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x26\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x39\x00\x3a\x00\x3b\x00\x3c\x00\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x26\x00\x4f\x00\x50\x00\x04\x00\x05\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\xff\xff\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\x10\x00\x1b\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x21\x00\x18\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x21\x00\xff\xff\x1b\x00\xff\xff\xff\xff\x26\x00\x04\x00\xff\xff\x21\x00\x22\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x04\x00\x30\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x21\x00\xff\xff\x1b\x00\xff\xff\xff\xff\x26\x00\x04\x00\xff\xff\x21\x00\x2a\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x04\x00\x30\x00\xff\xff\x2a\x00\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x30\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x18\x00\x21\x00\x1a\x00\x4f\x00\x50\x00\xff\xff\x26\x00\x53\x00\x13\x00\xff\xff\xff\xff\x16\x00\x17\x00\xff\xff\xff\xff\xff\xff\x30\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\xff\xff\xff\xff\x27\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x2d\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x3d\x00\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\x29\x00\x2a\x00\x2b\x00\x04\x00\xff\xff\x21\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x26\x00\x24\x00\x28\x00\xff\xff\xff\xff\x2b\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x2d\x00\x2e\x00\xff\xff\x18\x00\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\xff\xff\x3d\x00\xff\xff\x4f\x00\x50\x00\x3f\x00\x40\x00\x41\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x3f\x00\x40\x00\x41\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x3f\x00\x40\x00\x41\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x3f\x00\x40\x00\x41\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x3f\x00\x40\x00\x41\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\x42\x00\xff\xff\x53\x00\xff\xff\xff\xff\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x4c\x00\xff\xff\x2a\x00\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\x56\x00\x57\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x2c\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\x4c\x00\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x47\x00\x48\x00\x49\x00\xff\xff\x4b\x00\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x53\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x72\x00\x73\x00\x74\x00\x75\x00\xac\x00\xa2\x00\x89\x00\x23\x01\x89\x00\xee\x01\xb5\x00\x76\x00\x77\x00\x67\x00\x78\x00\x79\x00\x7a\x00\xa1\x00\xa2\x00\x7b\x00\x7c\x00\x7d\x00\x3c\x01\x0f\x01\x10\x01\x54\x00\x55\x00\xa7\x01\x74\x00\x75\x00\xa5\x00\x73\x00\xfe\x00\xb6\x00\x53\x00\xa0\x00\xa3\x00\x76\x00\x77\x00\xa6\x00\x78\x00\x79\x00\x7a\x00\x10\x01\xa2\x00\x7b\x00\x7c\x00\x7d\x00\xff\xff\xa3\x00\xb7\x00\x54\x00\x55\x00\xea\x01\x74\x00\x75\x00\x12\x00\x92\x00\x57\x00\x58\x00\x12\x00\x24\x01\xff\x00\x76\x00\x77\x00\xe9\x00\x78\x00\x79\x00\x7a\x00\x12\x00\x92\x00\x7b\x00\x7c\x00\x7d\x00\x8a\x01\xa3\x00\x9f\x00\x54\x00\x55\x00\x12\x00\x59\x00\x59\x01\xef\x01\x6f\x01\x57\x00\x58\x00\xb7\x00\xb8\x00\x4a\x01\x5a\x01\x77\x00\xa0\x00\x78\x00\x79\x00\x7a\x00\x12\x00\x92\x00\x7b\x00\x7c\x00\x7d\x00\x47\x00\x8b\x00\xb9\x00\x54\x00\x55\x00\x12\x00\x59\x00\x57\x01\x04\x01\x0e\x00\x57\x00\x58\x00\xb5\x00\x55\x01\xb9\x00\x58\x01\x77\x00\x05\x01\x78\x00\x79\x00\x7a\x00\x2b\x01\x63\x00\x7b\x00\x7c\x00\x7d\x00\x54\x00\x55\x00\x56\x01\x54\x00\x55\x00\x12\x00\x59\x00\x42\x01\xcb\x01\xb6\x00\x57\x00\x58\x00\x67\x00\x44\x01\x68\x00\x12\x00\x92\x00\x69\x00\x43\x01\x6a\x00\x3d\x01\x3a\x01\xa0\x00\x6b\x00\x6c\x00\x6d\x00\x54\x00\x55\x00\x46\x01\x54\x00\x55\x00\x12\x00\x59\x00\x57\x00\x58\x00\xe4\xff\x57\x00\x58\x00\x86\x00\x77\x00\xe9\x01\x78\x00\x79\x00\x7a\x00\x3b\x01\x38\x01\x7b\x00\x7c\x00\x7d\x00\xe4\xff\xe4\xff\xa9\x01\x54\x00\x55\x00\x12\x00\x59\x00\xff\xff\x12\x00\x59\x00\x57\x00\x58\x00\xe0\x00\x57\x00\x58\x00\x62\x01\x77\x00\xa7\x00\x78\x00\x79\x00\x7a\x00\x54\x00\x55\x00\x7b\x00\x7c\x00\x7d\x00\xa8\x00\x01\x01\xa2\x00\x54\x00\x55\x00\x12\x00\x59\x00\x89\x00\x12\x00\x59\x00\x57\x00\x58\x00\xcf\x01\x77\x00\x26\x01\x78\x00\x79\x00\x7a\x00\xaf\x01\xb0\x01\x7b\x00\x7c\x00\x7d\x00\x39\x01\xcb\x01\xa2\x00\x54\x00\x55\x00\x57\x00\x58\x00\x3a\x01\x12\x00\x59\x00\xa3\x00\x12\x00\x92\x00\x57\x00\x58\x00\x6a\x01\x89\x00\x78\x00\x79\x00\x7a\x00\x9a\x01\x40\x01\x7b\x00\x7c\x00\x7d\x00\x41\x01\x12\x00\x59\x00\x54\x00\x55\x00\x12\x00\x92\x00\x9b\x01\xa3\x00\x12\x00\x59\x00\x57\x00\x58\x00\x69\x01\x13\x01\x78\x00\x79\x00\x7a\x00\x14\x01\x17\x00\x7b\x00\x7c\x00\x7d\x00\x19\x00\x1a\x00\x1b\x00\x54\x00\x55\x00\x12\x00\x92\x00\x16\x01\xff\xff\x12\x00\x59\x00\xc8\x00\x90\x00\x57\x00\x58\x00\x85\x00\x1c\x00\x6a\x00\x17\x01\x60\x00\x98\x00\x6b\x00\x6c\x00\x6d\x00\x03\x01\x94\x00\xa3\xff\x54\x00\x55\x00\xa3\xff\x62\x00\xcb\x00\x12\x00\xc9\x00\x12\x00\x59\x00\x57\x00\x58\x00\x5b\x00\xa0\x00\x63\x00\x44\x01\x17\x00\xab\x00\x6f\x00\xa7\x00\x19\x00\x1a\x00\x1b\x00\x3f\x00\x40\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x45\x01\x46\x01\x12\x00\x59\x00\xcb\x00\x57\x00\x58\x00\x1c\x00\xbb\xff\x5b\x00\x60\x00\x89\x00\xff\xff\x17\x00\x06\x01\x6f\x00\x61\x00\x19\x00\x1a\x00\x1b\x00\x44\x01\x62\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x12\x00\x59\x00\x12\x00\x13\x00\x9d\x00\x63\x00\x41\x00\x1c\x00\xbb\xff\x46\x01\x60\x00\x12\x00\x13\x00\xd9\x00\xda\x00\x41\x00\x61\x00\x70\x00\xdd\xff\x12\x00\x13\x00\x62\x00\xfb\x00\xdb\x00\x5b\x00\x25\x00\xfc\x00\xe5\x00\x17\x00\x89\x00\x8a\x00\x63\x00\x19\x00\x1a\x00\x1b\x00\xaa\x00\x9c\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x3f\x00\x40\x00\x70\x00\xde\xff\x77\x01\xab\x00\x8b\x00\x1c\x00\x9b\x00\x38\x00\x60\x00\x3f\x00\x40\x00\x20\x01\x33\x01\x44\x01\x61\x00\xb2\x00\xb3\x00\x39\x00\x3a\x00\x62\x00\xc4\x01\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x21\x01\x22\x01\xc7\x01\x46\x01\x63\x00\x3f\x00\x40\x00\x12\x00\x13\x00\xc5\x01\xc6\x01\x41\x00\xff\xff\x31\x01\x32\x01\x31\x01\x79\x01\xff\xff\x12\x00\x13\x00\x5b\x00\x85\x00\x41\x00\x33\x01\x17\x00\x33\x01\xbb\xff\x7f\x00\x19\x00\x1a\x00\x80\x00\x81\x00\xbb\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xbb\xff\x57\x01\x12\x00\x13\x00\x37\x01\xb2\x01\x41\x00\x1c\x00\xbb\xff\x17\x00\x60\x00\x38\x01\xb3\x01\x19\x00\x1a\x00\x1b\x00\x61\x00\x9c\x01\x53\x00\xf1\x00\x53\x00\x62\x00\x54\x00\x55\x00\x54\x00\x55\x00\x56\x00\x83\x00\x6d\x01\x1c\x00\xa7\x00\x63\x00\x84\x00\xec\xff\x54\x00\x55\x00\x5b\x00\xf9\x00\x49\x01\x6b\x01\x17\x00\xfa\x00\xbb\xff\x70\x00\x19\x00\x1a\x00\x80\x00\x81\x00\xbb\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xbb\xff\xff\xff\x57\x00\x58\x00\x57\x00\x58\x00\xa2\xff\x1c\x00\xbb\xff\xa2\xff\x60\x00\x47\x01\x31\x01\xcd\x01\x57\x00\x58\x00\x61\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x62\x00\x33\x01\x12\x00\x59\x00\x12\x00\x59\x00\x4c\x01\xf5\x00\xce\x00\xcf\x00\x63\x00\x87\x01\x88\x00\x4b\x01\x12\x00\x59\x00\x3f\x01\x5b\x00\xd0\x00\xd1\x00\xd2\x00\x17\x00\x70\x00\xbb\xff\x7f\x00\x19\x00\x1a\x00\x80\x00\x81\x00\xbb\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xbb\xff\x12\x00\x13\x00\x0d\x01\x08\x01\x14\x00\x15\x00\x1c\x00\xbb\xff\x17\x00\x60\x00\xf4\x00\xf5\x00\x19\x00\x1a\x00\x1b\x00\x61\x00\x29\x01\x51\x01\xaa\x00\x3e\x01\x62\x00\x54\x00\x55\x00\x5b\x00\x3f\x00\x40\x00\x28\x01\x17\x00\x1c\x00\xbb\xff\x63\x00\x19\x00\x1a\x00\x80\x00\x81\x00\xbb\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xbb\xff\x80\x01\x70\x00\xd4\x00\x1f\x01\x54\x00\x55\x00\x1c\x00\xbb\xff\x84\x01\x60\x00\xf6\x01\xf7\x01\x85\x01\x57\x00\x58\x00\x61\x00\x15\x01\x12\x00\x13\x00\x08\x01\x62\x00\x41\x00\x0e\x01\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x07\x01\x63\x00\x19\x00\x1a\x00\x1b\x00\x12\x00\x59\x00\x7f\x01\x57\x00\x58\x00\xcb\x00\x54\x00\x55\x00\x70\x00\x4f\x01\x48\x00\x9d\x00\x11\x00\x1c\x00\xa0\x00\x50\x01\x49\x00\xa0\x01\x54\x00\x55\x00\x51\x01\xa1\x01\x4a\x00\xbf\x00\x12\x00\x59\x00\xf8\x00\x4b\x00\x84\x00\x4c\x00\x12\x00\x13\x00\x4d\x00\xf9\x00\x5d\x01\x20\x01\x4e\x00\xf5\x01\xea\x00\x57\x00\x58\x00\x1e\x00\x1f\x00\x20\x00\xc0\x00\xc1\x00\x23\x00\x24\x00\x25\x00\xbe\x01\x22\x01\x57\x00\x58\x00\xe9\x00\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x12\x00\x59\x00\x19\x00\x1a\x00\x1b\x00\x8f\x01\x90\x01\x91\x01\x92\x01\x8f\x00\x90\x00\xa7\x01\x12\x00\x59\x00\x47\x00\x48\x00\x12\x00\x98\x00\x1c\x00\x17\x00\x29\x00\x49\x00\xfd\x00\x19\x00\x1a\x00\x1b\x00\xa4\x01\x4a\x00\x3f\x00\x40\x00\x12\x00\x92\x00\x4b\x00\x25\x00\x4c\x00\x26\x00\x27\x00\x4d\x00\xc8\x01\x1c\x00\xc9\x01\x4e\x00\x9a\x01\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x4f\x00\x50\x00\x19\x00\x1a\x00\x1b\x00\x8d\x01\x17\x00\x18\x00\x8a\x01\x2a\x00\x19\x00\x1a\x00\x1b\x00\x12\x00\x13\x00\x48\x00\x01\x01\x41\x00\x1c\x00\x17\x00\x86\x01\x49\x00\xc5\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x4a\x00\xe6\x00\x0f\x00\x10\x00\x11\x00\x4b\x00\xa0\x00\x4c\x00\x1d\x00\x89\x00\x4d\x00\x7d\x01\x1c\x00\x72\x01\x4e\x00\x70\x00\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x4f\x00\x50\x00\x19\x00\x1a\x00\x1b\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x12\x00\x47\x01\x48\x00\x7c\x01\x89\x00\x1c\x00\x17\x00\x69\x01\x49\x00\x54\xff\x19\x00\x1a\x00\x1b\x00\x62\x01\x4a\x00\x09\x01\x0a\x01\x0b\x01\xf1\x00\x4b\x00\x0c\x01\x4c\x00\x12\x00\x30\x01\x4d\x00\x60\x01\x1c\x00\x5d\x01\x4e\x00\x5c\x01\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x4f\x00\x50\x00\x19\x00\x1a\x00\x1b\x00\xbb\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x70\x00\x44\x01\x48\x00\xc4\x01\xc1\x01\x1c\x00\x17\x00\x89\x00\x49\x00\x52\xff\x19\x00\x1a\x00\x1b\x00\xc0\x01\x4a\x00\xd3\x01\x46\x01\xd2\x01\xc6\x01\x4b\x00\xbb\x01\x4c\x00\x12\x00\x5e\x01\x4d\x00\xb5\x01\x1c\x00\x89\x00\x4e\x00\xae\x01\x43\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x4f\x00\x50\x00\x19\x00\x1a\x00\x1b\x00\x8d\x00\x12\x00\xc1\x01\x17\x00\xad\x01\xdd\x00\xac\x01\x19\x00\x1a\x00\x1b\x00\x48\x00\x12\x00\x13\x00\x1c\x00\x89\x00\xdb\x00\x49\x00\x33\x00\xaa\x01\x34\x00\x17\x00\x18\x00\x4a\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x4b\x00\x25\x00\x4c\x00\x26\x00\xe7\x00\x4d\x00\x12\x00\x13\x00\xa9\x01\x4e\x00\xad\x00\xf3\x00\xae\x00\x1c\x00\x12\x00\xdb\x01\x35\x00\x4f\x00\x50\x00\xe0\x00\x10\x00\x11\x00\x36\x00\x25\x00\x17\x00\x26\x00\x81\x00\xd8\x00\x19\x00\x1a\x00\x1b\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\xe8\x01\x38\x00\x19\x00\x1a\x00\x1b\x00\x89\x00\xa0\x01\x86\x01\x1c\x00\x89\x00\xa1\x01\xcc\x00\x0f\x00\x10\x00\x11\x00\x48\x00\xe0\x01\x26\x01\x1c\x00\xdf\x01\xde\x01\x49\x00\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x4a\x00\x70\x00\x19\x00\x1a\x00\x1b\x00\x4b\x00\xd9\x01\x4c\x00\xb0\x00\x89\x00\x4d\x00\x17\x00\x18\x00\xd8\x01\x4e\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\xd5\x01\xee\x01\x49\x00\x4f\x00\x50\x00\x17\x00\x89\x00\xad\x01\x4a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x4b\x00\x89\x00\x4c\x00\x29\x01\x90\x00\x4d\x00\xa9\x01\x25\x00\xb1\x00\x26\x00\x4c\x01\x89\x00\x1c\x00\xb2\x00\xf9\x01\x60\x00\xa9\x01\x4f\x00\x50\x00\x70\x00\x65\x00\x94\x00\x95\x00\x50\x00\x12\x00\x92\x00\x62\x00\xef\x00\x51\x00\x97\x01\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x4d\x01\x63\x00\xdb\x00\x3f\x00\x40\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x5b\x00\x17\x00\x76\x01\x88\x01\x17\x00\x19\x00\x1a\x00\x1b\x00\x19\x00\x1a\x00\x1b\x00\x60\x01\xd3\x01\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x2c\x01\x10\x00\x11\x00\x2f\x01\x1c\x00\xe6\x01\x9d\x01\x1c\x00\x12\x00\x13\x00\x60\x00\xe0\x01\x41\x00\xf1\x01\x5b\x00\xf7\x01\x61\x00\x00\x00\x17\x00\xf4\x01\xf9\x01\x62\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x63\x00\x00\x00\xaa\x00\x2c\x01\x10\x00\x11\x00\x2e\x01\x1c\x00\x17\x00\x00\x00\x60\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x61\x00\x2c\x01\x10\x00\x11\x00\x2d\x01\x62\x00\xe3\x01\x91\x01\x92\x01\x8f\x00\x90\x00\x00\x00\x1c\x00\x00\x00\x9a\x00\x63\x00\xbb\x00\x6d\x01\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\xbc\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x3f\x00\x40\x00\x12\x00\x92\x00\x00\x00\xbd\x00\xc5\x00\xc6\x00\xc7\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x63\x01\x64\x01\x6b\x00\x65\x01\x00\x00\x3f\x00\x40\x00\xc1\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\xe4\x01\x92\x01\x8f\x00\x90\x00\x00\x00\x3f\x00\x40\x00\x12\x00\x13\x00\x00\x00\xc2\x00\x41\x00\x00\x00\xc3\x00\x00\x00\xc5\x00\x00\x00\x96\x01\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x12\x00\x92\x00\x12\x00\x13\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x25\x00\x64\x00\x26\x00\x66\x01\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\x2a\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\xd0\x01\x64\x01\x6b\x00\x65\x01\x00\x00\x3f\x00\x40\x00\x00\x00\x12\x00\x13\x00\x98\x01\x00\x00\x41\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x74\x01\x8f\x00\x90\x00\x3f\x00\x40\x00\x00\x00\x12\x00\x13\x00\x00\x00\x25\x00\x41\x00\x26\x00\xc7\x01\x95\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x12\x00\x92\x00\x41\x00\x3f\x00\x40\x00\x94\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x73\x01\x8f\x00\x90\x00\x12\x00\x13\x00\x3f\x00\x40\x00\x41\x00\x93\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\xd0\x00\xd1\x00\xf1\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x12\x00\x92\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x00\x00\x00\x00\x8e\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\x00\x00\x8d\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\x8b\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x95\x00\x8f\x00\x90\x00\x96\x00\x00\x00\x3f\x00\x40\x00\xe0\x00\x10\x00\x11\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x7d\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x92\x00\x00\x00\x12\x00\x13\x00\x3f\x00\x40\x00\x41\x00\x00\x00\x00\x00\xbb\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\xb5\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x7e\x01\x10\x00\x11\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x00\x00\x12\x00\x13\x00\xb0\x01\x00\x00\x41\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x70\x01\x8f\x00\x90\x00\x3f\x00\x40\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x00\x00\x00\x00\xaa\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x12\x00\x92\x00\x41\x00\x3f\x00\x40\x00\xe5\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x67\x01\x10\x00\x11\x00\x12\x00\x13\x00\x3f\x00\x40\x00\x41\x00\xe2\x01\xe3\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\xe4\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x3f\x00\x40\x00\x00\x00\x12\x00\x13\x00\x12\x00\x13\x00\x31\x00\x00\x00\x41\x00\x00\x00\x00\x00\xd6\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\x00\x00\xf0\x01\x00\x00\x00\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x3f\x00\x40\x00\xa6\x01\xe0\x00\x10\x00\x11\x00\x00\x00\x00\x00\x81\x01\x3c\x00\x3d\x00\x3e\x00\xb6\x01\x10\x00\x11\x00\x00\x00\x00\x00\x3f\x00\x40\x00\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x00\x00\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x5b\x00\x12\x00\x13\x00\x00\x00\x17\x00\x41\x00\xbc\xff\x00\x00\x19\x00\x1a\x00\x53\x01\x54\x01\xbc\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xbc\xff\x12\x00\x13\x00\x00\x00\x00\x00\x41\x00\x00\x00\x1c\x00\xbc\xff\x5b\x00\x60\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x61\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x62\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x63\x00\x24\x00\x1c\x00\x00\x00\x00\x00\x60\x00\x00\x00\xa5\x01\xe0\x00\x10\x00\x11\x00\x61\x00\x00\x00\x00\x00\x5b\x00\x00\x00\x62\x00\x6f\x01\x17\x00\xda\x01\x6b\x00\x65\x01\x19\x00\x1a\x00\x1b\x00\x00\x00\x63\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x1c\x00\x00\x00\x00\x00\x60\x00\xd9\x01\x6b\x00\x65\x01\x00\x00\x00\x00\x61\x00\x00\x00\x00\x00\x5b\x00\x00\x00\x62\x00\xbd\x01\x17\x00\x00\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x63\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xd0\x00\xf2\x01\xf1\x00\x00\x00\xf6\x00\xf7\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x60\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x61\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x62\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x63\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\xd7\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x17\x00\xe0\x00\x10\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x1d\x01\x00\x00\x17\x00\x00\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x36\x01\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x37\x00\x00\x00\x00\x00\x17\x00\x00\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x7b\x01\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x17\x00\x00\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x79\x01\x00\x00\xdf\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x17\x00\x00\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\xcf\x01\x00\x00\xdd\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x17\x00\x00\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\xb9\x01\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x17\x00\x29\x00\x35\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x83\x01\x00\x00\x1c\x00\xd6\x01\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x37\x00\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x38\x00\xf7\x00\x00\x00\x1c\x00\x00\x00\x88\x01\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\xdd\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x12\x00\x92\x00\x17\x00\x18\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x37\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xc3\x01\x35\x00\x33\x00\x00\x00\x34\x00\x17\x00\x18\x00\x36\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xd8\x00\x17\x00\x00\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x36\x00\x00\x00\x60\x00\x00\x00\x00\x00\x37\x00\x17\x00\x00\x00\x94\x00\x95\x00\x19\x00\x1a\x00\x1b\x00\x62\x00\x17\x00\x38\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x63\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x94\x00\x00\x00\x60\x00\x00\x00\x00\x00\x62\x00\x17\x00\x00\x00\x94\x00\x12\x01\x19\x00\x1a\x00\x1b\x00\x62\x00\x17\x00\x63\x00\x00\x00\xcd\x01\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x63\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x60\x00\xeb\x00\x2f\x00\x00\x00\x30\x00\x1c\x00\x94\x00\xdd\x01\x12\x00\x13\x00\x00\x00\x62\x00\x31\x00\x1b\xff\x00\x00\x00\x00\x1b\xff\x1b\xff\x00\x00\x00\x00\x00\x00\x63\x00\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x00\x00\x1b\xff\x1b\xff\x1b\xff\x00\x00\x00\x00\x1b\xff\x44\x00\x45\x00\x46\x00\x17\x00\x18\x00\x1b\xff\x1b\xff\x19\x00\x1a\x00\x1b\x00\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x1b\xff\x00\x00\x00\x00\x1b\xff\x00\x00\x1c\x00\x00\x00\x00\x00\x49\x00\x8d\x00\x10\x00\x11\x00\x17\x00\x00\x00\x4a\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x4b\x00\x17\xff\x4c\x00\x00\x00\x00\x00\x4d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x17\xff\x17\xff\x00\x00\x1c\x00\x00\x00\x17\xff\x17\xff\x17\xff\x17\xff\x17\xff\x17\xff\x17\xff\x17\xff\x17\xff\x00\x00\x00\x00\x17\xff\x00\x00\x12\x00\x92\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x22\x01\x2b\x00\x2c\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\xbe\x01\x2b\x00\x2c\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\xeb\x01\x2b\x00\x2c\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\xe9\x01\x2b\x00\x2c\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x9d\x01\x00\x00\x31\x00\x00\x00\x00\x00\x9e\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x17\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x18\x01\x00\x00\x45\xff\x19\x01\x13\x00\x00\x00\x00\x00\x31\x00\x00\x00\x00\x00\x1a\x01\x1b\x01\x45\xff\x45\xff\x45\xff\x45\xff\x45\xff\x45\xff\x45\xff\xce\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xe2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xd4\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\xd5\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xe2\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xd8\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x1d\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xfc\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xee\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xed\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xec\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xea\x00\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xa2\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xa1\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x75\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x72\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xb9\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xb7\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xb1\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x9e\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xe1\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\xec\x01\x2e\x00\x2f\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x00\x00\x31\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (12, 268) [
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268)
	]

happy_n_terms = 62 :: Int
happy_n_nonterms = 88 :: Int

happyReduce_12 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_12 = happyReduce 6# 0# happyReduction_12
happyReduction_12 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut97 happy_x_2 of { happy_var_2 -> 
	case happyOut16 happy_x_5 of { happy_var_5 -> 
	happyIn15
		 (mkModule happy_var_2 happy_var_5
	) `HappyStk` happyRest}}

happyReduce_13 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_13 = happyReduce 8# 0# happyReduction_13
happyReduction_13 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut97 happy_x_2 of { happy_var_2 -> 
	case happyOut97 happy_x_4 of { happy_var_4 -> 
	case happyOut16 happy_x_7 of { happy_var_7 -> 
	happyIn15
		 (mkModuleInstance happy_var_2 happy_var_4 happy_var_7
	) `HappyStk` happyRest}}}

happyReduce_14 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_14 = happySpecReduce_3  0# happyReduction_14
happyReduction_14 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (mkAnonymousModule happy_var_2
	)}

happyReduce_15 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_15 = happySpecReduce_3  1# happyReduction_15
happyReduction_15 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_16 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_16 = happySpecReduce_3  1# happyReduction_16
happyReduction_16 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_17 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_17 = happySpecReduce_1  1# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 ((reverse happy_var_1, [])
	)}

happyReduce_18 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_18 = happySpecReduce_1  1# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 (([], reverse happy_var_1)
	)}

happyReduce_19 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_19 = happySpecReduce_0  1# happyReduction_19
happyReduction_19  =  happyIn16
		 (([], [])
	)

happyReduce_20 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_20 = happySpecReduce_3  2# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_21 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_21 = happySpecReduce_3  2# happyReduction_21
happyReduction_21 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_22 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_22 = happySpecReduce_1  2# happyReduction_22
happyReduction_22 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn17
		 ([happy_var_1]
	)}

happyReduce_23 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_23 = happyReduce 4# 3# happyReduction_23
happyReduction_23 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_import)    _)) -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn18
		 (Located { srcRange = rComb happy_var_1
                                                   $ fromMaybe (srcRange happy_var_2)
                                                   $ msum [ fmap srcRange happy_var_4
                                                          , fmap srcRange happy_var_3
                                                          ]
                                        , thing    = Import
                                          { iModule    = thing happy_var_2
                                          , iAs        = fmap thing happy_var_3
                                          , iSpec      = fmap thing happy_var_4
                                          }
                                        }
	) `HappyStk` happyRest}}}}

happyReduce_24 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_24 = happySpecReduce_2  4# happyReduction_24
happyReduction_24 happy_x_2
	happy_x_1
	 =  case happyOut97 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (Just happy_var_2
	)}

happyReduce_25 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_25 = happySpecReduce_0  4# happyReduction_25
happyReduction_25  =  happyIn19
		 (Nothing
	)

happyReduce_26 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_26 = happyReduce 4# 5# happyReduction_26
happyReduction_26 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut21 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (Just Located
                                  { srcRange = case happy_var_3 of
                                      { [] -> emptyRange
                                      ; xs -> rCombs (map srcRange xs) }
                                  , thing    = happy_var_1 (reverse (map thing happy_var_3))
                                  }
	) `HappyStk` happyRest}}

happyReduce_27 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_27 = happySpecReduce_0  5# happyReduction_27
happyReduction_27  =  happyIn20
		 (Nothing
	)

happyReduce_28 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_28 = happySpecReduce_3  6# happyReduction_28
happyReduction_28 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_29 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_29 = happySpecReduce_1  6# happyReduction_29
happyReduction_29 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 ([happy_var_1]
	)}

happyReduce_30 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_30 = happySpecReduce_0  6# happyReduction_30
happyReduction_30  =  happyIn21
		 ([]
	)

happyReduce_31 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_31 = happySpecReduce_1  7# happyReduction_31
happyReduction_31 happy_x_1
	 =  happyIn22
		 (Hiding
	)

happyReduce_32 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_32 = happySpecReduce_0  7# happyReduction_32
happyReduction_32  =  happyIn22
		 (Only
	)

happyReduce_33 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_33 = happySpecReduce_1  8# happyReduction_33
happyReduction_33 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 (Program (reverse happy_var_1)
	)}

happyReduce_34 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_34 = happySpecReduce_0  8# happyReduction_34
happyReduction_34  =  happyIn23
		 (Program []
	)

happyReduce_35 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_35 = happySpecReduce_3  9# happyReduction_35
happyReduction_35 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (Program (reverse happy_var_2)
	)}

happyReduce_36 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_36 = happySpecReduce_2  9# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  happyIn24
		 (Program []
	)

happyReduce_37 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_37 = happySpecReduce_2  10# happyReduction_37
happyReduction_37 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (happy_var_1
	)}

happyReduce_38 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_38 = happySpecReduce_3  10# happyReduction_38
happyReduction_38 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn25
		 (happy_var_2 ++ happy_var_1
	)}}

happyReduce_39 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_39 = happySpecReduce_1  11# happyReduction_39
happyReduction_39 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (happy_var_1
	)}

happyReduce_40 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_40 = happySpecReduce_3  11# happyReduction_40
happyReduction_40 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_41 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_41 = happySpecReduce_3  11# happyReduction_41
happyReduction_41 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_42 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_42 = happySpecReduce_1  12# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 ([exportDecl Nothing   Public happy_var_1]
	)}

happyReduce_43 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_43 = happySpecReduce_2  12# happyReduction_43
happyReduction_43 happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportDecl (Just happy_var_1) Public happy_var_2]
	)}}

happyReduce_44 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_44 = happyMonadReduce 3# 12# happyReduction_44
happyReduction_44 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_3)})
	) (\r -> happyReturn (happyIn27 r))

happyReduce_45 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_45 = happyReduce 6# 12# happyReduction_45
happyReduction_45 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut42 happy_x_4 of { happy_var_4 -> 
	case happyOut48 happy_x_6 of { happy_var_6 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 happy_var_4 happy_var_6)]
	) `HappyStk` happyRest}}}}

happyReduce_46 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_46 = happyReduce 5# 12# happyReduction_46
happyReduction_46 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut48 happy_x_5 of { happy_var_5 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 [] happy_var_5)]
	) `HappyStk` happyRest}}}

happyReduce_47 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_47 = happySpecReduce_2  12# happyReduction_47
happyReduction_47 happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportNewtype Public happy_var_1 happy_var_2]
	)}}

happyReduce_48 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_48 = happySpecReduce_1  12# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_49 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_49 = happySpecReduce_1  12# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_50 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_50 = happySpecReduce_1  12# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_51 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_51 = happySpecReduce_1  13# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 ([Decl (TopLevel {tlExport = Public, tlValue = happy_var_1 })]
	)}

happyReduce_52 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_52 = happyMonadReduce 2# 13# happyReduction_52
happyReduction_52 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_2)})
	) (\r -> happyReturn (happyIn28 r))

happyReduce_53 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_53 = happySpecReduce_1  13# happyReduction_53
happyReduction_53 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_54 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_54 = happyReduce 4# 14# happyReduction_54
happyReduction_54 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_3)
	) `HappyStk` happyRest}

happyReduce_55 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_55 = happyReduce 5# 14# happyReduction_55
happyReduction_55 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_4 of { happy_var_4 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_4)
	) `HappyStk` happyRest}

happyReduce_56 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_56 = happyReduce 5# 15# happyReduction_56
happyReduction_56 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut78 happy_x_5 of { happy_var_5 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}

happyReduce_57 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_57 = happyReduce 7# 15# happyReduction_57
happyReduction_57 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_4 of { happy_var_4 -> 
	case happyOut78 happy_x_7 of { happy_var_7 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_4 happy_var_7
	) `HappyStk` happyRest}}}

happyReduce_58 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_58 = happyReduce 4# 16# happyReduction_58
happyReduction_58 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_3 of { happy_var_3 -> 
	happyIn31
		 (reverse happy_var_3
	) `HappyStk` happyRest}

happyReduce_59 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_59 = happyReduce 5# 16# happyReduction_59
happyReduction_59 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_4 of { happy_var_4 -> 
	happyIn31
		 (reverse happy_var_4
	) `HappyStk` happyRest}

happyReduce_60 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_60 = happySpecReduce_1  17# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 ([happy_var_1]
	)}

happyReduce_61 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_61 = happySpecReduce_3  17# happyReduction_61
happyReduction_61 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_62 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_62 = happySpecReduce_3  17# happyReduction_62
happyReduction_62 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_63 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_63 = happyReduce 4# 18# happyReduction_63
happyReduction_63 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut78 happy_x_4 of { happy_var_4 -> 
	happyIn33
		 (mkParFun happy_var_1 happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_64 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_64 = happyMonadReduce 5# 18# happyReduction_64
happyReduction_64 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut81 happy_x_5 of { happy_var_5 -> 
	( mkParType happy_var_1 happy_var_3 happy_var_5)}}})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_65 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_65 = happyMonadReduce 4# 18# happyReduction_65
happyReduction_65 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut86 happy_x_4 of { happy_var_4 -> 
	( fmap (DParameterConstraint . distrLoc)
                                            (mkProp happy_var_4))})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_66 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_66 = happySpecReduce_1  19# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (White DocStr) _))) -> 
	happyIn34
		 (mkDoc (fmap tokenText happy_var_1)
	)}

happyReduce_67 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_67 = happySpecReduce_1  20# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (Just happy_var_1
	)}

happyReduce_68 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_68 = happySpecReduce_0  20# happyReduction_68
happyReduction_68  =  happyIn35
		 (Nothing
	)

happyReduce_69 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_69 = happySpecReduce_3  21# happyReduction_69
happyReduction_69 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut78 happy_x_3 of { happy_var_3 -> 
	happyIn36
		 (at (head happy_var_1,happy_var_3) $ DSignature (reverse happy_var_1) happy_var_3
	)}}

happyReduce_70 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_70 = happySpecReduce_3  21# happyReduction_70
happyReduction_70 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn36
		 (at (happy_var_1,happy_var_3) $ DPatBind happy_var_1 happy_var_3
	)}}

happyReduce_71 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_71 = happyReduce 5# 21# happyReduction_71
happyReduction_71 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut56 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_5 of { happy_var_5 -> 
	happyIn36
		 (at (happy_var_1,happy_var_5) $ DPatBind (PVar happy_var_2) happy_var_5
	) `HappyStk` happyRest}}}

happyReduce_72 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_72 = happyReduce 4# 21# happyReduction_72
happyReduction_72 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut42 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_4 of { happy_var_4 -> 
	happyIn36
		 (at (happy_var_1,happy_var_4) $
                             DBind $ Bind { bName      = happy_var_1
                                          , bParams    = reverse happy_var_2
                                          , bDef       = at happy_var_4 (Located emptyRange (DExpr happy_var_4))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = False
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}

happyReduce_73 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_73 = happyReduce 5# 21# happyReduction_73
happyReduction_73 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	case happyOut74 happy_x_3 of { happy_var_3 -> 
	case happyOut48 happy_x_5 of { happy_var_5 -> 
	happyIn36
		 (at (happy_var_1,happy_var_5) $
                             DBind $ Bind { bName      = happy_var_2
                                          , bParams    = [happy_var_1,happy_var_3]
                                          , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = True
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}}

happyReduce_74 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_74 = happyMonadReduce 4# 21# happyReduction_74
happyReduction_74 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut86 happy_x_4 of { happy_var_4 -> 
	( at (happy_var_1,happy_var_4) `fmap` mkTySyn happy_var_2 [] happy_var_4)}}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_75 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_75 = happyMonadReduce 5# 21# happyReduction_75
happyReduction_75 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut85 happy_x_3 of { happy_var_3 -> 
	case happyOut86 happy_x_5 of { happy_var_5 -> 
	( at (happy_var_1,happy_var_5) `fmap` mkTySyn happy_var_2 (reverse happy_var_3) happy_var_5)}}}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_76 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_76 = happyMonadReduce 5# 21# happyReduction_76
happyReduction_76 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_constraint) _)) -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut86 happy_x_5 of { happy_var_5 -> 
	( at (happy_var_2,happy_var_5) `fmap` mkPropSyn happy_var_3 [] happy_var_5)}}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_77 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_77 = happyMonadReduce 6# 21# happyReduction_77
happyReduction_77 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_constraint) _)) -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOut85 happy_x_4 of { happy_var_4 -> 
	case happyOut86 happy_x_6 of { happy_var_6 -> 
	( at (happy_var_2,happy_var_6) `fmap` mkPropSyn happy_var_3 (reverse happy_var_4) happy_var_6)}}}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_78 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_78 = happyMonadReduce 3# 21# happyReduction_78
happyReduction_78 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	( mkFixity LeftAssoc  happy_var_2 (reverse happy_var_3))}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_79 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_79 = happyMonadReduce 3# 21# happyReduction_79
happyReduction_79 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	( mkFixity RightAssoc happy_var_2 (reverse happy_var_3))}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_80 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_80 = happyMonadReduce 3# 21# happyReduction_80
happyReduction_80 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	( mkFixity NonAssoc   happy_var_2 (reverse happy_var_3))}})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_81 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_81 = happyMonadReduce 1# 21# happyReduction_81
happyReduction_81 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((( expected "a declaration"))
	) (\r -> happyReturn (happyIn36 r))

happyReduce_82 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_82 = happyReduce 4# 22# happyReduction_82
happyReduction_82 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut73 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_4 of { happy_var_4 -> 
	happyIn37
		 (at (happy_var_2,happy_var_4) $ DPatBind happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_83 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_83 = happyReduce 5# 22# happyReduction_83
happyReduction_83 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut42 happy_x_3 of { happy_var_3 -> 
	case happyOut48 happy_x_5 of { happy_var_5 -> 
	happyIn37
		 (at (happy_var_2,happy_var_5) $
                                   DBind $ Bind { bName      = happy_var_2
                                                , bParams    = reverse happy_var_3
                                                , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                                , bSignature = Nothing
                                                , bPragmas   = []
                                                , bMono      = False
                                                , bInfix     = False
                                                , bFixity    = Nothing
                                                , bDoc       = Nothing
                                                }
	) `HappyStk` happyRest}}}

happyReduce_84 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_84 = happyReduce 4# 23# happyReduction_84
happyReduction_84 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	happyIn38
		 (Newtype { nName = happy_var_2, nParams = [], nBody = happy_var_4 }
	) `HappyStk` happyRest}}

happyReduce_85 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_85 = happyReduce 5# 23# happyReduction_85
happyReduction_85 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOut85 happy_x_3 of { happy_var_3 -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	happyIn38
		 (Newtype { nName = happy_var_2, nParams = happy_var_3, nBody = happy_var_5 }
	) `HappyStk` happyRest}}}

happyReduce_86 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_86 = happySpecReduce_2  24# happyReduction_86
happyReduction_86 happy_x_2
	happy_x_1
	 =  happyIn39
		 ([]
	)

happyReduce_87 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_87 = happySpecReduce_3  24# happyReduction_87
happyReduction_87 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_2 of { happy_var_2 -> 
	happyIn39
		 (happy_var_2
	)}

happyReduce_88 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_88 = happySpecReduce_1  25# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 ([ happy_var_1]
	)}

happyReduce_89 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_89 = happySpecReduce_3  25# happyReduction_89
happyReduction_89 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn40
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_90 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_90 = happySpecReduce_1  26# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 (happy_var_1
	)}

happyReduce_91 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_91 = happySpecReduce_3  26# happyReduction_91
happyReduction_91 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut56 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 (happy_var_2
	)}

happyReduce_92 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_92 = happySpecReduce_1  27# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn42
		 ([happy_var_1]
	)}

happyReduce_93 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_93 = happySpecReduce_2  27# happyReduction_93
happyReduction_93 happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	happyIn42
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_94 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_94 = happySpecReduce_1  28# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 ([happy_var_1]
	)}

happyReduce_95 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_95 = happySpecReduce_2  28# happyReduction_95
happyReduction_95 happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_96 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_96 = happySpecReduce_2  29# happyReduction_96
happyReduction_96 happy_x_2
	happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 ([happy_var_1]
	)}

happyReduce_97 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_97 = happySpecReduce_3  29# happyReduction_97
happyReduction_97 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	happyIn44
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_98 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_98 = happySpecReduce_1  30# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 ([happy_var_1]
	)}

happyReduce_99 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_99 = happySpecReduce_3  30# happyReduction_99
happyReduction_99 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_100 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_100 = happySpecReduce_3  30# happyReduction_100
happyReduction_100 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_101 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_101 = happySpecReduce_3  31# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_2 of { happy_var_2 -> 
	happyIn46
		 (happy_var_2
	)}

happyReduce_102 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_102 = happySpecReduce_2  31# happyReduction_102
happyReduction_102 happy_x_2
	happy_x_1
	 =  happyIn46
		 ([]
	)

happyReduce_103 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_103 = happySpecReduce_1  32# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (ExprInput happy_var_1
	)}

happyReduce_104 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_104 = happySpecReduce_1  32# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (LetInput happy_var_1
	)}

happyReduce_105 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_105 = happySpecReduce_1  33# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (happy_var_1
	)}

happyReduce_106 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_106 = happyReduce 4# 33# happyReduction_106
happyReduction_106 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym CurlyR  ) _)) -> 
	happyIn48
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_107 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_107 = happyReduce 5# 33# happyReduction_107
happyReduction_107 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym CurlyR  ) _)) -> 
	happyIn48
		 (at (happy_var_1,happy_var_5) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_108 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_108 = happyReduce 4# 33# happyReduction_108
happyReduction_108 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_where  ) _)) -> 
	happyIn48
		 (at (happy_var_1,happy_var_2) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_109 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_109 = happyReduce 5# 33# happyReduction_109
happyReduction_109 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_4 of { happy_var_4 -> 
	happyIn48
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_110 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_110 = happyMonadReduce 1# 33# happyReduction_110
happyReduction_110 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((( expected "an expression"))
	) (\r -> happyReturn (happyIn48 r))

happyReduce_111 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_111 = happySpecReduce_1  34# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 ([happy_var_1]
	)}

happyReduce_112 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_112 = happySpecReduce_3  34# happyReduction_112
happyReduction_112 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_113 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_113 = happySpecReduce_3  35# happyReduction_113
happyReduction_113 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn50
		 ((happy_var_1, happy_var_3)
	)}}

happyReduce_114 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_114 = happySpecReduce_1  36# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_115 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_115 = happyReduce 4# 36# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_if     ) _)) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOut51 happy_x_4 of { happy_var_4 -> 
	happyIn51
		 (at (happy_var_1,happy_var_4) $ mkIf (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_116 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_116 = happyReduce 4# 36# happyReduction_116
happyReduction_116 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Lambda  ) _)) -> 
	case happyOut42 happy_x_2 of { happy_var_2 -> 
	case happyOut51 happy_x_4 of { happy_var_4 -> 
	happyIn51
		 (at (happy_var_1,happy_var_4) $ EFun (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_117 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_117 = happySpecReduce_1  37# happyReduction_117
happyReduction_117 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 (happy_var_1
	)}

happyReduce_118 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_118 = happySpecReduce_3  37# happyReduction_118
happyReduction_118 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (at (happy_var_1,happy_var_3) $ ETyped happy_var_1 happy_var_3
	)}}

happyReduce_119 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_119 = happySpecReduce_1  38# happyReduction_119
happyReduction_119 happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	happyIn53
		 (happy_var_1
	)}

happyReduce_120 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_120 = happySpecReduce_3  38# happyReduction_120
happyReduction_120 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut55 happy_x_2 of { happy_var_2 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn53
		 (binOp happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_121 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_121 = happySpecReduce_1  39# happyReduction_121
happyReduction_121 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (mkEApp happy_var_1
	)}

happyReduce_122 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_122 = happySpecReduce_2  39# happyReduction_122
happyReduction_122 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	happyIn54
		 (at (happy_var_1,happy_var_2) $ ENeg happy_var_2
	)}}

happyReduce_123 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_123 = happySpecReduce_2  39# happyReduction_123
happyReduction_123 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	happyIn54
		 (at (happy_var_1,happy_var_2) $ EComplement happy_var_2
	)}}

happyReduce_124 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_124 = happySpecReduce_1  40# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (happy_var_1
	)}

happyReduce_125 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_125 = happySpecReduce_1  40# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op  Other{}   )  _))) -> 
	happyIn55
		 (let Token (Op (Other ns i)) _ = thing happy_var_1
                                       in mkQual (mkModName ns) (mkInfix i) A.<$ happy_var_1
	)}

happyReduce_126 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_126 = happySpecReduce_1  41# happyReduction_126
happyReduction_126 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 (happy_var_1
	)}

happyReduce_127 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_127 = happySpecReduce_1  41# happyReduction_127
happyReduction_127 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn56
		 (Located happy_var_1 $ mkUnqual $ mkInfix "#"
	)}

happyReduce_128 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_128 = happySpecReduce_1  42# happyReduction_128
happyReduction_128 happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 (happy_var_1
	)}

happyReduce_129 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_129 = happySpecReduce_1  42# happyReduction_129
happyReduction_129 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn57
		 (Located happy_var_1 $ mkUnqual $ mkInfix "*"
	)}

happyReduce_130 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_130 = happySpecReduce_1  42# happyReduction_130
happyReduction_130 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Plus)  _)) -> 
	happyIn57
		 (Located happy_var_1 $ mkUnqual $ mkInfix "+"
	)}

happyReduce_131 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_131 = happySpecReduce_1  42# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	happyIn57
		 (Located happy_var_1 $ mkUnqual $ mkInfix "-"
	)}

happyReduce_132 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_132 = happySpecReduce_1  42# happyReduction_132
happyReduction_132 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	happyIn57
		 (Located happy_var_1 $ mkUnqual $ mkInfix "~"
	)}

happyReduce_133 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_133 = happySpecReduce_1  42# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Exp)   _)) -> 
	happyIn57
		 (Located happy_var_1 $ mkUnqual $ mkInfix "^^"
	)}

happyReduce_134 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_134 = happySpecReduce_1  43# happyReduction_134
happyReduction_134 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op (Other [] _)) _))) -> 
	happyIn58
		 (let Token (Op (Other [] str)) _ = thing happy_var_1
                                       in mkUnqual (mkInfix str) A.<$ happy_var_1
	)}

happyReduce_135 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_135 = happySpecReduce_1  44# happyReduction_135
happyReduction_135 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 ([happy_var_1]
	)}

happyReduce_136 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_136 = happySpecReduce_3  44# happyReduction_136
happyReduction_136 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_137 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_137 = happySpecReduce_1  45# happyReduction_137
happyReduction_137 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 ([happy_var_1]
	)}

happyReduce_138 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_138 = happySpecReduce_2  45# happyReduction_138
happyReduction_138 happy_x_2
	happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_139 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_139 = happySpecReduce_1  46# happyReduction_139
happyReduction_139 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn61
		 (at happy_var_1 $ EVar (thing happy_var_1)
	)}

happyReduce_140 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_140 = happySpecReduce_1  46# happyReduction_140
happyReduction_140 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn61
		 (at happy_var_1 $ numLit (tokenType (thing happy_var_1))
	)}

happyReduce_141 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_141 = happySpecReduce_1  46# happyReduction_141
happyReduction_141 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (StrLit {}) _))) -> 
	happyIn61
		 (at happy_var_1 $ ELit $ ECString $ getStr happy_var_1
	)}

happyReduce_142 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_142 = happySpecReduce_1  46# happyReduction_142
happyReduction_142 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn61
		 (at happy_var_1 $ ELit $ ECNum (getNum happy_var_1) CharLit
	)}

happyReduce_143 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_143 = happySpecReduce_3  46# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut48 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) $ EParens happy_var_2
	)}}}

happyReduce_144 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_144 = happySpecReduce_3  46# happyReduction_144
happyReduction_144 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut65 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) $ ETuple (reverse happy_var_2)
	)}}}

happyReduce_145 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_145 = happySpecReduce_2  46# happyReduction_145
happyReduction_145 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_2) $ ETuple []
	)}}

happyReduce_146 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_146 = happySpecReduce_2  46# happyReduction_146
happyReduction_146 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_2) $ ERecord []
	)}}

happyReduce_147 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_147 = happySpecReduce_3  46# happyReduction_147
happyReduction_147 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut67 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) $ ERecord (reverse happy_var_2)
	)}}}

happyReduce_148 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_148 = happySpecReduce_2  46# happyReduction_148
happyReduction_148 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_2) $ EList []
	)}}

happyReduce_149 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_149 = happySpecReduce_3  46# happyReduction_149
happyReduction_149 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut68 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_150 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_150 = happySpecReduce_2  46# happyReduction_150
happyReduction_150 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BackTick) _)) -> 
	case happyOut100 happy_x_2 of { happy_var_2 -> 
	happyIn61
		 (at (happy_var_1,happy_var_2) $ ETypeVal happy_var_2
	)}}

happyReduce_151 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_151 = happySpecReduce_3  46# happyReduction_151
happyReduction_151 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) $ ESel happy_var_1 (thing happy_var_3)
	)}}

happyReduce_152 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_152 = happySpecReduce_3  46# happyReduction_152
happyReduction_152 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut55 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn61
		 (at (happy_var_1,happy_var_3) $ EVar $ thing happy_var_2
	)}}}

happyReduce_153 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_153 = happyMonadReduce 2# 46# happyReduction_153
happyReduction_153 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_2) [])}})
	) (\r -> happyReturn (happyIn61 r))

happyReduce_154 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_154 = happyMonadReduce 3# 46# happyReduction_154
happyReduction_154 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_3) happy_var_2)}}})
	) (\r -> happyReturn (happyIn61 r))

happyReduce_155 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_155 = happySpecReduce_1  47# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 ([happy_var_1]
	)}

happyReduce_156 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_156 = happySpecReduce_3  47# happyReduction_156
happyReduction_156 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_157 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_157 = happyMonadReduce 1# 48# happyReduction_157
happyReduction_157 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (srcRange happy_var_1) (getNum happy_var_1) 0)})
	) (\r -> happyReturn (happyIn63 r))

happyReduce_158 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_158 = happyMonadReduce 1# 48# happyReduction_158
happyReduction_158 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	( polyTerm happy_var_1 1 1)})
	) (\r -> happyReturn (happyIn63 r))

happyReduce_159 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_159 = happyMonadReduce 3# 48# happyReduction_159
happyReduction_159 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (rComb happy_var_1 (srcRange happy_var_3))
                                                            1 (getNum happy_var_3))}})
	) (\r -> happyReturn (happyIn63 r))

happyReduce_160 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_160 = happySpecReduce_1  49# happyReduction_160
happyReduction_160 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn64
		 (fmap (`RecordSel` Nothing) happy_var_1
	)}

happyReduce_161 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_161 = happyMonadReduce 1# 49# happyReduction_161
happyReduction_161 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( mkTupleSel (srcRange happy_var_1) (getNum happy_var_1))})
	) (\r -> happyReturn (happyIn64 r))

happyReduce_162 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_162 = happySpecReduce_3  50# happyReduction_162
happyReduction_162 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_163 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_163 = happySpecReduce_3  50# happyReduction_163
happyReduction_163 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_164 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_164 = happySpecReduce_3  51# happyReduction_164
happyReduction_164 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn66
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_165 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_165 = happyReduce 4# 51# happyReduction_165
happyReduction_165 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut42 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_4 of { happy_var_4 -> 
	happyIn66
		 (Named { name = happy_var_1, value = EFun (reverse happy_var_2) happy_var_4 }
	) `HappyStk` happyRest}}}

happyReduce_166 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_166 = happySpecReduce_1  52# happyReduction_166
happyReduction_166 happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 ([happy_var_1]
	)}

happyReduce_167 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_167 = happySpecReduce_3  52# happyReduction_167
happyReduction_167 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_168 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_168 = happySpecReduce_3  53# happyReduction_168
happyReduction_168 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (EComp happy_var_1 (reverse happy_var_3)
	)}}

happyReduce_169 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_169 = happySpecReduce_1  53# happyReduction_169
happyReduction_169 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (EList [happy_var_1]
	)}

happyReduce_170 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_170 = happySpecReduce_1  53# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (EList (reverse happy_var_1)
	)}

happyReduce_171 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_171 = happyMonadReduce 2# 53# happyReduction_171
happyReduction_171 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   Nothing)}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_172 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_172 = happyMonadReduce 3# 53# happyReduction_172
happyReduction_172 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   (Just happy_var_3))}}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_173 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_173 = happyMonadReduce 4# 53# happyReduction_173
happyReduction_173 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) Nothing)}}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_174 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_174 = happyMonadReduce 5# 53# happyReduction_174
happyReduction_174 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	case happyOut48 happy_x_5 of { happy_var_5 -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) (Just happy_var_5))}}}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_175 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_175 = happySpecReduce_2  53# happyReduction_175
happyReduction_175 happy_x_2
	happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (EInfFrom happy_var_1 Nothing
	)}

happyReduce_176 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_176 = happyReduce 4# 53# happyReduction_176
happyReduction_176 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut48 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (EInfFrom happy_var_1 (Just happy_var_3)
	) `HappyStk` happyRest}}

happyReduce_177 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_177 = happySpecReduce_1  54# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 ([ reverse happy_var_1 ]
	)}

happyReduce_178 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_178 = happySpecReduce_3  54# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 (reverse happy_var_3 : happy_var_1
	)}}

happyReduce_179 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_179 = happySpecReduce_1  55# happyReduction_179
happyReduction_179 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 ([happy_var_1]
	)}

happyReduce_180 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_180 = happySpecReduce_3  55# happyReduction_180
happyReduction_180 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_181 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_181 = happySpecReduce_3  56# happyReduction_181
happyReduction_181 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (Match happy_var_1 happy_var_3
	)}}

happyReduce_182 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_182 = happySpecReduce_3  57# happyReduction_182
happyReduction_182 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) $ PTyped happy_var_1 happy_var_3
	)}}

happyReduce_183 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_183 = happySpecReduce_1  57# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 (happy_var_1
	)}

happyReduce_184 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_184 = happySpecReduce_3  58# happyReduction_184
happyReduction_184 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn73
		 (at (happy_var_1,happy_var_3) $ PSplit happy_var_1 happy_var_3
	)}}

happyReduce_185 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_185 = happySpecReduce_1  58# happyReduction_185
happyReduction_185 happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn73
		 (happy_var_1
	)}

happyReduce_186 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_186 = happySpecReduce_1  59# happyReduction_186
happyReduction_186 happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (PVar happy_var_1
	)}

happyReduce_187 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_187 = happySpecReduce_1  59# happyReduction_187
happyReduction_187 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn74
		 (at happy_var_1       $ PWild
	)}

happyReduce_188 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_188 = happySpecReduce_2  59# happyReduction_188
happyReduction_188 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_2) $ PTuple []
	)}}

happyReduce_189 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_189 = happySpecReduce_3  59# happyReduction_189
happyReduction_189 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_3)   happy_var_2
	)}}}

happyReduce_190 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_190 = happySpecReduce_3  59# happyReduction_190
happyReduction_190 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_3) $ PTuple (reverse happy_var_2)
	)}}}

happyReduce_191 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_191 = happySpecReduce_2  59# happyReduction_191
happyReduction_191 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_2) $ PList []
	)}}

happyReduce_192 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_192 = happySpecReduce_3  59# happyReduction_192
happyReduction_192 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_3) $ PList [happy_var_2]
	)}}}

happyReduce_193 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_193 = happySpecReduce_3  59# happyReduction_193
happyReduction_193 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_3) $ PList (reverse happy_var_2)
	)}}}

happyReduce_194 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_194 = happySpecReduce_2  59# happyReduction_194
happyReduction_194 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_2) $ PRecord []
	)}}

happyReduce_195 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_195 = happySpecReduce_3  59# happyReduction_195
happyReduction_195 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn74
		 (at (happy_var_1,happy_var_3) $ PRecord (reverse happy_var_2)
	)}}}

happyReduce_196 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_196 = happySpecReduce_3  60# happyReduction_196
happyReduction_196 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn75
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_197 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_197 = happySpecReduce_3  60# happyReduction_197
happyReduction_197 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut75 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn75
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_198 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_198 = happySpecReduce_3  61# happyReduction_198
happyReduction_198 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_199 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_199 = happySpecReduce_1  62# happyReduction_199
happyReduction_199 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_200 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_200 = happySpecReduce_3  62# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOut76 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_201 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_201 = happySpecReduce_1  63# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn78
		 (at happy_var_1 $ mkSchema [] [] happy_var_1
	)}

happyReduce_202 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_202 = happySpecReduce_2  63# happyReduction_202
happyReduction_202 happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	happyIn78
		 (at (happy_var_1,happy_var_2) $ mkSchema (thing happy_var_1) [] happy_var_2
	)}}

happyReduce_203 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_203 = happySpecReduce_2  63# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	happyIn78
		 (at (happy_var_1,happy_var_2) $ mkSchema [] (thing happy_var_1) happy_var_2
	)}}

happyReduce_204 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_204 = happySpecReduce_3  63# happyReduction_204
happyReduction_204 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (at (happy_var_1,happy_var_3) $ mkSchema (thing happy_var_1)
                                                          (thing happy_var_2) happy_var_3
	)}}}

happyReduce_205 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_205 = happySpecReduce_2  64# happyReduction_205
happyReduction_205 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn79
		 (Located (rComb happy_var_1 happy_var_2) []
	)}}

happyReduce_206 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_206 = happySpecReduce_3  64# happyReduction_206
happyReduction_206 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn79
		 (Located (rComb happy_var_1 happy_var_3) (reverse happy_var_2)
	)}}}

happyReduce_207 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_207 = happyMonadReduce 2# 65# happyReduction_207
happyReduction_207 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym FatArrR ) _)) -> 
	( fmap (\x -> at (x,happy_var_2) x) (mkProp happy_var_1))}})
	) (\r -> happyReturn (happyIn80 r))

happyReduce_208 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_208 = happySpecReduce_1  66# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn81
		 (Located happy_var_1 KNum
	)}

happyReduce_209 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_209 = happySpecReduce_1  66# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn81
		 (Located happy_var_1 KType
	)}

happyReduce_210 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_210 = happySpecReduce_3  66# happyReduction_210
happyReduction_210 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	happyIn81
		 (combLoc KFun happy_var_1 happy_var_3
	)}}

happyReduce_211 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_211 = happyMonadReduce 1# 67# happyReduction_211
happyReduction_211 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut94 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)})
	) (\r -> happyReturn (happyIn82 r))

happyReduce_212 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_212 = happyMonadReduce 3# 67# happyReduction_212
happyReduction_212 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	( mkTParam (at (happy_var_1,happy_var_3) happy_var_1) (Just (thing happy_var_3)))}})
	) (\r -> happyReturn (happyIn82 r))

happyReduce_213 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_213 = happySpecReduce_1  68# happyReduction_213
happyReduction_213 happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 ([happy_var_1]
	)}

happyReduce_214 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_214 = happySpecReduce_3  68# happyReduction_214
happyReduction_214 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOut82 happy_x_3 of { happy_var_3 -> 
	happyIn83
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_215 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_215 = happyMonadReduce 1# 69# happyReduction_215
happyReduction_215 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut94 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_216 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_216 = happyMonadReduce 5# 69# happyReduction_216
happyReduction_216 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym ParenR  ) _)) -> 
	( mkTParam (at (happy_var_1,happy_var_5) happy_var_2) (Just (thing happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_217 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_217 = happySpecReduce_1  70# happyReduction_217
happyReduction_217 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn85
		 ([happy_var_1]
	)}

happyReduce_218 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_218 = happySpecReduce_2  70# happyReduction_218
happyReduction_218 happy_x_2
	happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	case happyOut84 happy_x_2 of { happy_var_2 -> 
	happyIn85
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_219 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_219 = happySpecReduce_3  71# happyReduction_219
happyReduction_219 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (at (happy_var_1,happy_var_3) $ TFun happy_var_1 happy_var_3
	)}}

happyReduce_220 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_220 = happySpecReduce_3  71# happyReduction_220
happyReduction_220 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_2 of { happy_var_2 -> 
	case happyOut87 happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (at (happy_var_1,happy_var_3) $ TInfix happy_var_1 happy_var_2 defaultFixity happy_var_3
	)}}}

happyReduce_221 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_221 = happySpecReduce_1  71# happyReduction_221
happyReduction_221 happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	happyIn86
		 (happy_var_1
	)}

happyReduce_222 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_222 = happySpecReduce_2  72# happyReduction_222
happyReduction_222 happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn87
		 (at (happy_var_1,happy_var_2) $ foldr TSeq happy_var_2 (reverse (thing happy_var_1))
	)}}

happyReduce_223 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_223 = happySpecReduce_2  72# happyReduction_223
happyReduction_223 happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_2 of { happy_var_2 -> 
	happyIn87
		 (at (happy_var_1,head happy_var_2)
                                     $ TUser (thing happy_var_1) (reverse happy_var_2)
	)}}

happyReduce_224 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_224 = happySpecReduce_1  72# happyReduction_224
happyReduction_224 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn87
		 (happy_var_1
	)}

happyReduce_225 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_225 = happySpecReduce_1  73# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_226 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_226 = happySpecReduce_1  73# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn88
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_227 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_227 = happySpecReduce_1  73# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn88
		 (at happy_var_1 $ TChar (toEnum $ fromInteger
                                                          $ getNum happy_var_1)
	)}

happyReduce_228 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_228 = happySpecReduce_3  73# happyReduction_228
happyReduction_228 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_3) $ TSeq happy_var_2 TBit
	)}}}

happyReduce_229 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_229 = happySpecReduce_3  73# happyReduction_229
happyReduction_229 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_3) $ TParens happy_var_2
	)}}}

happyReduce_230 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_230 = happySpecReduce_2  73# happyReduction_230
happyReduction_230 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_2) $ TTuple []
	)}}

happyReduce_231 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_231 = happySpecReduce_3  73# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut91 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_3) $ TTuple  (reverse happy_var_2)
	)}}}

happyReduce_232 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_232 = happySpecReduce_2  73# happyReduction_232
happyReduction_232 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_2) $ TRecord []
	)}}

happyReduce_233 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_233 = happySpecReduce_3  73# happyReduction_233
happyReduction_233 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut93 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn88
		 (at (happy_var_1,happy_var_3) $ TRecord (reverse happy_var_2)
	)}}}

happyReduce_234 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_234 = happySpecReduce_1  73# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn88
		 (at happy_var_1 TWild
	)}

happyReduce_235 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_235 = happySpecReduce_1  74# happyReduction_235
happyReduction_235 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn89
		 ([ happy_var_1 ]
	)}

happyReduce_236 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_236 = happySpecReduce_2  74# happyReduction_236
happyReduction_236 happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn89
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_237 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_237 = happySpecReduce_3  75# happyReduction_237
happyReduction_237 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn90
		 (Located (rComb happy_var_1 happy_var_3) [ happy_var_2 ]
	)}}}

happyReduce_238 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_238 = happyReduce 4# 75# happyReduction_238
happyReduction_238 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym BracketR) _)) -> 
	happyIn90
		 (at (happy_var_1,happy_var_4) (fmap (happy_var_3 :) happy_var_1)
	) `HappyStk` happyRest}}}

happyReduce_239 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_239 = happySpecReduce_3  76# happyReduction_239
happyReduction_239 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn91
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_240 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_240 = happySpecReduce_3  76# happyReduction_240
happyReduction_240 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn91
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_241 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_241 = happySpecReduce_3  77# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_242 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_242 = happySpecReduce_1  78# happyReduction_242
happyReduction_242 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 ([happy_var_1]
	)}

happyReduce_243 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_243 = happySpecReduce_3  78# happyReduction_243
happyReduction_243 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	happyIn93
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_244 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_244 = happySpecReduce_1  79# happyReduction_244
happyReduction_244 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Ident [] _) _))) -> 
	happyIn94
		 (let Token (Ident _ str) _ = thing happy_var_1
                         in happy_var_1 { thing = mkIdent str }
	)}

happyReduce_245 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_245 = happySpecReduce_1  79# happyReduction_245
happyReduction_245 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	happyIn94
		 (Located { srcRange = happy_var_1, thing = mkIdent "x" }
	)}

happyReduce_246 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_246 = happySpecReduce_1  79# happyReduction_246
happyReduction_246 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_private)   _)) -> 
	happyIn94
		 (Located { srcRange = happy_var_1, thing = mkIdent "private" }
	)}

happyReduce_247 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_247 = happySpecReduce_1  79# happyReduction_247
happyReduction_247 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_as)        _)) -> 
	happyIn94
		 (Located { srcRange = happy_var_1, thing = mkIdent "as" }
	)}

happyReduce_248 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_248 = happySpecReduce_1  79# happyReduction_248
happyReduction_248 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_hiding)    _)) -> 
	happyIn94
		 (Located { srcRange = happy_var_1, thing = mkIdent "hiding" }
	)}

happyReduce_249 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_249 = happySpecReduce_1  80# happyReduction_249
happyReduction_249 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn95
		 (fmap mkUnqual happy_var_1
	)}

happyReduce_250 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_250 = happySpecReduce_1  81# happyReduction_250
happyReduction_250 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (fmap (mkModName . (:[]) . identText) happy_var_1
	)}

happyReduce_251 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_251 = happySpecReduce_1  81# happyReduction_251
happyReduction_251 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn96
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkModName (ns ++ [i]) A.<$ happy_var_1
	)}

happyReduce_252 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_252 = happySpecReduce_1  82# happyReduction_252
happyReduction_252 happy_x_1
	 =  case happyOut96 happy_x_1 of { happy_var_1 -> 
	happyIn97
		 (happy_var_1
	)}

happyReduce_253 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_253 = happySpecReduce_2  82# happyReduction_253
happyReduction_253 happy_x_2
	happy_x_1
	 =  case happyOut96 happy_x_2 of { happy_var_2 -> 
	happyIn97
		 (fmap paramInstModName happy_var_2
	)}

happyReduce_254 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_254 = happySpecReduce_1  83# happyReduction_254
happyReduction_254 happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 (happy_var_1
	)}

happyReduce_255 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_255 = happySpecReduce_1  83# happyReduction_255
happyReduction_255 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn98
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkQual (mkModName ns) (mkIdent i) A.<$ happy_var_1
	)}

happyReduce_256 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_256 = happySpecReduce_1  84# happyReduction_256
happyReduction_256 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_257 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_257 = happySpecReduce_1  84# happyReduction_257
happyReduction_257 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_258 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_258 = happySpecReduce_3  84# happyReduction_258
happyReduction_258 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_2 of { happy_var_2 -> 
	happyIn99
		 (happy_var_2
	)}

happyReduce_259 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_259 = happySpecReduce_1  85# happyReduction_259
happyReduction_259 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn100
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_260 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_260 = happySpecReduce_1  85# happyReduction_260
happyReduction_260 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn100
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_261 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_261 = happyMonadReduce 3# 85# happyReduction_261
happyReduction_261 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	( validDemotedType (rComb happy_var_1 happy_var_3) happy_var_2)}}})
	) (\r -> happyReturn (happyIn100 r))

happyReduce_262 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_262 = happySpecReduce_2  85# happyReduction_262
happyReduction_262 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn100
		 (at (happy_var_1,happy_var_2) (TRecord [])
	)}}

happyReduce_263 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_263 = happySpecReduce_3  85# happyReduction_263
happyReduction_263 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut102 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn100
		 (at (happy_var_1,happy_var_3) (TRecord (reverse happy_var_2))
	)}}}

happyReduce_264 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_264 = happySpecReduce_3  85# happyReduction_264
happyReduction_264 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn100
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) [happy_var_2]
	)}}}

happyReduce_265 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_265 = happySpecReduce_3  85# happyReduction_265
happyReduction_265 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut91 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn100
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) (reverse happy_var_2)
	)}}}

happyReduce_266 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_266 = happySpecReduce_3  86# happyReduction_266
happyReduction_266 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_267 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_267 = happySpecReduce_1  87# happyReduction_267
happyReduction_267 happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 ([happy_var_1]
	)}

happyReduce_268 :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )
happyReduce_268 = happySpecReduce_3  87# happyReduction_268
happyReduction_268 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_3 of { happy_var_3 -> 
	happyIn102
		 (happy_var_3 : happy_var_1
	)}}

happyNewToken action sts stk
	= lexerP(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Located _ (Token EOF _) -> happyDoAction 61# tk action sts stk;
	happy_dollar_dollar@(Located _ (Token (Num   {}) _)) -> cont 1#;
	happy_dollar_dollar@(Located _ (Token (StrLit {}) _)) -> cont 2#;
	happy_dollar_dollar@(Located _ (Token (ChrLit {}) _)) -> cont 3#;
	happy_dollar_dollar@(Located _ (Token (Ident [] _) _)) -> cont 4#;
	happy_dollar_dollar@(Located _ (Token  Ident{}     _)) -> cont 5#;
	Located happy_dollar_dollar (Token (KW KW_include)   _) -> cont 6#;
	Located happy_dollar_dollar (Token (KW KW_import)    _) -> cont 7#;
	Located happy_dollar_dollar (Token (KW KW_as)        _) -> cont 8#;
	Located happy_dollar_dollar (Token (KW KW_hiding)    _) -> cont 9#;
	Located happy_dollar_dollar (Token (KW KW_private)   _) -> cont 10#;
	Located happy_dollar_dollar (Token (KW KW_parameter) _) -> cont 11#;
	Located happy_dollar_dollar (Token (KW KW_property)  _) -> cont 12#;
	Located happy_dollar_dollar (Token (KW KW_infix)     _) -> cont 13#;
	Located happy_dollar_dollar (Token (KW KW_infixl)    _) -> cont 14#;
	Located happy_dollar_dollar (Token (KW KW_infixr)    _) -> cont 15#;
	Located happy_dollar_dollar (Token (KW KW_type   ) _) -> cont 16#;
	Located happy_dollar_dollar (Token (KW KW_newtype) _) -> cont 17#;
	Located happy_dollar_dollar (Token (KW KW_module ) _) -> cont 18#;
	Located happy_dollar_dollar (Token (KW KW_where  ) _) -> cont 19#;
	Located happy_dollar_dollar (Token (KW KW_let    ) _) -> cont 20#;
	Located happy_dollar_dollar (Token (KW KW_if     ) _) -> cont 21#;
	Located happy_dollar_dollar (Token (KW KW_then   ) _) -> cont 22#;
	Located happy_dollar_dollar (Token (KW KW_else   ) _) -> cont 23#;
	Located happy_dollar_dollar (Token (KW KW_x)       _) -> cont 24#;
	Located happy_dollar_dollar (Token (KW KW_primitive) _) -> cont 25#;
	Located happy_dollar_dollar (Token (KW KW_constraint) _) -> cont 26#;
	Located happy_dollar_dollar (Token (Sym BracketL) _) -> cont 27#;
	Located happy_dollar_dollar (Token (Sym BracketR) _) -> cont 28#;
	Located happy_dollar_dollar (Token (Sym ArrL    ) _) -> cont 29#;
	Located happy_dollar_dollar (Token (Sym DotDot  ) _) -> cont 30#;
	Located happy_dollar_dollar (Token (Sym DotDotDot) _) -> cont 31#;
	Located happy_dollar_dollar (Token (Sym Bar     ) _) -> cont 32#;
	Located happy_dollar_dollar (Token (Sym ParenL  ) _) -> cont 33#;
	Located happy_dollar_dollar (Token (Sym ParenR  ) _) -> cont 34#;
	Located happy_dollar_dollar (Token (Sym Comma   ) _) -> cont 35#;
	Located happy_dollar_dollar (Token (Sym Semi    ) _) -> cont 36#;
	Located happy_dollar_dollar (Token (Sym Dot     ) _) -> cont 37#;
	Located happy_dollar_dollar (Token (Sym CurlyL  ) _) -> cont 38#;
	Located happy_dollar_dollar (Token (Sym CurlyR  ) _) -> cont 39#;
	Located happy_dollar_dollar (Token (Sym TriL    ) _) -> cont 40#;
	Located happy_dollar_dollar (Token (Sym TriR    ) _) -> cont 41#;
	Located happy_dollar_dollar (Token (Sym EqDef   ) _) -> cont 42#;
	Located happy_dollar_dollar (Token (Sym BackTick) _) -> cont 43#;
	Located happy_dollar_dollar (Token (Sym Colon   ) _) -> cont 44#;
	Located happy_dollar_dollar (Token (Sym ArrR    ) _) -> cont 45#;
	Located happy_dollar_dollar (Token (Sym FatArrR ) _) -> cont 46#;
	Located happy_dollar_dollar (Token (Sym Lambda  ) _) -> cont 47#;
	Located happy_dollar_dollar (Token (Sym Underscore ) _) -> cont 48#;
	Located happy_dollar_dollar (Token (Virt VCurlyL)  _) -> cont 49#;
	Located happy_dollar_dollar (Token (Virt VCurlyR)  _) -> cont 50#;
	Located happy_dollar_dollar (Token (Virt VSemi)    _) -> cont 51#;
	Located happy_dollar_dollar (Token (Op Plus)  _) -> cont 52#;
	Located happy_dollar_dollar (Token (Op Mul)   _) -> cont 53#;
	Located happy_dollar_dollar (Token (Op Exp)   _) -> cont 54#;
	Located happy_dollar_dollar (Token (Op Minus) _) -> cont 55#;
	Located happy_dollar_dollar (Token (Op Complement) _) -> cont 56#;
	Located happy_dollar_dollar (Token (Op Hash) _) -> cont 57#;
	happy_dollar_dollar@(Located _ (Token (Op (Other [] _)) _)) -> cont 58#;
	happy_dollar_dollar@(Located _ (Token (Op  Other{}   )  _)) -> cont 59#;
	happy_dollar_dollar@(Located _ (Token (White DocStr) _)) -> cont 60#;
	_ -> happyError' (tk, [])
	})

happyError_ explist 61# tk = happyError' (tk, explist)
happyError_ explist _ tk = happyError' (tk, explist)

happyThen :: () => ParseM a -> (a -> ParseM b) -> ParseM b
happyThen = (>>=)
happyReturn :: () => a -> ParseM a
happyReturn = (return)
happyParse :: () => Happy_GHC_Exts.Int# -> ParseM (HappyAbsSyn )

happyNewToken :: () => Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )

happyDoAction :: () => Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn )

happyReduceArr :: () => Happy_Data_Array.Array Int (Happy_GHC_Exts.Int# -> Located Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> ParseM (HappyAbsSyn ))

happyThen1 :: () => ParseM a -> (a -> ParseM b) -> ParseM b
happyThen1 = happyThen
happyReturn1 :: () => a -> ParseM a
happyReturn1 = happyReturn
happyError' :: () => ((Located Token), [String]) -> ParseM a
happyError' tk = (\(tokens, explist) -> happyError) tk
vmodule = happySomeParser where
 happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut15 x))

program = happySomeParser where
 happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut23 x))

programLayout = happySomeParser where
 happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut24 x))

expr = happySomeParser where
 happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut48 x))

decl = happySomeParser where
 happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut36 x))

decls = happySomeParser where
 happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut44 x))

declsLayout = happySomeParser where
 happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut46 x))

letDecl = happySomeParser where
 happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut37 x))

repl = happySomeParser where
 happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut47 x))

schema = happySomeParser where
 happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut78 x))

modName = happySomeParser where
 happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut97 x))

helpName = happySomeParser where
 happySomeParser = happyThen (happyParse 11#) (\x -> happyReturn (happyOut99 x))

happySeq = happyDontSeq


parseModName :: String -> Maybe ModName
parseModName txt =
  case parseString defaultConfig { cfgModuleScope = False } modName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

parseHelpName :: String -> Maybe PName
parseHelpName txt =
  case parseString defaultConfig { cfgModuleScope = False } helpName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

addImplicitIncludes :: Config -> Program PName -> Program PName
addImplicitIncludes cfg (Program ds) =
  Program $ map path (cfgAutoInclude cfg) ++ ds
  where path p = Include Located { srcRange = rng, thing = p }
        rng    = Range { source = cfgSource cfg, from = start, to = start }


parseProgramWith :: Config -> Text -> Either ParseError (Program PName)
parseProgramWith cfg s = case res s of
                          Left err -> Left err
                          Right a  -> Right (addImplicitIncludes cfg a)
  where
  res = parse cfg $ case cfgLayout cfg of
                      Layout   -> programLayout
                      NoLayout -> program

parseModule :: Config -> Text -> Either ParseError (Module PName)
parseModule cfg = parse cfg { cfgModuleScope = True } vmodule

parseProgram :: Layout -> Text -> Either ParseError (Program PName)
parseProgram l = parseProgramWith defaultConfig { cfgLayout = l }

parseExprWith :: Config -> Text -> Either ParseError (Expr PName)
parseExprWith cfg = parse cfg { cfgModuleScope = False } expr

parseExpr :: Text -> Either ParseError (Expr PName)
parseExpr = parseExprWith defaultConfig

parseDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseDeclWith cfg = parse cfg { cfgModuleScope = False } decl

parseDecl :: Text -> Either ParseError (Decl PName)
parseDecl = parseDeclWith defaultConfig

parseDeclsWith :: Config -> Text -> Either ParseError [Decl PName]
parseDeclsWith cfg = parse cfg { cfgModuleScope = ms } decls'
  where (ms, decls') = case cfgLayout cfg of
                         Layout   -> (True, declsLayout)
                         NoLayout -> (False, decls)

parseDecls :: Text -> Either ParseError [Decl PName]
parseDecls = parseDeclsWith defaultConfig

parseLetDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseLetDeclWith cfg = parse cfg { cfgModuleScope = False } letDecl

parseLetDecl :: Text -> Either ParseError (Decl PName)
parseLetDecl = parseLetDeclWith defaultConfig

parseReplWith :: Config -> Text -> Either ParseError (ReplInput PName)
parseReplWith cfg = parse cfg { cfgModuleScope = False } repl

parseRepl :: Text -> Either ParseError (ReplInput PName)
parseRepl = parseReplWith defaultConfig

parseSchemaWith :: Config -> Text -> Either ParseError (Schema PName)
parseSchemaWith cfg = parse cfg { cfgModuleScope = False } schema

parseSchema :: Text -> Either ParseError (Schema PName)
parseSchema = parseSchemaWith defaultConfig

-- vim: ft=haskell
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 18 "<built-in>" #-}
{-# LINE 1 "/usr/local/Cellar/ghc/8.4.3/lib/ghc-8.4.3/include/ghcversion.h" #-}
















{-# LINE 19 "<built-in>" #-}
{-# LINE 1 "/var/folders/n8/s7z9ns8d4k39v2y_2sn__12m0000gp/T/ghc93615_0/ghc_2.h" #-}





















































































































































































{-# LINE 20 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 













-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 43 "templates/GenericTemplate.hs" #-}

data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList








{-# LINE 65 "templates/GenericTemplate.hs" #-}


{-# LINE 75 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail (happyExpListPerState ((Happy_GHC_Exts.I# (st)) :: Int)) i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = happyAdjustOffset (indexShortOffAddr happyActOffsets st)
         off_i  = (off Happy_GHC_Exts.+#  i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st




indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#




{-# INLINE happyLt #-}
happyLt x y = LT(x,y)


readArrayBit arr bit =
    Bits.testBit (Happy_GHC_Exts.I# (indexShortOffAddr arr ((unbox_int bit) `Happy_GHC_Exts.iShiftRA#` 4#))) (bit `mod` 16)
  where unbox_int (Happy_GHC_Exts.I# x) = x






data HappyAddr = HappyA# Happy_GHC_Exts.Addr#


-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 180 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st1)
             off_i = (off Happy_GHC_Exts.+#  nt)
             new_state = indexShortOffAddr happyTable off_i




          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st)
         off_i = (off Happy_GHC_Exts.+#  nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail explist 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ explist i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail explist i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

