-- | Tom Johnson. \"Perfect Rhythmic Tilings\".
-- Technical report, IRCAM, 24 January 2004. MaMuX Lecture.
module Music.Theory.Tiling.Johnson_2004 where

import Music.Theory.Tiling.Canon

-- | @{0,1,2}@ order 5, p.1
--
-- >>> v_print 15 (r_voices p1)
-- >
-- > ..***..........
-- > ........*.*.*..
-- > .....*...*...*.
-- > .*....*....*...
-- > *......*......*
p1 :: R
p1 = (15,[0,1,2],[1,2,4,5,7],[2,8,5,1,0])

-- | @{0,1,2}@ order 7, p.2
--
-- >>> v_print 21 (r_voices p2)
-- >
-- > ..............***....
-- > ..*.*.*..............
-- > ...*...*...*.........
-- > ........*....*....*..
-- > .....*......*......*.
-- > .*.......*.......*...
-- > *.........*.........*
p2 :: R
p2 = (21,[0,1,2],[1,2,4,5,7,8,10],[14,2,3,8,5,1,0])

-- | @{0,1}@ order 4, p.3
--
-- >>> v_print 8 (r_voices p3)
-- >
-- > *...*...
-- > .**.....
-- > ...*..*.
-- > .....*.*
p3 :: R
p3 = (8,[0,1],[4,1,3,2],[0,1,3,5])

-- | @{0,1}@ order 5, p.4
--
-- >>> mapM_ (v_print 10 . r_voices) p4
-- >
-- > *...*.....
-- > .**.......
-- > ...*....*.
-- > .....*.*..
-- > ......*..*
-- >
-- > *....*....
-- > .**.......
-- > ...*..*...
-- > ....*...*.
-- > .......*.*
-- >
-- > *...*.....
-- > .*....*...
-- > ..**......
-- > .....*..*.
-- > .......*.*
p4 :: [R]
p4 = [(10,[0,1],[4,1,5,2,3],[0,1,3,5,6])
     ,(10,[0,1],[5,1,3,4,2],[0,1,3,4,7])
     ,(10,[0,1],[4,5,1,3,2],[0,1,2,5,7])]

-- | Open @{1,2,3}@ order 5, p.4
--
-- >>> v_print 18 (r_voices p4_b)
-- >
-- > ...***............
-- > ........*.*.*.....
-- > .........*...*...*
-- > .*....*....*......
-- > *......*......*...
p4_b :: R
p4_b = (21,[0,1,2],[1,2,4,5,7],[3,8,9,1,0])

-- Local Variables:
-- truncate-lines:t
-- End:
