
static const floatx80 atan_tbl[128] = {
	{0x3FFB, LIT64(0x83D152C5060B7A51)},
	{0x3FFB, LIT64(0x8BC8544565498B8B)},
	{0x3FFB, LIT64(0x93BE406017626B0D)},
	{0x3FFB, LIT64(0x9BB3078D35AEC202)},
	{0x3FFB, LIT64(0xA3A69A525DDCE7DE)},
	{0x3FFB, LIT64(0xAB98E94362765619)},
	{0x3FFB, LIT64(0xB389E502F9C59862)},
	{0x3FFB, LIT64(0xBB797E436B09E6FB)},
	{0x3FFB, LIT64(0xC367A5C739E5F446)},
	{0x3FFB, LIT64(0xCB544C61CFF7D5C6)},
	{0x3FFB, LIT64(0xD33F62F82488533E)},
	{0x3FFB, LIT64(0xDB28DA8162404C77)},
	{0x3FFB, LIT64(0xE310A4078AD34F18)},
	{0x3FFB, LIT64(0xEAF6B0A8188EE1EB)},
	{0x3FFB, LIT64(0xF2DAF1949DBE79D5)},
	{0x3FFB, LIT64(0xFABD581361D47E3E)},
	{0x3FFC, LIT64(0x8346AC210959ECC4)},
	{0x3FFC, LIT64(0x8B232A08304282D8)},
	{0x3FFC, LIT64(0x92FB70B8D29AE2F9)},
	{0x3FFC, LIT64(0x9ACF476F5CCD1CB4)},
	{0x3FFC, LIT64(0xA29E76304954F23F)},
	{0x3FFC, LIT64(0xAA68C5D08AB85230)},
	{0x3FFC, LIT64(0xB22DFFFD9D539F83)},
	{0x3FFC, LIT64(0xB9EDEF453E900EA5)},
	{0x3FFC, LIT64(0xC1A85F1CC75E3EA5)},
	{0x3FFC, LIT64(0xC95D1BE828138DE6)},
	{0x3FFC, LIT64(0xD10BF300840D2DE4)},
	{0x3FFC, LIT64(0xD8B4B2BA6BC05E7A)},
	{0x3FFC, LIT64(0xE0572A6BB42335F6)},
	{0x3FFC, LIT64(0xE7F32A70EA9CAA8F)},
	{0x3FFC, LIT64(0xEF88843264ECEFAA)},
	{0x3FFC, LIT64(0xF7170A28ECC06666)},
	{0x3FFD, LIT64(0x812FD288332DAD32)},
	{0x3FFD, LIT64(0x88A8D1B1218E4D64)},
	{0x3FFD, LIT64(0x9012AB3F23E4AEE8)},
	{0x3FFD, LIT64(0x976CC3D411E7F1B9)},
	{0x3FFD, LIT64(0x9EB689493889A227)},
	{0x3FFD, LIT64(0xA5EF72C34487361B)},
	{0x3FFD, LIT64(0xAD1700BAF07A7227)},
	{0x3FFD, LIT64(0xB42CBCFAFD37EFB7)},
	{0x3FFD, LIT64(0xBB303A940BA80F89)},
	{0x3FFD, LIT64(0xC22115C6FCAEBBAF)},
	{0x3FFD, LIT64(0xC8FEF3E686331221)},
	{0x3FFD, LIT64(0xCFC98330B4000C70)},
	{0x3FFD, LIT64(0xD6807AA1102C5BF9)},
	{0x3FFD, LIT64(0xDD2399BC31252AA3)},
	{0x3FFD, LIT64(0xE3B2A8556B8FC517)},
	{0x3FFD, LIT64(0xEA2D764F64315989)},
	{0x3FFD, LIT64(0xF3BF5BF8BAD1A21D)},
	{0x3FFE, LIT64(0x801CE39E0D205C9A)},
	{0x3FFE, LIT64(0x8630A2DADA1ED066)},
	{0x3FFE, LIT64(0x8C1AD445F3E09B8C)},
	{0x3FFE, LIT64(0x91DB8F1664F350E2)},
	{0x3FFE, LIT64(0x97731420365E538C)},
	{0x3FFE, LIT64(0x9CE1C8E6A0B8CDBA)},
	{0x3FFE, LIT64(0xA22832DBCADAAE09)},
	{0x3FFE, LIT64(0xA746F2DDB7602294)},
	{0x3FFE, LIT64(0xAC3EC0FB997DD6A2)},
	{0x3FFE, LIT64(0xB110688AEBDC6F6A)},
	{0x3FFE, LIT64(0xB5BCC49059ECC4B0)},
	{0x3FFE, LIT64(0xBA44BC7DD470782F)},
	{0x3FFE, LIT64(0xBEA94144FD049AAC)},
	{0x3FFE, LIT64(0xC2EB4ABB661628B6)},
	{0x3FFE, LIT64(0xC70BD54CE602EE14)},
	{0x3FFE, LIT64(0xCD000549ADEC7159)},
	{0x3FFE, LIT64(0xD48457D2D8EA4EA3)},
	{0x3FFE, LIT64(0xDB948DA712DECE3B)},
	{0x3FFE, LIT64(0xE23855F969E8096A)},
	{0x3FFE, LIT64(0xE8771129C4353259)},
	{0x3FFE, LIT64(0xEE57C16E0D379C0D)},
	{0x3FFE, LIT64(0xF3E10211A87C3779)},
	{0x3FFE, LIT64(0xF919039D758B8D41)},
	{0x3FFE, LIT64(0xFE058B8F64935FB3)},
	{0x3FFF, LIT64(0x8155FB497B685D04)},
	{0x3FFF, LIT64(0x83889E3549D108E1)},
	{0x3FFF, LIT64(0x859CFA76511D724B)},
	{0x3FFF, LIT64(0x87952ECFFF8131E7)},
	{0x3FFF, LIT64(0x89732FD19557641B)},
	{0x3FFF, LIT64(0x8B38CAD101932A35)},
	{0x3FFF, LIT64(0x8CE7A8D8301EE6B5)},
	{0x3FFF, LIT64(0x8F46A39E2EAE5281)},
	{0x3FFF, LIT64(0x922DA7D791888487)},
	{0x3FFF, LIT64(0x94D19FCBDEDF5241)},
	{0x3FFF, LIT64(0x973AB94419D2A08B)},
	{0x3FFF, LIT64(0x996FF00E08E10B96)},
	{0x3FFF, LIT64(0x9B773F9512321DA7)},
	{0x3FFF, LIT64(0x9D55CC320F935624)},
	{0x3FFF, LIT64(0x9F100575006CC571)},
	{0x3FFF, LIT64(0xA0A9C290D97CC06C)},
	{0x3FFF, LIT64(0xA22659EBEBC0630A)},
	{0x3FFF, LIT64(0xA388B4AFF6EF0EC9)},
	{0x3FFF, LIT64(0xA4D35F1061D292C4)},
	{0x3FFF, LIT64(0xA60895DCFBE3187E)},
	{0x3FFF, LIT64(0xA72A51DC7367BEAC)},
	{0x3FFF, LIT64(0xA83A51530956168F)},
	{0x3FFF, LIT64(0xA93A20077539546E)},
	{0x3FFF, LIT64(0xAA9E7245023B2605)},
	{0x3FFF, LIT64(0xAC4C84BA6FE4D58F)},
	{0x3FFF, LIT64(0xADCE4A4A606B9712)},
	{0x3FFF, LIT64(0xAF2A2DCD8D263C9C)},
	{0x3FFF, LIT64(0xB0656F81F22265C7)},
	{0x3FFF, LIT64(0xB18465150F71496A)},
	{0x3FFF, LIT64(0xB28AAA156F9ADA35)},
	{0x3FFF, LIT64(0xB37B44FF3766B895)},
	{0x3FFF, LIT64(0xB458C3DCE9630433)},
	{0x3FFF, LIT64(0xB525529D562246BD)},
	{0x3FFF, LIT64(0xB5E2CCA95F9D88CC)},
	{0x3FFF, LIT64(0xB692CADA7ACA1ADA)},
	{0x3FFF, LIT64(0xB736AEA7A6925838)},
	{0x3FFF, LIT64(0xB7CFAB287E9F7B36)},
	{0x3FFF, LIT64(0xB85ECC66CB219835)},
	{0x3FFF, LIT64(0xB8E4FD5A20A593DA)},
	{0x3FFF, LIT64(0xB99F41F64AFF9BB5)},
	{0x3FFF, LIT64(0xBA7F1E17842BBE7B)},
	{0x3FFF, LIT64(0xBB4712857637E17D)},
	{0x3FFF, LIT64(0xBBFABE8A4788DF6F)},
	{0x3FFF, LIT64(0xBC9D0FAD2B689D79)},
	{0x3FFF, LIT64(0xBD306A39471ECD86)},
	{0x3FFF, LIT64(0xBDB6C731856AF18A)},
	{0x3FFF, LIT64(0xBE31CAC502E80D70)},
	{0x3FFF, LIT64(0xBEA2D55CE33194E2)},
	{0x3FFF, LIT64(0xBF0B10B7C03128F0)},
	{0x3FFF, LIT64(0xBF6B7A18DACB778D)},
	{0x3FFF, LIT64(0xBFC4EA4663FA18F6)},
	{0x3FFF, LIT64(0xC0181BDE8B89A454)},
	{0x3FFF, LIT64(0xC065B066CFBF6439)},
	{0x3FFF, LIT64(0xC0AE345F56340AE6)},
	{0x3FFF, LIT64(0xC0F222919CB9E6A7)}
};


static const floatx80 exp_tbl[64] = {
	{0x3FFF, LIT64(0x8000000000000000)},
	{0x3FFF, LIT64(0x8164D1F3BC030774)},
	{0x3FFF, LIT64(0x82CD8698AC2BA1D8)},
	{0x3FFF, LIT64(0x843A28C3ACDE4048)},
	{0x3FFF, LIT64(0x85AAC367CC487B14)},
	{0x3FFF, LIT64(0x871F61969E8D1010)},
	{0x3FFF, LIT64(0x88980E8092DA8528)},
	{0x3FFF, LIT64(0x8A14D575496EFD9C)},
	{0x3FFF, LIT64(0x8B95C1E3EA8BD6E8)},
	{0x3FFF, LIT64(0x8D1ADF5B7E5BA9E4)},
	{0x3FFF, LIT64(0x8EA4398B45CD53C0)},
	{0x3FFF, LIT64(0x9031DC431466B1DC)},
	{0x3FFF, LIT64(0x91C3D373AB11C338)},
	{0x3FFF, LIT64(0x935A2B2F13E6E92C)},
	{0x3FFF, LIT64(0x94F4EFA8FEF70960)},
	{0x3FFF, LIT64(0x96942D3720185A00)},
	{0x3FFF, LIT64(0x9837F0518DB8A970)},
	{0x3FFF, LIT64(0x99E0459320B7FA64)},
	{0x3FFF, LIT64(0x9B8D39B9D54E5538)},
	{0x3FFF, LIT64(0x9D3ED9A72CFFB750)},
	{0x3FFF, LIT64(0x9EF5326091A111AC)},
	{0x3FFF, LIT64(0xA0B0510FB9714FC4)},
	{0x3FFF, LIT64(0xA27043030C496818)},
	{0x3FFF, LIT64(0xA43515AE09E680A0)},
	{0x3FFF, LIT64(0xA5FED6A9B15138EC)},
	{0x3FFF, LIT64(0xA7CD93B4E9653568)},
	{0x3FFF, LIT64(0xA9A15AB4EA7C0EF8)},
	{0x3FFF, LIT64(0xAB7A39B5A93ED338)},
	{0x3FFF, LIT64(0xAD583EEA42A14AC8)},
	{0x3FFF, LIT64(0xAF3B78AD690A4374)},
	{0x3FFF, LIT64(0xB123F581D2AC2590)},
	{0x3FFF, LIT64(0xB311C412A9112488)},
	{0x3FFF, LIT64(0xB504F333F9DE6484)},
	{0x3FFF, LIT64(0xB6FD91E328D17790)},
	{0x3FFF, LIT64(0xB8FBAF4762FB9EE8)},
	{0x3FFF, LIT64(0xBAFF5AB2133E45FC)},
	{0x3FFF, LIT64(0xBD08A39F580C36C0)},
	{0x3FFF, LIT64(0xBF1799B67A731084)},
	{0x3FFF, LIT64(0xC12C4CCA66709458)},
	{0x3FFF, LIT64(0xC346CCDA24976408)},
	{0x3FFF, LIT64(0xC5672A115506DADC)},
	{0x3FFF, LIT64(0xC78D74C8ABB9B15C)},
	{0x3FFF, LIT64(0xC9B9BD866E2F27A4)},
	{0x3FFF, LIT64(0xCBEC14FEF2727C5C)},
	{0x3FFF, LIT64(0xCE248C151F8480E4)},
	{0x3FFF, LIT64(0xD06333DAEF2B2594)},
	{0x3FFF, LIT64(0xD2A81D91F12AE45C)},
	{0x3FFF, LIT64(0xD4F35AABCFEDFA20)},
	{0x3FFF, LIT64(0xD744FCCAD69D6AF4)},
	{0x3FFF, LIT64(0xD99D15C278AFD7B4)},
	{0x3FFF, LIT64(0xDBFBB797DAF23754)},
	{0x3FFF, LIT64(0xDE60F4825E0E9124)},
	{0x3FFF, LIT64(0xE0CCDEEC2A94E110)},
	{0x3FFF, LIT64(0xE33F8972BE8A5A50)},
	{0x3FFF, LIT64(0xE5B906E77C8348A8)},
	{0x3FFF, LIT64(0xE8396A503C4BDC68)},
	{0x3FFF, LIT64(0xEAC0C6E7DD243930)},
	{0x3FFF, LIT64(0xED4F301ED9942B84)},
	{0x3FFF, LIT64(0xEFE4B99BDCDAF5CC)},
	{0x3FFF, LIT64(0xF281773C59FFB138)},
	{0x3FFF, LIT64(0xF5257D152486CC2C)},
	{0x3FFF, LIT64(0xF7D0DF730AD13BB8)},
	{0x3FFF, LIT64(0xFA83B2DB722A033C)},
	{0x3FFF, LIT64(0xFD3E0C0CF486C174)}
};

static const float32 exp_tbl2[64] = {
	0x00000000, 0x9F841A9B, 0x9FC1D5B9, 0xA0728369,
	0x1FC5C95C, 0x1EE85C9F, 0x9FA20729, 0xA07BF9AF,
	0xA0020DCF, 0x205A63DA, 0x1EB70051, 0x1F6EB029,
	0xA0781494, 0x9EB319B0, 0x2017457D, 0x1F11D537,
	0x9FB952DD, 0x1FE43087, 0x1FA2A818, 0x1FDE494D,
	0x20504890, 0xA073691C, 0x1F9B7A05, 0xA0797126,
	0xA071A140, 0x204F62DA, 0x1F283C4A, 0x9F9A7FDC,
	0xA05B3FAC, 0x1FDF2610, 0x9F705F90, 0x201F678A,
	0x1F32FB13, 0x20038B30, 0x200DC3CC, 0x9F8B2AE6,
	0xA02BBF70, 0xA00BF518, 0xA041DD41, 0x9FDF137B,
	0x201F1568, 0x1FC13A2E, 0xA03F8F03, 0x1FF4907D,
	0x9E6E53E4, 0x1FD6D45C, 0xA076EDB9, 0x9FA6DE21,
	0x1EE69A2F, 0x207F439F, 0x201EC207, 0x9E8BE175,
	0x20032C4B, 0x2004DFF5, 0x1E72F47A, 0x1F722F22,
	0xA017E945, 0x1F401A5B, 0x9FB9A9E3, 0x20744C05,
	0x1F773A19, 0x1FFE90D5, 0xA041ED22, 0x1F853F3A
};


static const floatx80 exp2_tbl[64] = {
	{0x3FFF, LIT64(0x8000000000000000)},
	{0x3FFF, LIT64(0x8164D1F3BC030773)},
	{0x3FFF, LIT64(0x82CD8698AC2BA1D7)},
	{0x3FFF, LIT64(0x843A28C3ACDE4046)},
	{0x3FFF, LIT64(0x85AAC367CC487B15)},
	{0x3FFF, LIT64(0x871F61969E8D1010)},
	{0x3FFF, LIT64(0x88980E8092DA8527)},
	{0x3FFF, LIT64(0x8A14D575496EFD9A)},
	{0x3FFF, LIT64(0x8B95C1E3EA8BD6E7)},
	{0x3FFF, LIT64(0x8D1ADF5B7E5BA9E6)},
	{0x3FFF, LIT64(0x8EA4398B45CD53C0)},
	{0x3FFF, LIT64(0x9031DC431466B1DC)},
	{0x3FFF, LIT64(0x91C3D373AB11C336)},
	{0x3FFF, LIT64(0x935A2B2F13E6E92C)},
	{0x3FFF, LIT64(0x94F4EFA8FEF70961)},
	{0x3FFF, LIT64(0x96942D3720185A00)},
	{0x3FFF, LIT64(0x9837F0518DB8A96F)},
	{0x3FFF, LIT64(0x99E0459320B7FA65)},
	{0x3FFF, LIT64(0x9B8D39B9D54E5539)},
	{0x3FFF, LIT64(0x9D3ED9A72CFFB751)},
	{0x3FFF, LIT64(0x9EF5326091A111AE)},
	{0x3FFF, LIT64(0xA0B0510FB9714FC2)},
	{0x3FFF, LIT64(0xA27043030C496819)},
	{0x3FFF, LIT64(0xA43515AE09E6809E)},
	{0x3FFF, LIT64(0xA5FED6A9B15138EA)},
	{0x3FFF, LIT64(0xA7CD93B4E965356A)},
	{0x3FFF, LIT64(0xA9A15AB4EA7C0EF8)},
	{0x3FFF, LIT64(0xAB7A39B5A93ED337)},
	{0x3FFF, LIT64(0xAD583EEA42A14AC6)},
	{0x3FFF, LIT64(0xAF3B78AD690A4375)},
	{0x3FFF, LIT64(0xB123F581D2AC2590)},
	{0x3FFF, LIT64(0xB311C412A9112489)},
	{0x3FFF, LIT64(0xB504F333F9DE6484)},
	{0x3FFF, LIT64(0xB6FD91E328D17791)},
	{0x3FFF, LIT64(0xB8FBAF4762FB9EE9)},
	{0x3FFF, LIT64(0xBAFF5AB2133E45FB)},
	{0x3FFF, LIT64(0xBD08A39F580C36BF)},
	{0x3FFF, LIT64(0xBF1799B67A731083)},
	{0x3FFF, LIT64(0xC12C4CCA66709456)},
	{0x3FFF, LIT64(0xC346CCDA24976407)},
	{0x3FFF, LIT64(0xC5672A115506DADD)},
	{0x3FFF, LIT64(0xC78D74C8ABB9B15D)},
	{0x3FFF, LIT64(0xC9B9BD866E2F27A3)},
	{0x3FFF, LIT64(0xCBEC14FEF2727C5D)},
	{0x3FFF, LIT64(0xCE248C151F8480E4)},
	{0x3FFF, LIT64(0xD06333DAEF2B2595)},
	{0x3FFF, LIT64(0xD2A81D91F12AE45A)},
	{0x3FFF, LIT64(0xD4F35AABCFEDFA1F)},
	{0x3FFF, LIT64(0xD744FCCAD69D6AF4)},
	{0x3FFF, LIT64(0xD99D15C278AFD7B6)},
	{0x3FFF, LIT64(0xDBFBB797DAF23755)},
	{0x3FFF, LIT64(0xDE60F4825E0E9124)},
	{0x3FFF, LIT64(0xE0CCDEEC2A94E111)},
	{0x3FFF, LIT64(0xE33F8972BE8A5A51)},
	{0x3FFF, LIT64(0xE5B906E77C8348A8)},
	{0x3FFF, LIT64(0xE8396A503C4BDC68)},
	{0x3FFF, LIT64(0xEAC0C6E7DD24392F)},
	{0x3FFF, LIT64(0xED4F301ED9942B84)},
	{0x3FFF, LIT64(0xEFE4B99BDCDAF5CB)},
	{0x3FFF, LIT64(0xF281773C59FFB13A)},
	{0x3FFF, LIT64(0xF5257D152486CC2C)},
	{0x3FFF, LIT64(0xF7D0DF730AD13BB9)},
	{0x3FFF, LIT64(0xFA83B2DB722A033A)},
	{0x3FFF, LIT64(0xFD3E0C0CF486C175)}
};


static const float32 exp2_tbl2[64] = {
	0x3F738000, 0x3FBEF7CA, 0x3FBDF8A9, 0x3FBCD7C9,
	0xBFBDE8DA, 0x3FBDE85C, 0x3FBEBBF1, 0x3FBB80CA,
	0xBFBA8373, 0xBFBE9670, 0x3FBDB700, 0x3FBEEEB0,
	0x3FBBFD6D, 0xBFBDB319, 0x3FBDBA2B, 0x3FBE91D5,
	0x3FBE8D5A, 0xBFBCDE7B, 0xBFBEBAAF, 0xBFBD86DA,
	0xBFBEBEDD, 0x3FBCC96E, 0xBFBEC90B, 0x3FBBD1DB,
	0x3FBCE5EB, 0xBFBEC274, 0x3FBEA83C, 0x3FBECB00,
	0x3FBE9301, 0xBFBD8367, 0xBFBEF05F, 0x3FBDFB3C,
	0x3FBEB2FB, 0x3FBAE2CB, 0x3FBCDC3C, 0x3FBEE9AA,
	0xBFBEAEFD, 0xBFBCBF51, 0x3FBEF88A, 0x3FBD83B2,
	0x3FBDF8AB, 0xBFBDFB17, 0xBFBEFE3C, 0xBFBBB6F8,
	0xBFBCEE53, 0xBFBDA4AE, 0x3FBC9124, 0x3FBEB243,
	0x3FBDE69A, 0xBFB8BC61, 0x3FBDF610, 0xBFBD8BE1,
	0x3FBACB12, 0x3FBB9BFE, 0x3FBCF2F4, 0x3FBEF22F,
	0xBFBDBF4A, 0x3FBEC01A, 0x3FBE8CAC, 0xBFBCBB3F,
	0x3FBEF73A, 0xBFB8B795, 0x3FBEF84B, 0xBFBEF581
};


static const floatx80 log_tbl[128] = {
	{0x3FFE, LIT64(0xFE03F80FE03F80FE)},
	{0x3FF7, LIT64(0xFF015358833C47E2)},
	{0x3FFE, LIT64(0xFA232CF252138AC0)},
	{0x3FF9, LIT64(0xBDC8D83EAD88D549)},
	{0x3FFE, LIT64(0xF6603D980F6603DA)},
	{0x3FFA, LIT64(0x9CF43DCFF5EAFD48)},
	{0x3FFE, LIT64(0xF2B9D6480F2B9D65)},
	{0x3FFA, LIT64(0xDA16EB88CB8DF614)},
	{0x3FFE, LIT64(0xEF2EB71FC4345238)},
	{0x3FFB, LIT64(0x8B29B7751BD70743)},
	{0x3FFE, LIT64(0xEBBDB2A5C1619C8C)},
	{0x3FFB, LIT64(0xA8D839F830C1FB49)},
	{0x3FFE, LIT64(0xE865AC7B7603A197)},
	{0x3FFB, LIT64(0xC61A2EB18CD907AD)},
	{0x3FFE, LIT64(0xE525982AF70C880E)},
	{0x3FFB, LIT64(0xE2F2A47ADE3A18AF)},
	{0x3FFE, LIT64(0xE1FC780E1FC780E2)},
	{0x3FFB, LIT64(0xFF64898EDF55D551)},
	{0x3FFE, LIT64(0xDEE95C4CA037BA57)},
	{0x3FFC, LIT64(0x8DB956A97B3D0148)},
	{0x3FFE, LIT64(0xDBEB61EED19C5958)},
	{0x3FFC, LIT64(0x9B8FE100F47BA1DE)},
	{0x3FFE, LIT64(0xD901B2036406C80E)},
	{0x3FFC, LIT64(0xA9372F1D0DA1BD17)},
	{0x3FFE, LIT64(0xD62B80D62B80D62C)},
	{0x3FFC, LIT64(0xB6B07F38CE90E46B)},
	{0x3FFE, LIT64(0xD3680D3680D3680D)},
	{0x3FFC, LIT64(0xC3FD032906488481)},
	{0x3FFE, LIT64(0xD0B69FCBD2580D0B)},
	{0x3FFC, LIT64(0xD11DE0FF15AB18CA)},
	{0x3FFE, LIT64(0xCE168A7725080CE1)},
	{0x3FFC, LIT64(0xDE1433A16C66B150)},
	{0x3FFE, LIT64(0xCB8727C065C393E0)},
	{0x3FFC, LIT64(0xEAE10B5A7DDC8ADD)},
	{0x3FFE, LIT64(0xC907DA4E871146AD)},
	{0x3FFC, LIT64(0xF7856E5EE2C9B291)},
	{0x3FFE, LIT64(0xC6980C6980C6980C)},
	{0x3FFD, LIT64(0x82012CA5A68206D7)},
	{0x3FFE, LIT64(0xC4372F855D824CA6)},
	{0x3FFD, LIT64(0x882C5FCD7256A8C5)},
	{0x3FFE, LIT64(0xC1E4BBD595F6E947)},
	{0x3FFD, LIT64(0x8E44C60B4CCFD7DE)},
	{0x3FFE, LIT64(0xBFA02FE80BFA02FF)},
	{0x3FFD, LIT64(0x944AD09EF4351AF6)},
	{0x3FFE, LIT64(0xBD69104707661AA3)},
	{0x3FFD, LIT64(0x9A3EECD4C3EAA6B2)},
	{0x3FFE, LIT64(0xBB3EE721A54D880C)},
	{0x3FFD, LIT64(0xA0218434353F1DE8)},
	{0x3FFE, LIT64(0xB92143FA36F5E02E)},
	{0x3FFD, LIT64(0xA5F2FCABBBC506DA)},
	{0x3FFE, LIT64(0xB70FBB5A19BE3659)},
	{0x3FFD, LIT64(0xABB3B8BA2AD362A5)},
	{0x3FFE, LIT64(0xB509E68A9B94821F)},
	{0x3FFD, LIT64(0xB1641795CE3CA97B)},
	{0x3FFE, LIT64(0xB30F63528917C80B)},
	{0x3FFD, LIT64(0xB70475515D0F1C61)},
	{0x3FFE, LIT64(0xB11FD3B80B11FD3C)},
	{0x3FFD, LIT64(0xBC952AFEEA3D13E1)},
	{0x3FFE, LIT64(0xAF3ADDC680AF3ADE)},
	{0x3FFD, LIT64(0xC2168ED0F458BA4A)},
	{0x3FFE, LIT64(0xAD602B580AD602B6)},
	{0x3FFD, LIT64(0xC788F439B3163BF1)},
	{0x3FFE, LIT64(0xAB8F69E28359CD11)},
	{0x3FFD, LIT64(0xCCECAC08BF04565D)},
	{0x3FFE, LIT64(0xA9C84A47A07F5638)},
	{0x3FFD, LIT64(0xD24204872DD85160)},
	{0x3FFE, LIT64(0xA80A80A80A80A80B)},
	{0x3FFD, LIT64(0xD78949923BC3588A)},
	{0x3FFE, LIT64(0xA655C4392D7B73A8)},
	{0x3FFD, LIT64(0xDCC2C4B49887DACC)},
	{0x3FFE, LIT64(0xA4A9CF1D96833751)},
	{0x3FFD, LIT64(0xE1EEBD3E6D6A6B9E)},
	{0x3FFE, LIT64(0xA3065E3FAE7CD0E0)},
	{0x3FFD, LIT64(0xE70D785C2F9F5BDC)},
	{0x3FFE, LIT64(0xA16B312EA8FC377D)},
	{0x3FFD, LIT64(0xEC1F392C5179F283)},
	{0x3FFE, LIT64(0x9FD809FD809FD80A)},
	{0x3FFD, LIT64(0xF12440D3E36130E6)},
	{0x3FFE, LIT64(0x9E4CAD23DD5F3A20)},
	{0x3FFD, LIT64(0xF61CCE92346600BB)},
	{0x3FFE, LIT64(0x9CC8E160C3FB19B9)},
	{0x3FFD, LIT64(0xFB091FD38145630A)},
	{0x3FFE, LIT64(0x9B4C6F9EF03A3CAA)},
	{0x3FFD, LIT64(0xFFE97042BFA4C2AD)},
	{0x3FFE, LIT64(0x99D722DABDE58F06)},
	{0x3FFE, LIT64(0x825EFCED49369330)},
	{0x3FFE, LIT64(0x9868C809868C8098)},
	{0x3FFE, LIT64(0x84C37A7AB9A905C9)},
	{0x3FFE, LIT64(0x97012E025C04B809)},
	{0x3FFE, LIT64(0x87224C2E8E645FB7)},
	{0x3FFE, LIT64(0x95A02568095A0257)},
	{0x3FFE, LIT64(0x897B8CAC9F7DE298)},
	{0x3FFE, LIT64(0x9445809445809446)},
	{0x3FFE, LIT64(0x8BCF55DEC4CD05FE)},
	{0x3FFE, LIT64(0x92F113840497889C)},
	{0x3FFE, LIT64(0x8E1DC0FB89E125E5)},
	{0x3FFE, LIT64(0x91A2B3C4D5E6F809)},
	{0x3FFE, LIT64(0x9066E68C955B6C9B)},
	{0x3FFE, LIT64(0x905A38633E06C43B)},
	{0x3FFE, LIT64(0x92AADE74C7BE59E0)},
	{0x3FFE, LIT64(0x8F1779D9FDC3A219)},
	{0x3FFE, LIT64(0x94E9BFF615845643)},
	{0x3FFE, LIT64(0x8DDA520237694809)},
	{0x3FFE, LIT64(0x9723A1B720134203)},
	{0x3FFE, LIT64(0x8CA29C046514E023)},
	{0x3FFE, LIT64(0x995899C890EB8990)},
	{0x3FFE, LIT64(0x8B70344A139BC75A)},
	{0x3FFE, LIT64(0x9B88BDAA3A3DAE2F)},
	{0x3FFE, LIT64(0x8A42F8705669DB46)},
	{0x3FFE, LIT64(0x9DB4224FFFE1157C)},
	{0x3FFE, LIT64(0x891AC73AE9819B50)},
	{0x3FFE, LIT64(0x9FDADC268B7A12DA)},
	{0x3FFE, LIT64(0x87F78087F78087F8)},
	{0x3FFE, LIT64(0xA1FCFF17CE733BD4)},
	{0x3FFE, LIT64(0x86D905447A34ACC6)},
	{0x3FFE, LIT64(0xA41A9E8F5446FB9F)},
	{0x3FFE, LIT64(0x85BF37612CEE3C9B)},
	{0x3FFE, LIT64(0xA633CD7E6771CD8B)},
	{0x3FFE, LIT64(0x84A9F9C8084A9F9D)},
	{0x3FFE, LIT64(0xA8489E600B435A5E)},
	{0x3FFE, LIT64(0x839930523FBE3368)},
	{0x3FFE, LIT64(0xAA59233CCCA4BD49)},
	{0x3FFE, LIT64(0x828CBFBEB9A020A3)},
	{0x3FFE, LIT64(0xAC656DAE6BCC4985)},
	{0x3FFE, LIT64(0x81848DA8FAF0D277)},
	{0x3FFE, LIT64(0xAE6D8EE360BB2468)},
	{0x3FFE, LIT64(0x8080808080808081)},
	{0x3FFE, LIT64(0xB07197A23C46C654)}
};


static const floatx80 pi_tbl[65] = {
	{0xC004, LIT64(0xC90FDAA22168C235)},
	{0xC004, LIT64(0xC2C75BCD105D7C23)},
	{0xC004, LIT64(0xBC7EDCF7FF523611)},
	{0xC004, LIT64(0xB6365E22EE46F000)},
	{0xC004, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0xC004, LIT64(0xA9A56078CC3063DD)},
	{0xC004, LIT64(0xA35CE1A3BB251DCB)},
	{0xC004, LIT64(0x9D1462CEAA19D7B9)},
	{0xC004, LIT64(0x96CBE3F9990E91A8)},
	{0xC004, LIT64(0x9083652488034B96)},
	{0xC004, LIT64(0x8A3AE64F76F80584)},
	{0xC004, LIT64(0x83F2677A65ECBF73)},
	{0xC003, LIT64(0xFB53D14AA9C2F2C2)},
	{0xC003, LIT64(0xEEC2D3A087AC669F)},
	{0xC003, LIT64(0xE231D5F66595DA7B)},
	{0xC003, LIT64(0xD5A0D84C437F4E58)},
	{0xC003, LIT64(0xC90FDAA22168C235)},
	{0xC003, LIT64(0xBC7EDCF7FF523611)},
	{0xC003, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0xC003, LIT64(0xA35CE1A3BB251DCB)},
	{0xC003, LIT64(0x96CBE3F9990E91A8)},
	{0xC003, LIT64(0x8A3AE64F76F80584)},
	{0xC002, LIT64(0xFB53D14AA9C2F2C2)},
	{0xC002, LIT64(0xE231D5F66595DA7B)},
	{0xC002, LIT64(0xC90FDAA22168C235)},
	{0xC002, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0xC002, LIT64(0x96CBE3F9990E91A8)},
	{0xC001, LIT64(0xFB53D14AA9C2F2C2)},
	{0xC001, LIT64(0xC90FDAA22168C235)},
	{0xC001, LIT64(0x96CBE3F9990E91A8)},
	{0xC000, LIT64(0xC90FDAA22168C235)},
	{0xBFFF, LIT64(0xC90FDAA22168C235)},
	{0x0000, LIT64(0x0000000000000000)},
	{0x3FFF, LIT64(0xC90FDAA22168C235)},
	{0x4000, LIT64(0xC90FDAA22168C235)},
	{0x4001, LIT64(0x96CBE3F9990E91A8)},
	{0x4001, LIT64(0xC90FDAA22168C235)},
	{0x4001, LIT64(0xFB53D14AA9C2F2C2)},
	{0x4002, LIT64(0x96CBE3F9990E91A8)},
	{0x4002, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0x4002, LIT64(0xC90FDAA22168C235)},
	{0x4002, LIT64(0xE231D5F66595DA7B)},
	{0x4002, LIT64(0xFB53D14AA9C2F2C2)},
	{0x4003, LIT64(0x8A3AE64F76F80584)},
	{0x4003, LIT64(0x96CBE3F9990E91A8)},
	{0x4003, LIT64(0xA35CE1A3BB251DCB)},
	{0x4003, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0x4003, LIT64(0xBC7EDCF7FF523611)},
	{0x4003, LIT64(0xC90FDAA22168C235)},
	{0x4003, LIT64(0xD5A0D84C437F4E58)},
	{0x4003, LIT64(0xE231D5F66595DA7B)},
	{0x4003, LIT64(0xEEC2D3A087AC669F)},
	{0x4003, LIT64(0xFB53D14AA9C2F2C2)},
	{0x4004, LIT64(0x83F2677A65ECBF73)},
	{0x4004, LIT64(0x8A3AE64F76F80584)},
	{0x4004, LIT64(0x9083652488034B96)},
	{0x4004, LIT64(0x96CBE3F9990E91A8)},
	{0x4004, LIT64(0x9D1462CEAA19D7B9)},
	{0x4004, LIT64(0xA35CE1A3BB251DCB)},
	{0x4004, LIT64(0xA9A56078CC3063DD)},
	{0x4004, LIT64(0xAFEDDF4DDD3BA9EE)},
	{0x4004, LIT64(0xB6365E22EE46F000)},
	{0x4004, LIT64(0xBC7EDCF7FF523611)},
	{0x4004, LIT64(0xC2C75BCD105D7C23)},
	{0x4004, LIT64(0xC90FDAA22168C235)}
};


static const float32 pi_tbl2[65] = {
	0x21800000, 0xA0D00000, 0xA1E80000, 0x21480000,
	0xA1200000, 0x21FC0000, 0x21100000, 0xA1580000,
	0x21E00000, 0x20B00000, 0xA1880000, 0x21C40000,
	0x20000000, 0x21380000, 0xA1300000, 0x9FC00000,
	0x21000000, 0xA1680000, 0xA0A00000, 0x20900000,
	0x21600000, 0xA1080000, 0x1F800000, 0xA0B00000,
	0x20800000, 0xA0200000, 0x20E00000, 0x1F000000,
	0x20000000, 0x20600000, 0x1F800000, 0x1F000000,
	0x00000000,
	0x9F000000, 0x9F800000, 0xA0600000, 0xA0000000,
	0x9F000000, 0xA0E00000, 0x20200000, 0xA0800000,
	0x20B00000, 0x9F800000, 0x21080000, 0xA1600000,
	0xA0900000, 0x20A00000, 0x21680000, 0xA1000000,
	0x1FC00000, 0x21300000, 0xA1380000, 0xA0000000,
	0xA1C40000, 0x21880000, 0xA0B00000, 0xA1E00000,
	0x21580000, 0xA1100000, 0xA1FC0000, 0x21200000,
	0xA1480000, 0x21E80000, 0x20D00000, 0xA1800000
};
