(**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the "hack" directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 *)

open Reordered_argument_collections

type t

val of_id : id:int -> init:Errors.t -> t

val get_id : t -> int

val update :
  t ->
  Relative_path.Set.t -> (* edited files, so we can prioritize them *)
  FileInfo.fast -> (* rechecked files *)
  Errors.t ->
  t

val file_has_errors_in_ide : t -> Relative_path.t -> bool

val files_with_errors_in_ide : t -> Relative_path.Set.t

(* Errors ready for sending to client *)
val pop_errors : t ->  t * (Pos.absolute Errors.error_ list) SMap.t
