{- This module was generated from data in the Kate syntax
   highlighting file fsharp.xml, version 0.0.1, by Bas Bossink (bas.bossink@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Fsharp
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "FSharp"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.fs;*.fsi;*.fsx"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("FSharp","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("FSharp","Normal") -> return ()
      ("FSharp","Singleline Comment") -> (popContext) >> pEndLine
      ("FSharp","Multiline Comment") -> return ()
      ("FSharp","String Constant") -> return ()
      ("FSharp","Block") -> return ()
      ("FSharp","Sig") -> return ()
      ("FSharp","Struct") -> return ()
      ("FSharp","Object") -> return ()
      ("FSharp","ModuleEnv") -> return ()
      ("FSharp","ModuleEnv2") -> return ()
      ("FSharp","Camlp4 Quotation Constant") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "abstract and as assert base class delegate dowcast downto elif else exception extern false for fun function functor global if in inherit inline interfaece internal lazy let match member mutable namespace new not null of or override private public rec ref return static then to true try type upcast use val void when while with yield"
list_core_types = Set.fromList $ words $ "bool byte sbyte int16 uint16 int uint32 int64 uint64 nativeint unativeint char string decimal unit void float32 single float double bigint option seq"
list_symbols = Set.fromList $ words $ "?"
list_end = Set.fromList $ words $ "end"
list_sig = Set.fromList $ words $ "sig"
list_struct = Set.fromList $ words $ "struct"
list_object = Set.fromList $ words $ "object"
list_begin = Set.fromList $ words $ "begin"
list_do = Set.fromList $ words $ "do"
list_done = Set.fromList $ words $ "done"
list_module'5fenvironment = Set.fromList $ words $ "module open"

regex_'60'5cs'2a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a = compileRegex "`\\s*[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*"
regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'5cs'2a'5c'2e = compileRegex "[A-Z][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*\\s*\\."
regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a = compileRegex "[A-Z][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*"
regex_'23'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'2e'2a'24 = compileRegex "#[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*.*$"
regex_'27'28'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29'7c'5b'5e'27'5d'29'27 = compileRegex "'((\\\\[ntbr'\"\\\\]|\\\\[0-9]{3}|\\\\x[0-9A-Fa-f]{2})|[^'])'"
regex_'3c'3a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'3c = compileRegex "<:[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*<"
regex_'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a = compileRegex "[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*"
regex_'2d'3f0'5bxX'5d'5b0'2d9A'2dFa'2df'5f'5d'2b = compileRegex "-?0[xX][0-9A-Fa-f_]+"
regex_'2d'3f0'5boO'5d'5b0'2d7'5f'5d'2b = compileRegex "-?0[oO][0-7_]+"
regex_'2d'3f0'5bbB'5d'5b01'5f'5d'2b = compileRegex "-?0[bB][01_]+"
regex_'2d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28'28'5c'2e'28'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'29'7c'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'29 = compileRegex "-?[0-9][0-9_]*((\\.([0-9][0-9_]*)?([eE][-+]?[0-9][0-9_]*)?)|([eE][-+]?[0-9][0-9_]*))"
regex_'2d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a = compileRegex "-?[0-9][0-9_]*"
regex_'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29 = compileRegex "(\\\\[ntbr'\"\\\\]|\\\\[0-9]{3}|\\\\x[0-9A-Fa-f]{2})"
regex_'5c'5c'24 = compileRegex "\\\\$"
regex_'5c'5c'28'5c'5c'7c'3e'3e'7c'3c'3c'29 = compileRegex "\\\\(\\\\|>>|<<)"
regex_'5c'5c'3c'3a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'3c = compileRegex "\\\\<:[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*<"

parseRules ("FSharp","Normal") =
  (((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("FSharp","Multiline Comment"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute NormalTok) >>~ pushContext ("FSharp","Singleline Comment"))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '[' '<' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '>' ']' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '[' '|' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '|' ']' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_do >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_done >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_module'5fenvironment >>= withAttribute OtherTok) >>~ pushContext ("FSharp","ModuleEnv"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_begin >>= withAttribute KeywordTok) >>~ pushContext ("FSharp","Block"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_object >>= withAttribute KeywordTok) >>~ pushContext ("FSharp","Object"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_sig >>= withAttribute KeywordTok) >>~ pushContext ("FSharp","Sig"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_struct >>= withAttribute KeywordTok) >>~ pushContext ("FSharp","Struct"))
   <|>
   ((pRegExpr regex_'60'5cs'2a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pRegExpr regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'5cs'2a'5c'2e) >> pushContext ("FSharp","ModuleEnv2") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'2e'2a'24 >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("FSharp","String Constant"))
   <|>
   ((pRegExpr regex_'27'28'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29'7c'5b'5e'27'5d'29'27 >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute StringTok) >>~ pushContext ("FSharp","Camlp4 Quotation Constant"))
   <|>
   ((pRegExpr regex_'3c'3a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'3c >>= withAttribute StringTok) >>~ pushContext ("FSharp","Camlp4 Quotation Constant"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_core_types >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'3f0'5bxX'5d'5b0'2d9A'2dFa'2df'5f'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'2d'3f0'5boO'5d'5b0'2d7'5f'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'2d'3f0'5bbB'5d'5b01'5f'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'2d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28'28'5c'2e'28'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'29'7c'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'2d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","Singleline Comment") =
  (currentContext >>= \x -> guard (x == ("FSharp","Singleline Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("FSharp","Multiline Comment") =
  (((pDetect2Chars False '*' ')' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("FSharp","Multiline Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Multiline Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("FSharp","String Constant") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29 >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","String Constant")) >> pDefault >>= withAttribute StringTok))

parseRules ("FSharp","Block") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_end >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("FSharp","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Block")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","Sig") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_end >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("FSharp","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Sig")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","Struct") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_end >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("FSharp","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Struct")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","Object") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_end >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("FSharp","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Object")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","ModuleEnv") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pRegExpr regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'5cs'2a'5c'2e) >> pushContext ("FSharp","ModuleEnv2") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("FSharp","ModuleEnv2") =
  (((pRegExpr regex_'5bA'2dZ'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "." >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","ModuleEnv2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("FSharp","Camlp4 Quotation Constant") =
  (((pDetect2Chars False '>' '>' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '<' '<' >>= withAttribute StringTok) >>~ pushContext ("FSharp","Camlp4 Quotation Constant"))
   <|>
   ((pRegExpr regex_'3c'3a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'3c >>= withAttribute StringTok) >>~ pushContext ("FSharp","Camlp4 Quotation Constant"))
   <|>
   ((pRegExpr regex_'5c'5c'28'5c'5c'7c'3e'3e'7c'3c'3c'29 >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5c'5c'3c'3a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a'3c >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("FSharp","Camlp4 Quotation Constant")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("FSharp","Normal") <|> fail ("Unknown context" ++ show x)
