{- This module was generated from data in the Kate syntax
   highlighting file llvm.xml, version 1.00, by LLVM Team -}

module Text.Highlighting.Kate.Syntax.Llvm
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "LLVM"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ll"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("LLVM","llvm")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("LLVM","llvm") -> return ()
      ("LLVM","symbol") -> (popContext) >> pEndLine
      ("LLVM","symbol-string") -> return ()
      ("LLVM","string") -> return ()
      ("LLVM","comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "begin end true false declare define global constant gc module asm target datalayout null undef blockaddress sideeffect alignstack to unwind nuw nsw inbounds tail triple type align alias"
list_linkage'2dtypes = Set.fromList $ words $ "private internal available_externally linkonce weak common appending extern_weak linkonce_odr weak_odr dllimport dllexport"
list_calling'2dconventions = Set.fromList $ words $ "ccc fastcc coldcc cc"
list_visibility'2dstyles = Set.fromList $ words $ "default hidden protected"
list_parameter'2dattributes = Set.fromList $ words $ "zeroext signext inreg byval sret noalias nocapture nest"
list_function'2dattributes = Set.fromList $ words $ "alignstack alwaysinline inlinehint naked noimplicitfloat noinline noredzone noreturn nounwind optnone optsize readnone readonly ssp sspreq sspstrong"
list_types = Set.fromList $ words $ "float double fp128 x86_fp80 ppc_fp128 x86mmx void label metadata opaque"
list_intrinsic'2dglobal'2dvariables = Set.fromList $ words $ "llvm.used llvm.compiler.used llvm.global_ctors llvm.global_dtors"
list_instructions = Set.fromList $ words $ "ret br switch indirectbr invoke unwind unreachable add fadd sub fsub mul fmul udiv sdiv fdiv urem srem frem shl lshr ashr and or xor extractelement insertelement shufflevector extractvalue insertvalue alloca load store getelementptr trunc zext sext fptrunc fpext fptoui fptosi uitofp sitofp ptrtoint inttoptr bitcast addrspacecast icmp fcmp phi select call va_arg"
list_conditions = Set.fromList $ words $ "eq ne ugt uge ult ule sgt sge slt sle oeq ogt oge olt ole one ord ueq une uno"

regex_i'5b0'2d9'5d'2b = compileRegex True "i[0-9]+"
regex_'5b'2da'2dzA'2dZ'24'2e'5f'5d'5b'2da'2dzA'2dZ'24'2e'5f0'2d9'5d'2a'3a = compileRegex True "[-a-zA-Z$._][-a-zA-Z$._0-9]*:"
regex_'28'5b'2da'2dzA'2dZ'24'2e'5f'5d'5b'2da'2dzA'2dZ'24'2e'5f0'2d9'5d'2a'7c'5b0'2d9'5d'2b'29 = compileRegex True "([-a-zA-Z$._][-a-zA-Z$._0-9]*|[0-9]+)"

parseRules ("LLVM","llvm") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pAnyChar "@%" >>= withAttribute FunctionTok) >>~ pushContext ("LLVM","symbol"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ';' >>= withAttribute CommentTok) >>~ pushContext ("LLVM","comment"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("LLVM","string"))
   <|>
   ((pRegExpr regex_i'5b0'2d9'5d'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5b'2da'2dzA'2dZ'24'2e'5f'5d'5b'2da'2dzA'2dZ'24'2e'5f0'2d9'5d'2a'3a >>= withAttribute FunctionTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_linkage'2dtypes >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_calling'2dconventions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_visibility'2dstyles >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_parameter'2dattributes >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_function'2dattributes >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_intrinsic'2dglobal'2dvariables >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_instructions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_conditions >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LLVM","llvm")) >> pDefault >>= withAttribute NormalTok))

parseRules ("LLVM","symbol") =
  (((pDetectChar False '"' >>= withAttribute FunctionTok) >>~ pushContext ("LLVM","symbol-string"))
   <|>
   ((pRegExpr regex_'28'5b'2da'2dzA'2dZ'24'2e'5f'5d'5b'2da'2dzA'2dZ'24'2e'5f0'2d9'5d'2a'7c'5b0'2d9'5d'2b'29 >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("LLVM","symbol")) >> pDefault >>= withAttribute FunctionTok))

parseRules ("LLVM","symbol-string") =
  (((pDetectChar False '"' >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("LLVM","symbol-string")) >> pDefault >>= withAttribute FunctionTok))

parseRules ("LLVM","string") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("LLVM","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("LLVM","comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("LLVM","comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("LLVM","llvm") <|> fail ("Unknown context" ++ show x)
