.TH "hmmemit" 1 "Oct 2003" "HMMER 2.3.2" "HMMER Manual"

.SH NAME
.TP 
hmmemit - generate sequences from a profile HMM

.SH SYNOPSIS
.B hmmemit
.I [options]
.I hmmfile

.SH DESCRIPTION

.B hmmemit
reads an HMM file from
.I hmmfile
containing one or more HMMs,
and generates a number of sequences from each HMM;
or, if the
.B -c
option is selected, generate a single majority-rule consensus.
This can be useful for various applications in which one needs a simulation
of sequences consistent with a sequence family consensus. 

.pp
By default,
.B hmmemit
generates 10 sequences and outputs them in FASTA (unaligned) format.

.SH OPTIONS

.TP
.B -a
Write the generated sequences in an aligned format (SELEX) rather than
FASTA.

.TP
.B -c
Predict a single majority-rule consensus sequence instead of sampling
sequences from the HMM's probability distribution.  Highly conserved
residues (p >= 0.9 for DNA, p >= 0.5 for protein) are shown in upper
case; others are shown in lower case.  Some insert states may become
part of the majority rule consensus, because they are used in >= 50%
of generated sequences; when this happens, insert-generated residues
are simply shown as "x".

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.BI -n " <n>"
Generate
.I <n> 
sequences. Default is 10.

.TP
.BI -o " <f>"
Save the synthetic sequences to file
.I <f>
rather than writing them to stdout.

.TP
.B -q
Quiet; suppress all output except for the sequences themselves.
Useful for piping or directing the output.

.SH EXPERT OPTIONS

.TP
.BI --seed " <n>"
Set the random seed to
.I <n>,
where 
.I <n> 
is a positive integer. The default is to use 
.B time()
to generate a different seed for each run, which
means that two different runs of
.B hmmemit
on the same HMM will give slightly different
results.  You can use
this option to generate reproducible results.



.SH SEE ALSO

Master man page, with full list of and guide to the individual man
pages: see 
.B hmmer(1).
.PP
For complete documentation, see the user guide that came with the
distribution (Userguide.pdf); or see the HMMER web page,
http://hmmer.wustl.edu/.

.SH COPYRIGHT

.nf
Copyright (C) 1992-2003 HHMI/Washington University School of Medicine.
Freely distributed under the GNU General Public License (GPL).
.fi
See the file COPYING in your distribution for details on redistribution
conditions.

.SH AUTHOR 

.nf
Sean Eddy
HHMI/Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
http://www.genetics.wustl.edu/eddy/
.fi


