#!/usr/bin/perl -w

print "/** Do not modify. This file is automatically generated\n";
print "  * using gen_tld.pl and tld.list\n";
print "  */\n\n";
		
my @tld;
while(<STDIN>) {
	chomp;
	if(/^([\w\.]+)\s+/) {
		push @tld, uc $1;
	}
}
@tld = sort { length($a) <=> length($b) || $a cmp $b } @tld;
@tld = reverse @tld;

my $i;
print "static const char *tld[] = {\n";
for($i = 0; $i < scalar (@tld) - 1; ++$i) { print "\t\".$tld[$i]\",\n"; }
print "\t\"." . $tld[scalar(@tld) - 1] . "\"\n";
print "};\n";
print "static uint tldOffset(const char *domain) {\n";
print "	const char *end = domain + strlen(domain);\n";
print "	for(unsigned int i = 0; i < " . scalar @tld . "; ++i) {\n";
print " 	unsigned int len = strlen(tld[i]);\n";
print "		if(strcasecmp(end - len, tld[i]) == 0) {\n";
print "			return len;\n";
print "		}\n";
print "	}\n";
print " return 0;";
print "}\n";

	
