/*
* Copyright (c) 2012 The Broad Institute
* 
* Permission is hereby granted, free of charge, to any person
* obtaining a copy of this software and associated documentation
* files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use,
* copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following
* conditions:
* 
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
* THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package htsjdk.variant.variantcontext.writer;

import java.io.Closeable;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;

/**
 * this class writes VCF files
 */
public interface VariantContextWriter extends Closeable {

    /**
     * Writes the header
     *
     * @param header header
     * @throws IllegalStateException if header is already written
     */
    public void writeHeader(VCFHeader header);

    /**
     * attempt to close the VCF file
     */
    @Override
    public void close();

    /**
     * @return true if the underlying stream is a java.io.PrintStream  and its checkError returned true, used for pipelines
     */
    public boolean checkError();
    
    public void add(VariantContext vc);

    /**
     * Sets the VCF header so that data blocks can be written without writing the header
     *
     * Exactly one of writeHeader() or setHeader() should be called when using a writer
     *
     * @param header VCF header
     * @throws IllegalStateException if header or body is already written

     */
    void setHeader(VCFHeader header);
}