/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#ifndef MAINOPTIONS_H
#define MAINOPTIONS_H

#include <QString>
#include <QWidget>

#include "httraqt.h"
#include "ui_OptionsTab.h"


class HTTraQt;

class OptionsTab: public QWidget, public Ui_OptionsTab, public Translator
{
        Q_OBJECT
    public:
        OptionsTab(QWidget *parent = 0, Qt::WindowFlags fl = 0);
        bool testIt();
        void translateTab();
        void updateLastAction();

    private slots:
        void onSetOptions();
        void onURLList();
        void showHelp();
        void removeSpaceLines();
        void onCaptureUrl();
        void onAddURL();
        QString getAndTestUrlString(const QString st);

    public:
        int comb01;
        static int hl01[7];

    private:
        HTTraQt* parent;
};

#endif
