/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/BuildStringDialog.h"
#include "includes/OptionsDialog.h"
#include "includes/optionsbuild.h"
#include "../main/includes/httraqt.h"

optionsBuild::optionsBuild(QWidget* parent, Qt::WindowFlags fl)
    : QWidget(parent, fl), Ui::buildForm()
{
    setupUi(this);

    this->parent = static_cast<OptionsDialog*>(parent);

    QString str = this->parent->translate(LISTDEF_3);
    QStringList strl = str.split("\n");

    buildForm::label1045->insertItems(0, strl);

    opts = &(static_cast<OptionsDialog*>(this->parent))->_tabTextInfos;

    initTextPoints();

    connect(buildForm::label1209, SIGNAL(clicked()), this, SLOT(callBuildStringDialog()));
}


optionsBuild::~optionsBuild()
{
}


void optionsBuild::initTextPoints()
{
    *opts << (trWidgets) {
        buildForm::label1192, _STRUCT_TYPE, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        buildForm::label1030, _DOS_NAMES, "Dos", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1034, _NO_ERR_PAG, "NoErrorPages", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1035, _NO_EXTERAL, "NoExternalPages", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1037, _HIDE_PASS, "NoPwdInPages", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1038, _HIDE_QUERY, "NoQueryStrings", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1036, _NOT_PURGE, "NoPurgeOldFiles", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1031, _ISO9660_NAMES, "ISO9660", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        buildForm::label1045, -1, "Build", COMBOBOX, INTEGER, 0
    };
}


void optionsBuild::callBuildStringDialog()
{
    // einbauen aufruf vom dialog
    BuildStringDialog* bdial = new BuildStringDialog(this->parent->parent);
    bdial->exec();
}

/*$SPECIALIZATION$*/


