/*
 * db.h - a simple database
 * Copyright (C) 1996 by candy
 * $Id: db.h,v 3.6 1996/11/28 09:01:21 candy Exp $
 */
#ifndef DB_H__
#define DB_H__

struct db_t {
	size_t db_size;
	size_t db_max;
	void **db_table;
	int (*db_comp)(const void *, const void *);
	size_t db_used;
};


struct db_t * db_new(size_t max, int (*comp)(const void *, const void *));
void db_free(struct db_t *db);
void * db_install(struct db_t *db, const void *data);
void * db_lookup(struct db_t *db, const void *data);

#endif
