/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of an HP Apollo-thingy type keyboard.
 * By Mick J Hellstrom <mickh@rd.scitec.com.au>
 */

static const struct key_strings apollo_caps [] =
{

  /* Row 0 */
  {"Insert", "Mark", 0},
  {"LineDel", 0},
  {"CharDel", 0},

  {"F0", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},

  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},

  {"Again", 0},
  {"Read", 0},
  {"Save", "Edit", 0},
  {"Abort", "Exit", 0},
  {"Help", "Hold", 0},


  /* Row 1 */
  {"Cut", "Copy", "0"},
  {"Undo", "Paste", 0},
  {"Move", "Grow", 0},

  {"Escape", 0},
  {"!", "1", 0},
  {"@", "2", 0},
  {"#", "3", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"^", "6", 0},
  {"&", "7", 0},
  {"*", "8", 0},
  {"(", "9", 0},
  {")", "0", 0},
  {"_", "-", 0},
  {"+", "=", 0},
  {"~", "`", 0},
  {"Backspace", 0},


  /* Row 2 */
  {"Home", "0"},
  {"Shell", "Cmd", 0},
  {"End", 0},

  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Y", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"{", "[", 0 },
  {"}", "]", 0 },
  {"Delete", 0},

  {"7", 0},
  {"8", 0},
  {"9", 0},
  {"+", 0},


  /* Row 3 */
  {"PageLeft", 0},
  {"Up", 0},
  {"PageRight", 0},

  {"Ctrl", 0},
  {"Caps Lock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {":", ";", 0},
  {"\"", "'", 0},
  {"Return", 0},
  {"|", "\\", 0},

  {"4", 0},
  {"5", 0},
  {"6", 0},
  {"-", 0},


  /* Row 4 */
  {"Left", 0},
  {"Next", 0},
  {"Right", 0},

  {"Repeat", 0},
  {"LeftShift", 0},
  {"Z", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {"<", ",", 0},
  {">", ".", 0},
  {"?", "/", 0},
  {"RightShift", 0},
  {"Pop", 0},

  {"1", 0},
  {"2", 0},
  {"3", 0},
  {"Enter", 0},


  /* Row 5 */
  {"PageUp", 0},
  {"Down", 0},
  {"PageDn", 0},

  {" ", 0},

  {"0", 0},
  {".", 0}
};
