/*
 * @(#)Mball2dP.h
 *
 * Copyright 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Mball2d */

#ifndef _Mball2dP_h
#define _Mball2dP_h

#include "Mball2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Mball2DClassPart {
	int ignore;
} Mball2DClassPart;

typedef struct _Mball2DClassRec {
	CoreClassPart coreClass;
	MballClassPart mballClass;
	Mball2DClassPart mball2dClass;
} Mball2DClassRec;

extern Mball2DClassRec mball2dClassRec;
#endif

typedef struct _Mball2DPart {
	Position    faceLength;
	Position    viewLength;
} Mball2DPart;

typedef struct _Mball2DRec {
	CorePart    core;
	MballPart     mball;
	Mball2DPart   mball2d;
} Mball2DRec;

extern Boolean positionToSector2D(Mball2DWidget w, int x, int y,
	int *sector, int *view);
extern void eraseFrame2D(const Mball2DWidget w);
extern void drawFrame2D(Mball2DWidget w, Boolean focus);
extern void drawWedge2D(Mball2DWidget w, int wedge);
extern void drawSector2D(const Mball2DWidget w,
	const int sector, const int offset);
#ifdef WINVER
extern void initializePuzzle2D(Mball2DWidget w);
extern void sizePuzzle2D(Mball2DWidget w);
extern void resizePuzzle2D(Mball2DWidget w);
extern void exposePuzzle2D(Mball2DWidget w);
#endif

#endif /* _Mball2dP_h */
