/*****************************************************************************/
/*  xsol.h - A solitare program for X Windows written using Motif            */
/*  Copyright (C) 1998 Brian Masney <masneyb@newwave.net>                    */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*****************************************************************************/

/* 2-9,T,J,Q,K,A */
static const unsigned char card_nums[14][32] = {
  {0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x20, 0x02, 0x10, 0x04, 0x00, 0x04,
   0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00,
   0xf0, 0x07, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x20, 0x02, 0x10, 0x04, 0x00, 0x04,
   0x00, 0x02, 0x80, 0x01, 0x00, 0x02, 0x00, 0x04, 0x10, 0x04, 0x20, 0x02,
   0xc0, 0x01, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
   0x10, 0x04, 0x10, 0x04, 0xf0, 0x07, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
   0xe0, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x10, 0x04, 0x20, 0x02,
   0xc0, 0x01, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00,
   0x10, 0x00, 0xf0, 0x07, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x04,
   0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02,
   0xe0, 0x03, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0xe0, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
   0x10, 0x04, 0xe0, 0x07, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x80, 0x00,
   0x40, 0x00, 0x20, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00,
   0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0x90, 0x04, 0x90, 0x04, 0x90, 0x04,
   0x90, 0x04, 0x90, 0x04, 0x90, 0x04, 0x90, 0x04, 0x90, 0x04, 0x90, 0x04,
   0x10, 0x03, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00,
   0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04,
   0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x88, 0x04, 0x08, 0x05, 0x08, 0x06,
   0xf0, 0x07, 0x00, 0x08, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x10, 0x02, 0x10, 0x01, 0x90, 0x00,
   0x50, 0x00, 0x30, 0x00, 0x50, 0x00, 0x90, 0x00, 0x10, 0x01, 0x10, 0x02,
   0x10, 0x04, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x40, 0x01,
   0x20, 0x02, 0x20, 0x02, 0xe0, 0x03, 0x10, 0x04, 0x10, 0x04, 0x08, 0x08,
   0x08, 0x08, 0x00, 0x00, 0x00, 0x00}};

/* Club, Spade, Diamond, Heart */
static const unsigned char card_family[4][32] = {
  {0x00, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xf8, 0x0f,
   0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f, 0xb8, 0x0e, 0xc0, 0x01, 0xc0, 0x01,
   0xe0, 0x03, 0xf0, 0x07, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07,
   0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0f, 0xb8, 0x0e, 0xd0, 0x05, 0xc0, 0x01,
   0xe0, 0x03, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07,
   0xf8, 0x0f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x00, 0x00, 0x38, 0x0e, 0x7c, 0x1f, 0x7c, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f,
   0xf8, 0x0f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x07, 0xe0, 0x03, 0xe0, 0x03,
   0xc0, 0x01, 0x80, 0x00, 0x00, 0x00}};

/* Our card back. CARD_WIDTHxCARD_HEIGHT, 70x85 */
static const unsigned char card_back[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34,
   0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49,
   0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24, 0x49, 0x92, 0x24,
   0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x32,
   0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39, 0x4b, 0x92, 0x24,
   0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92, 0x24, 0x49, 0x92,
   0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x24, 0x39,
   0x4b, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0x92, 0x34, 0x27, 0x49, 0x92,
   0x24, 0x49, 0x92, 0x24, 0x49, 0x32, 0x93, 0x24, 0x49, 0x92, 0x24, 0x49,
   0x92, 0x24, 0x39, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f};

/* Empty pile marker. CARD_WIDTHxCARD_HEIGHT, 70x85 */
static const unsigned char empty_pile[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x78, 0x00, 0x0f, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x06, 0x00, 0x30, 0x00, 0x00, 0x20, 0x01, 0x00, 0x80, 0x01, 0x00, 0xc0,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x20,
   0x01, 0x00, 0x30, 0x00, 0x00, 0x00, 0x06, 0x00, 0x20, 0x01, 0x00, 0x08,
   0x00, 0x00, 0x00, 0x0a, 0x00, 0x20, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x11, 0x00, 0x20, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x20,
   0x01, 0x00, 0x01, 0x00, 0x00, 0x80, 0x40, 0x00, 0x20, 0x01, 0x00, 0x01,
   0x00, 0x00, 0x40, 0x40, 0x00, 0x20, 0x01, 0x80, 0x00, 0x00, 0x00, 0x20,
   0x80, 0x00, 0x20, 0x01, 0x40, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x20,
   0x01, 0x40, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x20, 0x01, 0x20, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x02, 0x20, 0x01, 0x20, 0x00, 0x00, 0x00, 0x04,
   0x00, 0x02, 0x20, 0x01, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x20,
   0x01, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x20, 0x01, 0x10, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x04, 0x20, 0x01, 0x10, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x04, 0x20, 0x01, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x20,
   0x01, 0x08, 0x00, 0x00, 0x40, 0x00, 0x00, 0x08, 0x20, 0x01, 0x08, 0x00,
   0x00, 0x20, 0x00, 0x00, 0x08, 0x20, 0x01, 0x08, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x08, 0x20, 0x01, 0x08, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x20,
   0x01, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x20, 0x01, 0x08, 0x00,
   0x00, 0x04, 0x00, 0x00, 0x08, 0x20, 0x01, 0x08, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x08, 0x20, 0x01, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x08, 0x20,
   0x01, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x20, 0x01, 0x10, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x04, 0x20, 0x01, 0x10, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x04, 0x20, 0x01, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x20,
   0x01, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x20, 0x01, 0x20, 0x00,
   0x10, 0x00, 0x00, 0x00, 0x02, 0x20, 0x01, 0x40, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x01, 0x20, 0x01, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x20,
   0x01, 0x80, 0x00, 0x04, 0x00, 0x00, 0x80, 0x00, 0x20, 0x01, 0x00, 0x01,
   0x02, 0x00, 0x00, 0x40, 0x00, 0x20, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00,
   0x40, 0x00, 0x20, 0x01, 0x00, 0x82, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20,
   0x01, 0x00, 0x84, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20, 0x01, 0x00, 0x48,
   0x00, 0x00, 0x00, 0x08, 0x00, 0x20, 0x01, 0x00, 0x30, 0x00, 0x00, 0x00,
   0x06, 0x00, 0x20, 0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x20,
   0x01, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x06, 0x00, 0x30, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x78, 0x00, 0x0f,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f};
