#-----------------------------------------------------------------------------
#  Copyright (C) 2002-2017 Thomas S. Ullrich
#
#  This file is part of "xyscan".
#
#  This file may be used under the terms of the GNU General Public License.
#  This project is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License.
#  
#  Author: Thomas S. Ullrich
#  Last update: Nov 30, 2016
#-----------------------------------------------------------------------------
#
#  Unix/Linux syntax:
#  qmake [PREFIX=<dir>] xyscan.pro
#  where PREFIX is the directory under which xyscan will
#  be installed. The default (if PREFIX is not defined)
#  is /usr/local.
#
#  For Windows and macOS binary versions are available.
#  They should be used since building and deploying xyscan
#  on these platforms is not for the faint hearted.
#
#  If you want to try nevertheless, either use Qt's Developer
#  application or (as the author does) xcode on macOS and
#  VisualStudio on Win directly.
#
#  Xcode:
#  qmake -spec macx-xcode xyscan.pro
#
#  VS:
#  qmake.exe -tp vc
#
#  This will create the referring project files that you open
#  with Xcode and VS.
#-----------------------------------------------------------------------------
VERSION = 4.3.0
TEMPLATE = app
CONFIG  += qt warn_on release c++11
QT += network xml widgets printsupport multimedia
RESOURCES += xyscan.qrc

isEmpty(PREFIX) {
    PREFIX = /usr/local
}

win32 {
   RC_FILE += xyscan.rc
   ICON += xyscan.ico
}

macx {
   ICON += xyscan.icns
}

# For MacPorts installations
macx {
   INCLUDEPATH += /opt/local/include/poppler/qt5/
   INCLUDEPATH += /opt/local/include/poppler
   LIBS += -L/opt/local/lib/ -lpoppler
   LIBS += -L/opt/local/lib/ -lpoppler-qt5
}

#
# For various lib location of poppler. If your installation is
# different you will have to add your location here.
#
unix {
   INCLUDEPATH += /usr/include/poppler/qt5/
   INCLUDEPATH += /usr/include/poppler
   INCLUDEPATH += /usr/local/include/poppler/qt5/
   INCLUDEPATH += /usr/local/include/poppler
   INCLUDEPATH += /opt/local/include/poppler/qt5/
   INCLUDEPATH += /opt/local/include/poppler
   LIBS += -L/usr/local/lib/ -L/usr/lib/ -lpoppler -lpoppler-qt5
}

#
# For installation (make install)
#
unix {
   documentation.path = $$PREFIX/share/xyscan/docs
   documentation.files = docs/*  license.txt gpl.txt
   target.path = $$PREFIX/bin/
   INSTALLS += documentation
   INSTALLS += target
}

#
# All source files
#
HEADERS = ./src/xyscanWindow.h \
          ./src/xyscanAbout.h \
          ./src/xyscanVersion.h \
          ./src/xyscanHelpBrowser.h \
          ./src/xyscanMarkerMaps.h \
          ./src/xyscanStateMachine.h \
          ./src/xyscanUpdater.h \
          ./src/xyscanGraphicsView.h \
          ./src/xyscanDataTable.h

SOURCES = ./src/xyscanMain.cpp \
          ./src/xyscanWindow.cpp \
          ./src/xyscanAbout.cpp \
          ./src/xyscanHelpBrowser.cpp \
          ./src/xyscanStateMachine.cpp \
          ./src/xyscanUpdater.cpp \
          ./src/xyscanGraphicsView.cpp \
          ./src/xyscanDataTable.cpp

# TRANSLATIONS = xyscan_fr.ts
